.\"{{{  Notes
.\" This manual should be improved in many points, but it is ok for a first
.\" impression of Origami.  You should have seen the original documentation,
.\" and you would be happy about this document...  On the other side, have you
.\" ever seen the GNU Emacs manual?  It is for people who are able to read the
.\" whole bible while waiting for the bus.
.\" I wrote this manual using Origami and the -ms macros of MROFF, but it
.\" should be formattable with every other member of the roff family and does
.\" not need eqn, tbl or pic.
.\"
.\" Michael Haardt
.\"}}}
.\"{{{  A few macros
.\" Although I hate macros in documents, there does not seem
.\" to be another way for this manual...
.\" small paragraph
.de SP
.nr PP .35v
.LP
.in .75c
.nr PP .75v
..
.\"}}}
.\"{{{  Title and abstract
.TL
Origami User Guide
.AU
Michael Haardt
.AI
.if "\(oe"" Auf der Hoern 40
.if !"\(oe"" Auf der H\(oern 40
5100 Aachen
Germany
.AB
This document explains the principles of folding editors in general,
because most people have never used such an editor.  It gives an example of
an Origami editing session to show the advantages of folding program sources.
It then explains how to compile and install Origami.  All functions of
Origami are listed and described.  It never refers to concrete keys,
because the Emacs-like and the TDS keybindings are completely different.
This document explains the Origami control language (OCL) detail,
because very complicated editor commands can be created.
.AE
.\"}}}
.\"{{{  Introduction
.NH 1
Introduction
.\"{{{  Origami
.NH 2
Origami
.LP
Origami is a `folding editor', similar to, and inspired by, the editor
included in the Inmos TDS (Transputer Development System).  Those of us
who have become familiar with the TDS editor have long bemoaned the lack
of a similar editor for use with other languages, for example Pascal and
C.
.PP
Origami is not a word processor (although many of its features would be
useful in a word processor), but it comes into its own as a program
editor for structured languages and documents.  The structuring of the
code or text is obvious from the screen display (if Origami is sensibly
used!), although no actual code may be visible.
.PP
Existing files, not produced using Origami, may be imported into
Origami, and then folded up for future use, and ease of development.
These files may be further edited either using Origami or some other
editor (if you can bear to use one after Origami!), and compiled in the
normal way.
.\"}}}
.\"{{{  The Folding Editor
.NH 2
The Folding Editor
.LP
A `folding editor' extends the principle of tree structured directories
to editing text files.  This allows the simultaneous display of large amounts
of text by `folding' sections of text away behind a descriptive
heading.  This results in a tree structure very similar to a
sub-directory structure of, for example, UNIX.
.PP
By suitable structuring of a text it should be possible, in most
circumstances, to ensure that no display exceeds a single screen at any
time.  To access text which is folded away you can either ENTER the
containing fold, in which case the contents of the fold and its header
are the only displayed text, or you can OPEN the fold, in which case the
contents are displayed in the context of the surrounding text.
.PP
The advantage of this system is that it eliminates the need for
seemingly endless paging through long files to find the section of
interest, allowing you to move down the tree structure, following the
(hopefully) descriptive headers to locate the text you require.
.\"}}}
.\"{{{  Examples of Origami folding
.NH 2
Examples of Origami Folding
.LP
As an example, a Pascal file might look like this at
the top level (eg immediately after starting Origami):
.DS L
program test;
\&...  CONSTs
\&...  TYPEs
\&...  VARs
\&...  procedures
\&...  main body of code
.DE
OPENing the VARs fold might lead to the following display:
.DS L
program test;
\&...  CONSTs
\&...  TYPEs
{\&{\&{  VARs
VAR  i : integer;
     x : real;
}\&}\&}
\&...  procedures
\&...  main body of code
.DE
ENTERing the procedures fold might give:
.DS L
{\&{\&{  procedures
\&...   statistical procedures
\&...   string handling procedures
\&...   procedure user_input
}\&}\&}
.DE
Each of these folds can be ENTERed further until actual code
is reached - for example if we ENTER the
\&`procedure user_input' fold we might find:
.DS L
{\&{\&{  procedure user_input
procedure user_input(prompt : str_type; var reply : str_type);
\&...  local declarations
\&...  local procedures
  begin
    repeat
      write(prompt);
      readln(reply);
    until verify_reply(reply);
  end;
}\&}\&}
.DE
.\"}}}
.\"}}}
.\"{{{  Installing Origami
.\"{{{F install.ms
.\":::F install.ms
.\"}}}
.so install.ms
.\"}}}
.\"{{{  Using Origami
.NH 1
Using Origami
.\"{{{  Getting started
.NH 2
Getting Started
.LP
At this point, you have the choice either to read the next chapters
about using Origami or to use the tutorial to learn by doing.  This
tutorial is similar to the well-known teach-emacs tutorial.  You need a
copy of the learn directory.  Change to this directory and type start-me
<return>.  This tutorial must be used in Emacs-mode.
.PP
It is assumed, that Origami is installed and ready to use on your
system.  It is invoked by typing `origami' after the system prompt.
Filenames may be typed after `origami' \(em if this is not done a
prompt for a filename will be issued.
.PP
If the file being read contains tab characters, Origami will ask for the
tab size in order to preserve your formatting.  If you have
no write permissions for the specified file, Origami will switch to
view-only mode.  Look at the manual page for advanced command line
options.
.\"}}}
.\"{{{  The screen format
.NH 2
The Screen Format
.LP
On starting an Origami session, a status line appears near the bottom of
the screen.  This line will remain throughout your edit, and any prompts
or warnings issued by the editor will appear below this line.  If you
started typing a key sequence bound to a command, this sequence will be
displayed under the status line, too.  If the second character of the
line is a star, your file contains unsaved changes.  The current
language and the active modes are indicated in parentheses:
.IP Folding/F 1i
is displayed during creating a fold.
.IP DefMac/D 1i
is displayed during defining a keyboardmacro.
.IP ExMac/E 1i
is displayed during the execution of a macro (keyboard or fix).
.IP View/V 1i
is displayed if origami is in view-only mode.
.IP Over/O 1i
Origami is in overwrite-mode.
.IP ArgRep/R 1i
Origami is in argument-repeat-mode.
.IP AutoSave/S 1i
Origami is in auto-save-mode.  Origami will save your
files periodically.
.LP
The short forms are used if the statusline is too long.  If there is a
name defined in your keybinding file, it is displayed to the left of the
language indicator.  If the filename is to long to be displayed in the
statusline, origami tries to cut the path and displays ``...'' instead
of the missing part of the path.
.\"}}}
.\"{{{  The editor buffers
.NH 2
The Editor Buffers
.LP
There are three buffers in Origami.  The `move buffer' that contains up
to one textline, the `pick buffer' in which several lines can be
accumulated before inserting them back into the file, and the `delete
buffer', which holds the last deleted line (in each case a line can be a
closed fold, with all its contents).  The operations of these buffers in
Origami are slightly different from TDS \(em move, delete and pick
buffers are lost on exit from Origami.
.\"}}}
.\"{{{  Processing Origami files
.NH 2
Processing Origami Files
.LP
If a saved file should pass a particular compiler, the fold structure
must appear to the compiler as comments.  As comments differ from one
language to another, this means choosing the language before saving a
new file for the first time, although on reading a file back into
Origami the language type is retained (provided the file contained at
least one fold).  As a consequence of this you should take care not to
include strings which the compiler would recognise as comments within
the fold header, as this will lead to nested comments which are not
allowed in some languages.
.PP
Origami knows the languages None, Occam, Pascal, C, Lisp, Roff, Fortran,
TeX, Script, User and Inmos.  You can specify your own comment strings
using language User.  Inmos allows to edit files generated by Tds and
MultiTool without converting them.  Script is useful for sh, csh, remind
etc.
.\"}}}
.\"}}}
.\"{{{  All Origami functions
.\"{{{F functions.ms
.\":::F functions.ms
.\"}}}
.so functions.ms
.\"}}}
.\"{{{  Programming in OCL
.\"{{{F Programming in OCL
.\":::F ocl.ms
.\"}}}
.so ocl.ms
.\"}}}
.\"{{{  Miscellanous things
.NH 1
Miscellanous things
.LP
Sometimes, it is useful to know if a document contains ``dangerous''
strings for Origami.  The following simple shell script searches these
strings.
.DS
fgrep '{\&{\&{' <filename>
fgrep '}\&}\&}' <filename>
fgrep ':\&:\&:' <filename>
.DE
.\"}}}
.\"{{{  Copyrights
.NH 1
Copyright appointments
.LP
This chapter wasn't included in earlier versions, but a discussion on USENET
convinced me to write it.  Please read it careful.
.PP
Each part of this software can and must be copied free.  If you copy
binaries, you must not prevent people from copying sources, too.  You
must not remove my name from this program.  If you want to use parts of
it for your own purposes, point out what is your code and what is mine.
.PP
If this software is used on a machine, no one may forbid
other people to use it on the same machine.  (A little bit uncommon.  I hope it
prevents some braindamaged teaching methods I saw here at the RWTH in
Aachen recently.  No more comments at this place.) If you have problems
with this restriction then send me mail, please.  I will try to get a
clearance.
.PP
No part of this software may be used for military purposes.  I will make
no execptions for this point.
.PP
If someone want to use software from this package for commercial purposes,
he needs a written non-exclusive license.
.PP
There are no remarks in the other files of this package about copyright
and these things, because program code and comments about it are two
different things, but the above conditions are valid for the whole
package!
.\"}}}
.\"{{{  Acknowledgements
.NH 1
Acknowledgements
.LP
Most of this manual was written by me, but the original was written by
someone else, who didn't leave his name in it.  The concept of the
folding editor was originally implemented as part of the Transputer
development system at INMOS Ltd., Bristol, UK.  The editor was a part of
the TDS D700, and was written in Occam.  It first ran on a 68000 based
Sage/Stride development system, and later was Transputer resident on the
PC development system.
.PP
Origami was rewritten from scratch in Turbo Pascal by Martin Green while
at Ferranti Ltd, Cheadle Heath, Stockport, England, and used the same
key mappings and editor functions as the TDS editor.
.PP
It was then converted from Turbo Pascal by p2c and ported by Charlie
Lawrence, while at Eastman Kodak Co.  He added lex/yacc based keyfiles,
and did the considerable work needed to get it running in C.
.PP
I fixed some bugs in memory managment and otherwhere, ported it to
MINIX, changed its user interface to look more Emacs-like and added new
features.  A friend of mine, Wolfgang Stumvoll, wrote the OCL code and
the keybind compiler.  He also made beta tests of all my new versions by
using them for his daily work, which helped a lot to find existing and
new bugs.  Last but not least, he wrote the OCL fill-paragraph,
goto-matching-fence and towers-of-hanoi macros.  Both of us made a
general code clean-up, which was highly overdue.
.PP
Michael Schwingen ported Origami to Atari TOS and fixed a few minor bugs.
.PP
I maintain the whole Origami source code, which means that I will answer
or forward mail concerning Origami, decide if and how extensions should
be made, give advices for people who are porting it, post new versions and
update the documentation.
.\"}}}
