/* origami.h - contains some definitions ans a lot of prototypes */

#include "short.h"
#include "keys.h"

#define PRIVATE static
#define PUBLIC

extern char keybase[120];

#define maxavail()      60000

#ifdef STD_C
#ifndef EDITOR_G
extern void restore_element(uchar close_line);
extern bool find_item(int *cursor_x_pos);
extern void write_dsp_line(element *ptr,int level);
extern void title(void);
extern void restore(int from);
extern int to_bottom(int m);
extern void pre_open_fold(element *q);
extern void find_element(int new_line_no,uchar close_line);
extern void proc_replace(char *search,char *replace,char *line,int position);
extern void top(void);
extern void bottom(void);
extern bool copy_a_line(element **to_ptr);
extern void undelete_before(element *ptr_to_new);
extern void undelete_pick_before(void);
extern void undelete_after(element *ptr_to_new);
extern void remove_line(element **p);
extern void start_make_fold(int ind);
extern void make_fold(int *cursor_x_pos);
extern void open_fold(void);
extern void close_fold(void);
extern void delete_list(element *from_ptr,element *to_ptr);
extern void total_save(void);
extern void enter_fold(void);
extern void exit_fold(void);
extern void remove_fold(void);
extern bool help(bool);
extern void create_list(void);
extern void line_or_move_up(int to_line);
extern void move_or_line_down(int from_line);
extern void get_search(void);
#endif /* EDITOR_G */

#ifndef EDTUTIL_G
extern void pad_(char *s, int ch, int l);
extern char *spaces(char *Result, int l);
extern void colour(int n);
extern void press(int ch, int keypad);
extern void message(char *s);
extern void no_message(void);
extern TOKEN get_arg(void);
extern TOKEN single_key(void);
extern int edit_key(bool *keypad);
extern char *readprompt(char *Result, char *prompt, int max);
extern bool yes(char *q);
extern char *upper_case(char *Result, char *s);
extern char *tabbed_out(char *Result, char *instr);
extern bool valid_key(bool *keypad, char *ch);
extern bool valid_field_key(bool *keypad, char *ch);
#endif /* EDTUTIL_G */

#ifndef FIELDEDT_G
extern int field_edit(bool *keypad,int *field_pos_,char *field_str_);
#endif /* FIELDEDT_G */

#ifndef FILER_G
extern void file_info(char *s);
extern void proc_error(uchar b);
extern bool normal_att(element *p);
extern void insert_file(element *file_ptr,element *prec_ptr,element *next_ptr,bool remember_file);
#endif /* FILER_G */

#ifndef MISC_G
extern int ReadKey(void);
extern int strpos2(char *,char *,int);
extern void strinsert(char *,char *,int);
extern char *strsub(char *,char *,int,int);
#endif /* MISC_G */

#ifndef ORIEDT_G
extern int first_char(char *s);
extern int last_char(char *s);
extern void trailing_spaces(char *s);
extern void join_links(element *p,element *q);
extern void move_on(element **p);
extern int insert_indent_of(element *p);
extern void close_fold_at(element *ptr);
extern int lines_within(element *p);
extern bool available(int lines);
extern void proc_undispose(element **p);
extern void proc_new(element **p);
extern void proc_to_edit_pos(void);
extern void proc_from_edit_pos(void);
extern void copyin(char *, element *, bool);
extern void copyout(char *, element *);
#endif /* ORIEDT_G */

#ifndef ORIGAMI_G
extern void proc_dispose(element *);
#endif /* ORIGAMI_G */

#ifndef PROCEXIT_G
extern void proc_exit(element *file_ptr_,element *from_ptr);
#endif /* PROCEXIT_G */

#else

#ifndef EDITOR_G
extern void restore_element();
extern bool find_item();
extern void write_dsp_line();
extern void title();
extern void restore();
extern int to_bottom();
extern void pre_open_fold();
extern void find_element();
extern void proc_replace();
extern void top();
extern void bottom();
extern bool copy_a_line();
extern void undelete_before();
extern void undelete_pick_before();
extern void undelete_after();
extern void remove_line();
extern void start_make_fold();
extern void make_fold();
extern void open_fold();
extern void close_fold();
extern void delete_list();
extern void total_save();
extern void enter_fold();
extern void exit_fold();
extern void remove_fold();
extern bool help();
extern void create_list();
extern void line_or_move_up();
extern void move_or_line_down();
extern void get_search();
#endif /* EDITOR_G */

#ifndef EDTUTIL_G
extern void pad_();
extern char *spaces();
extern void colour();
extern void press();
extern void message();
extern void no_message();
extern TOKEN get_arg();
extern TOKEN single_key();
extern int edit_key();
extern char *readprompt();
extern bool yes();
extern char *upper_case();
extern char *tabbed_out();
extern bool valid_key();
extern bool valid_field_key();
#endif /* EDTUTIL_G */

#ifndef FIELDEDT_G
extern int field_edit();
#endif /* FIELDEDT_G */

#ifndef FILER_G
extern void file_info();
extern void proc_error();
extern bool normal_att();
extern void insert_file();
#endif /* FILER_G */

#ifndef MISC_G
extern int ReadKey();
extern int strpos2();
extern void strinsert();
extern char *strsub();
#endif /* MISC_G */

#ifndef ORIEDT_G
extern int first_char();
extern int last_char();
extern void trailing_spaces();
extern void join_links();
extern void move_on();
extern int insert_indent_of();
extern void close_fold_at();
extern int lines_within();
extern bool available();
extern void proc_undispose();
extern void proc_new();
extern void proc_to_edit_pos();
extern void proc_from_edit_pos();
extern void copyin();
extern void copyout();
#endif /* ORIEDT_G */

#ifndef ORIGAMI_G
extern void proc_dispose();
#endif /* ORIGAMI_G */

#ifndef PROCEXIT_G
extern void proc_exit();
#endif /* PROCEXIT_G */

#endif /* STD_C */

#define FileNotFound 2
#define EndOfFile 3
#define FileWriteError 4

