/*{{{  #includes*/
#include <sys/types.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <access.h>
#include <bool.h>
#include <argparse.h>

#include "short.h"
#include "globals.h"
#define ORIGAMI_G
#include "origami.h"
#include "macros.h"
/*}}}  */

#define read_list();    create_list(); restore_element(4); title();

char keybase[120]=".origami";

/*{{{  copy_line_to_parts*/
void copy_line_to_parts(line, parts) char *line; element **parts;
{
  if ((*parts)->strng!=NULL) free((*parts)->strng);
  (*parts)->strng = malloc(strlen(line)+1);
  strcpy((*parts)->strng, line);
}
/*}}}  */
/*{{{  copy_parts_to_parts*/
void copy_parts_to_parts(in_parts, parts) element *in_parts, **parts;
{
  if ((*parts)->strng!=NULL) free((*parts)->strng);
  (*parts)->strng = malloc(strlen((in_parts)->strng)+1);
  strcpy((*parts)->strng, (in_parts)->strng);
}
/*}}}  */
/*{{{  append_to_pick*/
#define append_to_pick() (join_links(pick_tail, pick_ptr), \
                        pick_ptr->UU.U1.indent = 0, \
                        pick_tail = pick_ptr)

/*}}}  */
/*{{{  ClrScr*/
#ifdef STD_C
void            ClrScr(void)
#else
void            ClrScr()
#endif
{
  gotoxy(1, W_oy);
  ClrFullScr();
}
/*}}}  */
/*{{{  proc_dispose*/
#ifdef STD_C
void            proc_dispose(element *p)
#else
void            proc_dispose(p) element *p;
#endif
{
  dispose_size += lines_within(p);
  join_links(dispose_tail, p);
  dispose_tail = p;
}
/*}}}  */
/*{{{  proc_language*/
#ifdef STD_C
PRIVATE void    proc_language(LOC_flare *LINK)
#else
PRIVATE void    proc_language(LINK) LOC_flare *LINK;
#endif
{
  int             i;
  char            lang_prompt[80];

  *lang_prompt = '\0';
  for (i = 0; i <= NO_LANGUAGES; i++)
  {
    strcat(lang_prompt, language_string[i]);
    strcat(lang_prompt, " ");
  }
  readprompt(LINK->command_str, lang_prompt, 1);
  if (*LINK->command_str != '\0')
  for (i = 0; i <= NO_LANGUAGES; i++)
  if (toupper(LINK->command_str[0]) == *language_string[i])
  {
    dialect = i;
    break;
  }
  if (dialect == NO_LANGUAGES - 1)
  {
    readprompt(dialect_start[dialect],"Start of comment", 3);
    readprompt(dialect_end[dialect], "End of comment", 3);
  }
  title();
}
/*}}}  */
/*{{{  initialise*/
#ifdef STD_C
PRIVATE void    initialise(LOC_flare *LINK)
#else
PRIVATE void    initialise(LINK) LOC_flare *LINK;
#endif
{
  element        *WITH;

  real_tail = real_head;
  dispose_head = (element *) malloc(sizeof(element));
  line_size = sizeof(element);
  dispose_tail = dispose_head;
  null_item_ptr = dispose_head;
  null_item_ptr->strng = NULL;

  WITH = null_item_ptr;
  WITH->selected = FALSE;
  WITH->foldline = NOT_FOLD;
  WITH->UU.U1.indent = 0;
  WITH->UU.U1.fold_indent = 0;
  WITH->fold = NULL;
  WITH->UU.U1.fold_type = 0;
  WITH->UU.U1.fold_contents = 1;
  WITH->fold_close_line = 4;
  proc_new(&new_file_ptr);
  proc_new(&pick_head);
  pick_tail = pick_head;
  proc_new(&deleted_line_ptr);
  proc_new(&buff_start_ptr);
  buff_end_ptr = buff_start_ptr;
  move_ptr = NULL;
  pick_ptr = NULL;
  LINK->keypad = TRUE;
  line_dsp_line = NULL;
  ClrFullScr();
}
/*}}}  */
/*{{{  goto_line*/
#ifdef STD_C
PRIVATE void    goto_line(LOC_flare *LINK)
#else
PRIVATE void    goto_line(LINK) LOC_flare *LINK;
#endif
{
  int no;

  readprompt(LINK->command_str, "goto-line", 15);
  no = 0;
  if (*LINK->command_str != '\0')
  if ((no=atoi(LINK->command_str))>0)
  {
    LINK->cursor_x_pos = 1;
    find_element(no, 4);
  }
}
/*}}}  */
/*{{{  valid_screen_key*/
#ifdef STD_C
PRIVATE bool valid_screen_key(bool * keypad, int *ch)
#else
PRIVATE bool valid_screen_key(keypad, ch) bool *keypad; int *ch;
#endif
{
  if (*keypad && select_on) return (key_convert_list[*ch - 256][2]);
  else return TRUE;
}
/*}}}  */
/*{{{  flare2_program*/
#ifdef STD_C
PRIVATE void    flare2_program(void)
#else
PRIVATE void    flare2_program()
#endif
{
  LOC_flare       V;
  int             sect_lines;
  TOKEN           ch;
  bool            temp_b;
  char            t_str[MAX_FIELD_SIZE + 1], STR1[MAX_FIELD_SIZE + 1];
  bool            quit = FALSE;
  int             cursor_x_pos = 1;
  element        *WITH;
  char            STR2[166];
  char            STR3[170];
  char            STR4[168];
  char            STR5[256];

  dsp_fields[0]=4; dsp_fields[1]=OVERFLOW_LINE;
  V.cursor_x_pos = cursor_x_pos;
  initialise(&V);
  read_list();
  if (gotoarg>0) find_element(gotoarg, 4);
  do
  {
    copyin(current_dsp_line, current, FALSE);
    proc_to_edit_pos();
    strcpy(old_current_dsp_line, current_dsp_line);
    dsp_fields[0] = cursor_level;
    ch = field_edit(&V.keypad, &V.cursor_x_pos, current_dsp_line);
    proc_from_edit_pos();
    if (current->foldline != END_FOLD)
    copyout(current_dsp_line, current);
    if (valid_screen_key(&V.keypad, &ch))
    {
      no_message();
      if (V.keypad)
      {
        switch (ch)
        {
          /*{{{  O_AUTO_FOLD*/
          case O_AUTO_FOLD:
          if (!select_on)       /* makefold */
          {
            start_make_fold(V.cursor_x_pos);    /* makefold */
            if (select_on)
            {
              while (current != tail && last_char(line_of(STR1, current)) > 0)
              move_down();
              make_fold(&V.cursor_x_pos);
              if (!select_on) /* makefold */
              {
                WITH = current;
                copy_parts_to_parts(WITH->fold, &current);
                write_dsp_line(current, cursor_level);
                move_down();
                while (current!=tail && last_char(line_of(STR1, current))==0)
                move_down();
              }
            }
          }
          break;
          /*}}}  */
          /*{{{  O_FOLD_INFO*/
          case O_FOLD_INFO:
          WITH = current;
          message("Enter depth  ",FALSE);
          printf("%d folds. %d spaces. ", enter_depth, enter_depth_spaces);
          if (filed_or_fold(current))
          printf(":::A %2d %d", WITH->UU.U1.fold_type, WITH->UU.U1.fold_contents);
          if (WITH->foldline == START_FILED)
          printf(" %s", line_of(STR1, WITH->other_end));
          break;
          /*}}}  */
          /*{{{  O_FIND/O_FIND_REVERSE*/
          case O_FIND:
          case O_FIND_REVERSE:
          get_search();
          if (*item_to_look_for!='\0')
          if (!find_item(&V.cursor_x_pos,ch==O_FIND_REVERSE)) message("failing",TRUE);
          break;
          /*}}}  */
          /*{{{  O_OPEN_NEW_FILE*/
          case O_OPEN_NEW_FILE:
          if (yes("File not saved. Save")) total_save();
          delete_list(real_head, real_tail);
          read_list();
          break;
          /*}}}  */
          /*{{{  O_UNDEL_LINE*/
          case O_UNDEL_LINE:
          if (!entered(current))
          {
            if (line_dsp_line == NULL && dispose_head != dispose_tail)
            {
              message("Press undo-delete-line again for best try",TRUE);
              ch = edit_key(&V.keypad);
              if (V.keypad && ch == O_UNDEL_LINE) proc_undispose(&line_dsp_line);
              else press(ch, V.keypad);
            }
            if (line_dsp_line != NULL) undelete_before(line_dsp_line);
            line_dsp_line = NULL;
          }
          break;
          /*}}}  */
          /*{{{  O_BOT_OF_FOLD*/
          case O_BOT_OF_FOLD:
          bottom();
          break;
          /*}}}  */
          /*{{{  O_TOP_OF_FOLD*/
          case O_TOP_OF_FOLD:
          top();
          break;
          /*}}}  */
          /*{{{  O_COPY_PICK*/
          case O_COPY_PICK:
          if (current->foldline==NOT_FOLD || current->foldline==START_FOLD)
          {
            pick_ptr = NULL;
            if (copy_a_line(&pick_ptr))
            append_to_pick();
          }
          break;
          /*}}}  */
          /*{{{  O_PICK*/
          case O_PICK:
          pick_ptr = NULL;
          remove_line(&pick_ptr);
          if (pick_ptr != NULL) append_to_pick();
          break;
          /*}}}  */
          /*{{{  O_PUT_PICK*/
          case O_PUT_PICK:
          if (!entered(current))
          {
            if (pick_head != pick_tail)
            {
              if (available(2))
              undelete_pick_before();
            }
            else message("no pick",TRUE);
          }
          break;
          /*}}}  */
          /*{{{  O_LANGUAGE*/
          case O_LANGUAGE:
          proc_language(&V);
          break;
          /*}}}  */
          /*{{{  O_FILE_FOLD*/
          case O_FILE_FOLD:     /* file/unfile */
          if (filed_or_fold(current))
          {
            if (normal_att(current))
            {
              if (current->foldline == START_FOLD)
              {
                FILE *fp;
                char *s;
          
                check_fold(current);
                copy_parts_to_line(Start_of_fold, t_str);
                s=t_str; while (*s && *s!=' ') s++; *s='\0';
                if (access(t_str, AWRITE|AREAD)==0)
                {
                  sprintf(STR4, "toggle-create-fild-fold - Overwrite %s", t_str);
                  can_open = yes(STR4);
                }
                else if ((fp=fopen(t_str,"w"))!=NULL) { fclose(fp); can_open=TRUE; }
                else can_open=FALSE;
                  if (can_open)
                  {
                    copy_line_to_parts(t_str, &End_of_fold);
                    proc_exit(End_of_fold, Start_of_fold);
                    if (Start_of_fold->fold != End_of_fold)
                    delete_list(Start_of_fold->fold, End_of_fold->prec);
                    Start_of_fold->fold = End_of_fold;
                    End_of_fold->prec = Start_of_fold;
                    Start_of_fold->foldline = START_FILED;
                  }
                else
                {
                  sprintf(STR3, "You are not allowed to open %s", t_str);
                  message(STR3,TRUE);
                }
              }
              else
              { /* unfile */
                pre_open_fold(current);
                if (Start_of_fold->next == End_of_fold)
                insert_file(End_of_fold, Start_of_fold, End_of_fold, FALSE);
                close_fold_at(current);
              }
              write_dsp_line(current, cursor_level);
            }
          }
          break;
          /*}}}  */
          /*{{{  O_QUIT*/
          case O_QUIT:
          quit=(file_changed ? yes("File modified. Leave anyway") : TRUE);
          break;
          /*}}}  */
          /*{{{  O_UP*/
          case O_UP:
          move_up();
          break;
          /*}}}  */
          /*{{{  O_DOWN*/
          case O_DOWN:
          move_down();
          break;
          /*}}}  */
          /*{{{  O_LINE_UP*/
          case O_LINE_UP:
          line_up();
          break;
          /*}}}  */
          /*{{{  O_LINE_DOWN*/
          case O_LINE_DOWN:
          line_down();
          break;
          /*}}}  */
          /*{{{  O_FINISH*/
          case O_FINISH:
          if (tail == real_tail)
          {
            quit = TRUE;
            total_save();
          }
          else proc_error(1);
          break;
          /*}}}  */
          /*{{{  O_HELP*/
          case O_HELP:
          if (help(TRUE)) restore(1);
          break;
          /*}}}  */
          /*{{{  O_DESCRIBE_BINDINGS*/
          case O_DESCRIBE_BINDINGS:
          if (help(FALSE)) restore(1);
          break;
          /*}}}  */
          /*{{{  O_FIND_NEXT*/
          case O_FIND_NEXT:
          if (*item_to_look_for!='\0')
          if (!find_item(&V.cursor_x_pos,FALSE)) message("failing",TRUE);
          break;
          /*}}}  */
          /*{{{  O_INSERT_FILE*/
          case O_INSERT_FILE:
          if (!entered(current))
          {
            insert_file((element *) NULL, current->prec, current, FALSE);
            restore_element((uchar) cursor_level);
          }
          break;
          /*}}}  */
          /*{{{  O_DEL_LINE*/
          case O_DEL_LINE:
          remove_line(&line_dsp_line);
          break;
          /*}}}  */
          /*{{{  O_ATTACH_FILE*/
          case O_ATTACH_FILE:
          if (current->foldline == START_FOLD) {
            if (normal_att(current)) {
              check_fold(current);
              if (Start_of_fold->fold == End_of_fold) {
                copy_parts_to_line(Start_of_fold, t_str);
                if (access(t_str,AREAD)==0)
                {
                  copy_line_to_parts(t_str, &End_of_fold);
                  Start_of_fold->foldline = START_FILED;
                  write_dsp_line(current, cursor_level);
                }
                else
                {
                  sprintf(STR2, "open-file-fold %s failed", t_str);
                  message(STR2,TRUE);
                }
              }
            }
          }
          break;
          /*}}}  */
          /*{{{  O_PAGE_DOWN*/
          case O_PAGE_DOWN:
          for (sect_lines = 1; sect_lines <= 6; sect_lines++)
          move_down();
          V.cursor_x_pos = 1;
          break;
          /*}}}  */
          /*{{{  O_PAGE_UP*/
          case O_PAGE_UP:
          for (sect_lines = 1; sect_lines <= 6; sect_lines++)
          move_up();
          V.cursor_x_pos = 1;
          break;
          /*}}}  */
          /*{{{  O_RETURN*/
          case O_RETURN:
          if (!select_on)
          {
            if (split_line)
            {
              undelete_after(part_line);
            }
            else
            {
              undelete_before(part_line);
              move_down();
            }
            (void) available(0);
          }
          break;
          /*}}}  */
          /*{{{  O_SUSPEND*/
          case O_SUSPEND:
          {
            char *shell;
            if ((shell = getenv("SHELL")) == 0)
            {
              message("no SHELL environment variable",TRUE);
              break;
            }
            message("sub shell created",TRUE);
            gotoxy(1, screen_lines);
            putchar('\n');
            fflush(stdout);
            reset_keyboard();
            system(shell);
            init_keyboard();
            gotoxy(1, 1);
            ClrFullScr();
            title();
            restore(1);
          }
          break;
          /*}}}  */
          /*{{{  O_SHELL_COMMAND*/
          case O_SHELL_COMMAND:
          {
            char cmd[80];
          
            readprompt(cmd, "shell-command", 80);
            if (*cmd=='\0') break;
            gotoxy(1, screen_lines);
            putchar('\n');
            fflush(stdout);
            reset_keyboard();
            system(cmd);
            init_keyboard();
            message("End",TRUE);
            single_key();
            gotoxy(1, 1);
            ClrFullScr();
            title();
            restore(1);
          }
          break;
          /*}}}  */
          /*{{{  O_SAVE_FILE*/
          case O_SAVE_FILE:
          total_save();
          title();
          break;
          /*}}}  */
          /*{{{  O_WRITE_FILE*/
          case O_WRITE_FILE:
          {
          if (tail == real_tail)
          {
            readprompt(t_str, "write-file", 63);
            if (*t_str != '\0') copy_line_to_parts(t_str, &new_file_ptr);
            if (!fold_in && (dialect < NO_LANGUAGES))
              fold_out=yes("listing-mode");
            else
              fold_out=FALSE;
            proc_exit(new_file_ptr, real_head->next);
            fold_out=FALSE;
            title();
          }
          else proc_error(1);
          break;
          }
          /*}}}  */
          /*{{{  O_DELETE*/
          case O_DELETE:
          if (current->foldline == NOT_FOLD) {
            if (current != tail && current != head->next &&
            current->prec->foldline == NOT_FOLD) {
              copy_parts_to_line(current, t_str);
              trailing_spaces(t_str);
              part_line = NULL;
              remove_line(&part_line);
              proc_dispose(part_line);
              move_up();
              copyin(current_dsp_line, current, FALSE);
              trailing_spaces(current_dsp_line);
              V.cursor_x_pos = strlen(current_dsp_line) + 1;
              sprintf(STR5, "%s%s", line_of(STR1, current), t_str);
              copy_line_to_parts(STR5, &current);
              write_dsp_line(current, cursor_level);
            }
          }
          break;
          /*}}}  */
          /*{{{  O_REPLACE*/
          case O_REPLACE:
          {
            get_search();
            if (*item_to_look_for!='\0')
            {
              get_replace();
              while (find_item(&V.cursor_x_pos,FALSE))
              {
                copyin(current_dsp_line, current, FALSE);
                proc_replace(item_to_look_for, replace_item, current_dsp_line,
                V.cursor_x_pos);
                V.cursor_x_pos+=strlen(replace_item);
                copyout(current_dsp_line, current);
                write_dsp_line(current, cursor_level);
              }
              no_message();
            }
            break;
          }
          /*}}}  */
          /*{{{  O_QUERY_REPLACE*/
          /* sorry for this hack, improve it if you can */
          case O_QUERY_REPLACE:
          {
            char ch='\0';
          
            get_search();
            if (*item_to_look_for!='\0')
            {
              get_replace();
              while (find_item(&V.cursor_x_pos,FALSE))
              {
                copyin(current_dsp_line, current, FALSE);
                if (ch!='!')
                {
                  if (V.cursor_x_pos>LEN)
                  {
                    gotoxy(1,OVERFLOW_LINE);
                    fputs(current_dsp_line+LEN,stdout);
                    clreol();
                    gotoxy((V.cursor_x_pos-1)%LEN+1,OVERFLOW_LINE);
                  }
                  else
                  {
                    message("(Y)es, (N)o, (!)Do rest, (A)bort, (.)Do and abort:",FALSE);
                    gotoxy(V.cursor_x_pos, cursor_level);
                  }
                  ch=single_key();
                  ch=tolower(ch);
                }
                else ch='y';
                if (ch!='n' && ch!='a')
                {
                  proc_replace(item_to_look_for, replace_item, current_dsp_line,
                  V.cursor_x_pos);
                  V.cursor_x_pos+=strlen(replace_item);
                  copyout(current_dsp_line, current);
                  write_dsp_line(current, cursor_level);
                }
                if (ch=='a' || ch=='.') break;
              }
              no_message();
            }
            break;
          }
          /*}}}  */
          /*{{{  O_REFRESH*/
          case O_REFRESH:
          restore(1);
          title();
          break;
          /*}}}  */
          /*{{{  O_GOTO_LINE*/
          case O_GOTO_LINE:
          goto_line(&V);
          break;
          /*}}}  */
          /*{{{  M_GO_LINE*/
          case M_GO_LINE:
            V.cursor_x_pos = 1;
            find_element(macro_int[get_arg()], 4);
            break;
          /*}}}  */
          /*{{{  O_FIRST_LINE_TO_FOLD_HEADER*/
          case O_FIRST_LINE_TO_FOLD_HEADER:
          WITH = current;
          if (WITH->foldline == START_FOLD)
          {
            copy_parts_to_parts(WITH->fold, &current);
            write_dsp_line(current, cursor_level);
          }
          break;
          /*}}}  */
          /*{{{  O_CREATE_FOLD*/
          case O_CREATE_FOLD:
          if (!select_on)
          {
            if (available(3))
            start_make_fold(V.cursor_x_pos);
          }
          else make_fold(&V.cursor_x_pos);
          break;
          /*}}}  */
          /*{{{  O_ENTER_FOLD*/
          case O_ENTER_FOLD:
          V.cursor_x_pos = 1;
          enter_fold();
          break;
          /*}}}  */
          /*{{{  O_EXIT_FOLD*/
          case O_EXIT_FOLD:
          exit_fold();
          break;
          /*}}}  */
          /*{{{  O_REMOVE_FOLD*/
          case O_REMOVE_FOLD:
          remove_fold();
          break;
          /*}}}  */
          /*{{{  O_OPEN_FOLD*/
          case O_OPEN_FOLD:
          open_fold();
          break;
          /*}}}  */
          /*{{{  O_CLOSE_FOLD*/
          case O_CLOSE_FOLD:
          close_fold();
          break;
          /*}}}  */
          /*{{{  O_MOVE*/
          case O_MOVE:
          if (move_ptr != NULL)
          {
            if (!entered(current))
            {
              undelete_before(move_ptr);
              move_ptr = NULL;
            }
          }
          else remove_line(&move_ptr);
          break;
          /*}}}  */
          /*{{{  O_COPY*/
          case O_COPY:
          if ((current->foldline == NOT_FOLD ||
          current->foldline == START_FOLD) && current != tail)
          {
            if (available(lines_within(current)))
            {
              if (copy_a_line(&copy_ptr))
              undelete_after(copy_ptr);
            }
          }
          break;
          /*}}}  */
          /*{{{  M_EXIT*/
          case M_EXIT: {
            char string[100];
            char *s=string;
            TOKEN x;
          
            while ((x=get_arg())!=M_END_MACRO) *s++ = x;
            *s='\0';
            if (*string!='\0') message(string,TRUE);
            stop_macros();
            break;
          }
          /*}}}  */
        }
      }
    } else message("key disabled during create fold",TRUE);
  } while (!quit);

  full_window();
  message("Bye",TRUE);
  gotoxy(1, screen_lines);
}
/*}}}  */
/*{{{  exit_origami*/
void exit_origami(c) int c;
{
  reset_keyboard();
  putchar('\n');
  exit(c);
}
/*}}}  */

/*{{{  argtab*/
#define argnum 6

ARG argtab[argnum] =
{
  's', INT_ARG, &m_s_depth,
  'l', INT_ARG, &gotoarg,
  'k', STRING_ARG, keybase,
  'n', BOOL_ARG, &fold_in,
  'b', BOOL_ARG, &browse_mode,
  'p', BOOL_ARG, &c_hash_front
};
/*}}}  */

#ifdef STD_C
extern int      HostBegin(void);
#else
extern int      HostBegin();
#endif

/*{{{  main*/
#ifdef STD_C
main(int argc, char *argv[])
#else
main(argc, argv) int argc; char *argv[];
#endif
{
  int called_argc=argc;

#ifndef NO_MSG
  printf("%s\n,%s\n",
  "originally by:- Martin Green, Ferranti Ltd, Cheadle Heath, Stockport, England",
  "Converted from Pascal and modified by Charlie Lawrence, Eastman Kodak Co.");
  sleep(1);
#endif
  strcpy(keybase,".origami");
  m_s_depth=M_DEPTH;
  argc=argparse(argc,argv,argtab,argnum);
  if (m_s_depth<=0) {
    fprintf(stderr,"invalid macrostackdepth\n");
    exit(1);
  }
  if (argc==2) {
    filearg = argv[1];
  } else if (argc!=1) {
    fprintf(stderr,"wrong parameter list\n");
    fprintf(stderr,"usage: origami [-lnumber][-knamebase][-b][-p] [filename]\n");
    exit(1);
  }
  if (HostBegin()) exit(1);
  full_window();
  ClrScr();

  flare2_program();

  exit_origami(0);
}
/*}}}  */
