#include <stdio.h>

#include "bool.h"

#include "short.h"
#include "keys.h"
#include "keytab.h"

/*{{{  add_key*/
Key *add_key (key,current)
int key;
Key *current;
{
Key *k,*a;
static int nadd_count,add_count = 0;

   /*{{{  is key already used?*/
   for (k = current->n_level;k;k = k->next) {
     /*{{{  used => return it*/
     if (k->key == key) {
       nadd_count++;
       if (k->code) {
         printf ("Warning: Key %d is masked by other keys.\n",k->code);
         return(0);
       }
       return (k);
     }
     /*}}}  */
     if (k->next == 0) break;
   }
   /*}}}  */
   /*{{{  else generate new tree-entry*/
   /*{{{  get new tree-node*/
   if ((a = (Key *)calloc (sizeof(Key),1)) == 0) {
           perror ("calloc");
           return (0);
   }
   a->key = key;
   /*}}}  */
   if (k == 0)
     current->n_level = a;
   else
     k->next = a;
   return (a);
   /*}}}  */
}
/*}}}  */
/*{{{  set_key_code*/
int set_key_code (code,current)
TOKEN code;
Key *current;
{
  if (current->code) {
    printf("duplicate key sequence %d and %d.\n",code,current->code);
    return (1);
  }
  if (current->n_level) {
    printf ("Warning: Key %d masks other keys.\n",code);
    return(1);
  }
  current->code = code;
  return (0);
}
/*}}}  */
static Key *toplevel,*find_current;
/*{{{  find_key*/
int find_key (key)
int key;
{
Key *find;

        for (find = find_current->n_level;find;find = find->next)
                if (key == find->key)
                        break;


/* sequence not found, end search */
        if (find == 0) {
                find_current = toplevel;
                return (0);
        }

/* an encoded sequence is found, end search */
        if (find->code) {
                find_current = toplevel;
                return (find->code);
        }

/* the search continues */
        if (find->n_level) {
                find_current = find;
                return (1);
        }
/* no level below this, the search ends */
        find_current = toplevel;
        return (0);
}
/*}}}  */
/*{{{  set_key_top*/
void set_key_top (top)
Key *top;
{
  toplevel = top;
  find_current = top;
}
/*}}}  */
