.NH 1
Installing Origami
.\"{{{  Compiling Origami
.NH 2
Compiling Origami
.LP
Before compiling Origami, you have to generate makefiles for your
machine.  There are cpp-makefiles with explanations on how to do this at
their heads.  If you port Origami to a new machine, please change the
cpp-makefile and send me cdiffs for everything.  Origami tries to be
POSIX compatible.  Not BSD, not v7, not system V.  POSIX!  After
compiling everything, copy the binaries to /usr/local/bin.  I suggest to
copy the keybind-files and the learn directory to a public readable
directory, where every user can get them to modify them for his personal
use.  At last, you have to make your choice, which keybindings you
personally want to use.  Read the next sections to see how to install
them.
.\"}}}
.\"{{{  origami and its startup-files
.NH 2
Startup-files
.LP
Origami uses startup-files to determine its behaviour.  Every used
command must be bound to keyboard-inputs explicitly.  You can also
declare ``user defined commands''.  These features are
explained in the chapter ``Programming in OCL''.
.LP
Used startup-files and their meanings:
.\"{{{  rc
.IP $HOME/.origamirc
This file contains the keybinding table and all user defined commands.
Every command you want to use is bound to a sequence of keyboard inputs.
Origami won't start missing the file ``$HOME/.origamirc''.
.\"}}}
.\"{{{  bind
.IP $HOME/.origamibind
This file contains a help, decribing the keysequences for each bound
command.  Its displayed when calling the command
``describe-bindings''.
.\"}}}
.\"{{{  help
.IP $HOME/.origamihelp
There is no standardfile for it.  It's displayed using the special
origami command ``O_HELP''.  You can use it for ``user-defined-helps''
(all the stuff you always forget).
.\"}}}
.LP
.\"{{{  generate the base
The namebase ``.origami'' in ``$HOME/.origamirc'',
``$HOME/.origamibind'' and ``$HOME/.origamihelp'' is generated using the
commandname (argv[0]) and the following rules:
.IP \(bu
If there are any path-limiters ``/'', only the string following the last
``/'' is used.
.IP \(bu
All ``.'' at begin of the remaining string are removed.
.IP \(bu
The startupfilenames are generated by adding ``$HOME/.'' at front and
``rc'', ``bind'' or ``help'' at end of the string.
.\"}}}
.LP
.\"{{{  example
This way of getting the startup-files makes it possibly to use origami
with several startup-files.  Renaming the binary or using a link
switches to other startup-files.  For example:
.IP origami
using a normal text-installation.  No special commands.
.br
Uses ``$HOME/.origamirc'', ...
.IP morigami
using special mail-macros.
.br
Uses ``$HOME/.morigamirc'', ...
.LP
To use such an environment, create a link named ``morigami'' and generate
startup-files ``$HOME/.morigamirc``, ...  containing bindings and macros
needed for mailing.
.\"}}}
.\"}}}
.\"{{{  Keybindings
.NH 2
Keybindings
.\"{{{  synopsis of keybind
.NH 3
Synopsis of Keybind
.LP
The keybind program compiles a keybinding-file into the startupfiles
``$HOME/.origamirc'' and ``$HOME/.origamibind''.  Its synopsis is:
.DS
keybind [-hlsv?] [\-o<namebase>] \fIkeybinding-file\fP
keybind \-k<number>
.DE
Options:
.IP \-s
the entries in bind are sorted
.IP "\-o<name>"
the outputfiles are named $HOME/<name>rc and $HOME/<name>bind instead of
$HOME/.origamirc etc.  Useful for using origami via link, renamed binary
or with commandline option ``-k<basename>''.
.IP \-k<number>
display the names of the origami function with token-value number.  This
is useful, if keybind complains about your keybinding (different
functions bound to the same keysequence etc.).
.IP \-?
display usage
.IP \-h
same
.IP \-l
list all keywords known in origami and keybind.
.IP \-v
during compilation of the sourcefile print information about needed
resources.
.LP
Be careful with keybind, it overwrites existing files!
.\"}}}
.\"{{{  the keybinding file
.NH 3
The keybinding file
.nr PP .25v
.\"{{{  introduction to keybindings and OCL
.sp .5v
.LP
This file contains a list of ASCII rules to bind keysequences to Origami
functions.  It looks like LISP, but it isn't LISP.  The language is
named OCL (Origami control language).  This section describes all
functions used for binding functions to keys.  OCL is described in a
later chapter, because it is not necessary for keybindings and it is very
powerful, perhaps too powerful for learning it while installing Origami.
.\"}}}
.\"{{{  defbinding for name of keybinding
.sp .5v
.LP
(defbinding <name-of-binding>)
.IP "" .75c
Defines a name for the binding, which is displayed in the statusline of
Origami.  Multiple usage of this command is not allowed.  The name is
limited to 16 characters.
.\"}}}
.\"{{{  keybind
.sp .5v
.LP
(keybind <operation> <keysequence>)
.IP "" .75c
The Origami-operation named <operation> is bound to the keyboard input
<keysequence>.  The file .origamibind contains an entry ``<operation>
<keysequence>''
.\"}}}
.\"{{{  alias
.sp .5v
.LP
(alias <name> <keysequence>)
.IP "" .75c
The keyboard input <keysequence> can be named $<name> in the following
definitions.  Using $<name> puts name in the file .origamibind instead
of the sequence of keys.
.\"}}}
.\"{{{  description of operands
.\"{{{  name
.sp .5v
.LP
\fI<name>\fP is a normal identifier
.\"}}}
.\"{{{  keysequence
.sp .5v
.LP
A \fI<keysequence>\fP is a sequence of <key> enclosed in parentheses.
.\"}}}
.\"{{{  key
.sp .5v
.LP
\fI<key>\fP specifies a single key (or two keys, because M-"a requires two keystrokes):
.IP \fI"x\fP 1i
is a single character
.IP \fIC-X\fP 1i
is control-x
.IP \fIC-?\fP 1i
is the delete-key (127)
.IP \fIM-"x\fP 1i
means Meta-key (ESC) followed by x (case-sensitive)
.IP \fIM-C-X\fP 1i
META-control-x
.IP \fI$name\fP 1i
represents the keys defined in (alias name ..)
.\"}}}
.\"}}}
.nr PP .75v
.\"{{{  comments and folds
.sp .5v
.LP
Newlines can be used anywhere in the text between syntactical
structures.  Comments can be put in the same way.  A comment starts with
``;'' and ends at the end of the line.  The braces ``{'' and ``}'' have
the same effect as ``;'', so you can use origami with language None and
filed-folds are included automatically.
.\"}}}
.\"{{{  default aliases
.\"{{{  terminal independent capabilities
.LP
These aliases can be used without declaration:
.DS
$esc = escape-key = 27
$tab = tab-key = 9
$return = return-key = 13 (yes!)
.DE
.\"}}}
.\"{{{  terminal depedent capabilities
The following default aliases are available, if your terminal has the
termcap capabilities in parentheses: $backspace (kb), $backtab (kB),
$rubout (kD), $clreol (kE), $delline (kL), $home (kh), $end (kH), $up
(ku), $down (kd), $left (kl), $right (kr), $prev_page (kN), $next_page
(kP) $f0 (k0), $f1 (k1), $f2 (k2), $f3 (k3), $f4 (k4), $f5 (k5), $f6
(k6), $f7 (k7), $f8 (k8), $f9 (k9), $f10 (k;)
.PP
Your termcap(5) manual explains all capabilities in detail.  The above
keys mentioned do not represent all capabilities, but those which are
frequently used.
.\"}}}
.\"}}}
.\"}}}
.\"{{{  example
.NH 3
Example
.LP
The following examples are only written to explain the syntax.  They
will not really work, because you will not be able to move the cursor or
even quit Origami.
.\"{{{  first example with return
.DS
; This is a simple keybind-file
(keybind newline-and-indent C-M)
.DE
The operation `newline-and-indent' is activated through C-M.  The
keybindinghelp contains `newline-and-indent C-M'.
.\"}}}
.\"{{{  same example with alias
You can achieve the same keybinding by using an alias:
.DS
; This keybinding uses alias
(alias return C-M)
(keybind newline-and-indent $return)
.DE
The operation `newline-and-indent' is also activated through C-M, but
the keybinding help contains now `newline-and-indent return'.
.\"}}}
.\"}}}
.\"}}}
.\"{{{  Termcap
.NH 2
Required termcap capabilities
.LP
Origami uses the termcap database.  It requires a few capabilities to
work.  It does not need intelligent terminals.  The following
capabilities are required:
.\"{{{  required capabilities
.IP cm
cursor motion
.IP ce
clear to end of line
.IP cd
clear to end of display
.IP co
number of columns
.IP li
number of lines
.\"}}}
.LP
The following capabilities are optional:
.\"{{{  optional capabilities
.IP ti
termcap usage initialization
.IP te
termcap usage end
.IP al
add line
.IP dl
delete line
.IP so
stand out
.IP se
standout end
.IP sg
standout glitch
.\"}}}
.\"}}}
.\"{{{  Bugs and limitations of Origami
.NH 2
Limitations of Origami
.LP
Origami stores the complete file in memory while editing which limits
the size of files to 24 kByte on PC MINIX 1.5.10.  The length of a line
is limited to 256 characters, and the depth of folding is limited to
256.  When reading files, longer lines are splitted.  Indenting folds
may generate long lines and this case isn't handled correct.  Origami
expands tab characters to blanks.  You should never edit Makefiles with
Origami, because make needs tab characters.  Otherwise, it is unable to
work.  In my opinion, this is a (documented!) bug in make.  If your file
contains `{\&{\&{', `:\&:\&:\&', `.\&.\&.' or \&`}\&}\&}', Origami will
think of them as folding marks!  Origami may die on such things.  There
is a problem editing ``C''-files, if you use the preprocessor-mark ``#''
within the fold-structure.  Origami only allows input, when the current
position is behind current indentation.  Use option \-p to change the
position of leading ``#'' while writing or reading files.  If Origami is
reading a file or a pipe, you cannot abort it.  So you cannot abort the
entering of a filed fold.
.\"}}}
