#include "keys.h"
#ifndef GLOBALS_H
#define GLOBALS_H

#ifdef GLOBALS_G
# define vextern
#else
# define vextern extern
#endif

#define MAX_FIELD_SIZE  156

#define END_OF_LINE     '$'

#define TITLE_LINE      (screen_lines-1)
#define MESSAGE_LINE    screen_lines
#define OVERFLOW_LINE   MESSAGE_LINE
#define SCREEN_LEN      (screen_lines-2)
#define NOT_FOLD        0
#define START_FILED     0x81
#define START_FOLD      0x82
#define END_FOLD        0x83
#define START_OPEN_FOLD 0x86
#define START_ENTER_FILED 0x87
#define START_ENTER_FOLD 0x88
#define MARKER_LEN      5
#define NO_LANGUAGES  8   /*(inc User-defined)+tds*/
#define START    1
#define LEN     80
#define M_DEPTH 64

/* ATTENTION: ONLY FOR MINIX PC, USE short OR int FOR OTHER SYSTEMS */
typedef unsigned char SHORT;

typedef unsigned char uchar;
typedef uchar buffer[1024];

typedef char *language_comment[NO_LANGUAGES + 1];

typedef int fields[2];

typedef struct element {
  char *strng;
  struct element *prec, *next, *fold, *other_end;
  bool selected;
  uchar foldline, fold_close_line;
  union {
    struct {
      SHORT indent, fold_indent, fold_type, fold_contents;
    } U1;
    struct {
      int int1, int2;
    } U0;
  } UU;
} element;

typedef int key_conversion[3];
typedef key_conversion key_convert_lists[];

#define version         "1.5"

#define MAX_MACRO_LENGTH        512

#define null_dsp_line   ""

extern key_convert_lists key_convert_list;

extern bool file_changed, browse_mode;

extern fields dsp_fields;

extern bool select_on;

extern char deleted_ch;

vextern element *line_dsp_line, *part_line, *new_file_ptr;
vextern bool split_line;
vextern element *head, *tail, *current, *select_ptr, *screen_start,
                *screen_end, *null_item_ptr, *deleted_line_ptr,
                *buff_start_ptr, *buff_end_ptr, *real_head, *real_tail;
vextern int makefold_indent;
vextern element *move_ptr, *copy_ptr, *pick_ptr, *dispose_head, *dispose_tail,
                *pick_head, *pick_tail;
extern int cursor_level, screen_end_level;
extern char item_to_look_for[40], replace_item[40];
extern bool key_already_pressed;
extern char already_pressed_key;
extern bool already_pressed_keypad_key, screen_message;

vextern char keybinding_name[10];

extern language_comment dialect_start;

extern language_comment dialect_end;

extern bool fold_out;
extern bool fold_in;
extern bool c_hash_front;

#define fortran_ 6
#define c_typ 3

extern char *language_string[NO_LANGUAGES + 1];

extern int dialect, dispose_size, enter_depth, enter_depth_spaces;
extern char fold_open_str[5];
extern char specials[9];
extern bool new_file;

struct LOC_flare2_program {
  char command_str[17];
  bool keypad;
  int cursor_x_pos;
} ;
typedef struct LOC_flare2_program LOC_flare;

struct LOC_field_edit {
  int *field_pos;
  char *field_str;
  bool field_key;
  int sect, full_len, ind;
} ;
typedef struct LOC_field_edit LOC_field;

struct LOC_insert_file {
  FILE *tdsfile;
  element *current, *trailing, *S;
  char filename[65];
  int new_indent;
  char dsp_line[MAX_FIELD_SIZE + 1];
  char tdsfile_NAME[120];
} ;
typedef struct LOC_insert_file LOC_file;

struct LOC_proc_exit {
  element *file_ptr, *p, *pn;
  char dsp_line[MAX_FIELD_SIZE + 1];
  FILE *tdsfile;
  char tdsfile_NAME[120];
} ;
typedef struct LOC_proc_exit LOC_proc;

typedef struct {
  bool defineable;
  TOKEN *string;
} macro_entry;
#define MACRO_COUNT (MAX_MACRO+1)
extern macro_entry fix_macros[MACRO_COUNT];
vextern int m_s_depth;
vextern int *macro_int;
vextern bool macro_tag;

vextern FILE *tstorefile;
vextern int line_size, current_ind, first_edit_pos,
              pre_edit_pos;
vextern char current_dsp_line[MAX_FIELD_SIZE + 1],
             old_current_dsp_line[MAX_FIELD_SIZE + 1];
vextern char tstorefile_NAME[120];

vextern int P_ioresult, W_dy, W_oy,W_dx;
vextern bool file_exists, can_open;
vextern element *End_of_fold, *Start_of_fold, *Line_after_fold;

vextern char *filearg;
vextern int gotoarg;

#undef vextern

#endif

extern screen_lines;
extern bool dirty;
extern int sg;
