.NH 1
All Origami functions
.LP
This chapter lists all Origami functions with their keybind names.  Most
of them have an Emacs-like and a TDS name.  If you want to create a new
keybinding, regard the Emacs-like and the TDS binding as examples.
.\"{{{  moving around
.NH 2
Moving around
.\"{{{  backward-character
.LP
backward-character, O_LEFT
.\"}}}
.\"{{{  forward-character
.LP
forward-character, O_RIGHT
.\"}}}
.\"{{{  previous-line
.LP
previous-line, O_UP
.\"}}}
.\"{{{  next-line
.LP
next-line, O_DOWN
.\"}}}
.\"{{{  beginning-of-line
.LP
beginning-of-line, O_START_OF_LINE
.\"}}}
.\"{{{  end-of-line
.LP
end-of-line, O_END_OF_LINE
.\"}}}
.\"{{{  backward-word
.LP
backward-word, O_WORD_LEFT
.\"}}}
.\"{{{  forward-word
.LP
forward-word, O_WORD_RIGHT
.\"}}}
.\"{{{  previous-page
.LP
previous-page, O_PAGE_UP
.\"}}}
.\"{{{  next-page
.LP
next-page, O_PAGE_DOWN
.\"}}}
.\"{{{  beginning-of-fold
.LP
beginning-of-fold, O_TOP_OF_FOLD
.SP
Moves to the beginning of the entered fold.
.\"}}}
.\"{{{  end-of-fold
.LP
end-of-fold, O_BOT_OF_FOLD
.SP
Moves to the end of the entered fold
.\"}}}
.\"{{{  goto-line
.LP
goto-line, O_GOTO_LINE
.SP
Prompts for a line number and moves cursor to this line.  If needed,
Origami opens closed folds to reach this line.
Warning: goto-line counts lines from the beginning of an entered fold.
This may be not the beginning of the file.
.\"}}}
.\"}}}
.\"{{{  folding
.NH 2
Folding
.\"{{{  open-fold
.LP
open-fold, O_OPEN_FOLD
.SP
Open fold, and show the contents in the context of the current level.
You can not open file-folds, only entering them is allowed.
.\"}}}
.\"{{{  close-fold
.LP
close-fold, O_CLOSE_FOLD
.SP
If the cursor is located within an opened fold, close this fold.
.\"}}}
.\"{{{  enter-fold
.LP
enter-fold, O_ENTER_FOLD
.SP
Enter the fold at the current line.  Entering a filed-fold saves the
current file.
.\"}}}
.\"{{{  exit-fold
.LP
exit-fold, O_EXIT_FOLD
.SP
Exit fold.  Exiting a filed fold saves it.
.\"}}}
.\"{{{  unfold-fold
.LP
unfold-fold, O_REMOVE_FOLD
.SP
Remove fold at the current line \(em deletes the fold structure and
inserts the contents of the fold instead.
.\"}}}
.\"{{{  create-fold
.LP
create-fold, O_CREATE_FOLD
.SP
Create fold.  Use twice \(em first to indicate the top of a new fold,
then to indicate the bottom of it.  Lines to be included within the fold
must not be indented less than the fold itself.  Several other keys are
disabled while Create Fold is in operation.
.\"}}}
.\"{{{  create-auto-fold
.LP
create-auto-fold, O_AUTO_FOLD
.SP
Autofold: takes all lines to the first blank line, folds them up,
inserts the first line as the fold header, and positions the cursor on
the next non-blank line.
.\"}}}
.\"{{{  auto-header
.LP
auto-header, O_FIRST_LINE_TO_FOLD_HEADER
.SP
When the cursor is on a closed fold this key will copy the first line
enclosed by that fold onto the fold line.
.\"}}}
.\"{{{  toggle-create-file-fold
.LP
toggle-create-file-fold, O_FILE_FOLD
.SP
File (create new file) or unfile a fold.
.br
Creating a file writes the contents of the fold into a new file named by
the fold-comment (up to the first whitespace).  Unlike TDS origami does
not create a new filename, if the chosen one is already used.  It
doesn't matter, if you change the fold-comment after filing a fold,
because the filename is stored internally.
.br
Unfile a filed-fold removes the link and puts the file-contents into the
text.  Unlike TDS origami doesn't remove the file.
.\"}}}
.\"{{{  open-file-fold
.LP
open-file-fold, O_ATTACH_FILE
.SP
Attach a file to a fold.  This function open a existing file instead of
creating a new one (and thus differs from O_FILE_FOLD).  The filename is
taken from the comment of the empty fold the cursor is placed on.  The
filename begins behind the foldmark and ends at the first whitespace.
The rest of the line has no influence on the attach.  After attaching
files you can change the fold-header.  Fileinformation are stored
internally.
.\"}}}
.\"}}}
.\"{{{  editing
.NH 2
Editing
.\"{{{  delete-to-end-of-line, O_DEL_TO_EOL
.LP
delete-to-end-of-line, O_DEL_TO_EOL
.SP
Delete to end of line. There is no `undo' for this operation.
.\"}}}
.\"{{{  delete-line, O_DEL_LINE
.LP
delete-line, O_DEL_LINE
.SP
Transfers the current line to the `delete buffer', and overwrite the old
contents of the delete buffer.
.\"}}}
.\"{{{  undo-delete-line, O_UNDEL_LINE
.LP
undo-delete-line, O_UNDEL_LINE
.SP
Transfers the line currently stored in the delete buffer back into the
file before the current line.  This can be done for exact one line.
.\"}}}
.\"{{{  delete-character, O_DEL_CHAR_RIGHT
.LP
delete-character, O_DEL_CHAR_RIGHT
.SP
Delete character under the cursor.  If the cursor was at the right
margin, the next line will be appended to this line.
.\"}}}
.\"{{{  delete-previous-character, O_DELETE
.LP
delete-previous-character, O_DELETE
.SP
Deletes the character to the left of the cursor.  If the cursor was at
the left margin, this line will be appended to the previous line.
.\"}}}
.\"{{{  undo-delete-character
.LP
undo-delete-character
.SP
Undeletes the last deleted character.  Until the next ``O_DELETE'' or
``O_DEL_CHAR_RIGHT'' the character inserted in the text is always the
same.
.\"}}}
.\"{{{  transpose-characters
.LP
transpose-characters
.SP
transposes the character left of the cursor with the character under the
cursor and moves the cursor right one character.
.\"}}}
.\"{{{  case-word-capitalize
.LP
case-word-capitalize
.SP
Capitalizes the character under the cursor and puts the rest of the
word to lower case.  If the character under cursor is no letter,
nothing happens, otherwise it moves to the next non-letter after the
word.
.\"}}}
.\"{{{  case-word-upper
.LP
case-word-upper
.SP
Same as case-word-capitalize, but changes all letters to capitals.
.\"}}}
.\"{{{  case-word-lower
.LP
case-word-lower
.SP
Same as case-word-capitalize, but changes all letters to small ones.
.\"}}}
.\"{{{  toggle-case
.LP
O_TOGGLE_CASE
.SP
Characters under the cursor change their case.
.\"}}}
.\"{{{  newline-and-indent, O_RETURN
.LP
newline-and-indent, O_RETURN
.SP
Opens the line at cursor position and indents the right part like the
left part.  This works for fold comments only at end of line.
.\"}}}
.\"{{{  kill-line, O_PICK
.LP
kill-line, O_PICK
.SP
Removes a line from the file and adds it to the end of the `pick
buffer'.  Note that the `pick buffer' is lost on exiting Origami, unlike
TDS.
.\"}}}
.\"{{{  copy-to-kill-buffer, O_COPY_PICK
.LP
copy-to-kill-buffer, O_COPY_PICK
.SP
Copies a line to the end of the `pick buffer' without deleting it from
the file.  Note that the `pick buffer' is lost on exiting Origami,
unlike TDS.
.\"}}}
.\"{{{  fold-kill-buffer, O_PUT_PICK
.LP
fold-kill-buffer, O_PUT_PICK
.SP
Places the `pick buffer' before the current line.
.\"}}}
.\"{{{  move-line, O_MOVE
.LP
move-line, O_MOVE
.SP
If the move buffer is empty, the current line from the file is moved to
the `move buffer'.  Otherwise the `move buffer' is inserted before the
current line.  Note that the `move buffer' is lost on exiting Origami,
unlike TDS.
.\"}}}
.\"{{{  double-line, O_COPY
.LP
double-line, O_COPY
.SP
Duplicates the current line in the file.  Lines containing filed-folds
cannot be duplicated.
.\"}}}
.\"}}}
.\"{{{  search & replace
.NH 2
Search and replace
.\"{{{  search-forward
.LP
search-forward, O_FIND
.SP
Prompts for a search string and displays next occurence.  An empty search string
uses the last search string.
.\"}}}
.\"{{{  search-reverse
.LP
search-reverse, O_FIND_REVERSE
.SP
Same as search-forward, but searches backward.
.\"}}}
.\"{{{  replace-string
.LP
replace-string
.SP
Asks for a search and a replace string and replaces all occurences.
.\"}}}
.\"{{{  quere-replace-string
.LP
query-replace-string
.SP
Same as replace-string, but asks before replacing each occurence.
.\"}}}
.\"{{{  incremental-search
.LP
incremental-search
.SP
Searches the text for a string.  String can be entered incremental.
Deleting characters invokes a jump to the position, where the character
was added to the search-string.  Adding a character tries to find the
string.  Aborting this command jumps to the calling-position.  O_RETURN
ends the search.  O_UP, O_LEFT and O_FIND_REVERSE switch the
searchdirection to backwards and search the string.  O_DOWN, O_RIGHT and
O_FIND switch the searchdirection to forward and search the string.
.LP
incremental-reverse
.SP
Same as ``incremental-search'', but it starts with searchdirection
backwards.
.\"}}}
.\"}}}
.\"{{{  files
.NH 2
Files
.\"{{{  read-file
.LP
read-file, O_OPEN_NEW_FILE
.SP
Read another file for editing, saving the current one if required.
.\"}}}
.\"{{{  next-file
.LP
next-file
.SP
Read next file given in commandline, saving the current one if required.
.\"}}}
.\"{{{  previous-file
.LP
previous-file
.SP
Read previous file given in commandline, saving the current one if
required.
.\"}}}
.\"{{{  save-file
.LP
save-file, O_SAVE_FILE
.SP
saves the current file with the current name and language.
.\"}}}
.\"{{{  write-file
.LP
write-file
.SP
Prompts for a filename and `listing-mode'.  The text is written to a new
file with the current language.  If `listing-mode' is set, the generated
file is modified in the following way:
.DS
the `language-definition-line' is removed
in `begin-fold'-comments `{\&{\&{' are removed
the `end-fold'-comments are removed
.DE
While using the language `Tds' it is impossible to set `listing-mode',
because the the generated files have an incompatible structure.
.\"}}}
.\"{{{  insert-file
.LP
insert-file, O_INSERT_FILE
.SP
Insert File.  Prompts for a filename, and imports this file into the
file being edited at the current position.
.\"}}}
.\"{{{  filter-buffer
.LP
filter-buffer
.SP
Filters the current text.  Origami prompts for the name of a filter.
The current text is saved and piped through this filter.  Origami tries
to move the cursor to the line where the cursor stood before executing this
command.  Environment variables ORIFILE, ORILINE and ORIWORD are set to
current filename, textline and word.
.\"}}}
.\"{{{  pipe-from-command
.LP
pipe-from-command
.SP
Prompts for a command.  This will be executed and its standard output is
inserted in the text at current position.  Environment variables
ORIFILE, ORILINE and ORIWORD are set to current filename, textline and
word.
.\"}}}
.\"{{{  pipe-to-command
.LP
pipe-to-command
.SP
Prompts for a command.  The current file will be piped to this command
as standard input.  Environment variables ORIFILE, ORILINE and ORIWORD
are set to current filename, textline and word.
.\"}}}
.\"}}}
.\"{{{  macros
.NH 2
Macros
.\"{{{  define-macro
.LP
define-macro, O_DEFINE_MACRO
.SP
Records all keys into the keyboard macro buffer until define-macro is
pressed again.  Calling fix-macros is allowed during define-macro.
.\"}}}
.\"{{{  execute-macro
.LP
execute-macro, O_EXECUTE_MACRO
.SP
Call keyboard macro.
.\"}}}
.\"{{{  execute-macro-n
.LP
execute-macro-??, O_CALL_FIX_?? (1<=??<=64)
.SP
execute the fix-macro with number ??.  These macrobuffers are also used
from (defmacro ...  ) in keybind, so that using these operation has the
same effect as calling the keysequence from macro!.  Buffers not used
from keybind are empty.
.\"}}}
.\"{{{  DEFINE_FIX
.LP
O_DEFINE_FIX
.SP
Asks for the number of the fix macro buffer.  The contents of the
keyboard macro buffer is copied to this fix macro buffer.  Using (deffun
\&.. ) in keybind makes it impossible to overwrite
the fix buffer.
.\"}}}
.\"}}}
.\"{{{  shell commands
.NH 2
Shell commands
.\"{{{  i-shell
.LP
i-shell, O_SHELL
.SP
Creates a shell.  Exiting from this shell will return to Origami.
Environment variables ORIFILE, ORILINE and ORIWORD are set to current
filename, textline and word.
.\"}}}
.\"{{{  shell-command
.LP
shell-command
.SP
Prompts for a command and starts a shell which executes it.  Environment
variables ORIFILE, ORILINE and ORIWORD are set to current filename,
textline and word.
.\"}}}
.\"{{{  suspend-origami
.LP
suspend-origami
.SP
If your system has job control, origami will be stopped and the calling
shell is reactivated.
.\"}}}
.\"}}}
.\"{{{  arguments
.NH 2
Arguments
.LP
Like in Emacs, you can repeat each command by using an numerical
argument.  The first digit is given by set-argument-<digit>.  These
functions read more digits of the argument until you type a non-digit.
This non-digit may be a key sequence bound to a command or just a single
character.  It will be executed <argument> times.  Pressing the
abort-key will abort the repeated execution.  These commands can not be
used in macros.  If you are defining a keyboard-macro, the repeated
Operation is stored <argument> times in the buffer.
.LP
set-argument-0 ... set-argument-9
.\"}}}
.\"{{{  special functions
.NH 2
Special functions
.\"{{{  quote-character
.LP
quote-character, O_QUOTE
.SP
The next character typed in will be returned to the editor ignoring all
keysequences starting with it.
.\"}}}
.\"{{{  redraw-display
.LP
redraw-display, O_REFRESH
.SP
Refresh and center screen.  This is useful after getting things like
``Message from ...''.  If you are working with a window environment
which does not send a window-changed signal, you may use this command
after resizing a window.
.\"}}}
.\"{{{  help
.LP
help, O_HELP
.SP
Displays the helpfile $HOME/.origamihelp.  Since there is no default file for
this function, you can create your own helpfile.  It may be useful for new
and very complicated macros or other things you always forget.
.\"}}}
.\"{{{  describe-bindings
.LP
describe-bindings
.SP
Displays the keybinding file $HOME/.origamibind created by the keybind
compiler.  If you are using multiple keyboards, origami will only
display the entries concerning the current keytab.
.\"}}}
.\"{{{  set-language
.LP
set-language, O_LANGUAGE
.SP
Allows you to select the language for which the code is to be saved \(em
ie the format in which folds are to be saved.  If you choose `User',
origami prompts for the begin- and end-commentstring used for hiding the
foldcomments.  Each string can be up to three characters in length.
.\"}}}
.\"{{{  describe-fold
.LP
describe-fold, O_FOLD_INFO
.SP
Returns information on the fold depth, position and indentation of the
current line, plus information about any fold the cursor is on.
.\"}}}
.\"{{{  modes
.\"{{{  edit/view
.LP
add-mode-view
.SP
Sets view-only mode.
.LP
delete-mode-view
.SP
Sets edit mode.
.\"}}}
.\"{{{  insert/overwrite
.LP
add-mode-overwrite
.SP
Sets overwrite mode.  Text input will overwrite other text.
.LP
delete-mode-overwrite
.SP
Sets insert mode.  Text input will be inserted.
.\"}}}
.\"{{{  echo on/off
.LP
add-mode-echo
.SP
Incomplete keysequences are displayed under the statusline.
.LP
delete-mode-echo
.SP
Do not show unfinished keysequences.
.\"}}}
.\"{{{  auto-save on/off
.LP
add-mode-auto-save
.SP
Prompts for the auto-save duration.  Origami will save your files
periodically in auto-save mode.  Default time is 8 minutes.
.LP
delete-mode-auto-save
.SP
auto-save is switched of.
.\"}}}
.\"{{{  user-mode on/off
.LP
set-user-mode
.SP
Prompts for a string, which is displayed as additional mode in the
statusline.  Doing this again will overwrite the string.
.LP
reset-user-mode
.SP
No `user-mode'-string is displayed.
.\"}}}
.\"}}}
.\"{{{  pipe_kbd
.LP
O_PIPE_KBD
.SP
Prompts for a command.  This command will be executed and its
standardoutput will be read as keyboardinput for origami.  Using
O_PIPE_KBD while reading from a file instead of the keyboard will close
all pipes! Environment variables ORIFILE, ORILINE and ORIWORD are set to
current filename, textline and word.  The general-abort-key stops the
reading from a pipe.
.\"}}}
.\"{{{  abort
.LP
abort
.SP
Aborts any operation.  There are several commands which can be aborted
by this key.  This operation can only be bound to a
.I single
key.  This key even stops a running macro, which may be useful if it
contains an endless loop.  If you are anxious of Origami doing something
wrong, this key brings you back to a safe state.
.\"}}}
.\"}}}
.\"{{{  how to get out
.NH 2
How to get out
.nr PP .25v
.\"{{{  quick-exit

.LP
quick-exit, O_FINISH
.SP
If needed exit entered folds, save the file and exit from Origami.
.\"}}}
.\"{{{  exit-origami
.LP
exit-origami, O_QUIT
.SP
If your file was changed since last save, Origami asks you if you want
to leave anyway.
.\"}}}
.\"}}}
