/* filer.c - File routines for Origami */

#include <sys/types.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <access.h>
#include "bool.h"

#include "short.h"

#include "globals.h"
#define FILER_G
#include "origami.h"
#include "macros.h"

#ifdef STD_C
PRIVATE int P_eof(FILE *f)
#else
PRIVATE int P_eof(f)
FILE *f;
#endif /* STD_C */
{
  int ch;

  if (feof(f))
  return 1;
  if (f == stdin)
  return 0;    /* not safe to look-ahead on the keyboard! */
  ch = getc(f);
  if (ch == EOF)
  return 1;
  (void) ungetc(ch, f);
  return 0;
}

#ifdef STD_C
void proc_error(uchar b)
#else
void proc_error(b)
uchar b;
#endif /* STD_C */
{
  switch (b) {   /*case*/

    case 0:
    message("line is not a simple fold!",TRUE);
    break;

    case 1:
    message("not at top",TRUE);
    break;
  }
}

#ifdef STD_C
bool normal_att(element *p)
#else
bool normal_att(p)
element *p;
#endif /* STD_C */
{
  return (p->UU.U1.fold_type == 0 && p->UU.U1.fold_contents == 1);
}

int bfile_no = 0, bfile_last = 0;
buffer buff;   /*should have 1 for each file*/
PRIVATE int the_pos;

#ifdef STD_C
PRIVATE void get_dsp_file(LOC_file *LINK)
#else
PRIVATE void get_dsp_file(LINK) LOC_file *LINK;
#endif
{
  extern char *filearg;

  if (filearg)
  {
    strcpy(LINK->filename, filearg);
    filearg=NULL;
  }
  else readprompt(LINK->filename, "filename", 60);
}

#ifdef STD_C
PRIVATE void create_node(LOC_file *LINK)
#else
PRIVATE void create_node(LINK)
LOC_file *LINK;
#endif /* STD_C */
{
  element *pt;

  proc_new(&pt);
  copy_line_to_parts(LINK->dsp_line, &pt);
  if (LINK->trailing == NULL)
  pt->UU.U1.indent = LINK->new_indent;
  join_links(LINK->current, pt);
  LINK->current = pt;
}

#ifdef STD_C
PRIVATE void read_b(uchar *b,LOC_file *LINK)
#else
PRIVATE void read_b(b, LINK)
uchar *b;
LOC_file *LINK;
#endif /* STD_C */
{
  bfile_no++;
  if (bfile_no >= bfile_last) {
    bfile_last = fread((char *)buff, 1, sizeof(uchar) * 512, LINK->tdsfile);
    bfile_no = 0;
  }
  *b = buff[bfile_no];
}

#ifdef STD_C
PRIVATE void read_tag(int *tag,int *value,LOC_file *LINK)
#else
PRIVATE void read_tag(tag, value, LINK)
int *tag, *value;
LOC_file *LINK;
#endif /* STD_C */
{
  uchar b;

  *value = 0;
  do {
    read_b(&b, LINK);
    *tag = b >> 6;
    *value = ((*value) << 6) + (b & 63);
  } while (*tag == 3);
}

#ifdef STD_C
PRIVATE void read_string(char *s, LOC_file *LINK)
#else
PRIVATE void read_string(s, LINK)
char *s;
LOC_file *LINK;
#endif /* STD_C */
{
  int i, tag, value;
  uchar b;

  read_tag(&tag, &value, LINK);
  if (tag != 0) {
    sprintf(s, "%d", value);
    return;
  }
  s[value] = '\0';
  /* p2c: edtio.pas, line 133:
   * Note: Modification of string length may translate incorrectly [146]
  */
  for (i = 0; i < value; i++) {
    read_b(&b, LINK);
    s[i] = b;
  }
}

#ifdef STD_C
PRIVATE void connect_fold(LOC_file *LINK)
#else
PRIVATE void connect_fold(LINK)
LOC_file *LINK;
#endif /* STD_C */
{
  if (LINK->trailing == NULL)
  return;
  LINK->S = LINK->trailing;
  join_links(LINK->current, LINK->S->other_end);
  LINK->current = LINK->S->other_end;
  LINK->current->other_end = LINK->S;
  LINK->trailing = LINK->S->fold;
  LINK->S->fold = LINK->S->next;
  LINK->S->other_end = LINK->current;
  LINK->S->foldline = LINK->current->foldline;   /*start*/
  /* _fold or _filed */
  current_ind -= LINK->S->UU.U1.fold_indent;
  LINK->current->foldline = END_FOLD;
  LINK->current = LINK->S;
}

#ifdef STD_C
PRIVATE void start_a_fold(uchar start_,int indent,LOC_file *LINK)
#else
PRIVATE void start_a_fold(start_, indent, LINK)
uchar start_;
int indent;
LOC_file *LINK;
#endif /* STD_C */
{
  copy_line_to_parts(LINK->dsp_line, &LINK->current);
  LINK->current->UU.U1.fold_indent = indent;
  current_ind += indent;
  LINK->current->fold = LINK->trailing;
  LINK->trailing = LINK->current;
  proc_new(&LINK->current->other_end);
  LINK->current->other_end->foldline = start_;
}

#ifdef STD_C
PRIVATE void read_fold(int *, bool, LOC_file *);

PRIVATE void read_a_list(int indent,LOC_file *LINK)
#else
PRIVATE void read_fold();

PRIVATE void read_a_list(indent, LINK)
int indent;
LOC_file *LINK;
#endif /* STD_C */
{
  int i, tag, value;
  uchar b;

  do {
    read_tag(&tag, &value, LINK);
    switch (tag) {

      case 0:   /*record tag*/
      LINK->dsp_line[value] = '\0';
      /* p2c: edtio.pas, line 218:
       * Note: Modification of string length may translate incorrectly [146]
      */
      for (i = 0; i < value; i++) {
        read_b(&b, LINK);
        LINK->dsp_line[i] = b;
      }
      create_node(LINK);
      break;

      case 2:   /*function tag*/
      switch (value) {

        case 2:   /*startfold*/
        read_fold(&indent, FALSE, LINK);
        break;

        case 4:   /*startfiled*/
        read_fold(&indent, TRUE, LINK);
        break;
      }
      break;
    }
  } while (tag != 2 || value != 1);
}

#ifdef STD_C
PRIVATE void read_fold(int *indent,bool filed,LOC_file *LINK)
#else
PRIVATE void read_fold(indent, filed, LINK)
int *indent;
bool filed;
LOC_file *LINK;
#endif /* STD_C */
{
  int tag, value, t, c, extra_indent;
  element *WITH;

  read_tag(&tag, &value, LINK);   /*startlist*/
  read_string(LINK->dsp_line, LINK);
  read_tag(&tag, &t, LINK);
  read_tag(&tag, &c, LINK);
  read_tag(&tag, &extra_indent, LINK);
  read_tag(&tag, &value, LINK);   /*should be endlist*/
  create_node(LINK);
  if (filed)
  start_a_fold(START_FILED, extra_indent, LINK);
  else
  start_a_fold(START_FOLD, extra_indent, LINK);
  if (filed) {
    read_string(LINK->dsp_line, LINK);
    copy_line_to_parts(LINK->dsp_line, &LINK->trailing->other_end);
  }
  else
  read_a_list(*indent + extra_indent, LINK);
  read_tag(&tag, &value, LINK);   /*endfold or endfiled*/
  connect_fold(LINK);
  WITH = LINK->current;
  WITH->UU.U1.fold_type = t;
  WITH->UU.U1.fold_contents = c;
}

#ifdef STD_C
PRIVATE bool read_tds(LOC_file *LINK)
#else
PRIVATE bool read_tds(LINK)
LOC_file *LINK;
#endif /* STD_C */
{
  int tag, value;
  bool tds;

  tds = TRUE;
  bfile_no = bfile_last;
  read_tag(&tag, &value, LINK);
  if (tag == 2 && value == 0) {
    dialect = NO_LANGUAGES;
    read_a_list(0, LINK);
  }
  else
  tds = FALSE;
  if (LINK->tdsfile != NULL)
  (void) fclose(LINK->tdsfile);
  LINK->tdsfile = NULL;
  return tds;
}

#ifdef STD_C
PRIVATE bool find_dialect(char *ss)
#else
PRIVATE bool find_dialect(ss)
char *ss;
#endif /* STD_C */
{
  char s[MAX_FIELD_SIZE + 1];
  int i;
  bool b;
  char STR1[MAX_FIELD_SIZE + 1];

  b = TRUE;
  strcpy(s, ss);
  i = first_char(s);
  if (i > strlen(s)) {
    dialect = 0;
    return b;
  }
  b = FALSE;
  strcpy(s, copy_to_end(STR1, s, i));
  trailing_spaces(s);
  for (i = 1; i < NO_LANGUAGES; i++) {
    if ((strlen(s) == strlen(dialect_start[i])) &&
    (strpos2(dialect_start[i], s, 1) == 1)) {
      dialect = i;
      b = TRUE;
    }
  }
  return b;
}

#ifdef STD_C
PRIVATE void get_the_pos(char *str,LOC_file *LINK)
#else
PRIVATE void get_the_pos(str, LINK)
char *str;
LOC_file *LINK;
#endif /* STD_C */
{
  int i;
  char STR1[256];
  char STR2[MAX_FIELD_SIZE + 1];

  the_pos = strpos2(LINK->dsp_line, str, 1);
  if (the_pos <= 0)
  return;
  if (the_pos==1) *STR1='\0';
  else sprintf(STR1, "%.*s", the_pos - 1, LINK->dsp_line);
  if (!find_dialect(STR1)) {
    the_pos = 0;
    return;
  }
  strcpy(LINK->dsp_line,
  copy_to_end(STR2, LINK->dsp_line, the_pos + strlen(str)));
  i = first_char(LINK->dsp_line);
  if (i <= strlen(LINK->dsp_line))
  strcpy(LINK->dsp_line, copy_to_end(STR2, LINK->dsp_line, i));
  i = strlen(LINK->dsp_line) - strlen(dialect_end[dialect]);
  if (i > 0) {
    LINK->dsp_line[i] = '\0';
    /* p2c: edtio.pas, line 266:
    * Note: Modification of string length may translate incorrectly [146] */
  }
  else
  LINK->dsp_line[0] = '\0';
  the_pos -= strlen(dialect_start[dialect]);
}

static char envfile[128];

#ifdef STD_C
void insert_file(element *file_ptr,element *prec_ptr,element *next_ptr,bool remember_file)
#else
void insert_file(file_ptr, prec_ptr, next_ptr, remember_file)
element *file_ptr, *prec_ptr, *next_ptr;
bool remember_file;
#endif /* STD_C */
{
  LOC_file V;
  bool add_c;
  int marker_pos, i, j;
  char STR1[74];
  char STR2[256];
  char *TEMP;
  char STR3[MAX_FIELD_SIZE + 1];
  char STR4[6];

  V.tdsfile = NULL;
  V.current = prec_ptr;
  V.new_indent = insert_indent_of(next_ptr);
  if (file_ptr == NULL) get_dsp_file(&V); else line_of(V.filename, file_ptr);
  if (*V.filename == '\0' && remember_file) exit_origami(0);
  if (access(V.filename,AREAD)==0 && access(V.filename,AWRITE) == -1) browse_mode=TRUE;
  strcpy(V.tdsfile_NAME, V.filename);
  sprintf(envfile,"ORIFILE=%s",V.filename);
  putenv(envfile);
  if (V.tdsfile != NULL) V.tdsfile = freopen(V.tdsfile_NAME, "r", V.tdsfile);
  else V.tdsfile = fopen(V.tdsfile_NAME, "r");
  sprintf(STR1, "Loading %s", V.filename);
  message(STR1,TRUE);
  V.trailing = NULL;
  current_ind = 0;
  if (V.tdsfile!=NULL && !read_tds(&V))
  {
    strcpy(tstorefile_NAME, V.filename);
    if (tstorefile != NULL) tstorefile = freopen(tstorefile_NAME, "r", tstorefile);
    else tstorefile = fopen(tstorefile_NAME, "r");
    while (!P_eof(tstorefile) && available(1))
    {
      fgets(V.dsp_line, MAX_FIELD_SIZE + 1, tstorefile);
      TEMP = strchr(V.dsp_line, '\n');
      if (TEMP != NULL) *TEMP = 0;
      if (!fold_in) {
        marker_pos = strpos2(V.dsp_line, "{{{}}}", 1);
        if (marker_pos > 0)
        {
          trailing_spaces(V.dsp_line);
          dialect = NO_LANGUAGES - 1;
          sprintf(STR2, "%.*s", marker_pos - 1, V.dsp_line);
          strcpy(dialect_start[dialect], STR2);
          strcpy(dialect_end[dialect],
          strsub(STR2, V.dsp_line, marker_pos + 6, strlen(V.dsp_line)));
          fgets(V.dsp_line, MAX_FIELD_SIZE + 1, tstorefile);
          TEMP = strchr(V.dsp_line, '\n');
          if (TEMP != NULL) *TEMP = 0;
        }
      }
      trailing_spaces(V.dsp_line);
      strcpy(V.dsp_line, tabbed_out(STR3, V.dsp_line));
      if (strlen(V.dsp_line) < current_ind) pad_(V.dsp_line, ' ', current_ind);
      add_c = FALSE;
      if (toupper(V.dsp_line[0]) == 'C')
      {
        i = strpos2(V.dsp_line, "C{{{", 1);
        j = strpos2(V.dsp_line, "C...", 1);
        if (dialect == fortran_ && current_ind > 0 || i > 1 || j > 1)
        V.dsp_line[0] = ' ';
        if (dialect == fortran_ && i == 0 && j == 0)
        add_c = TRUE;
      }
      i = first_char(V.dsp_line);
      if (i <= current_ind)
      strcpy(V.dsp_line, copy_to_end(STR3, V.dsp_line, i));
      else
      strcpy(V.dsp_line, copy_to_end(STR3, V.dsp_line, current_ind + 1));
      if (add_c) {
        if (*V.dsp_line == '\0')
        strcpy(V.dsp_line, "C");
        else if (upper(V.dsp_line[0]) != 'C')
        strinsert("C ", V.dsp_line, 1);
      }
      if (!fold_in) {
        get_the_pos(":::A", &V);
        if (the_pos > 0) {  /*read and save attributes*/
          if (V.trailing != NULL) {
            the_pos = strpos2(V.dsp_line, " ", 1);
            if (the_pos==1) *STR2='\0';
            else sprintf(STR2, "%.*s", the_pos - 1, V.dsp_line);
            i = (sscanf(STR2, "%d", &V.trailing->UU.U1.fold_type) == 0);
            i = (sscanf(copy_to_end(STR3, V.dsp_line, the_pos), "%d",
            &V.trailing->UU.U1.fold_contents) == 0);
          }
          continue;
        }
        get_the_pos(":::F", &V);
        if (the_pos > 0) {  /*save filename*/
          if (V.trailing != NULL) {
            copy_line_to_parts(V.dsp_line, &V.trailing->other_end);
            if (V.trailing->UU.U1.fold_type != 0)
            connect_fold(&V);
          }
          continue;
        }
        get_the_pos("}}}", &V);
        if (the_pos > 0) {
          connect_fold(&V);
          continue;
        }
      }
      create_node(&V);
      if (!fold_in) {
        sprintf(STR4, "%sF", fold_open_str);
        get_the_pos(STR4, &V);
        if (the_pos == 0)
          get_the_pos("...F", &V);
        if (the_pos > 0)
          start_a_fold(START_FILED, the_pos - 1, &V);
        else {
          get_the_pos(fold_open_str, &V);
          if (the_pos > 0)
          start_a_fold(START_FOLD, the_pos - 1, &V);
        }
      }
    }
    if (tstorefile != NULL)
    (void) fclose(tstorefile);
    tstorefile = NULL;
  }
  if (!available(1)) {
    message("not enough memory",TRUE);
    exit_origami(0);
  }
  if (remember_file) {
    if (file_ptr == NULL)
    copy_line_to_parts(V.filename, &prec_ptr);
    copy_line_to_parts(V.filename, &next_ptr);
  }
  join_links(V.current, next_ptr);
  if (V.tdsfile != NULL) fclose(V.tdsfile);
}
