/* edtutil.c - utility source file */

#include <ctype.h>
#include <string.h>
#include <stdio.h>

#include <bool.h>

#include "short.h"

#include "globals.h"
#define EDTUTIL_G
#include "origami.h"

static TOKEN **macro_stack;
static TOKEN *macro_pos;
static bool do_macro=TRUE;
static bool defining_macro=FALSE;
static int macro_count;
static int executing_macro=0;

/*{{{  upper                 konvert c->C*/
#ifdef STD_C
char upper(char ch)
#else
char upper(ch)
char ch;
#endif /* STD_C */
{
  return (islower(ch)? toupper(ch) :ch);
}
/*}}}  */
/*{{{  pad_                  fill string s from position to end with token*/
#ifdef STD_C
void pad_(char *s,TOKEN ch,int l)
#else
void pad_(s, ch, l)
char *s;
int ch, l;
#endif /* STD_C */
{
  int i;

  i = strlen(s);
  s[l] = '\0';
  for (; i < l; i++)
  s[i] = (char)ch;
}
/*}}}  */
/*{{{  spaces                fill a string with spaces*/
#ifdef STD_C
char *spaces(char *Result,int l)
#else
char *spaces(Result, l)
char *Result;
int l;
#endif /* STD_C */
{
  int i;

  Result[l] = '\0';
  for (i = 0; i < l; i++) Result[i] = ' ';

  return Result;
}
/*}}}  */
/*{{{  press                 move a token,keypad to already_pressed*/
#ifdef STD_C
void press(int ch,bool keypad)
#else
void press(ch, keypad)
int ch;
bool keypad;
#endif /* STD_C */
{
  key_already_pressed = TRUE;
  already_pressed_key = (char)ch;
  already_pressed_keypad_key = keypad;
}
/*}}}  */
/*{{{  message               put a message under statusline*/
#ifdef STD_C
void message(char *s; bool brackets)
#else
void message(s, brackets)
char *s; bool brackets;
#endif /* STD_C */
{
  gotoxy(1, MESSAGE_LINE);
  if (brackets) putchar('[');
  fputs(s, stdout);
  if (brackets) putchar(']');
  clreol();
  fflush(stdout);
  screen_message = TRUE;
}
/*}}}  */
/*{{{  no_message            remove message and maybe put define_macro*/
#ifdef STD_C
void no_message(void)
#else
void no_message()
#endif /* STD_C */
{
  if (screen_message)
  {
    gotoxy(1, MESSAGE_LINE);
    clreol();
    screen_message = FALSE;
  }
  if (defining_macro) message("Defining macro",TRUE);
}
/*}}}  */
/*{{{  stop_macros           stop macro-execution at correct point*/
void stop_macros()
{
  do_macro=FALSE;
}
/*}}}  */
/*{{{  get_arg               get a int-Argument from macro-buffer*/
#ifdef STD_C
TOKEN get_arg(void)
#else
TOKEN get_arg()
#endif
{
  return(*macro_pos++);
}
/*}}}  */
/*{{{  get_line_no           get the linenumber of current line*/
#ifdef STD_C
int get_line_no()
#else
int get_line_no()
#endif /* STD_C */
{
  int current_line_no=0;
  element *p;

  p = head->next;
  while (p!=current && p != tail) {
    current_line_no++;
    move_on(&p);
  }
  return current_line_no;
}

/*}}}  */
/*{{{  single_key            get a token*/
#ifdef STD_C
TOKEN single_key(void)
#else
TOKEN single_key()
#endif /* STD_C */
{
  TOKEN ch;
  char *readprompt();

  do {
    /*{{{  get next token*/
    if (executing_macro) {
      if (do_macro)
        ch = *macro_pos++;
      else {
        ch = get_key();
        executing_macro=0;
        do_macro=TRUE;
      }
    } else
      ch = get_key();
    if (ch<' ') ch=O_NOP;
    /*}}}  */
    switch (ch) {
      /*{{{  M_STORE_LINE_NO*/
      case M_STORE_LINE_NO:
        macro_int[get_arg()]=get_line_no();
        break;
      /*}}}  */
      /*{{{  M_END_MACRO*/
      case M_END_MACRO:
        macro_pos=macro_stack[--executing_macro];
        break;
      /*}}}  */
      /*{{{  M_CALL*/
      case M_CALL: {
        int diff;
      
        ch=O_NOP;
        if (!executing_macro) {
          message("no macro_programm_ops allowed",TRUE);
          ch=0;
          break;
        }
        diff= get_arg();
        /*{{{  stack-handling*/
        if (macro_stack==NULL)
          macro_stack=(TOKEN**) malloc(m_s_depth*sizeof(TOKEN*));
        else if (executing_macro==m_s_depth) {
          stop_macros();
          message("macro-stack overflow, macro stopped",TRUE);
          break;
        }
        /*}}}  */
        macro_stack[executing_macro++] = macro_pos;
        macro_pos=macro_pos+diff;
        break;
      }
      /*}}}  */
      /*{{{  M_JMP*/
      case M_JMP: {
        int diff;
      
        ch=O_NOP;
        if (!executing_macro) {
          message("no macro_programm_ops allowed",TRUE);
          ch=0;
          break;
        }
        diff= get_arg();
        macro_pos=macro_pos+diff;
        break;
      }
      /*}}}  */
      /*{{{  M_JMP_FALSE*/
      case M_JMP_FALSE: {
        int diff;
      
        ch=O_NOP;
        if (!executing_macro) {
          message("no macro_programm_ops allowed",TRUE);
          ch=0;
          break;
        }
        diff= get_arg();
        if (!macro_tag) macro_pos=macro_pos+diff;
        break;
      }
      /*}}}  */
      /*{{{  M_JMP_TRUE*/
      case M_JMP_TRUE: {
        int diff;
      
        ch=O_NOP;
        if (!executing_macro) {
          message("no macro_programm_ops allowed",TRUE);
          ch=0;
          break;
        }
        diff= get_arg();
        if (macro_tag) macro_pos=macro_pos+diff;
        break;
      }
      /*}}}  */
      /*{{{  M_NOT*/
      case M_NOT:
        ch=O_NOP;
        macro_tag=!macro_tag;
        break;
      /*}}}  */
      /*{{{  M_TEXTLINE*/
      case M_TEXTLINE:
        ch=O_NOP;
        macro_tag=(current->foldline==NOT_FOLD);
        break;
      /*}}}  */
      /*{{{  M_BEGIN_FOLD_COMMENT*/
      case M_BEGIN_FOLD_COMMENT:
        ch=O_NOP;
        macro_tag = (current->foldline==START_OPEN_FOLD);
        break;
      /*}}}  */
      /*{{{  M_CLOSED_FOLD*/
      case M_CLOSED_FOLD:
        ch=O_NOP;
        macro_tag = (current->foldline==START_FOLD);
        break;
      /*}}}  */
      /*{{{  M_END_FOLD_COMMENT*/
      case M_END_FOLD_COMMENT:
        ch=O_NOP;
        macro_tag=(current->foldline==END_FOLD);
        break;
      /*}}}  */
      /*{{{  M_FILED_FOLD*/
      case M_FILED_FOLD:
        ch=O_NOP;
        macro_tag=(current->foldline==START_FILED);
        break;
      /*}}}  */
      /*{{{  M_SET_COUNTER*/
      case M_SET_COUNTER: {
        int x=get_arg();
      
        ch=O_NOP;
        macro_int[x]=get_arg();
        break;
      }
      /*}}}  */
      /*{{{  M_NULL_COUNTER*/
      case M_NULL_COUNTER: {
        int x=get_arg();
      
        ch=O_NOP;
        macro_tag=(macro_int[x]==0);
        break;
      }
      /*}}}  */
      /*{{{  M_POSITIV_COUNTER*/
      case M_POSITIV_COUNTER: {
        int x=get_arg();

        ch=O_NOP;
        macro_tag=(macro_int[x]>0);
        break;
      }
      /*}}}  */
      /*{{{  M_ADD_COUNTER*/
      case M_ADD_COUNTER: {
        int x=get_arg();
      
        ch=O_NOP;
        macro_int[x]=macro_int[x]+ get_arg();
        break;
      }
      /*}}}  */
      /*{{{  M_INV_COUNTER*/
      case M_INV_COUNTER: {
        int x=get_arg();
      
        ch=O_NOP;
        macro_int[x] = -macro_int[x];
        break;
      }
      /*}}}  */
      /*{{{  M_SUM_COUNTER*/
      case M_SUM_COUNTER: {
        int x=get_arg();
      
        ch=O_NOP;
        macro_int[x] += macro_int[get_arg()];
        break;
      }
      /*}}}  */
      /*{{{  O_DEF_MACRO*/
      case O_DEF_MACRO:
        ch=O_NOP;
        if (executing_macro) {
          message("no define macro during execute macro",TRUE);
          ch=0;
          stop_macros();
          break;
        }
        defining_macro = !defining_macro;
        if (defining_macro) {
          macro_pos = fix_macros[0].string;
          macro_count=0;
        } else
          *macro_pos=M_END_MACRO;
        break;
      /*}}}  */
      /*{{{  O_DEF_FIX*/
      case O_DEF_FIX: {
        char temp[20];
        int x;
      
        /*{{{  testing error-cases*/
        if (defining_macro || executing_macro) {
          message("no define-fix during define/execute macro",TRUE);
          defining_macro=FALSE;
          executing_macro=0;
          ch=O_NOP;
          break;
        }
        /*}}}  */
        readprompt(temp,"Which fix_macro_buffer",20);
        x=atoi(temp);
        /*{{{  testing error-cases*/
        ch=0;
        if (x<1 || x>MAX_MACRO) {
          message("invalid macroplace",TRUE);
          break;
        }
        if (!fix_macros[x].defineable) {
          message("macro is not defineable",TRUE);
          break;
        }
        /*}}}  */
        ch=O_NOP;
        if (fix_macros[x].string!=NULL) free(fix_macros[x].string);
        fix_macros[x].string=(int*) malloc((macro_count+1)*sizeof(int));
        memcpy(fix_macros[x].string,fix_macros[0].string,
               (macro_count+1)*sizeof(TOKEN));
        break;
      }
      /*}}}  */
      /*{{{  execute macros*/
      case O_EXE_MACRO:
        if (defining_macro) {
          message("exe macro not allowed during define macro",TRUE);
          stop_macros();
          ch=0;
          break;
        }
        if (macro_count==0) *fix_macros[0].string=M_END_MACRO;
      case O_CALL_FIX_1:
      case O_CALL_FIX_2:
      case O_CALL_FIX_3:
      case O_CALL_FIX_4:
      case O_CALL_FIX_5:
      case O_CALL_FIX_6:
      case O_CALL_FIX_7:
      case O_CALL_FIX_8:
      case O_CALL_FIX_9:
      case O_CALL_FIX_10:
      case O_CALL_FIX_11:
      case O_CALL_FIX_12:
      case O_CALL_FIX_13:
      case O_CALL_FIX_14:
      case O_CALL_FIX_15:
      case O_CALL_FIX_16:
      case O_CALL_FIX_17:
      case O_CALL_FIX_18:
      case O_CALL_FIX_19:
      case O_CALL_FIX_20:
      case O_CALL_FIX_21:
      case O_CALL_FIX_22:
      case O_CALL_FIX_23:
      case O_CALL_FIX_24:
      case O_CALL_FIX_25:
      case O_CALL_FIX_26:
      case O_CALL_FIX_27:
      case O_CALL_FIX_28:
      case O_CALL_FIX_29:
      case O_CALL_FIX_30:
      case O_CALL_FIX_31:
      case O_CALL_FIX_32: {
        int number=ch-O_EXE_MACRO;
      
        /*{{{  stack-handling*/
        if (macro_stack==NULL)
          macro_stack=(TOKEN**) malloc(m_s_depth*sizeof(TOKEN*));
        else if (executing_macro==m_s_depth) {
          stop_macros();
          ch=O_NOP;
          message("macro-stack overflow, macro stopped",TRUE);
          break;
        }
        /*}}}  */
        /*{{{  maybe store this call in keyboard-macro-buffer*/
        if (defining_macro && !executing_macro) {
          *macro_pos++ = ch;
          /*{{{  macro-buffer full*/
          if (++macro_count == MAX_MACRO_LENGTH) {
            message("keyboard-macro-buffer full",TRUE);
            *--macro_pos=M_END_MACRO;
            defining_macro = FALSE;
          }
          /*}}}  */
        }
        /*}}}  */
        macro_stack[executing_macro++]=macro_pos;
        macro_pos=fix_macros[number].string;
        break;
      };
      /*}}}  */
      /*{{{  default: if defining_macro, store token*/
      default:
      if (defining_macro && !executing_macro) {
        *macro_pos++ = ch;
        /*{{{  macro-buffer full*/
        if (++macro_count == MAX_MACRO_LENGTH) {
          message("keyboard-macro-buffer full",TRUE);
          *--macro_pos=M_END_MACRO;
          defining_macro = FALSE;
        }
        /*}}}  */
      }
      break;
      /*}}}  */
    }
  } while (ch==O_NOP);
  return ch;
}
/*}}}  */
/*{{{  readprompt            read a string with prompt*/
#ifdef STD_C
char *readprompt(char *Result,char *prompt,int max)
#else
char *readprompt(Result, prompt, max) char *Result, *prompt; int max;
#endif
{
  char s[65];
  TOKEN ch;
  char STR1[68];
  bool running = TRUE;

  (void) sprintf(STR1, "%s ? ", prompt);
  message(STR1,FALSE);
  *s = '\0';

  do
  {
    ch = single_key();
    if (ch < 128)
    {
      putchar(ch);
      (void) sprintf(s + strlen(s), "%c", ch);
    }
    else if (ch == O_DELETE)
    {
      if (strlen(s))
      {
        s[strlen(s) - 1] = '\0';
        putchar('\b'); putchar(' '); putchar('\b');
      }
    }
    else running = FALSE;
  } while (strlen(s) < max && running);
  strcpy(Result, s);
  return Result;
}
/*}}}  */
/*{{{  edit_key*/
#ifdef STD_C
TOKEN edit_key(bool *keypad)
#else
TOKEN edit_key(keypad)
bool *keypad;
#endif /* STD_C */
{
  TOKEN ch;

  if (key_already_pressed) {
    key_already_pressed = FALSE;
    *keypad = already_pressed_keypad_key;
    return already_pressed_key;
  }
  /* get valid key */
  do {
    ch = single_key();
  } while (ch < 32);

  if (ch > 255)
  *keypad = TRUE;
  else
  *keypad = FALSE;

  return ch;
}
/*}}}  */
/*{{{  yes                   ask for boolean*/
#ifdef STD_C
bool yes(char *q)
#else
bool yes(q)
char *q;
#endif /* STD_C */
{
  char temp[33];
  bool y, yes_or_no;

  y = FALSE;
  yes_or_no = FALSE;
  do {
    readprompt(temp, q, 6);
    /* p2c: termkey.pas, line 278:
     * Note: Possible string truncation in assignment [145]
    */
    if (*temp != '\0') {
      temp[0] = upper(temp[0]);
      y = (temp[0] == 'Y');
      yes_or_no = (y || temp[0] == 'N');
    }
  } while (!yes_or_no);
  return y;
}
/*}}}  */
/*{{{  upper_case            toupper for all chars of a string*/
#ifdef STD_C
char *upper_case(char *Result,char *s_)
#else
char *upper_case(Result, s_)
char *Result, *s_;
#endif /* STD_C */
{
  char s[MAX_FIELD_SIZE + 1];
  int i, FORLIM;

  strcpy(s, s_);
  FORLIM = strlen(s);
  for (i = 0; i < FORLIM; i++)
  s[i] = upper(s[i]);
  return strcpy(Result, s);
}
/*}}}  */
/*{{{  tabbed_out            expand tabs*/
#ifdef STD_C
char *tabbed_out(char *Result,char *instr)
#else
char *tabbed_out(Result, instr)
char *Result, *instr;
#endif /* STD_C */
{
  uchar j, i;
  uchar FORLIM;
  char STR1[65];
  PRIVATE int tab_size = 0;

  j = 0;
  FORLIM = strlen(instr);
  for (i = 0; i < FORLIM; i++) {
    if (instr[i] == '\t') {
      while (tab_size <= 0)
      sscanf(readprompt(STR1, "Tab size", 10), "%d", &tab_size);
      do {
        j++;
        Result[j - 1] = ' ';
      } while (j % tab_size != 0);
    }
    else {
      j++;
      Result[j - 1] = instr[i];
    }
  }
  Result[j] = '\0';
  /* p2c: newutil.pas, line 121:
   * Note: Modification of string length may translate incorrectly [146]
  */
  return Result;
}
/*}}}  */
/*{{{  valid_key             check token for valid (browse!)*/
#ifdef STD_C
bool valid_key(bool *keypad,int *ch)
#else
bool valid_key(keypad, ch) bool *keypad; int *ch;
#endif
{
  bool browse_key;

  browse_key = (*keypad && key_convert_list[*ch - 256][1]) && (*ch > 255);
  if (browse_mode && !browse_key)
  {
    message("browse mode!",TRUE);
    return FALSE;
  }
  else
  {
    if (!browse_key && !file_changed)
    {
      file_changed = TRUE;
      title();
    }
    return TRUE;
  }
}
/*}}}  */
/*{{{  valid_field_key check if token is a correct field_key*/
#ifdef STD_C
bool valid_field_key(bool *keypad,TOKEN *ch)
#else
bool valid_field_key(keypad, ch) bool *keypad; TOKEN *ch;
#endif
{
  if (*keypad) return (key_convert_list[*ch - 256][0]);
  else return TRUE;
}
/*}}}  */
