#include <signal.h>
#include <stdio.h>
#include "bool.h"
#include "short.h"
#include "keys.h"
#include "keytab.h"
#include "globals.h"
#include "rcformat.h"
#include "origami.h"

static Key *key_point,*top_level;

FILE *rcfile;

/*{{{  parse rcfile*/
rc_file_parser()
{
  int  key,macro,lg;
  bool macro_def;
  int  input;

  if (getc(rcfile)!=RC_FORMAT) {
    printf("rc-file has wrong format\n");
    return(1);
  }
  macro_int=NULL;
  while ((input=getc(rcfile))!=RC_ENDE) {
    switch (input) {
      /*{{{  keydef*/
      case RC_DEFKEY:
        key=getw(rcfile);
        lg=getw(rcfile);
        while (lg--) {
          if ((key_point = add_key (getc(rcfile),key_point)) == 0) return(1);
        }
        if (set_key_code(key,key_point)) return(1);
        key_point = top_level;
        break;
      /*}}}  */
      /*{{{  macrodef/init*/
      case RC_INITMACRO:
      case RC_DEFMACRO: {
        TOKEN *x;
      
        macro=getw(rcfile);
        lg=getw(rcfile);
        /*{{{  Errors*/
        if (macro<1 || macro>=MACRO_COUNT) {
          printf("wrong macro-number\n");
          return(1);
        }
        if (   !fix_macros[macro].defineable
            || (fix_macros[macro].string!=NULL)) {
          printf("duplicate macro-definition for %d\n",macro);
          return(1);
        }
        /*}}}  */
        fix_macros[macro].defineable=(input==RC_INITMACRO);
        x=fix_macros[macro].string=(TOKEN *) malloc((1+lg)*sizeof(TOKEN));
        while (lg--) {
          *x++=getw(rcfile);
        }
        *x=M_END_MACRO;
        break;
      }
      /*}}}  */
      /*{{{  keyname*/
      case RC_KEYNAME: {
        int i=5;
        char *n=keybinding_name;
      
        while (i--) *n++ = getc(rcfile); *n++=','; *n='\0';
        break;
      }
      /*}}}  */
      /*{{{  ints*/
      case RC_INTS:
        input=getw(rcfile);
        if (macro_int==NULL) {
          macro_int=(int*) calloc(input,sizeof(int));
          break;
        }
      /*}}}  */
      default:
        printf("bad data in rc-file\n");
        return(1);
    }
  }
  return(0);
}
/*}}}  */

/*{{{  HostBegin*/
#ifdef STD_C
HostBegin(void)
#else
HostBegin()
#endif /* STD_C */
{
char keyfile[128], *home=getenv("HOME");
int die_a_quick_death();

  /*{{{  open rc-file*/
  if (home == NULL) {
          printf ("Environment variable HOME not set.\n");
          return (1);
  }
  strcpy(keyfile,home);
  strcat(keyfile,"/");
  strcat(keyfile,keybase);
  strcat(keyfile,"rc");
  if ((rcfile = fopen (keyfile,"r")) == 0) {
          printf ("Unable to open %s.\n",keyfile);
          return (1);
  }
  /*}}}  */

  top_level = key_point = (Key *)calloc (sizeof(Key),1);

  if (rc_file_parser()) {
    printf("Cannot setup the keyboard-translation-table\n");
    return (1);
  }
  set_key_top (top_level);

  fclose (rcfile);

  signal (SIGINT,die_a_quick_death);

  if (get_terminal_capability()) return (1);
  init_keyboard ();

  return (0);
}
/*}}}  */
