/* cpp-makefile for Origami
   Use the following symbols to generate a makefile for your system by
   using /usr/lib/cpp -DSYMBOL Makefile.cpp >Makefile

   MINIX    - MINIX 1.5.10
     INTEL  - Intel Version
     MC68K  - Motorola 68k Version

   SUN      - SUN 3/4 workstations

   The following CFLAGS are supported:

   SHORT_NAMES  for only 7 significant characters in indentifiers
   NO_MSG       to avoid the copyright message with sleep at startup.  Only for
                personal use!
*/

#ifdef MINIX
#ifdef INTEL
CC=		cc
CFLAGS=		-O -I/usr/include/local -DSHORT_NAMES -DNO_MSG
LDFLAGS=	-i -T/usr/tmp
LIBS=		
O=		s
PUTW=		putw.$(O)
#endif
#ifdef MC68K
/* Warning: This will probably not work! */
CC=		cc
CFLAGS=		-O -I/usr/include/local -DNO_MSG
LDFLAGS=	-T/usr/tmp
LIBS=		
O=		o
PUTW=		putw.$(O)
#endif
#endif

#ifdef SUN
CC=		cc
CFLAGS=		-I. -DNO_MSG
LDFLAGS=	-s
LIBS=		-ltermcap
O=		o
#endif

HDRS=		globals.h keys.h keytab.h macros.h origami.h short.h

K_HDRS=		rcformat.h keys.h keybind.h scanner.h

SRCS=		origami.c editor.c edtutil.c fieldedt.c filer.c globals.c \
		misc.c oriedt.c procexit.c keytab.c keyboard.c screen.c \
		binread.c

K_SRCS=		scanner.c parser.c keybind.c

OBJS=		origami.$(O) editor.$(O) edtutil.$(O) fieldedt.$(O) filer.$(O) \
		globals.$(O) misc.$(O) oriedt.$(O) procexit.$(O) keytab.$(O) \
		keyboard.$(O) screen.$(O) binread.$(O) $(PUTW)

K_OBJS=		scanner.$(O) parser.$(O) keybind.$(O) $(PUTW)

all:		origami keybind

origami:	$(OBJS)
		$(CC) $(LDFLAGS) -o $@ $(OBJS) $(LIBS)

$(OBJS):	$(HDRS)

keybind:	$(K_OBJS)
		$(CC) $(LDFLAGS) -o $@ $(K_OBJS) $(LIBS)
		
$(K_OBJS):	$(K_HDRS)

clean:
		rm -f core origami keybind $(OBJS) $(K_OBJS)

#ifdef MINIX
order:
		fgrep \*\*\*SVCLOCK SVC/?*

shar:		clean
		shar * >ori.sh
		compress ori.sh
		rm ori.sh
#else
shar:		clean
		shar -o ori.sh *
		compress ori.sh
#endif
