#include "proto.h"
#include "init.h"
#include "global.h"
#include "io-term.h"
/*
 * These commands are run before we are ready to do output.  They
 * should not do any kind of io or cause errors.  If they do, you
 * will experience core dumps.
 */
char *init_cmds[] =
{
  "create-keymap universal",
  "create-keymap help universal",
  "create-keymap mouse universal",
  "",
  "# The navigation keymaps hold cell cursor motion bindings.",
  "",
  "create-keymap navigate universal",
  "create-keymap trolx-navigate universal",
  "create-keymap meta-navigate universal",
  "",
  "create-keymap main navigate",
  "create-keymap trolx trolx-navigate",
  "create-keymap meta meta-navigate",
  "# The digit map is for builing numeric prefix arguments.",
  "create-keymap digit main",
  "",
  "# The edit keymaps are used while editting the input area.",
  "",
  "create-keymap edit universal",
  "create-keymap meta-edit universal",
  "create-keymap trolx-edit universal",
  "",
  "create-keymap ansi universal",
  "",
  "bind-key universal break ^G",
  "bind-key universal mouse ^\\",
  "",
  "# Vectors between keymaps",
  "bind-key navigate trolx-navigate ^X",
  "bind-key navigate meta-navigate ^[",
  "bind-key main digit ^U",
  "bind-key main trolx ^X",
  "bind-key main meta ^[",
  "bind-key main help ^H",
  "bind-key edit trolx-edit ^X",
  "bind-key edit meta-edit ^[",
  "",
  "# Mouse events. ",
  "bind-key mouse mouse-goto 0",
  "bind-key mouse mouse-mark 1",
  "bind-key mouse mouse-mark-and-goto 2",
  "",
  "",
  "# Prefix arguments",
  "bind-key digit digit-0 0",
  "bind-key digit digit-1 1",
  "bind-key digit digit-2 2",
  "bind-key digit digit-3 3",
  "bind-key digit digit-4 4",
  "bind-key digit digit-5 5",
  "bind-key digit digit-6 6",
  "bind-key digit digit-7 7",
  "bind-key digit digit-8 8",
  "bind-key digit digit-9 9",
  "bind-key meta digit-0 0",
  "bind-key meta digit-1 1",
  "bind-key meta digit-2 2",
  "bind-key meta digit-3 3",
  "bind-key meta digit-4 4",
  "bind-key meta digit-5 5",
  "bind-key meta digit-6 6",
  "bind-key meta digit-7 7",
  "bind-key meta digit-8 8",
  "bind-key meta digit-9 9",
  "",
  "# Help commands.",
  "bind-key help describe-key k",
  "bind-key main describe-key ;",
  "bind-key help show-variable v",
  "bind-key help show-options o",
  "bind-key main show-options O",
  "",
  "# Variable commands",
  "bind-key main set-variable v",
  "bind-key main show-variable V",
  "bind-key meta show-all-variables ^V",
  "bind-key help show-all-variables ^V",
  "",
  "#",
  "bind-key main print-region p",
  "bind-key main psprint-region P",
  "bind-key meta start-entering-macro (",
  "bind-key meta stop-entering-macro )",
  "bind-key meta read-commands <",
  "bind-key meta write-keys >",
  "bind-key meta execute-command X",
  "bind-key meta execute-command x",
  "",
  "# File and window commands.",
  "bind-key trolx visit-spreadsheet ^v",
  "bind-key trolx save-spreadsheet ^s",
  "bind-key trolx merge-spreadsheet ^i",
  "bind-key trolx merge-spreadsheet ^m",
  "bind-key trolx write-region-to-file w",
  "bind-key trolx clear-spreadsheet ^?",
  "bind-key trolx quit ^C",
  "",
  "bind-key main visit-spreadsheet r",
  "bind-key main save-spreadsheet w",
  "bind-key main merge-spreadsheet R",
  "bind-key main write-region-to-file W",
  "",
  "bind-key meta redraw-screen ^L",
  "bind-key main quit Q",
  "",
  "bind-key meta close-window C",
  "bind-key meta goto-window G",
  "bind-key meta open-window W",
  "bind-key meta close-window c",
  "bind-key meta goto-window g",
  "bind-key meta open-window w",
  "",
  "bind-key trolx split-window-vertically 2",
  "bind-key trolx split-window-horizontally 5",
  "bind-key trolx delete-other-windows 1",
  "bind-key trolx delete-window 0",
  "bind-key trolx-navigate other-window o",
  "bind-key trolx-edit other-window o",
  "# ",
  "bind-key main recalculate !",
  "bind-key main bind-key :",
  "",
  "# Motion commands.",
  "bind-key navigate left-cell ^B",
  "bind-key navigate right-cell ^F",
  "bind-key navigate down-cell ^N",
  "bind-key navigate up-cell ^P",
  "bind-key navigate recenter-window ^L",
  "",
  "bind-key navigate left-cell h",
  "bind-key navigate down-cell j",
  "bind-key navigate up-cell k",
  "bind-key navigate right-cell l",
  "bind-key navigate downleft-cell b",
  "bind-key navigate downright-cell n",
  "bind-key navigate upleft-cell y",
  "bind-key navigate upright-cell u",
  "",
  "bind-key meta-navigate scan-left b",
  "bind-key meta-navigate scan-down n",
  "bind-key meta-navigate scan-up p",
  "bind-key meta-navigate scan-right f",
  "",
  "bind-key meta-navigate scan-left H",
  "bind-key meta-navigate scan-down J",
  "bind-key meta-navigate scan-up K",
  "bind-key meta-navigate scan-right L",
  "bind-key meta-navigate scan-left h",
  "bind-key meta-navigate scan-down j",
  "bind-key meta-navigate scan-up k",
  "bind-key meta-navigate scan-right l",
  "bind-key meta-navigate upper-left ^Y",
  "bind-key meta-navigate upper-right ^U",
  "bind-key meta-navigate lower-left ^B",
  "bind-key meta-navigate lower-right ^N",
  "",
  "# Ansi motion.",
  "bind-key ansi up-cell A",
  "bind-key ansi down-cell B",
  "bind-key ansi right-cell C",
  "bind-key ansi left-cell D",
  "bind-key meta ansi [",
  "",
  "# Scrolling commands.",
  "bind-key navigate scroll-down ^V",
  "bind-key navigate scroll-down J",
  "bind-key meta-navigate scroll-up v",
  "bind-key navigate scroll-up K",
  "bind-key trolx-navigate scroll-right >",
  "bind-key navigate scroll-right L",
  "bind-key trolx-navigate scroll-left <",
  "bind-key navigate scroll-left H",
  "bind-key navigate scroll-upright U",
  "bind-key navigate scroll-downleft B",
  "bind-key navigate scroll-downright N",
  "bind-key navigate scroll-upleft Y",
  "bind-key trolx-navigate goto-cell g",
  "bind-key trolx-navigate exchange-point-and-mark ^X",
  "bind-key main goto-cell g",
  "",
  "# Commands for manipulating the mark.",
  "bind-key navigate mark-cell ^@",
  "",
  "# Cell changing commands.",
  "bind-key main enter-text-in-cell  ",
  "bind-key main enter-text-in-cell \"",
  "bind-key main enter-text-in-cell #",
  "bind-key main enter-text-in-cell $",
  "bind-key main enter-text-in-cell (",
  "bind-key main enter-text-in-cell +",
  "bind-key main enter-text-in-cell -",
  "bind-key main enter-text-in-cell .",
  "bind-key main enter-text-in-cell 0",
  "bind-key main enter-text-in-cell 1",
  "bind-key main enter-text-in-cell 2",
  "bind-key main enter-text-in-cell 3",
  "bind-key main enter-text-in-cell 4",
  "bind-key main enter-text-in-cell 5",
  "bind-key main enter-text-in-cell 6",
  "bind-key main enter-text-in-cell 7",
  "bind-key main enter-text-in-cell 8",
  "bind-key main enter-text-in-cell 9",
  "bind-key main enter-text-in-cell @",
  "",
  "bind-key main edit-cell-with-default =",
  "bind-key main edit-value-cell E",
  "bind-key main edit-cell e",
  "",
  "# Moving around cell values.",
  "bind-key main copy-values-in-region C",
  "bind-key main delete-region X",
  "bind-key main delete-cell x",
  "bind-key main copy-region c",
  "bind-key main move-region m",
  "bind-key main insert-row ^O",
  "bind-key main delete-row ^K",
  "bind-key meta insert-col ^O",
  "bind-key meta delete-col ^K",
  "bind-key main sort-region s",
  "",
  "# Formatting commands",
  "bind-key meta set-user-format U",
  "bind-key meta set-user-format u",
  "bind-key main set-defaults d",
  "bind-key main format-region F",
  "bind-key main format-cell f",
  "bind-key main set-option o",
  "",
  "",
  "# Edit commands",
  "bind-key edit beginning-of-line ^A",
  "bind-key edit end-of-line ^E",
  "bind-key edit forward-char ^F",
  "bind-key edit backward-char ^B",
  "bind-key edit delete-char ^D",
  "bind-key edit delete-backward-char ^H",
  "bind-key edit finish-line ^J",
  "bind-key edit kill-line ^K",
  "bind-key edit finish-line ^M",
  "bind-key edit toggle-over-write ^O",
  "bind-key edit delete-to-start ^U",
  "",
  "bind-key edit insert-character  ",
  "bind-key edit insert-character !",
  "bind-key edit insert-character \"",
  "bind-key edit insert-character #",
  "bind-key edit insert-character $",
  "bind-key edit insert-character %",
  "bind-key edit insert-character &",
  "bind-key edit insert-character '",
  "bind-key edit insert-character (",
  "bind-key edit insert-character )",
  "bind-key edit insert-character *",
  "bind-key edit insert-character +",
  "bind-key edit insert-character ,",
  "bind-key edit insert-character -",
  "bind-key edit insert-character .",
  "bind-key edit insert-character /",
  "bind-key edit insert-character 0",
  "bind-key edit insert-character 1",
  "bind-key edit insert-character 2",
  "bind-key edit insert-character 3",
  "bind-key edit insert-character 4",
  "bind-key edit insert-character 5",
  "bind-key edit insert-character 6",
  "bind-key edit insert-character 7",
  "bind-key edit insert-character 8",
  "bind-key edit insert-character 9",
  "bind-key edit insert-character :",
  "bind-key edit insert-character ;",
  "bind-key edit insert-character <",
  "bind-key edit insert-character =",
  "bind-key edit insert-character >",
  "bind-key edit insert-character ?",
  "bind-key edit insert-character @",
  "bind-key edit insert-character A",
  "bind-key edit insert-character B",
  "bind-key edit insert-character C",
  "bind-key edit insert-character D",
  "bind-key edit insert-character E",
  "bind-key edit insert-character F",
  "bind-key edit insert-character G",
  "bind-key edit insert-character H",
  "bind-key edit insert-character I",
  "bind-key edit insert-character J",
  "bind-key edit insert-character K",
  "bind-key edit insert-character L",
  "bind-key edit insert-character M",
  "bind-key edit insert-character N",
  "bind-key edit insert-character O",
  "bind-key edit insert-character P",
  "bind-key edit insert-character Q",
  "bind-key edit insert-character R",
  "bind-key edit insert-character S",
  "bind-key edit insert-character T",
  "bind-key edit insert-character U",
  "bind-key edit insert-character V",
  "bind-key edit insert-character W",
  "bind-key edit insert-character X",
  "bind-key edit insert-character Y",
  "bind-key edit insert-character Z",
  "bind-key edit insert-character [",
  "bind-key edit insert-character \\",
  "bind-key edit insert-character ]",
  "bind-key edit insert-character ^",
  "bind-key edit insert-character _",
  "bind-key edit insert-character `",
  "bind-key edit insert-character a",
  "bind-key edit insert-character b",
  "bind-key edit insert-character c",
  "bind-key edit insert-character d",
  "bind-key edit insert-character e",
  "bind-key edit insert-character f",
  "bind-key edit insert-character g",
  "bind-key edit insert-character h",
  "bind-key edit insert-character i",
  "bind-key edit insert-character j",
  "bind-key edit insert-character k",
  "bind-key edit insert-character l",
  "bind-key edit insert-character m",
  "bind-key edit insert-character n",
  "bind-key edit insert-character o",
  "bind-key edit insert-character p",
  "bind-key edit insert-character q",
  "bind-key edit insert-character r",
  "bind-key edit insert-character s",
  "bind-key edit insert-character t",
  "bind-key edit insert-character u",
  "bind-key edit insert-character v",
  "bind-key edit insert-character w",
  "bind-key edit insert-character x",
  "bind-key edit insert-character y",
  "bind-key edit insert-character z",
  "bind-key edit insert-character {",
  "bind-key edit insert-character |",
  "bind-key edit insert-character }",
  "bind-key edit insert-character ~",
  "",
  "bind-key edit delete-backward-char ^?",
  "bind-key meta-edit insert-abs-ref A",
  "bind-key meta-edit backward-word B",
  "bind-key meta-edit delete-word D",
  "bind-key meta-edit insert-cell-expression E",
  "bind-key meta-edit forward-word F",
  "bind-key meta-edit insert-rel-ref R",
  "bind-key meta-edit insert-cell-value V",
  "bind-key meta-edit insert-abs-ref a",
  "bind-key meta-edit backward-word b",
  "bind-key meta-edit delete-word d",
  "bind-key meta-edit insert-cell-expression e",
  "bind-key meta-edit forward-word f",
  "bind-key meta-edit insert-rel-ref r",
  "bind-key meta-edit insert-cell-value v",
  "bind-key meta-edit backward-delete-word ^?",
  "",
  "# Other init commands:",
  "define-font times *times-medium-r-* Times-Roman",
  "define-font times-italic *times-medium-i-* Times-Italic",
  "define-font times-oblique *times-medium-o-* Times-Italic",
  "define-font times-bold *times-bold-r-* Times-Bold",
  "define-font times-oblique-bold *times-bold-o-* Times-BoldItalic",
  "define-font times-italic-bold *times-bold-i-* Times-BoldItalic",
  "define-font courier *courier-medium-r-* Courier",
  "define-font courier-oblique *courier-medium-o-* Courier-Italic",
  "define-font courier-bold *courier-bold-r-* Courier-Bold",
  "define-font courier-bold-oblique *courier-bold-o-* Courier-BoldItalic",
  "define-font helvetica *helvetica-medium-r-* Helvetica",
  "define-font helvetica-oblique *helvetica-medium-o-* Helvetica-Italic",
  "define-font helvetica-bold *helvetica-bold-r-* Helvetica-Bold",
  "define-font helvetica-bold-oblique *helvetica-bold-o-* Helvetica-BoldItalic",
  "define-font fixed *fixed-medium-r-* Times-Roman",
  0
};

void 
run_init_cmds ()
{
  char **p = init_cmds;
  while (*p)
    {
      char * cmd = strdup (*p++);
      execute_cmd (cmd);
      free (cmd);
    }
}
