/* heuristics.c */
/* transportable */

/**********************************************************************/
/*                                                                    */
/*           MM   MM  IIIIIII  L        L        EEEEEEE              */
/*           M M M M     I     L        L        E                    */
/*           M  M  M     I     L        L        EEEE                 */
/*           M     M     I     L        L        E                    */
/*           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              */
/*                                                                    */
/*      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          */
/*      B     B  O     O  R     R  N N   N  E        S                */
/*      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           */
/*      B     B  O     O  R    R   N   N N  E              S          */
/*      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           */
/*                                                                    */
/*                                                                    */
/* Creation: Edmond Dujardin                                          */
/*           (c) 1962 Parker Brothers, Inc.                           */
/*                                                                    */
/* Written by: Brett K. Carver                                        */
/*             Hewlett-Packard, 1983.                                 */
/*                                                                    */
/* Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             */
/*                                                                    */
/**********************************************************************/

#include "miles.h"

/*********************************/
/* external variable definitions */
/*********************************/

extern int cards_played[20];    /* set of cards already played */
extern int hand[2][15];         /* current status of players */
extern int extension;           /* boolean for extension */

/**********************************************************************/
/*                                                                    */
/*              HEURISTIC ALGORITHMS FOR ME TO PLAY/DISCARD           */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/*                                                                    */
/* 100 -> Must play card                                              */
/*     /                                                              */
/*  75 -> Must play miles                                             */
/*     /                                                              */
/*  50 -> Can play or discard                                         */
/*     /                                                              */
/*   0 -> Don't discard                                               */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/* Card            Play    Weight Conditions                          */
/* ----            ----    ------ ----------                          */
/*                                                                    */
/* safety          play    100    have its hazard                     */
/* safety          play    80     have its hazard, just drawn         */
/* safety          play    97     your score >= 600/900               */
/* safety          play    80     my score >= 600/900                 */
/* safety          play    51     both hazards played                 */
/* safety          play    6      need room                           */
/* safety          discard 0      never                               */
/*                                                                    */
/* hazard          play    95     rolling                             */
/* hazard          discard 50     he has safety                       */
/* hazard          discard 3      need room                           */
/* speed limit     play    90     rolling                             */
/* speed limit     discard 50     he has safety                       */
/* speed limit     discard 6      need room                           */
/*                                                                    */
/* remedy          play    85     have hazard                         */
/* remedy          discard 50     have safety                         */
/* remedy          discard 50     both hazards played                 */
/* remedy          discard 50     one hazards played, > 1 in hand     */
/* remedy          discard 40     > 2 in hand                         */
/* remedy          discard 10     > 1 in hand                         */
/* remedy          discard 2      need room                           */
/* roll            play    80     have remedy or stop                 */
/* roll            discard 50     have safety                         */
/* roll            discard 40     > 3 in hand                         */
/* roll            discard 10     > 2 in hand                         */
/* roll            discard 1      need room                           */
/*                                                                    */
/* 200             play    75     score = 500/800                     */
/* 200             play    63     score < 400/700                     */
/* 200             play    73     your score >= 600/900               */
/* 200             play    35     need points                         */
/* 100             play    75     score = 600/900                     */
/* 100             play    61     score < 500/800                     */
/* 100             play    71     your score >= 600/900               */
/* 100             play    30     need points                         */
/* 75              play    75     score = 625/925                     */
/* 75              play    59     score < 525/825                     */
/* 75              play    69     your score >= 600/900               */
/* 75              play    25     need points                         */
/* 75              play    54     600/900 miles, 25 in hand           */
/* 50              play    75     score = 650/950                     */
/* 50              play    57     score < 550/850                     */
/* 50              play    67     your score >= 600/900               */
/* 50              play    20     need points                         */
/* 50              play    53     600/900 miles, 50 or 2 50 in hand   */
/* 50              play    53     625/925 miles, 25 in hand           */
/* 25              play    75     score = 675/975                     */
/* 25              play    55     score < 575/875                     */
/* 25              play    65     your score >= 600/900               */
/* 25              play    15     need points                         */
/* 25              play    52     600/900 miles, 3 25 in hand         */
/* 25              play    52     625/925 miles, 2 25 in hand         */
/* 25              play    52     650/950 miles, 1 25 in hand         */
/* 200             discard 50     two played                          */
/* 200             discard 50     > 800 miles                         */
/* 200             discard 50     one played, > 1 in hand             */
/* 100             discard 50     > 900 miles                         */
/* 75              discard 50     > 950 miles                         */
/* 50              discard 50     > 950 miles                         */
/* 200             discard 4      need room                           */
/* 100             discard 5      need room                           */
/* 75              discard 3      score = 625/925, 1 in hand          */
/* 75              discard 7      need room                           */
/* 50              discard 3      score = 650/950, 1 in hand          */
/* 50              discard 8      need room                           */
/* 25              discard 3      score = 675/975, 1 in hand          */
/* 25              discard 9      need room                           */
/*                                                                    */
/**********************************************************************/

/*********************************************/
/* counts the number of this card in me hand */
/*********************************************/
count_card(card)
int card;
{
int count;
int i;
count = 0;
for (i=0; i<7; i++)
    if (hand[me][i] == card)
         count += 1;
return(count);
}

/*******************************************/
/* computes a weight for playing this card */
/*******************************************/
compute_play_weight(num)
int num;
{
int score_limit;
score_limit = extension ? 1000 : 700;
switch (hand[me][num]) {
    case extra_tank: {
         if (hand[me][battle] == out_of_gas)
              if (num != 6)
                   return(100);
              else
                   return(80);
         if (hand[you][miles] + 100 >= score_limit)
              return(97);
         if (hand[me][miles] + 100 >= score_limit)
              return(80);
         if (cards_played[out_of_gas] == 0)
              return(51);
         return(6);
         }
    case puncture_proof: {
         if (hand[me][battle] == flat_tire)
              if (num != 6)
                   return(100);
              else
                   return(80);
         if (hand[you][miles] + 100 >= score_limit)
              return(97);
         if (hand[me][miles] + 100 >= score_limit)
              return(80);
         if (cards_played[flat_tire] == 0)
              return(51);
         return(6);
         }
    case driving_ace: {
         if (hand[me][battle] == accident)
              if (num != 6)
                   return(100);
              else
                   return(80);
         if (hand[you][miles] + 100 >= score_limit)
              return(97);
         if (hand[me][miles] + 100 >= score_limit)
              return(80);
         if (cards_played[accident] == 0)
              return(51);
         return(6);
         }
    case right_of_way: {
         if (hand[me][battle] == stop || hand[me][limit] == speed_limit)
              if (num != 6)
                   return(100);
              else
                   return(80);
         if (hand[you][miles] + 100 >= score_limit)
              return(97);
         if (hand[me][miles] + 100 >= score_limit)
              return(80);
         if (cards_played[stop] == 0 && cards_played[speed_limit] == 0)
              return(51);
         return(6);
         }
    case gasoline: {
         return(85);
         }
    case spare_tire: {
         return(85);
         }
    case repairs: {
         return(85);
         }
    case end_of_limit: {
         return(85);
         }
    case roll: {
         return(85);
         }
    case out_of_gas: {
         return(95);
         }
    case flat_tire: {
         return(95);
         }
    case accident: {
         return(95);
         }
    case speed_limit: {
         return(90);
         }
    case stop: {
         return(95);
         }
    case miles_200: {
         if (hand[me][miles] + 200 == score_limit)
              return(75);
         if (hand[you][miles] + 100 >= score_limit)
              return(73);
         if (hand[me][miles] + 200 <= score_limit - 100)
              return(63);
         return(35);
         }
    case miles_100: {
         if (hand[me][miles] + 100 == score_limit)
              return(75);
         if (hand[you][miles] + 100 >= score_limit)
              return(71);
         if (hand[me][miles] + 100 <= score_limit - 100)
              return(61);
         return(30);
         }
    case miles_75: {
         if (hand[me][miles] + 75 == score_limit)
              return(75);
         if (hand[you][miles] + 100 >= score_limit)
              return(69);
         if (hand[me][miles] + 75 <= score_limit - 100)
              return(59);
         if (hand[me][miles] == score_limit - 100 && count_card(miles_25) >= 1)
              return(54);
         return(25);
         }
    case miles_50: {
         if (hand[me][miles] + 50 == score_limit)
              return(75);
         if (hand[you][miles] + 100 >= score_limit)
              return(67);
         if (hand[me][miles] + 50 <= score_limit - 100)
              return(57);
         if (hand[me][miles] == score_limit - 100 && count_card(miles_50) >= 2)
              return(53);
         if (hand[me][miles] == score_limit - 100 && count_card(miles_25) >= 2)
              return(53);
         if (hand[me][miles] == score_limit - 75 && count_card(miles_25) >= 1)
              return(53);
         return(20);
         }
    case miles_25: {
         if (hand[me][miles] + 25 == score_limit)
              return(75);
         if (hand[you][miles] + 100 >= score_limit)
              return(65);
         if (hand[me][miles] + 25 <= score_limit - 100)
              return(55);
         if (hand[me][miles] == score_limit - 100 && count_card(miles_25) >= 4)
              return(52);
         if (hand[me][miles] == score_limit - 75 && count_card(miles_25) >= 3)
              return(52);
         if (hand[me][miles] == score_limit - 50 && count_card(miles_25) >= 2)
              return(52);
         return(15);
         }
    }
return(0);	/* never gets here */
}

/**********************************************/
/* computes a weight for discarding this card */
/**********************************************/
compute_discard_weight(num)
int num;
{
int score_limit;
score_limit = extension ? 1000 : 700;
switch (hand[me][num]) {
    case extra_tank: {
         return(0);
         }
    case puncture_proof: {
         return(0);
         }
    case driving_ace: {
         return(0);
         }
    case right_of_way: {
         return(0);
         }
    case gasoline: {
         if (hand[me][safety] & 0x1)
              return(50);
         if (cards_played[out_of_gas] == 0)
              return(50);
         if (cards_played[out_of_gas] == 1 && count_card(gasoline) > 1)
              return(50);
         if (count_card(gasoline) > 2)
              return(40);
         if (count_card(gasoline) > 1)
              return(10);
         return(2);
         }
    case spare_tire: {
         if (hand[me][safety] & 0x2)
              return(50);
         if (cards_played[flat_tire] == 0)
              return(50);
         if (cards_played[flat_tire] == 1 && count_card(spare_tire) > 1)
              return(50);
         if (count_card(spare_tire) > 2)
              return(40);
         if (count_card(spare_tire) > 1)
              return(10);
         return(2);
         }
    case repairs: {
         if (hand[me][safety] & 0x4)
              return(50);
         if (cards_played[accident] == 0)
              return(50);
         if (cards_played[accident] == 1 && count_card(repairs) > 1)
              return(50);
         if (count_card(repairs) > 2)
              return(40);
         if (count_card(repairs) > 1)
              return(10);
         return(2);
         }
    case end_of_limit: {
         if (hand[me][safety] & 0x8)
              return(50);
         if (cards_played[speed_limit] == 0)
              return(50);
         if (cards_played[speed_limit] == 1 && count_card(end_of_limit) > 1)
              return(50);
         if (count_card(end_of_limit) > 2)
              return(40);
         if (count_card(end_of_limit) > 1)
              return(10);
         return(2);
         }
    case roll: {
         if (hand[me][safety] & 0x8)
              return(50);
         if (count_card(roll) > 3)
              return(40);
         if (count_card(roll) > 2)
              return(10);
         return(1);
         }
    case out_of_gas: {
         if (hand[you][safety] & 0x1)
              return(50);
         return(3);
         }
    case flat_tire: {
         if (hand[you][safety] & 0x2)
              return(50);
         return(3);
         }
    case accident: {
         if (hand[you][safety] & 0x4)
              return(50);
         return(3);
         }
    case speed_limit: {
         if (hand[you][safety] & 0x8)
              return(50);
         return(6);
         }
    case stop: {
         if (hand[you][safety] & 0x8)
              return(50);
         return(3);
         }
    case miles_200: {
         if (hand[me][cnt_200] == 2)
              return(50);
         if (hand[me][cnt_200] == 1 && count_card(miles_200) > 1)
              return(50);
         if (hand[me][miles] + 200 > score_limit)
              return(50);
         return(4);
         }
    case miles_100: {
         if (hand[me][miles] + 100 > score_limit)
              return(50);
         return(5);
         }
    case miles_75: {
         if (hand[me][miles] + 75 > score_limit)
              return(50);
         if (hand[me][miles] + 75 == score_limit && count_card(miles_75) == 1)
              return(3);
         return(7);
         }
    case miles_50: {
         if (hand[me][miles] + 50 > score_limit)
              return(50);
         if (hand[me][miles] + 50 == score_limit && count_card(miles_50) == 1)
              return(3);
         return(8);
         }
    case miles_25: {
         if (hand[me][miles] + 25 > score_limit)
              return(50);
         if (hand[me][miles] + 25 == score_limit && count_card(miles_25) == 1)
              return(3);
         return(9);
         }
    }
return(0);	/* never gets here */
}

/*********** end of program **********/
