/* card.c */
/* transportable    */

/**********************************************************************/
/*                                                                    */
/*           MM   MM  IIIIIII  L        L        EEEEEEE              */
/*           M M M M     I     L        L        E                    */
/*           M  M  M     I     L        L        EEEE                 */
/*           M     M     I     L        L        E                    */
/*           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              */
/*                                                                    */
/*      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          */
/*      B     B  O     O  R     R  N N   N  E        S                */
/*      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           */
/*      B     B  O     O  R    R   N   N N  E              S          */
/*      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           */
/*                                                                    */
/*                                                                    */
/* Creation: Edmond Dujardin                                          */
/*           (c) 1962 Parker Brothers, Inc.                           */
/*                                                                    */
/* Written by: Brett K. Carver                                        */
/*             Hewlett-Packard, 1983.                                 */
/*                                                                    */
/* Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             */
/*                                                                    */
/**********************************************************************/

#include "miles.h"

/**********************************/
/* external procedure definitions */
/**********************************/

extern rand();

/*********************************/
/* external variable definitions */
/*********************************/

extern int deck[20];            /* shufled deck of cards */
extern int hand[2][15];         /* current status of players */

/**********************************************************************/
/*                                                                    */
/*              CARD DECK HANDLING UTILITIES                          */
/*                                                                    */
/**********************************************************************/

/*********************************************************/
/* initilaizes a card_set structure with the card counts */
/*********************************************************/
initialize_card_set (cards)
int cards[20];
{
cards[0]              = 101;    /* total cards */
cards[extra_tank]     = 1;      /* safeties */
cards[puncture_proof] = 1;
cards[driving_ace]    = 1;
cards[right_of_way]   = 1;
cards[gasoline]       = 6;      /* remedies */
cards[spare_tire]     = 6;
cards[repairs]        = 6;
cards[end_of_limit]   = 6;
cards[roll]           = 14;
cards[out_of_gas]     = 2;      /* hazards */
cards[flat_tire]      = 2;
cards[accident]       = 2;
cards[speed_limit]    = 3;
cards[stop]           = 4;
cards[miles_200]      = 4;      /* distance */
cards[miles_100]      = 12;
cards[miles_75]       = 10;
cards[miles_50]       = 10;
cards[miles_25]       = 10;
}

/********************************************/
/* removes a card from the deck and returns */
/* card if it could, 0 if it couldn't       */
/********************************************/
remove_card (cards,card)
int cards[20];
int card;
{
if (cards[card] > 0) {          /* any more cards */
    cards[card]--;              /* decrement card count */
    cards[0]--;                 /* decrement total card count */
    return(card);
    }
else
    return(0);
}

/*********************************************/
/* given a random number, return a card type */
/*********************************************/
get_card (number)
int number;
{
number = number % 101;          /* 0 - 101 */
if (number >= 28 && number <= 41)
    return(roll);
if (number >= 59 && number <= 70)
    return(miles_100);
if (number >= 71 && number <= 80)
    return(miles_75);
if (number >= 81 && number <= 90)
    return(miles_50);
if (number >= 91 && number <= 100)
    return(miles_25);
if (number >= 4 && number <= 9)
    return(gasoline);
if (number >= 10 && number <= 15)
    return(spare_tire);
if (number >= 16 && number <= 21)
    return(repairs);
if (number >= 22 && number <= 27)
    return(end_of_limit);
if (number >= 51 && number <= 54)
    return(stop);
if (number >= 55 && number <= 58)
    return(miles_200);
if (number >= 48 && number <= 50)
    return(speed_limit);
if (number >= 42 && number <= 43)
    return(out_of_gas);
if (number >= 44 && number <= 45)
    return(flat_tire);
if (number >= 46 && number <= 47)
    return(accident);
if (number == 0)
    return(extra_tank);
if (number == 1)
    return(puncture_proof);
if (number == 2)
    return(driving_ace);
if (number == 3)
    return(right_of_way);
while (TRUE) ;                  /* error case */
}

/********************************************/
/* deals a card, if no cards left, return 0 */
/* 1. gets a random number                  */
/* 2. gets the card                         */
/* 3. removes the card from the deck        */
/* 4. if successful, return card            */
/********************************************/
deal_card ()
{
int card;
int more_cards;
int i;
more_cards = FALSE;
for (i=0; i<20; i++)
    if (deck[i] > 0)
         more_cards = TRUE;
if (more_cards)
    while ((card = remove_card(&deck[0],get_card(rand()))) == 0)
         ;
else
    card = 0;
return(card);
}

/*******************************************/
/* checks to see if who has any cards left */
/*******************************************/
any_cards_left(who)
int who;
{
int i;
for (i=0; i<7; i++)
    if (hand[who][i] > 0)
         return(TRUE);
return(FALSE);
}

/*********** end of program **********/
