/*
 * This file is part of the Minicom Communications Program,
 * written by Miquel van Smoorenburg 1991/1992.
 *
 * config.h  -  default configuration.
 */

/* Which tty to use */
#define DFL_PORT "/dev/com2l"

/* Default baudrate  */
#define DEF_BAUD "2400"

/* Default script interpreter */
#define SCRIPTPROG "/usr/local/bin/runscript"

/* Where is kermit and how do we call it */
#define KERMIT "/usr/bin/kermit -l %l -b %b"

/* The "callout" program - empty if you don't have one */
/* #define CALLOUT "" */
#define CALLOUT "/etc/disable com2r"

/* The "callin" program - empty if you don't have one */
/* #define CALLIN "" */
#define CALLIN "/etc/enable com2r"

/* The position of the lock files - again, empty if you don't have them */
/* #define UUCPLOCK "" */
#define UUCPLOCK "/usr/spool/uucp/LCK..5.1"

/*
 * The next definitions are permanent ones - you can't edit the
 * configuration from within minicom to change them
 */

/* Location of "keyserv" program" */
#define KEYSERV "/usr/local/lib/minicom/keyserv"

/* Location of parameter files */
#define PARDIR "/usr/local/lib/minicom"

/* Menu Colors (for all possible colors - look in window.h) */
#define MFG	YELLOW	/* ForeGround */
#define MBG	BLUE	/* BackGround */

/* Terminal window colors */
#define SFG	BLUE
#define SBG	CYAN

/* The next automatically defines "KEY_KLUDGE" for a Minix system;
 * it improves the algorithm for decoding escape sequences but
 * is very Minix specific (read: DIRTY)
 */
#ifdef _MINIX
#  define KEY_KLUDGE 1
#endif

/*
 * Only and only define this if you have a slow machine and find
 * the output of minicom unaccepably jerky.
 */
#ifdef _MINIX
#  define SMOOTH /* */
#endif

#if defined (_SYSV) || defined (_BSD43)
#  if !defined(linux) && !defined(_SVR2) && !defined(COHERENT)
#    define HAS_FCHOWN
#  endif
#endif
