#!/bin/sh
# ------------------------------------------------------------------------------
# Program		:	man (substitite for /bin/man)
# Created by		:	H.P. Heidinger, Germany 
# Creation date		:	07-Oct-92/hph
# Last modified by	:	-
# Revision date		:	21-Oct-92/hph
# Revision 		:	V1.2
# ------------------------------------------------------------------------------
# Purpose: Display manual pages - but even compressed ones
#
#           man is a substitute for the conventional man(1) programm
#           usually /bin/man. The advantage is that it handles manual
#           pages which are in compressed form.
#
#           The program supports compressed manuals for:
#           compress	(zcat)	= suffix .Z
#           freeze	(fcat)	= suffix .F
#           pack	(pcat)	= suffix .z
#           unzip	(unzip)	= suffix .zip	... and of course ..
#           cat			= no suffix, i.e. uncompressed
#
# ------------------------------------------------------------------------------
#set -x
. /etc/default/man

###
# Do the default action if no parameters were specified
###
if [ $# = 0 ]
then
	$MANPAGER $MANHELP
	exit
fi


###
# Scan for command line parameters (all separated by space!)
###
FLAGFOUND=TRUE
while [ $FLAGFOUND = TRUE ]
do
	case $1 in
		-w)	ONLY_PATHES=TRUE
			shift
		;;
		*)	FLAGFOUND=FALSE		# ignore rest of command line
	;;
	esac
done


###
# Here we go ... find entries in the manuals-index-file that fit the request
###
if [ .$ONLY_PATHES = .TRUE ]
then
	if [ .$1 = "." ]
	then
		echo "Usage: man [-w] manual"
		exit
	fi
fi

Manuals=`egrep "[ \t]*[^a-z,A-Z,0-9]+$1\$" $MANINDX|cut -f1 -d" "`
for i in $Manuals
do
    filename=`basename $i`

    if [ .$ONLY_PATHES = .TRUE ]
    then
    	echo $i
    else
    	if [ -f $MANBASE/$i ]	
    	# Try uncompressed first in case the compressor failed 
    	# because of the # 14 character file name limit
	then
		Viewfile=$MANBASE/$i
	elif [ -f $MANBASE/$i\.Z ]; then 
		Viewfile=$MANBASE/$i\.Z
	elif [ -f $MANBASE/$i\.F ]; then 
		Viewfile=$MANBASE/$i\.F
	elif [ -f $MANBASE/$i\.z ]; then 
		Viewfile=$MANBASE/$i\.z
	elif [ -f $MANBASE/$i\.zip ]; then 
		Viewfile=$MANBASE/$i\.zip
	###
	# For a decompressor of your choice replace the ".X" below
	# with the file name extention your decompressor uses and
	# add an entry in the 'case' below also
	###
	#elif [ -f $MANBASE/$i\.X ]; then 
	#	Viewfile=$MANBASE/$i\.X
	fi

	case $Viewfile in
		*.Z)	zcat	$MANBASE/$i.Z	| $MANPAGER
		;;
		*.F)	fcat	$MANBASE/$i.F	| $MANPAGER
		;;
		*.z)	pcat	$MANBASE/$i.z	| $MANPAGER
		;;
		*.zip)	unzip	$MANBASE/$i.zip	| $MANPAGER
		###
		# For a decompressor of your choice 
		###
		#;;
		#*.X)	decomp	$MANBASE/$i.X	| $MANPAGER
		;;
		*)	 cat	$MANBASE/$i	| $MANPAGER
	;;
	esac
    fi 
done
