#!/bin/sh

test -r .vers || exit 1

VERS="`cat .vers`"
DIST="m4-$VERS"

rm -rf dist
mkdir dist
mkdir dist/$DIST

(	cd dist/$DIST
	for i in "$@"; do
		case $i in
		*/*)	ln -s ../../../$i $i 2>/dev/null ||
				( mkdir `echo $i | sed 's/\/[^\/][^\/]*$//'` &&
				  ln -s ../../../$i $i )
			;;
		*)	ln -s ../../$i $i;;
		esac
	done
)

( cd dist; tar cfh ../m4.tar $DIST )

compress < m4.tar > $DIST.tar.Z
rm -fr m4.tar dist
