/* last.c by Harry C. Pulley, IV.  v1.20 7Oct92  
   released to the public domain 

   to compile, cc last.c should do

   this should probably go in /usr/local/bin or something similar 
   (even in /usr/bin) */

#include <stdio.h>
#include <stdlib.h>
#include <utmp.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#define WTMP_FILE "/usr/adm/wtmp"

main(argc,argv)
int argc;
char **argv;
{
	struct stat wstats;

	FILE *wtmp;
	/* N.B. 32000 is an arbitrary number.  you can pick a higher one if you
	   think you will have more login entries than that ;-) */
	long struct_size=(long)sizeof(struct utmp),count=32000L;
	char user[14]="*";

	long save_pos,cur_pos;

	struct utmp wbuf,nwbuf;
	struct tm *wtime;

	/* parse command line args */

	if (argc>3)
	{
		fputs("Usage: last [-num back] [username]\nusername may be any valid user name (eg. root) or reboot or date\n",stderr);
		exit(1);
	}

	if (argc>1)
	{
		int arg;

		for (arg=1;arg<argc;arg++)
		{
			if (argv[arg][0]=='-')
				count=atol(argv[arg]+1);
			else
				strcpy(user,argv[arg]);
		}
	}

	/* open login accounting file */
	wtmp=fopen(WTMP_FILE,"r");

	if (wtmp==NULL)
	{
		fputs("Fopen error\n",stderr);
		exit(1);
	}

	/* go to end of file since we want reverse chronological order of logins */
	if (fseek(wtmp,0L,2))
	{	
		fputs("Seek error\n",stderr);
		exit(1);
	}

	/* cur_pos keeps track of current file pos */
	cur_pos=ftell(wtmp);
	cur_pos-=struct_size;

	/* seek back one entry */
	if (fseek(wtmp,cur_pos,0))
	{	
		stat(WTMP_FILE,&wstats);
	
		wtime=localtime(&(wstats.st_ctime));

		printf("wtmp starts at %24s\n",asctime(wtime));

		/* fputs("Seek error\n",stderr); */
		exit(1);
	}

	puts("username       tty      time             date");

	/* keep reading until -n have been listed or end of file */
	while(count>0)
	{
		fread(&wbuf,sizeof(struct utmp),1,wtmp);

		/* save current position for later */
		save_pos=ftell(wtmp);

		/* is this a special (reboot, date change) entry? */
		if (strlen(wbuf.ut_line)<2&&(wbuf.ut_line[0]=='|'||wbuf.ut_line[0]=='~')&&(!strcmp(user,"*")||!strcmp(user,"reboot")||!strcmp(user,"date")))
		{
			/* save time of ~ entry for reboot time relative to real time 
			   - I know this is confusing, but so is the wtmp file.  mail
			   me if you want an explanation; I tend to bop around abit
			   but you can try hcp@csx.cciw.ca and 
			   hcpiv@grumpy.cis.uoguelph.ca */
			time_t orig_time=wbuf.ut_time,diff_time=(time_t) 0;

			/* is this a reboot ~ entry? */
			if (wbuf.ut_line[0]=='~'&&(!strcmp(user,"*")||!strcmp(user,"reboot")))
			{
				/* scan ahead until we find a real time entry
				   - the boot time entry is actually the shut
				   down time, correct me if I am wrong */
				do
				{
					fread(&wbuf,sizeof(struct utmp),1,wtmp);
	
					/* if the next entry is a date change
					   we can use the time difference 
					   between the boot entry and the first
					   (from) entry of date to get the 
					   actual boot time */
					if (wbuf.ut_line[0]=='|'&&strlen(wbuf.ut_line)<2)
						diff_time=wbuf.ut_time-orig_time;
				}
				while (wbuf.ut_line[0]=='|'&&strlen(wbuf.ut_line)<2);

				/* calculate actual boot time */
				wbuf.ut_time-=diff_time;	
				wtime=localtime(&(wbuf.ut_time));

				printf("reboot         -        Machine Rebooted %24s",asctime(wtime));

				count--;
			}
			/* else it is a date entry */
			else if (!strcmp(user,"*")||!strcmp(user,"date"))
			{
				fread(&wbuf,sizeof(struct utmp),1,wtmp);

				/* the first date entry is the date before 
				   setting the date.  we want to skip that one
				   and go to the real date */
				if (wbuf.ut_line[0]=='}'&&strlen(wbuf.ut_line)==1)
				{
					wtime=localtime(&(wbuf.ut_time));

					printf("date           -        Date Set         %24s",asctime(wtime));

					count--;
				}
			}
				
			/* break if done */
			if (count==0)
				break;

			/* restore file ptr to last reboot or date change and 
			   advance (rewind actually, since we are going 
			   backwards) then seek */
			cur_pos=save_pos-struct_size;
	
			if (fseek(wtmp,cur_pos,0))
				break;
		}

		/* is this a login entry? */
		if (strlen(wbuf.ut_name)>0&&(!strcmp(user,wbuf.ut_name)||!strcmp(user,"*")))
		{
			/* loop until we find the logout (or another login) for
			   this tty */
			do
			{
				fread(&nwbuf,sizeof(struct utmp),1,wtmp);
		
				if (feof(wtmp))
					break;

				/* reboots or date changes will goof things up
				   for us, so assume logout after a reboot or a
				   date change (not a BAD assumption, I hope ;) 
				*/
				if (strlen(nwbuf.ut_line)<2&&(nwbuf.ut_line[0]=='}'||nwbuf.ut_line[0]=='|'||wbuf.ut_line[0]=='~'))
					break;
			}
			while(strcmp(wbuf.ut_line,nwbuf.ut_line));

			/* if we reached eof before finding a logout, then the
			   user is still logged in */
			if (feof(wtmp))
			{
				wtime=localtime(&(wbuf.ut_time));

				printf("%-14s %-8s Still Logged On  %24s",wbuf.ut_name,wbuf.ut_line,asctime(wtime));
			
				count--;
			}			
			else /* user logged out */
			{
				time_t difft;
				long hours,minutes;

				difft=nwbuf.ut_time-wbuf.ut_time;

				hours=(long) difft/3600;
				if (hours>99)
					hours=99;

				minutes=((long) difft%3600)/60;	

				wtime=localtime(&(wbuf.ut_time));

				printf("%-14s %-8s %02ld:%02ld            %24s",wbuf.ut_name,wbuf.ut_line,hours,minutes,asctime(wtime));
			
				count--;
			}

			/* again, go back to original login and advance one 
			   entry */
			cur_pos=save_pos-struct_size;
		}
	
		cur_pos-=struct_size;

		if (fseek(wtmp,cur_pos,0))
			break;
		
		/* ftell check added for Coherent 4.0 which does not return 
		   an error when seeking past beginning of file - 7Oct92
		   bug reported by Bjarne G. Hald (hald@id.dth.dk) */
		if (ftell(wtmp)<0)
			break;
	}

	/* if we reached eof before -n lines, print out the date of the first
	   entry of wtmp as the start of login accounting */
	if (count>0)
	{
		wtime=localtime(&(wbuf.ut_time));

		printf("wtmp starts at %24s\n",asctime(wtime));
	}
	
	/* clean up */
	fclose(wtmp);
	fflush(stdout);
}
/* end of main */
