/*
 * This program (called "Hotel") is copyright 1989 to Scott R. Turner,
 * in both source code and executable form.  Permission is given to 
 * copy both the source code and the executable under the following
 * conditions:
 * 
 * COPYING POLICIES
 * 
 *   1. You may copy and distribute verbatim copies of Hotel code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each file a valid copyright notice such as
 * "Copyright (C) 1989 Scott R. Turner", and keep intact the copyright
 * and license notices on all files.  You may charge a distribution fee for the
 * physical act of transferring a copy, but that fee may not exceed
 * your actual costs in creating and delivering the copy.
 * 
 *   2. You may modify your copy or copies of Hotel or any portion of it,
 * and copy and distribute such modifications under the terms of
 * Paragraph 1 above, provided that you also do the following:
 * 
 *     a) cause the modified files to carry prominent notices stating
 *     who last changed such files and the date of any change; and
 * 
 *     b) cause the whole of any work that you distribute or publish,
 *     that in whole or in part contains or is a derivative of Hotel
 *     or any part thereof, to be licensed at no charge to all third
 *     parties on terms identical to those contained in this License
 *     Agreement (except that you may choose to grant more extensive
 *     warranty protection to third parties, at your option).
 *
 *   3. You may not copy, sublicense, distribute or transfer Hotel
 * except as expressly provided under this License Agreement.  Any attempt
 * otherwise to copy, sublicense, distribute or transfer Hotel is void and
 * your rights to use Hotel under this License agreement shall be
 * automatically terminated.  However, parties who have received computer
 * software programs from you with this License Agreement will not have
 * their licenses terminated so long as such parties remain in full compliance.
 * 
 *   4.  Under no circumstances may you charge for copies of Hotel, for copies
 * of any program containing code from Hotel in whole or in part, or for 
 * any software package or collection of programs or code that contains Hotel
 * in whole or part.
 *
 */ 
/*
 *  utils.c
 *  Scott R. Turner
 *  9/7/88
 *
 *  Various utility functions.
 *
 */
#include "defs.h"

extern int unplayable();
#ifdef UNIX
#ifndef COHERENT
extern long random();
#else
extern int rand();
#endif
#endif UNIX
int tilecount = 0;

/*
 *  randum is the standard 1-n random integer generator.
 *
 */

int randum(n)
     int n;
{
  if (!n) return(0);
#ifdef UNIX
#ifndef COHERENT
  return((random() % n) + 1);
#else
  return((rand() % n) + 1);
#endif
#endif
#ifdef TURBO
  return((rand() % n) + 1);
#endif
};

/*
 *  newtile replaces a tile in a player's holding with a tile
 *  from the board.
 *
 */

newtile(p)
     int p;
{
  int x,y,available,choice;

  available=0;
  for(x=1;x<=boardsize;x++)
    for(y=1;y<=boardsize;y++)
      if (board[x][y] == 0 && !unplayable(x,y)) available++;

  if (debug) {
  	printw("Available tiles = %d.\n",available);
	refresh();
  };
  if (available == 0) return(0);
  
  choice = randum(available);

  for(x=1;x<=boardsize;x++)
    for(y=1;y<=boardsize;y++) {
      if (board[x][y] == 0) {
	choice--;
	if (choice == 0) {
	  board[x][y] = -p;
	  return(1);
	};
      };
    };
      
  return(0);

};

/*
 *  new_hotel returns true if the placement creates a new hotel
 *  and there is a new hotel to create.
 *
 */

new_hotel(x,y)
     int x,y;
{
  int i,j,new;

  /* Is the new tile adjacent to an existing hotel? */

  new = 1;
  for(i= -1;i<2;i++)
    for(j= -1;j<2;j++)
      if ( i*j == 0 && (i != 0 || j != 0) &&
	  ((x+i) > 0) && ((y+j) > 0) &&
	  ((x+i) <= boardsize) && ((y+j) <= boardsize) &&
	  (board[x+i][y+j] > 0) && (board[x+i][y+j] < UNUSED)) {
	new = 0;
	break;
      };

  if (new == 0) return(new);
              
  /* Is there an UNUSED adjacent? */

  new = 0;
  for(i= -1;i<2;i++)
    for(j= -1;j<2;j++)
      if ( i*j == 0 && (i != 0 || j != 0) &&
	  ((x+i) > 0) && ((y+j) > 0) &&
	  ((x+i) <= boardsize) && ((y+j) <= boardsize) &&
	  (board[x+i][y+j] == UNUSED)) {
	new = 1;
	break;
      };

  if (new == 0) return(new);
  
/* Is there an available hotel? */

  new = 0;
  for(i=1;i<=numhotels;i++)
    if(hotels[i].size == 0) {
      new = 1;
      break;
    };

  return(new);

};

int maj_bonus(p,i)
  int p,i;
{
  int j,k,max1,num1,max2,num2,first,second;
  
  max1 = 0;
  num1 = 0;
  max2 = 0;
  num2 = 0;

  for(j=1;j<=numplayers;j++) {
    if (players[j].shares[i] > max1) {
      max2 = max1;
      num2 = num1;
      max1 = players[j].shares[i];
      num1 = 1;
    } else if (players[j].shares[i] == max1) {
      num1++;
    } else if (players[j].shares[i] > max2) {
      max2 = players[j].shares[i];
      num2 = 1;
    } else if (players[j].shares[i] == max2) {
      num2++;
    };
  };

  majority_bonus(i,&first,&second);

  if (max2 == 0 || num1 > 1) {

    /*
     *  The top dogs split both.
     *
     */

    for(k=1;k<=numplayers;k++)
      if (players[k].shares[i] == max1 && k == p) {
	return(round((first + second) / num1));
      };
  } else
    for (k=1;k<=numplayers;k++)
      if (players[k].shares[i] == max1 && k == p) {
	return(round(first));
      } else if (players[k].shares[i] == max2 && k == p) {
	return(round(second/num2));
      };

  return(0);
  
};

/*
 *  merge returns true if this play will merge 2 or more hotels.
 *  It returns the list of hotels that will/can be merge in
 *  possibles.
 *
 */

int mergecheck(x,y,possibles)
     int x,y,*possibles;
{
  int i,j,k,lsize,count,seen[MAXHOTELS];

  if (unplayable(x,y)) return(0);
  for (i=1;i<=numhotels;i++) seen[i] = 0;
  lsize = 9999;
  count = 0;
  for(i= -1;i<2;i++)
    for(j= -1;j<2;j++)
      if ( i*j == 0 && (i != 0 || j != 0) &&
	  ((x+i) > 0) && ((y+j) > 0) &&
	  ((x+i) <= boardsize) && ((y+j) <= boardsize) &&
	  (board[x+i][y+j] != UNUSED) &&
	  (board[x+i][y+j] > 0)){
	if (!seen[board[x+i][y+j]]) {
	  count++;
	  seen[board[x+i][y+j]] = 1;
	  if (hotels[board[x+i][y+j]].size < lsize) {
	    for (k=1;k<=numhotels;k++) possibles[k] = 0;
	    lsize = hotels[board[x+i][y+j]].size;
	    possibles[board[x+i][y+j]] = 1;
	  } else if (hotels[board[x+i][y+j]].size == lsize) {
	    possibles[board[x+i][y+j]] = 1;
	  };
	};
      };

  if (count < 2) return(0);
  else return(1);
  
};
	    
/*
 *  adjacent returns the number of an adjacent hotel if there
 *  is one.  adjacent assumes that there is at most one adjacent
 *  hotel.
 *
 */

int adjacent(x,y,h)
     int x,y,*h;
{
  int i,j;

  for(i= -1;i<2;i++)
    for(j= -1;j<2;j++)
      if ( i*j == 0 && (i != 0 || j != 0) &&
	  ((x+i) > 0) && ((y+j) > 0) &&
	  ((x+i) <= boardsize) && ((y+j) <= boardsize) &&
	  (board[x+i][y+j] != UNUSED) &&
	  (board[x+i][y+j] > 0)){
	*h = board[x+i][y+j];
	return(*h);
      };
  *h = 0;
  return(0);
};
	
