/*
 * This program (called "Hotel") is copyright 1989 to Scott R. Turner,
 * in both source code and executable form.  Permission is given to 
 * copy both the source code and the executable under the following
 * conditions:
 * 
 * COPYING POLICIES
 * 
 *   1. You may copy and distribute verbatim copies of Hotel code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each file a valid copyright notice such as
 * "Copyright (C) 1989 Scott R. Turner", and keep intact the copyright
 * and license notices on all files.  You may charge a distribution fee for the
 * physical act of transferring a copy, but that fee may not exceed
 * your actual costs in creating and delivering the copy.
 * 
 *   2. You may modify your copy or copies of Hotel or any portion of it,
 * and copy and distribute such modifications under the terms of
 * Paragraph 1 above, provided that you also do the following:
 * 
 *     a) cause the modified files to carry prominent notices stating
 *     who last changed such files and the date of any change; and
 * 
 *     b) cause the whole of any work that you distribute or publish,
 *     that in whole or in part contains or is a derivative of Hotel
 *     or any part thereof, to be licensed at no charge to all third
 *     parties on terms identical to those contained in this License
 *     Agreement (except that you may choose to grant more extensive
 *     warranty protection to third parties, at your option).
 *
 *   3. You may not copy, sublicense, distribute or transfer Hotel
 * except as expressly provided under this License Agreement.  Any attempt
 * otherwise to copy, sublicense, distribute or transfer Hotel is void and
 * your rights to use Hotel under this License agreement shall be
 * automatically terminated.  However, parties who have received computer
 * software programs from you with this License Agreement will not have
 * their licenses terminated so long as such parties remain in full compliance.
 * 
 *   4.  Under no circumstances may you charge for copies of Hotel, for copies
 * of any program containing code from Hotel in whole or in part, or for 
 * any software package or collection of programs or code that contains Hotel
 * in whole or part.
 *
 */ 
/*
 *  Wed Nov  2 11:28:34 1988 -- Scott R. Turner
 *  display_utils.c  (PC Version)
 *
 *  This file contains utility functions for maintaining
 *  the screen display.  (Primarily print_board).
 *
 */

#include "defs.h"
#ifdef TURBO
#define DULCORNER 201  
#define DURCORNER 187
#define DLRCORNER 188  
#define DLLCORNER 200
#define DLINE 205    
#define DVERTICAL 186    
#define BLOCK 254      
#define POINT 250      
#define LINE 196  
#define LINETEE 194  
#define VERTICAL 179    
#define ULCORNER 218
#define URCORNER 191
#define LRCORNER 217
#define LLCORNER 192
#define TRIPLELINE 240
#define LHORTEE 180
#define RHORTEE 195
#endif

#ifdef UNIX
#define DULCORNER '+' 
#define DURCORNER '+'
#define DLRCORNER '+'  
#define DLLCORNER '+'
#define DLINE '-'
#define DVERTICAL '|'
#define BLOCK '*'  
#define POINT '.'      
#define LINE '-' 
#define LINETEE '+'
#define VERTICAL '|'
#define ULCORNER '+'
#define URCORNER '+'
#define LRCORNER '+'
#define LLCORNER '+'
#define TRIPLELINE '*'
#define LHORTEE '|'
#define RHORTEE '|'
#endif

print_board(p)
     int p;
{
  int i,j,tile,x,y;

  getyx(stdscr,y,x);
  tile = 1;
  move(2,3);
  addch(DULCORNER);
  for(i=1;i<=boardsize;i++) {
    move(2,(i-1)*2+4);
/*    addstr("MM"); */
    addch(DLINE);
    addch(DLINE);
  }
  move(2,boardsize*2+4);
  addch(DLINE);
  addch(DURCORNER);
/*  addstr("M;"); */
  for(i=1;i<=boardsize;i++) {
    move(i+2,3);
/*    addch(':'); */
    addch(DVERTICAL);
    for(j=1;j<=boardsize;j++) {
      move(i+2,(2 * j)+3);
      if (board[i][j] == UNUSED) {
/*	addch('~'); */
        addch(BLOCK);
      } else if (board[i][j] == 0) {
/*	addch('y');  */
        addch(POINT);
      } else if (board[i][j] == -p) {
	standout();
	addch('0' + tile++);
	standend();
      } else if (board[i][j] == UNPLAYABLE && debug) {
        addch('*');
      } else if (board[i][j] < 0) {
/*	addch('y');  */
        addch(POINT);
      } else
	addch(board[i][j] + 'A' - 1);
    };
    move(i+2,(boardsize*2+5));
/*    addch(':');  */
    addch(DVERTICAL);
  };
  move(boardsize+3,3);
/*  addch('H'); */
  addch(DLLCORNER);
  for(i=1;i<=boardsize;i++) {
    move(boardsize+3,(i-1)*2+4);
/*    addstr("MM");  */
    addch(DLINE);
    addch(DLINE);
  }
  move(boardsize+3,boardsize*2+4);
/*  addstr("M<"); */
  addch(DLINE);
  addch(DLRCORNER);

  /*  Now do rhs info. */

  move(2,(boardsize*2+8));
  printw("Hotel    Cost    Yours   Available");
  move(3,(boardsize*2+8));
  for (i=1;i<=6;i++) addch(LINE);
  addch(LINETEE);
  for (i=1;i<=8;i++) addch(LINE);
  addch(LINETEE);
  for (i=1;i<=7;i++) addch(LINE);
  addch(LINETEE);
  for (i=1;i<=10;i++) addch(LINE);
/*  printw("D D D D D D B D D D D D D D D B D D D D D D D B D D D D D D D D D D"); */
  for(i=1;i<=numhotels;i++) {
    move(i+3,(boardsize*2+10));
    clrtoeol();
    addch(i+'A'-1);
    if(hotels[i].size > 0) {
      move(i+3,(boardsize*2+17));
      printw("$%d",share_cost(i));
    } else {
      move(i+3,(boardsize*2+16));
      printw("($%d)",share_cost(i));
    };
    if (players[p].shares[i] > 0) {
      move(i+3,(boardsize*2+27));
      printw("%d",players[p].shares[i]);
    };
    move(i+3,(boardsize*2+36));
    printw("%d",hotels[i].shares);
    move(i+3,(boardsize*2+14));
/*    addch('3'); */
    addch(VERTICAL);
    move(i+3,(boardsize*2+23));    
/*    addch('3');  */
    addch(VERTICAL);
    move(i+3,(boardsize*2+31));
/*    addch('3');  */
    addch(VERTICAL);
  };

  move(numhotels+6,(boardsize*2+18));
  clrtoeol();
  printw("Cash = $%d",players[p].cash);
  move(0,0);
/*  printw("ZDDDDDDDDDDDDDDDDDDDDDDDDD 4 pHpOpTpEpLp C D D D D D D D D D D D D D D D D D D D D D D D D ?"); */
  addch(ULCORNER);
  for(i=1;i<=25;i++) addch(LINE);
  addch(LHORTEE); addch(' ');
  addch(TRIPLELINE); addch('H');
  addch(TRIPLELINE); addch('O');
  addch(TRIPLELINE); addch('T');
  addch(TRIPLELINE); addch('E');
  addch(TRIPLELINE); addch('L');
  addch(' '); addch(RHORTEE);
  for(i=1;i<=25;i++) addch(LINE);
  addch(URCORNER);
  for(i=1;i<=(boardsize+3);i++) {
  	move(i,0);
/*  	addch('3');  */
        addch(VERTICAL);
	move(i,65);
/*  	addch('3');  */
        addch(VERTICAL);
  };
  move((boardsize + 4),0);
/*  printw("@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY"); */
  addch(LLCORNER);
  for(i=1;i<=64;i++) addch(LINE);
  addch(LRCORNER);
  move(y,x);
  refresh();
};

