/*
 * This program (called "Hotel") is copyright 1989 to Scott R. Turner,
 * in both source code and executable form.  Permission is given to 
 * copy both the source code and the executable under the following
 * conditions:
 * 
 * COPYING POLICIES
 * 
 *   1. You may copy and distribute verbatim copies of Hotel code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each file a valid copyright notice such as
 * "Copyright (C) 1989 Scott R. Turner", and keep intact the copyright
 * and license notices on all files.  You may charge a distribution fee for the
 * physical act of transferring a copy, but that fee may not exceed
 * your actual costs in creating and delivering the copy.
 * 
 *   2. You may modify your copy or copies of Hotel or any portion of it,
 * and copy and distribute such modifications under the terms of
 * Paragraph 1 above, provided that you also do the following:
 * 
 *     a) cause the modified files to carry prominent notices stating
 *     who last changed such files and the date of any change; and
 * 
 *     b) cause the whole of any work that you distribute or publish,
 *     that in whole or in part contains or is a derivative of Hotel
 *     or any part thereof, to be licensed at no charge to all third
 *     parties on terms identical to those contained in this License
 *     Agreement (except that you may choose to grant more extensive
 *     warranty protection to third parties, at your option).
 *
 *   3. You may not copy, sublicense, distribute or transfer Hotel
 * except as expressly provided under this License Agreement.  Any attempt
 * otherwise to copy, sublicense, distribute or transfer Hotel is void and
 * your rights to use Hotel under this License agreement shall be
 * automatically terminated.  However, parties who have received computer
 * software programs from you with this License Agreement will not have
 * their licenses terminated so long as such parties remain in full compliance.
 * 
 *   4.  Under no circumstances may you charge for copies of Hotel, for copies
 * of any program containing code from Hotel in whole or in part, or for 
 * any software package or collection of programs or code that contains Hotel
 * in whole or part.
 *
 */ 
/*
 *  init.c
 *  Scott R. Turner
 *  9/7/88
 *
 *  init.c contains the routines to initialize the game and to 
 *  ask the initial questions of the user (number of players, etc.)
 *
 */
#include "defs.h"
extern void newtile();
extern void help();
extern int getnum();
extern void any_key();
int human_player;

init()
{
  int i,j,x,y;
  char ans[80], ch;


/* Initialize run-time variables.  These will probably be modified
   or set to new values by the function that will read the startup
   file. 
*/

  numhotels = 7;
  boardsize = 10;
  numshares = 30;
  startcash = 6000;
  numtiles = 6;
  maxbuy = 3;

/*   At this point, read the initialization file. */
  
/* Initialize the board */

  for(i=1;i<=MAXBOARD;i++)
    for(j=1;j<=MAXBOARD;j++)
      board[i][j] = 0;
  
/* Initialize the hotels */

  for(i=1;i<=MAXHOTELS;i++)
    {
      hotels[i].size = 0;
      hotels[i].shares = numshares;

      /*  Class and Name will probably be set in the initialization file. */

    };

  strcpy(hotels[1].name,"American Motel");
  hotels[1].class = 0;
  strcpy(hotels[2].name,"Bedford Arms");
  hotels[2].class = 0;
  strcpy(hotels[3].name,"Century Plaza");
  hotels[3].class = 1;
  strcpy(hotels[4].name,"Danford Arms");
  hotels[4].class = 1;
  strcpy(hotels[5].name,"Eagle Overnight");
  hotels[5].class = 1;
  strcpy(hotels[6].name,"Fawlty Towers");
  hotels[6].class = 2;
  strcpy(hotels[7].name,"Girabaldi Deluxe");
  hotels[7].class = 2;

  /*  Give the players various names, if they turn out to be computer */

  strcpy(players[1].name,"Andrew");
  strcpy(players[2].name,"Betty");
  strcpy(players[3].name,"Charley");
  strcpy(players[4].name,"Darlene");
  strcpy(players[5].name,"Edmond");
  strcpy(players[6].name,"Freddy");
  strcpy(players[7].name,"Gertrude");

  for(i=1;i<=MAXPLAYERS;i++)
    {
      players[i].cash = startcash;
      for(j=1;j<=MAXHOTELS;j++)
	players[i].shares[j] = 0;
    };
    
  /* Copyright Screen */
  clear();
  move(3,0);
  printw("                                   H*O*T*E*L\n");
  printw("                       Copyright 1989 by Scott R. Turner\n");
  refresh();
  sleep(1);
  clear();

  /* Time to query the user. */

  printw("Welcome to the game of Hotel.\n\n");
  printw("Instructions? (Y/N) ");
  refresh();
  noecho();
  crmode();
  ch = getch();
  if (ch == 'Y' || ch == 'y') help();
  printw("\nHow many players? (2 to %d) ",MAXPLAYERS);
  refresh();
  numplayers = getnum(2,MAXPLAYERS);
  for(i=1;i<=numplayers;i++){
  	players[i].strategy = 1;
  };
  human_player = randum(numplayers);
  players[human_player].strategy = 0;
  strcpy(players[human_player].name,"You");
  printw("You will be the ");
  switch (human_player) {
  	case 1: printw("first");
  		break;
  	case 2: printw("second");
  		break;
  	case 3: printw("third");
  		break;
  	case 4: printw("fourth");
  		break;
  	case 5: printw("fifth");
  		break;
  	case 6: printw("sixth");
  		break;
  	case 7: printw("seventh");
  		break;
  	};
  printw(" player.\n");
  any_key();
  clear();
  
/* Give every player some initial tiles. */

  for(i=1;i<=numplayers;i++)
    for(j=1;j<=numtiles;j++)
      newtile(i);

/* Place one tile for each player. */

  for(i=1;i<=numplayers;i++) {
    x = randum(boardsize);
    y = randum(boardsize);
    while(board[x][y] != 0) {
      x = randum(boardsize);
      y = randum(boardsize);
    };
    board[x][y] = UNUSED;
  };
};
