/*
 * This program (called "Hotel") is copyright 1989 to Scott R. Turner,
 * in both source code and executable form.  Permission is given to 
 * copy both the source code and the executable under the following
 * conditions:
 * 
 * COPYING POLICIES
 * 
 *   1. You may copy and distribute verbatim copies of Hotel code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each file a valid copyright notice such as
 * "Copyright (C) 1989 Scott R. Turner", and keep intact the copyright
 * and license notices on all files.  You may charge a distribution fee for the
 * physical act of transferring a copy, but that fee may not exceed
 * your actual costs in creating and delivering the copy.
 * 
 *   2. You may modify your copy or copies of Hotel or any portion of it,
 * and copy and distribute such modifications under the terms of
 * Paragraph 1 above, provided that you also do the following:
 * 
 *     a) cause the modified files to carry prominent notices stating
 *     who last changed such files and the date of any change; and
 * 
 *     b) cause the whole of any work that you distribute or publish,
 *     that in whole or in part contains or is a derivative of Hotel
 *     or any part thereof, to be licensed at no charge to all third
 *     parties on terms identical to those contained in this License
 *     Agreement (except that you may choose to grant more extensive
 *     warranty protection to third parties, at your option).
 *
 *   3. You may not copy, sublicense, distribute or transfer Hotel
 * except as expressly provided under this License Agreement.  Any attempt
 * otherwise to copy, sublicense, distribute or transfer Hotel is void and
 * your rights to use Hotel under this License agreement shall be
 * automatically terminated.  However, parties who have received computer
 * software programs from you with this License Agreement will not have
 * their licenses terminated so long as such parties remain in full compliance.
 * 
 *   4.  Under no circumstances may you charge for copies of Hotel, for copies
 * of any program containing code from Hotel in whole or in part, or for 
 * any software package or collection of programs or code that contains Hotel
 * in whole or part.
 *
 */ 
/*
 *  human.c
 *  Scott R. Turner
 *  9/7/88
 *
 *  This file contains the "play", "buy" and "liquidate" strategies
 *  for human players.
 *
 */
#include "defs.h"
#include "my_wgets.h"
extern int legal_play();
extern void print_board();
extern void update_cash();
extern void getnum_help();
extern void buy_help();
extern void newhotel_help();
extern void save_help();
extern void quit();

/*
 *  human_play queries the player to find out which of his tiles
 *  he would like to play.
 *
 */

void  human_play(n,px,py)
     int n;
     int *px,*py;
{
  int tile,i,j,legl;

  print_board(n);
  move((boardsize+5),0);
  clrtobot();
  printw("Cash: $%d\n",players[n].cash);
  printw("Holdings: ");
  for(i=1;i<=numhotels;i++)
    if(players[n].shares[i] > 0)
      printw("(%c) %d  ",(i + 'A' - 1),players[n].shares[i]);
  printw("\n");

  /*  The player may not have a legal play.  */

  legl = 0;
    for(i=1;i<=boardsize;i++)
      for(j=1;j<=boardsize;j++)
	if(board[i][j] == -n && legal_play(i,j)) {
	  legl=1;
	  goto done;
	}
 done:

  if (!legl) {
    printw("Sorry, you have no legal moves.\n");
    refresh();
    *px = -1;
    *py = -1;
    return;
  };

  /* Else get his play. */

  do {
    legl = 0;
    printw("Which tile to play? ");
    refresh();
    tile = getnum(1,numtiles);

    /* Is this legitimate? */

    if(tile > numtiles || tile < 1) {
      printw("That is not a valid tile number.\n");
    } else {

      /* Figure out where it is */

      for(i=1;i<=boardsize;i++)
	for(j=1;j<=boardsize;j++)
	  if(board[i][j] == -n) {
	    tile--;
	    if (tile == 0) {
	      *px = i;
	      *py = j;
	      goto finished;
	    };
	  };
      
    finished:
      
      legl = legal_play(*px,*py);
      if (!legl) {
        move((boardsize+8),0);
	clrtobot();
	printw("You cannot create another hotel.\n");
	refresh();
      };
    };
  } while (!legl);
  
};

/*
 *  human_buy queries the player and asks what shares he would
 *  like to purchase, and returns the answer in purchases.
 *
 */
beep2()
{
  printf("%c",7);
};

void  human_buy(p,purchases)
     int p, purchases[MAXHOTELS];
{
  extern int share_cost();
  int i,j,tot,cashtot,goahead;
  char ans;

  for(i=1;i<=numhotels;i++) purchases[i] = 0;

  goahead = 0;
  for(j=1;j<=numhotels;j++)
    if(hotels[j].shares>0 &&
       hotels[j].size>0 && players[p].cash >= share_cost(j))
      goahead = 1;

  if (!goahead) return;

  /*  Query the user about each available hotel. */

  print_board(p);
  move((boardsize+5),0);
  clrtobot();
  printw("What to buy?\n");
  printw("(Hit letter once for each stock, Space to finish.) ");
  refresh();

  tot = 0;
  cashtot = players[p].cash;

  do {
    ans = getch();
    if (islower(ans)) ans = toupper(ans);
    if (ans == REFRESHKEY) {
      wrefresh(curscr);
      continue;
    }
    if (ans == QUITKEY) {
      quit();
    };
    if (ans == HELPKEY) {
        buy_help();
	continue;
    };
    if (ans == 32) break;
    clrtobot();
    i = (ans - 'A' + 1);
    if (i < 1 || i > numhotels || hotels[i].size == 0 ||
	hotels[i].shares == 0) {
      /* An invalid choice, so beep. */
      beep2();
      continue;
    };
    /* Can he afford this? */
    if (share_cost(i) > cashtot) {
      beep2();
      continue;
    };
    purchases[i]++;
    tot++;
    cashtot -= share_cost(i);
  } while (tot != maxbuy);
  move((boardsize+10),0);
  clrtobot();
  refresh();
};

/*
 *  human_liquidate is called when a hotel chain is sunk and a player might
 *  have stock to get rid of.
 *
 */

void  human_liquidate(p,maxhot,sunk,sell,trade)
     int p, *sell, *trade, maxhot,sunk;
{
  int i;

  print_board(p);
  refresh();
  if(players[p].shares[sunk]) {
      *sell = MAXSHARES + 1;
      while(*sell+*trade > players[p].shares[sunk]) {
	move((boardsize+5),0);
	clrtobot();
	*sell = 0;
	*trade = 0;
again:	  
	printw("You have %d shares of (%d) %s.\n",
	       players[p].shares[sunk],sunk,hotels[sunk].name);
	if (hotels[maxhot].shares != 0) {
	  printw("There are %d shares of %s available.\n",hotels[maxhot].shares,
		 hotels[maxhot].name);
	  printw("How many shares would you like to trade in (2 for 1)? ");
	  refresh();
	  echo();
#ifdef UNIX
	  nl(); 
#endif UNIX
        /*	  scanw("%d",trade);  */
        /*  Trying getint. */
        *trade = getint();
#ifdef UNIX
	  nonl(); 
#endif UNIX
	  noecho();
	  printw("\n");

	  if (*trade % 2) {
	    move((boardsize+5),0);
	    clrtobot();
	    printw("Trading an odd number of shares is wasteful.\n");
	    refresh();
	    (void) any_key();
	    goto again;
	  };
	  if ((*trade / 2) > hotels[maxhot].shares) {
	    move((boardsize+5),0);
	    clrtobot();
	    printw("No point in trading for more shares than available.");
	    refresh();
	    (void) any_key();
	    goto again;
	  };
	};
	if (players[p].shares[sunk] > *trade) {
	  printw("How many shares would you like to sell at %d? ",share_cost(sunk));
	  refresh();
	  echo();
#ifdef UNIX
	  nl(); 
#endif UNIX
	  /*  scanw("%d",sell); */
	  *sell = getint();
#ifdef UNIX
	  nonl(); 
#endif UNIX
	  noecho();
	  printw("\n");
        };
	if (*sell+*trade > players[p].shares[sunk]) {
	  printw("That's too many.  You only have %d shares.\n",
		 players[p].shares[sunk]);
          refresh();
          (void) any_key();
	};
     };
   };
};

int  human_new(n,x,y)
     int n,x,y;
{
  int i;
  char ans;

  print_board(n);
  do {
topofselect:
    move((boardsize + 5), 0);
    clrtobot();
    printw("You have created a new hotel.\n");
    printw("Available hotels:\n");
    for(i=1;i<=numhotels;i++)
      if (hotels[i].size == 0)
        printw("%c ",hotels[i].name[0]);
    printw("\nSelect a hotel: ");
    refresh();
nextinput:
    ans = getch();
    if (islower(ans)) ans = toupper(ans);
    if (ans == REFRESHKEY) {
      wrefresh(curscr);
      goto nextinput;
    }
    if (ans == QUITKEY) {
      quit();
    };
    if (ans == HELPKEY) {
        newhotel_help();
        goto topofselect;
    };
    clrtobot();
    i = (ans - 'A' + 1);
    if (i < 1 || i > numhotels || hotels[i].size != 0) {
#ifdef UNIX
       printw("\n");
#endif UNIX       
       printw("That is not a legal selection.\n");
       refresh();
       goto topofselect;
    };
  } while (0);
  move((boardsize+10),0);
  clrtobot();
  refresh();
  return(i);
};

/*
 *  human_save is a routine for asking the player which of N
 *  equal size hotels they'd like to save.
 *
 */

int  human_save(p,max,adj)
     int p,adj[MAXHOTELS+1];
{
  int j,i;
  char ans;

  print_board(p);
  printw("Save which hotel: ");
  for(j=1;j<=MAXHOTELS;j++)
    if (adj[j] == max) printw(" %c",hotels[j].name[0]);
  printw("?");
  refresh();
  i = 0;
  do {
    ans = getch();
    if (islower(ans)) ans = toupper(ans);
    if (ans == REFRESHKEY) {
      wrefresh(curscr);
      continue;
    }
    if (ans == QUITKEY) {
      quit();
    };
    if (ans == HELPKEY) {
        save_help();
	continue;
    };
    clrtobot();
    i = (ans - 'A' + 1);
  } while (i < 1 || i > numhotels || adj[i] != max);
  printw("\n");
  move((boardsize+10),0);
  clrtobot();
  refresh();
  return(i);

};

/*
 *  getnum does the input processing to get a number in the
 *  range [low,high] inclusive.
 *
 *  Should put hooks in here for clear and help, etc.
 */

getnum(low,high)
     int low,high;
{
  char ch;
  int ans,y,x;

  ans = low - 1;
  do {
    ch = getch();
    if (islower(ch)) ch = toupper(ch);
    if (ch == REFRESHKEY) {
      wrefresh(curscr);
      continue;
    };
    if (ch == HELPKEY) {
        getnum_help();
	continue;
    };
    if (ch == QUITKEY) {
      quit();
    };
    clrtobot();
    ans = ch - '0';
  } while (ans < low || ans > high);
  printw("%d\n",ans);
  return(ans);
};
