/*
 * This program (called "Hotel") is copyright 1989 to Scott R. Turner,
 * in both source code and executable form.  Permission is given to 
 * copy both the source code and the executable under the following
 * conditions:
 * 
 * COPYING POLICIES
 * 
 *   1. You may copy and distribute verbatim copies of Hotel code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each file a valid copyright notice such as
 * "Copyright (C) 1989 Scott R. Turner", and keep intact the copyright
 * and license notices on all files.  You may charge a distribution fee for the
 * physical act of transferring a copy, but that fee may not exceed
 * your actual costs in creating and delivering the copy.
 * 
 *   2. You may modify your copy or copies of Hotel or any portion of it,
 * and copy and distribute such modifications under the terms of
 * Paragraph 1 above, provided that you also do the following:
 * 
 *     a) cause the modified files to carry prominent notices stating
 *     who last changed such files and the date of any change; and
 * 
 *     b) cause the whole of any work that you distribute or publish,
 *     that in whole or in part contains or is a derivative of Hotel
 *     or any part thereof, to be licensed at no charge to all third
 *     parties on terms identical to those contained in this License
 *     Agreement (except that you may choose to grant more extensive
 *     warranty protection to third parties, at your option).
 *
 *   3. You may not copy, sublicense, distribute or transfer Hotel
 * except as expressly provided under this License Agreement.  Any attempt
 * otherwise to copy, sublicense, distribute or transfer Hotel is void and
 * your rights to use Hotel under this License agreement shall be
 * automatically terminated.  However, parties who have received computer
 * software programs from you with this License Agreement will not have
 * their licenses terminated so long as such parties remain in full compliance.
 * 
 *   4.  Under no circumstances may you charge for copies of Hotel, for copies
 * of any program containing code from Hotel in whole or in part, or for 
 * any software package or collection of programs or code that contains Hotel
 * in whole or part.
 *
 */ 
/*
 *  help.c
 *  Scott R. Turner
 *  2/1/89
 * 
 *  This file contains the help screen.
 *
 */
#include "defs.h"
extern void any_key();

void help()
{
    char ch;	
clear();
printw("                   About Hotel\n\n");
printw("Hotel is game of building and controlling hotel chains.  It is played\n");
printw("on a %d by %d board.  Each player takes turns placing tiles on the\n", boardsize, boardsize);
printw("board.  When two tiles are adjacent, a new hotel is created, and the creator\n");
printw("is given one share of stock in the new hotel.  The hotels are numbered\n");
printw("A, B, C and so on.  There can be a maximum of %d hotels.\n",numhotels);
printw("\nThe Screen\n\n");
printw("The left portion of the screen will display the board.  Hotel chains will\n");
printw("be shown by the appropriate capital letter.  Played tiles which are not a\n");
printw("part of any hotel chain are shown as boxes.  Tiles which you can play are\n");
printw("number from 1 to %d.\n\n",numtiles);
printw("The right side of the screen shows the status of all the hotels and how much\n");
printw("money you currently have.  For each hotel, one line shows the cost of a share\n");
printw("in that hotel, how many shares you currently hold, and how many shares are\n");
printw("still available.\n\n");
printw("---Hit any key to continue---");
refresh();
ch = getch();
clear();
printw("\nThe Play\n\n");
printw("You can play a tile by simply typing the number of the tile you wish to play.\n");
printw("If your play creates a new hotel, you will be asked to choose which hotel\n");
printw("you'd like to create.  If no hotels are available, you are not allowed to make\n");
printw("a play which would create a new hotel.\n\n");
printw("If your play makes two hotels touch each other, the smaller hotel is merged\n");
printw("into the larger hotel.  If both are the same size, you are given your choice\n");
printw("which to merge.  When a hotel is merged, everyone who owns stock in the merged\n");
printw("hotel is given a chance to trade in or sell their stock.  In addition, the two\n");
printw("players who own the most stock in the merged hotel are paid bonuses.  This\n");
printw("is the only source of income in the game.\n\n");
printw("When a hotel reaches a size of 10, it is said to be `safe' and cannot be\n");
printw("merged into another hotel.\n\n");
printw("The game ends when all the hotels are safe or when one hotel covers almost\n");
printw("half the board.\n\n");
printw("---Hit any key to continue---");
refresh();
ch = getch();
clear();
printw("\nStock\n\n");
printw("Each turn, you may purchase up to three shares of stock.  To purchase a share,\n");
printw("type the letter corresponding to the hotel.  If you do not have enough money\n");
printw("for the purchase, or if the hotel's stock is not currently available, the game\n");
printw("will beep and reject your purchase.\n\n");
printw("To purchase less than three shares, type a carriage return to end your\n");
printw("purchasing.\n\n");
printw("As a hotel grows in size, its stock becomes more expensive, so\n");
printw("it is a good idea to enlarge the hotels you own stock in.\n\n");
printw("---Hit any key to continue---");
refresh();
ch = getch();
clear();
printw("\nGeneral\n\n");
printw("Most of the time, the 'q' key will quit the game and ^L will refresh\n");
printw("the screen.  'h' will usually give some help.\n");
printw("\nCredits\n\n");
printw("Hotel was written by Scott R. Turner (srt@cs.ucla.edu).  Special thanks\n");
printw("must go to Matthew Merzbacher (matthew@cs.ucla.edu) for help in debugging\n");
printw("and testing the various versions, and for helping me win the 1989 ACM\n");
printw("Scholastic Programming Championship.\n\n");
printw("---Hit any key to continue---");
refresh();
ch = getch();
clear();
};

void anykey_help()
{
    int y,x;
    getyx(curscr,y,x);
    move((LINES-2),0);
    clrtobot();
    printw("Hit any key to continue on with the program.  You may hit\n");
    printw("`Q' to quit the program, or `^L' to refresh the screen.");
    move(y,x);
    refresh();
};

void getnum_help()
{
    int y,x;
    getyx(curscr,y,x);
    move((LINES-2),0);
    clrtobot();
    printw("You should enter a number indicating the tile you wish to play.\n");
    printw("You may also enter `Q' to quit or `^L' to refresh the screen.\n");
    move(y,x);
    refresh();
};

void buy_help()
{
    int y,x;
    getyx(curscr,y,x);
    move((LINES-5),0);
    clrtobot();
    printw("Type the letter for the hotel for each stock you wish to buy, up\n");
    printw("to a maximum of three.  For instance, typing `abb' would buy two shares\n");
    printw("of Hotel B and one share of A.  To buy less than three shares, hit a\n");
    printw("carriage return to end.  The computer will beep if you do not have the\n");
    printw("money to make a purchase or if there is no stock available.");
    move(y,x);
    refresh();
};

void newhotel_help()
{
    int y,x;
    getyx(curscr,y,x);
    move((LINES-3),0);
    clrtobot();
    printw("You are being asked to select a hotel to create.  Type the letter of one\n");
    printw("of the available hotels.  You may also type `Q' to quit and `^L' to\n");
    printw("refresh the screen.");
    move(y,x);
    refresh();
};
    
void save_help()
{
    int y,x;
    getyx(curscr,y,x);
    move((LINES-4),0);
    clrtobot();
    printw("You are being asked which of two or more hotels to save.  All the hotels\n");
    printw("are the same size, and all of them will be liquidated EXCEPT the one you\n");
    printw("choose to save.  Type the letter of the hotel to save, or `Q' to quit or\n");
    printw("type `^L' to refresh the screen.");
    move(y,x);
    refresh();
};

