/*
 * This program (called "Hotel") is copyright 1989 to Scott R. Turner,
 * in both source code and executable form.  Permission is given to 
 * copy both the source code and the executable under the following
 * conditions:
 * 
 * COPYING POLICIES
 * 
 *   1. You may copy and distribute verbatim copies of Hotel code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each file a valid copyright notice such as
 * "Copyright (C) 1986 Scott R. Turner", and keep intact the copyright
 * and license notices on all files.  You may charge a distribution fee for the
 * physical act of transferring a copy, but that fee may not exceed
 * your actual costs in creating and delivering the copy.
 * 
 *   2. You may modify your copy or copies of Hotel or any portion of it,
 * and copy and distribute such modifications under the terms of
 * Paragraph 1 above, provided that you also do the following:
 * 
 *     a) cause the modified files to carry prominent notices stating
 *     who last changed such files and the date of any change; and
 * 
 *     b) cause the whole of any work that you distribute or publish,
 *     that in whole or in part contains or is a derivative of Hotel
 *     or any part thereof, to be licensed at no charge to all third
 *     parties on terms identical to those contained in this License
 *     Agreement (except that you may choose to grant more extensive
 *     warranty protection to third parties, at your option).
 *
 *   3. You may not copy, sublicense, distribute or transfer Hotel
 * except as expressly provided under this License Agreement.  Any attempt
 * otherwise to copy, sublicense, distribute or transfer Hotel is void and
 * your rights to use Hotel under this License agreement shall be
 * automatically terminated.  However, parties who have received computer
 * software programs from you with this License Agreement will not have
 * their licenses terminated so long as such parties remain in full compliance.
 * 
 *   4.  Under no circumstances may you charge for copies of Hotel, for copies
 * of any program containing code from Hotel in whole or in part, or for 
 * any software package or collection of programs or code that contains Hotel
 * in whole or part.
 *
 */ 
/*
    defs.h
    Scott R. Turner
    9/7/88

    This file contains the data structure and constant 
    definitions for Hotel.

*/
#include <stdio.h>
#include <curses.h>
#include <ctype.h>

/*  Constants */

#define MAXHOTELS 12
#define MAXPLAYERS 7
#define MAXBOARD 20
#define MAXSTRATEGIES 20
#define MAXSHARES 50
#define TURNLIMIT 100
#define UNUSED 99           /* Placed but unused tiles. */
#define UNPLAYABLE -100     /* Tiles which aren't playable because they would
			     * merge two safe hotel chains.
			     */

/* Interaction Defines */

#define REFRESHKEY 12
#define QUITKEY 'Q'
#define HELPKEY 'H'

/* Functions */

#define round(x) (int) (x + .5)

/*  Hotel Definition */

typedef struct hotelstruct {
  int size;      /* # of squares occupied */
  int shares;    /* # of outstanding shares */
  int class;     /* price class */
  char name[80]; /* name of hotel */
} hotel;

/*  Player Definition */

typedef struct playerstruct {
  long cash;                /* Cash on hand for this player */
  int strategy;             /* Strategy, 0  Human Player */
  char name[80];            /* Name of player */
  int shares[MAXHOTELS];    /* # shares in each hotel */
} player;

extern hotel hotels[MAXHOTELS+1];
extern player players[MAXPLAYERS+1];
extern int board[MAXBOARD+1][MAXBOARD+1]; 
extern int numplayers, numhotels, boardsize,
  numshares, numtiles, startcash,pnum;  
extern int turn, maxbuy;
extern WINDOW *iowin;
extern int debug;  /* Debug flag */
extern int human_player;
