/*
 * This program (called "Hotel") is copyright 1989 to Scott R. Turner,
 * in both source code and executable form.  Permission is given to 
 * copy both the source code and the executable under the following
 * conditions:
 * 
 * COPYING POLICIES
 * 
 *   1. You may copy and distribute verbatim copies of Hotel code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each file a valid copyright notice such as
 * "Copyright (C) 1989 Scott R. Turner", and keep intact the copyright
 * and license notices on all files.  You may charge a distribution fee for the
 * physical act of transferring a copy, but that fee may not exceed
 * your actual costs in creating and delivering the copy.
 * 
 *   2. You may modify your copy or copies of Hotel or any portion of it,
 * and copy and distribute such modifications under the terms of
 * Paragraph 1 above, provided that you also do the following:
 * 
 *     a) cause the modified files to carry prominent notices stating
 *     who last changed such files and the date of any change; and
 * 
 *     b) cause the whole of any work that you distribute or publish,
 *     that in whole or in part contains or is a derivative of Hotel
 *     or any part thereof, to be licensed at no charge to all third
 *     parties on terms identical to those contained in this License
 *     Agreement (except that you may choose to grant more extensive
 *     warranty protection to third parties, at your option).
 *
 *   3. You may not copy, sublicense, distribute or transfer Hotel
 * except as expressly provided under this License Agreement.  Any attempt
 * otherwise to copy, sublicense, distribute or transfer Hotel is void and
 * your rights to use Hotel under this License agreement shall be
 * automatically terminated.  However, parties who have received computer
 * software programs from you with this License Agreement will not have
 * their licenses terminated so long as such parties remain in full compliance.
 * 
 *   4.  Under no circumstances may you charge for copies of Hotel, for copies
 * of any program containing code from Hotel in whole or in part, or for 
 * any software package or collection of programs or code that contains Hotel
 * in whole or part.
 *
 */ 
/*
 *  COSTS
 *  Scott R. Turner
 *  9/10/88
 *
 *  Costs contains the functions to compute the cost of a share of stock in
 *  a hotel and the function to figure the majority holders bonus.
 *
 */

#include "defs.h"

/*
 *  Share_cost returns the cost per share of a hotel.
 *
 */

static int cost_table[42] = { 0, 0,
 /*  2    3    4    5    6    7    8    9   10   */
    200, 300, 400, 500, 600, 600, 600, 600, 600,
 /* 11   12   13   14   15   16   17   18   19   20  */
    700, 700, 700, 700, 700, 700, 700, 700, 700, 700,
 /* 21   22   23   24   25   26   27   28   29  30  */
    800, 800, 800, 800, 800, 800, 800, 800, 800, 800,
 /* 31   32   33   34   35   36   37   38   39   40   41+ */
    900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 1000};

share_cost(hot)
     int hot;
{

  if (hotels[hot].size < 2) {
    return(cost_table[2]+(100*hotels[hot].class));
  } else if (hotels[hot].size > 40) {
    return(cost_table[41]+(100 * hotels[hot].class));
  } else return(cost_table[hotels[hot].size]+(100*hotels[hot].class));
  
};

/*
 *  majority_bonus returns the first & second major holders bonuses.
 *
 */

majority_bonus (hot, first, second)
     int hot, *first, *second;
{
  int cost;

  cost = share_cost(hot);
  *first = 10*cost;
  *second = 5*cost;

};
