#include "as.h"
#include "md.h"
#include "aout.h"
#include "struc-symbol.h"
#include "write.h"
#include "append.h"

/* Relocation. */

/*
 * In: length of relocation (or of address) in chars: 1, 2 or 4.
 * Out: GNU LD relocation length code: 0, 1, or 2.
 */

static unsigned char

nbytes_r_length [] = {
  42, 0, 1, 42, 2
  };


/* The sparc needs its own emit_relocations() */
#if !defined(SPARC) && !defined(I860)
/*
 *		emit_relocations()
 *
 * Crawl along a fixS chain. Emit the segment's relocations.
 */
void
emit_relocations (fixP, segment_address_in_file)
     register fixS *	fixP;	/* Fixup chain for this segment. */
     relax_addressT	segment_address_in_file;
{
  struct relocation_info	ri;
  register symbolS *		symbolP;

	/* JF this is for paranoia */
  bzero((char *)&ri,sizeof(ri));
  for ( ;  fixP;  fixP = fixP -> fx_next)
    {
      if (symbolP = fixP -> fx_addsy)
	{

#ifdef NS32K
		/* These two 'cuz of NS32K */
	  ri . r_bsr		= fixP -> fx_bsr;
	  ri . r_disp		= fixP -> fx_im_disp;
#endif

	  ri . r_length		= nbytes_r_length [fixP -> fx_size];
	  ri . r_pcrel		= fixP -> fx_pcrel;
	  ri . r_address	= fixP -> fx_frag -> fr_address
	    +   fixP -> fx_where
	      - segment_address_in_file;
	  if ((symbolP -> sy_type & N_TYPE) == N_UNDF)
	    {
	      ri . r_extern	= 1;
	      ri . r_symbolnum	= symbolP -> sy_number;
	    }
	  else
	    {
	      ri . r_extern	= 0;
	      ri . r_symbolnum	= symbolP -> sy_type & N_TYPE;
	    }

	  /* 
	    The 68k machines assign bit-fields from higher bits to 
	    lower bits ("left-to-right") within the int.  VAXen assign 
	    bit-fields from lower bits to higher bits ("right-to-left").
	    Both handle multi-byte numbers in their usual fashion
	    (Big-endian and little-endian stuff).
	    Thus we need a machine dependent routine to make
	    sure the structure is written out correctly.  FUN!
	   */
	  md_ri_to_chars((char *) &ri, ri); 
	  append (&next_object_file_charP, (char *)& ri, (unsigned long)sizeof(ri));
	}
    }

}
#endif

/* Aout file generation & utilities */

/* Convert a lvalue to machine dependent data */
#define MD(v)	\
  md_number_to_chars((char *)&header->v,header->v, sizeof(header->v))

void a_header_append(header, where)
struct exec * header;
char** where;
{
    MD(a_text);
    MD(a_data);
    MD(a_bss);
    MD(a_trsize);
    MD(a_drsize);
    MD(a_syms);
    MD(a_info);
    MD(a_entry);
#ifdef EXEC_MACHINE_TYPE
    MD(a_machtype);
#endif /* EXEC_MACHINE_TYPE */
#ifdef EXEC_VERSION
    MD(a_version);
#endif /* EXEC_VERSION */
    append(where, (char *)header, sizeof(struct exec));
}

#undef MD
/* Convert a lvalue to machine dependent data */
#define MD(v)	\
  md_number_to_chars((char *)&symbolP->v,symbolP->v, sizeof(symbolP->v))

void a_symbol_append(symbolP, where)
symbolS *	symbolP;
char** 		where;
{
    MD(sy_strx);
    MD(sy_desc);
    MD(sy_value);
    append(where, (char *)&symbolP->sy_symbol, sizeof(symbol_type));
}

void emit_symbols(symbol_rootP, where)
symbolS *	symbol_rootP;
char**		where;
{
    symbolS *	symbolP;
    /*
     * Emit all symbols left in the symbol chain.
     */
    for(symbolP = symbol_rootP; symbolP; symbolP = symbolP -> sy_next) {
	/* Used to save the offset of the name. It is used to point
	   to the string in memory but must be a file offset. */
	register char *	temp;

	temp = S_GET_NAME(symbolP);
	S_SET_OFFSET(symbolP, symbolP->sy_name_offset);
	/* Any symbol still undefined and is not a dbg symbol is made N_EXT. */
	if (symbolP->sy_type == N_UNDF)
	    S_SET_EXTERNAL(symbolP);
	SYMBOL_OUTPUT(symbolP, where);
	S_SET_NAME(symbolP,temp);
    }
}
