
#include <stdio.h>

#ifdef SUN4
#include <sys/stdtypes.h>
#else   /* SUN4 */
# ifndef getc
#   define getc(p)         (--(p)->_cnt < 0 ? _filbuf(p) : (int) *(p)->_ptr++)
# endif
# ifndef putc
#   define putc(x, p)      (--(p)->_cnt < 0 ? _flsbuf((unsigned char) (x), (p)) : (int) (*(p)->_ptr++ = (unsigned char) (x)))
# endif
#ifndef BSD4_2
typedef unsigned short u_short;
#endif  /* BSD4_2 */
#endif  /* SUN4 */

#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

/* for MAXNAMLEN only !!! */
#ifdef unix
#ifndef BSD4_2
#include <dirent.h>
#else
#include <sys/dir.h>
#endif /* BSD4_2 */
#endif /* unix */

#if !defined(MAXNAMLEN)
#define MAXNAMLEN       255
#else
#if MAXNAMLEN < 255
#undef MAXNAMLEN
#define MAXNAMLEN       255
#endif
#endif

#ifdef DEBUG
#include <assert.h>
#endif  /* DEBUG */

#ifdef __TURBOC__
#define MSDOS
#include <io.h>
#include <alloc.h>
#endif  /* __TURBOC__ */

#ifdef MSDOS
#include <stdlib.h>
#include <fcntl.h>
#endif  /* MSDOS */

typedef unsigned char uchar;

#if defined(BITS) && BITS > 14
typedef unsigned long hash_t;
#else
typedef u_short hash_t;
#endif  /* BITS */

#ifdef  lint
#define N2              256
#else   /* lint */
#define N2              8192    /* buffer size */
#endif  /* lint */

#define F2              256     /* pre-sence buffer size */
#define THRESHOLD	2

#define N_CHAR2         (256 - THRESHOLD + F2 + 1) /* code: 0 .. N_CHARi - 1 */
#define T2              (N_CHAR2 * 2 - 1)       /* size of table */

#define ENDOF           256                     /* pseudo-literal */

extern uchar    Table2[];

extern long     in_count, bytes_out, file_length;

extern uchar    text_buf[];
extern u_short  match_position, match_length;

extern short    quiet, force;      /* useful flags */

/* Note ind_threshold is triangle number of Kbytes */

extern long indc_threshold, indc_count;

extern short    do_melt, topipe, greedy;

#define MAGIC1          ((uchar)'\037')
#define MAGIC2_1        ((uchar)'\236')          /* freeze vers. 1.X */
#define MAGIC2_2        ((uchar)'\237')

extern int exit_stat;

#ifdef DEBUG
extern short debug;
extern short verbose;
extern char * pr_char();
extern long symbols_out, refers_out;
#endif /* DEBUG */

#ifdef GATHER_STAT
extern long node_steps, node_matches;
#endif

extern short DecodeChar(), DecodePosition(), GetNBits();
#ifndef COHERENT
extern void melt2(), (*meltfunc)(), writeerr(), prratio(), prbits(), freeze();
#else
extern void melt2(), writeerr(), prratio(), prbits(), freeze();
extern int (*meltfunc)();
#endif

#if defined(BSD42) && !defined(BSD4_2)
#define BSD4_2
#endif

#ifdef COMPAT
#include "compat.h"
#endif

#define INDICATOR \
if (quiet < 0 && (in_count > indc_count)) {\
	if (ferror(stdout))\
		writeerr();\
	if (file_length) {\
		fprintf(stderr, " %2d%%\b\b\b\b",\
			ftell(stdin) * 100 / file_length);\
		indc_count += indc_threshold;\
	} else {\
		fprintf(stderr, " %5ldK\b\b\b\b\b\b\b", in_count / 1024);\
		indc_count += indc_threshold;\
		indc_threshold += 1024;\
	}\
	fflush (stderr);\
}

#ifdef BSD4_2
#define strchr index
#endif
