#include "freeze.h"
#include "bitio.h"

unsigned long getbuf = 0;       /* assume sizeof (unsigned long) >= 4 */
u_short putbuf;
uchar   bitlen = 0, __, crpt_flag = 0;

/* get N bits (N <= 16), returning in Bit(N-1)...Bit 0 */

short GetNBits (n)
	register u_short n;
{
	register unsigned long dx = getbuf;
	register uchar c;

	static u_short mask[17] = {
		0x0000,
		0x0001, 0x0003, 0x0007, 0x000f,
		0x001f, 0x003f, 0x007f, 0x00ff,
		0x01ff, 0x03ff, 0x07ff, 0x0fff,
		0x1fff, 0x3fff, 0x7fff, 0xffff };

	while (bitlen < n)
		{
			c = getchar ();
			dx |= (unsigned long) c << (BYSH - bitlen);
			bitlen += 8;
		}
	crpt_flag = feof(stdin);
	getbuf = dx << n;
	bitlen -= n;
	return (dx >> (bits(getbuf) - n)) & mask[n];
}

/* output `l' high bits of `c' */

void Putcode (l, c)
	register u_short l;
	u_short c;
{
	register u_short len = bitlen;
	register u_short b = (u_short)putbuf;
	b |= c >> len;
	if ((len += l) >= 8) {
		putchar ((int)(b >> 8));
		if ((len -= 8) >= 8) {
			putchar ((int)b);
			bytes_out += 2;
			len -= 8;
			b = c << (l - len);
		} else {
			b <<= 8;
			bytes_out++;
		}
	}
	if (ferror(stdout))
		writeerr();
	putbuf = b;
	bitlen = len;
}


/* Flushes the bit I/O buffers and check the state of stdout */

void EncodeEnd ()
{
	if (bitlen) {
		putchar((int)(putbuf >> 8));
		bytes_out++;
		if (ferror(stdout))
			writeerr();
	}
}

/* File too short or invalid header, print a message */

void crpt_message ( )
{
	fprintf ( stderr, "melt: corrupt input\n" );
}

