/* Fonteditor fuer den Citizen MSP 10   (c) DC 90 / Softdrink 
   Duale Version: MS-DOS 3.3 und Coherent 3.2 (c)92
   Dreifach-Version: MS-DOS 3.3 / Coherent 3.2 / Coherent 4.0 (c) DC93
*/
#define VERSION "V1.02"
		      /* Compile-Switches */

			  /* Includes */
#include <stdio.h>

#ifdef __MSDOS__
#include <conio.h>
#endif

#include <ctype.h>        /* fuer isdigit usw. */
#include <sys/stat.h>     /* fuer S_IFREG, S_IREAD, S_IWRITE */
#include <string.h>       /* fuer strcpy */

#ifdef __MSDOS__
#include <io.h>           /* fuer open usw. */
#include <fcntl.h>        /* fuer O_BINARY, O_WRONLY usw. */
#include <dos.h>          /* fuer hardresume */
#include <dir.h>          /* fuer findfirst, findnext usw. */
#else
#define O_BINARY  0       /* for compatibility only ... */
#define O_RDONLY  0
#define O_WRONLY  1
#define O_RDWRITE 2
#define STDPRN "/dev/rlp"
#include <sys/types.h>
#include <dirent.h>
#include <curses.h>

#define cprintf printw
#define printf  printw
#define cputs(s)   addstr(s)
#ifdef _I386
#define clrscr() erase()
#else
#define clrscr() clear()
#endif
#define gotoxy(a,b) move(b,a)
#define putch(c) addch(c)
#define window(a,b,c,d)
#define ungetch(x) ungetc(x,stdin)
#define highvideo()       /* verzichten wir drauf... */
#endif



#define ESC 27
#define ENTER 13
#define DEL 8
#define KEINE 0
#define ZEILEN 8
#define SPALTEN 11

#define tab 10                  /* Einrueckg. z. B. der Statuswerte */
#define statuszeile 19          /* Zeile, ab der Statuswerte ausgeg. wrd. */
#define tispalte 30             /* Titelzeile */
#define tizeile 3               /* Titelspalte */
#define taspalte 2              /* Menutafelspalte */
#define tazeile  5              /* Menutafelzeile */
#define enterzeile 16           /* hier steht der Cursor beim Auswaehlen */

             /* Grafikzeichen und Cursorbewegungen */
#ifdef __MSDOS__
#define CHRLO 218    /* links oben */
#define CHRRO 191    /* rechts oben */
#define CHRLU 192    /* links unten */
#define CHRRU 217    /* rechts unten */
#define CHRQU 196    /* Querstrich */
#define CHRSE 179    /* Senkrechte */
#define CHRKR 197    /* Kreuz */
#define CHRLA 195    /* linker Abschluss einer Linie, die den Rahmen trifft */
#define CHRRA 180    /* rechter */
#define CHROA 194    /* oberer */
#define CHRUA 193    /* unterer */
#define CHRQA 196    /* Querstrich, soweit im Rahmen */
#define CHRSA 179    /* Senkrechte, soweit im Rahmen */
#define PIXEL 254
#define CURL  'K'
#define CURR  'M'
#define CURUP 'H'
#define CURDN 'P'
#define PGUP  'I'
#define PGDN  'Q'
#else
#ifdef _I386         /* Coherent 4.0: wie MSDOS */
#define CHRLO 218    /* links oben */
#define CHRRO 191    /* rechts oben */
#define CHRLU 192    /* links unten */
#define CHRRU 217    /* rechts unten */
#define CHRQU 196    /* Querstrich */
#define CHRSE 179    /* Senkrechte */
#define CHRKR 197    /* Kreuz */
#define CHRLA 195    /* linker Abschluss einer Linie, die den Rahmen trifft */
#define CHRRA 180    /* rechter */
#define CHROA 194    /* oberer */
#define CHRUA 193    /* unterer */
#define CHRQA 196    /* Querstrich, soweit im Rahmen */
#define CHRSA 179    /* Senkrechte, soweit im Rahmen */
#define PIXEL 254
#else                /* Coherent 3.2: 7-Bit-Grafikzeichen */
#define CHRLO '#'
#define CHRRO '#'
#define CHRLU '#'
#define CHRRU '#'
#define CHRQU ' '
#define CHRSE ' '
#define CHRKR ' '
#define CHRLA '|'
#define CHRRA '|'
#define CHROA '-'
#define CHRUA '-'
#define CHRQA '-'
#define CHRSA '|'
#define PIXEL '*'
#endif
#define CURL  'h'
#define CURR  'l'
#define CURUP 'k'
#define CURDN 'j'
#define PGUP  '-'
#define PGDN  '+'
#endif

/* Die folgenden Abkuerzungen werden in convert benutzt */
#define ZEILE  (herczeichen[i].line[start+hercindex])
#define NZEILE (herczeichen[i].line[start+hercindex+1])

#ifndef __MSDOS__
FILE *stdprn;
WINDOW *stdschirm, *taschirm, *tischirm;
#endif
			  /* Globals */

char versionnr[]=VERSION,
     drucker[]  ="Citizen MSP-Serie",

				/* Ueberschriften (Titel) */

     hatitle[]  ="Font-Editor",
     latitle[]  ="Laden",
     edtitle[]  ="Zeichen-Editor",
     sititle[]  ="Sichern",
     satitle[]  ="Sichern als ...",
     intitle[]  ="Installieren",
     detitle[]  ="Deinstallieren",
     tetitle[]  ="Test",
     kotitle[]  ="Konvertieren",
     netitle[]  ="Neuer Font",
     fetitle[]  ="-Fehler-",
     ubtitle[]  ="Uebernehmen",
     uatitle[]  ="Uebern. als ...",
     betitle[]  ="Bearbeiten",
     entitle[]  ="Entfernen",
     letitle[]  ="Leeren",
     estitle[]  ="Verlassen",
     bltitle[]  ="Blaettern",

				/* Auswahlfenster (Tafeln) */

     starttbl[] ="(c) DC90-93\n\n\rDaniel Coenen\n\rSchwanenwall 3\n\r4600 Dortmund 1\n\n\rmail:\n\rumunk!taunus!coenen\n\n\rBitte Taste druecken",
     haupttbl[] ="[L]aden\n\r[E]ditor\n\rLoesche [Z]eichen\n\r[S]ichern\n\rSichern [a]ls ...\n\r[I]nstallieren\n\r[D]eeinstall.\n\r[T]est\n\r[K]onvertieren\n\r[N]euer Font\n\r<ESC>",
#ifdef __MSDOS__
     editrtbl[] ="\x18\x19\x1a\x1b\n\r\x11\xbc\n\rBild\x18 Bild\x19\n\r[P]ins\n\r[U]ebernehmen\n\rUebern. [a]ls ...\n\r[B]earbeiten\n\r[L]eeren\n\r<ESC>",
#else
     editrtbl[] ="h=links l=rechts\n\rk=hoch  j=runter \n\r<SPACE>/<ENTER>\n\r+/-=Blaettern\n\r[P]ins\n\r[U]ebernehmen\n\rUebern. [a]ls ...\n\r[B]earbeiten\n\r[Z]uruecksetzen\n\r<ESC>",
#endif
/*     nimpltbl[] ="Nicht implementiert.\n\n\rBitte Taste druecken", */
     zwarntbl[] ="Zeichen noch nicht\n\ruebernommen!\n\n\rTrotzdem? [j/n]",
/*     okay_tbl[] ="OK\n\n\rBitte Taste druecken", */
     verbttbl[] ="VERBOTEN!\n\n\rBitte Taste druecken",
     kenumtbl[] ="Zeichen hat keine\n\rNummer!\n\n\rBitte Taste druecken",
     zhlintbl[] ="Bitte Zahl eingeben!\n\r[0-255]",
     zhlintbl2[] ="Und die 2. Zahl!\n\r[0-255]",
/*     drucktbl[] ="Bitte Drucker\n\reinschalten und\n\rTaste druecken", */
     kenamtbl[] ="Font hat keinen\n\rNamen!\n\n\rBitte Taste druecken",
     strintbl[] ="Bitte Fontnamen\n\reingeben!",
     nopentbl[] ="Datei kann nicht\n\reroeffnet werden!\n\n\rBitte Taste druecken",
     nofnttbl[] ="Kein Druckerfont!\n\n\rBitte Taste druecken",
     fwarntbl[] ="Font nicht\n\rgesichert!\n\n\rTrotzdem? [j/n]",
     drkfetbl[] ="Drucker nicht\n\rbetriebsbereit!\n\n\rBitte Taste druecken",
     flpfetbl[] ="Bitte Diskette\n\reinlegen\n\rund Taste druecken!\n\n\r(<ESC> fuer\n\rProgramm-Abbruch)",
     hrcintbl[] ="Bitte Fontnamen\n\reines Hercules-\n\rRAM-Fonts eingeben!",
     nherctbl[] ="Kein Hercules-\n\rRAM-Font!\n\n\rBitte Taste druecken",
     momentbl[] ="Einen Augenblick\n\rbitte ...";

				/* Ein Zeichen besteht aus 11 Spalten zu
				   8 Zeilen. Die 8 Zeilen kann man mit den
				   Bits eines Bytes darstellen:
				   1=Pixel, 0=kein Pixel
				   Da fuer den Design-Regel-Algorithmus
				   jedes Pixel einen linken und rechten
				   Nachbarn haben muss, wird bei dem aktuell
				   editierten Zeichen ein Feld mit den
				   Indices 0..12 deklariert, von dem
				   aber nur 1..11 benutzbar sind.
				*/
				/* Beschreibung des aktuellen Fonts */
struct
{
  char used;                    /* Zeichen definiert? */
  char att;                     /* obere/untere 8 Nadeln */
  unsigned char dat[11];        /* 11 Spalten a 8 Zeilen */
} zeichen[256];

char fontname[15];

				/* Beschreibung des aktuellen Zeichens */
unsigned char col[13];
unsigned char znr,              /* Zeichennummer */
	      attribut=0;       /* obere/untere 8 Nadeln */

char nofontname=1,              /* Font hat keinen Namen */
     nocharname=1,              /* Zeichen hat keinen Namen */
     fontunsaved=0,             /* Font muss nicht gesich. werden */
     charunsaved=0;             /* Zeichen muss nicht gesich. werd. */

int iko=1,jko=0;
enum {FLOPPY,DRUCKER} device;   /* gibt an, welche Hardware genutzt wird */
int d_errno;                    /* -1 fuer Fehler beim Drucken */


#ifndef __MSDOS__

int filelength(desc)
int desc;
{
  struct stat zustand;
  fstat(desc,&zustand);
  return zustand.st_size;
}

#endif

void drawline(links,rechts,mitte1,mitte2)
int links,rechts,mitte1,mitte2;
{
  int j;
  putch(links);
  for(j=0;j<SPALTEN;j++)
  {
    if (mitte1!=0)
      putch(mitte1);
    else
    {
      if (j<10) putch (j+48);  /* 0 - 9 */
      else putch(j+55);        /* ab 10: 'A', 'B' usw. */
    }
    if (j<SPALTEN-1)
      putch(mitte2);
    else                       /* j=SPALTEN - 1 -> rechter Rand */
      putch(rechts);
  }
}

void menu()                     /* Zeichnet feste Maskenteile (Gitter...) */
{
  int i;
  clrscr();
  gotoxy(2*tab,1);
  printf("Zeichensatzeditor %s  %s\n",drucker,versionnr);
  gotoxy(25,5);
  drawline(CHRLO,CHRRO,CHRQA,CHROA);
  for (i=0;i<ZEILEN;i++)
  {
    gotoxy(25,6+2*i);
    drawline(CHRSA,CHRSA,' ',CHRSE);
    printf(" %d",ZEILEN-1-i);
    gotoxy(25,7+2*i);
    if (i<ZEILEN-1)
      drawline(CHRLA,CHRRA,CHRQU,CHRKR);
    else
      drawline(CHRLU,CHRRU,CHRQA,CHRUA);
  }
  gotoxy(25,6+2*ZEILEN);
  drawline(' ',' ',0,' ');  /* 0 bewirkt Ausgabe der Spaltennummer */
#ifdef _DCDEBUG_
  gotoxy(1,1);
  printf("NoFontName");
  gotoxy(1,2);
  printf("NoCharName");
  gotoxy(1,3);
  printf("Fontunsaved");
  gotoxy(1,4);
  printf("Charunsaved");
#endif

  gotoxy(1,statuszeile);
  printf("Font:");
  gotoxy(1,statuszeile+1);
  printf("Zeichen:");
  gotoxy(1,statuszeile+2);
  printf("belegt:");
  gotoxy(1,statuszeile+3);
  printf("Pins:");
#ifndef __MSDOS__
  refresh();
#endif
}

void title(zeile)                       /* schreibt eine Titelzeile */
char *zeile;
{
  static char *oldzeile=NULL;           /* Merkt sich letzte Zeile */
  if (zeile==oldzeile) return;          /* Wiederhole nichts */
  oldzeile=zeile;                       /* Naechstes Mal dies d. oldzeile */
#ifdef __MSDOS__
  window(tispalte,tizeile,tispalte+20,tizeile);
#else
  stdscr=tischirm;
#endif
  clrscr();
  cputs(zeile);
#ifdef __MSDOS__
  window(1,1,80,25);
#else
  refresh();
  stdscr=stdschirm;
#endif
}

void table(text)                        /* schreibt Auswahl-/Fehlertafel */
char *text;
{
  static char *oldtext=NULL;            /* Merkt sich letzten Text */
  if (text==oldtext) return;            /* Wiederhole nichts */
  oldtext=text;                         /* Naechstes Mal dies d. oldtext */
#ifdef __MSDOS__
  window(taspalte,tazeile,taspalte+20,tazeile+10);
#else
  stdscr=taschirm;
#endif
  clrscr();
  cputs(text);
#ifdef __MSDOS__
  window(1,1,80,25);
#else
  refresh();
  stdscr=stdschirm;
#endif
}

void paint()                          /* zeichnet aktuell edit. Zeichen */
{
  int i,j;
  char maske;
  for (i=1;i<12;i++)
    for (j=0;j<8;j++)
    {
      gotoxy(24+2*i,20-2*j);
      maske=1<<j;
      if (col[i]&maske) putch(PIXEL);
      else putch(' ');
    }
#ifndef __MSDOS__
  refresh();
#endif
}

void printstat()                        /* schreibt akt. Namen, Nr., Pins */
{

#ifdef _DCDEBUG_
  gotoxy(tab+4,1);printf("%d",nofontname);
  gotoxy(tab+4,2);printf("%d",nocharname);
  gotoxy(tab+4,3);printf("%d",fontunsaved);
  gotoxy(tab+4,4);printf("%d",charunsaved);
#endif

  gotoxy(tab,statuszeile);
  if (nofontname) cprintf("<keiner>      ");
  else cprintf("%-12s",fontname);
  gotoxy(tab,statuszeile+1);
  if (nocharname) cprintf("<keins>");
  else cprintf("%-7d",znr);
  gotoxy(tab,statuszeile+2);
  if (nocharname) cprintf("<ungewiss>");
  else if(zeichen[znr].used) cprintf("ja        ");
       else cprintf("nein      ");
  gotoxy(tab,statuszeile+3);
  if (attribut) cprintf("obere 8 ");
  else cprintf("untere 8");
#ifndef __MSDOS__
  refresh();
#endif
}

	       /* Lesefunktionen fuer BS, Zahl und Dateinamen */

int liescode(above,choice,x,y)
char above[];
char choice[];
int x;
int y;
{
  title(above);
  table(choice);
  gotoxy(x,y);
#ifndef __MSDOS__
  refresh();                            /* damit man d. Cursor sieht */
#endif
  return(getch());
}

int liesbs(above,choice,x,y)
char above[];
char choice[];
int x;
int y;
{
  int c;
  title(above);
  table(choice);
  gotoxy(x,y);
  while((c=getch())==0) getch(); /* Sondertasten ueberlesen */
  if(c==ESC) return('n');
  if(c==ENTER) return('j');
  return(c);
}

int liesnummer(above,choice,x,y)
char above[];
char choice[];
int x;
int y;
{
  int zahl,              /* Zahl, soweit eingegeben */
      c;                 /* ASCII-Wert der neuen Ziffer */
  title(above);
  table(choice);

  /* eine absturzfreie, gepufferte Eingabe aus dem Hause softdrink */
  /* Die conio-Lesefunktionen sind entweder:
     ungepuffert, nicht fensterorientiert (cscanf)  oder
     gepuffert, aber nicht ESC-fest und nicht fensterorientiert (cgets)
  */
#ifdef __MSDOS__
  window(x,y,x+10,y);
#else
  stdscr=newwin(1,11,y,x);
  touchwin(stdscr);
#endif
  clrscr();
  zahl=0;
  while(1)
  {
#ifndef __MSDOS__
    refresh();
#endif
    c=getch();
    if(isdigit(c))
    {
      putch(c);
      zahl=10*zahl+c-48;  /* ASCII-Code-maessig abziehen */
      if (zahl>255) ungetch(DEL); /* automatisches DELETE */
      continue;
    }
    if(c==ENTER)break;
    switch(c)
    {
      case ESC:
	zahl=0;
	clrscr();
	break;
      case DEL:
	zahl=zahl/10;     /* letzte Ziffer "loeschen" */
	clrscr();
	if(zahl>0) cprintf("%d",zahl);
	break;
      default: putchar(7); /* nicht putch, sonst Curses-Chaos */
    }
  }
#ifdef __MSDOS__
  window(1,1,80,25);
#else
  delwin(stdscr);
  stdscr=stdschirm;
  touchwin(stdscr);
#endif

  return(zahl);
}

int liesnamen(above,choice,x,y,buffer)
char above[];
char choice[];
int x;
int y;
char buffer[];
{
  char minibuffer[20];       /* Zwischenpuffer */
  int rawc,             /* Zeichen der Eingabe */
      c,          /* Zeichen im Zwischenpuffer */
      i,            /* Index im Zwischenpuffer */
      len=0;         /* Gesamtlaenge d. Namens */
#ifdef __MSDOS__
  struct ffblk fileblock; /* nimmt findfirst- u. findnext-Info auf */
#else
#ifdef _I386
  DIR *directory;         /* Directory-Deskriptor */
  struct dirent *entry;   /* zeigt auf Directory-Eintrag */
#else
  int dirdesc;            /* Deskriptor fuer aktuelles Directory */ 
  struct dirent entry;    /* nimmt Directory-Eintrag auf */
  int valid;
#endif
#endif

					/* Die Position des '.' wird
					   notiert.
					   0 bedeutet: nicht enthalten
					*/
  char dirstate=0;    /* Directory neu scannen */
  char punktset=0;    /* Noch kein Pt. im Namen */
  title(above);
  table(choice);
#ifdef __MSDOS__
  window(x,y,x+13,y);
#else
  stdscr=newwin(1,14,y,x);
  touchwin(stdscr);
#endif
  clrscr();
  buffer[0]='\0';                       /* Leerstring */
  while(1)
  {
#ifndef __MSDOS__
    refresh();
#endif
    rawc=getch();
    if ( rawc == ENTER ) break;
/* Unter MSDOS wird nun geprueft, ob 0 gefolgt von CURDN eingelesen
   wurde (2 Klammerebenen), unter COHERENT nur, ob PGDN gedrueckt wurde */
#ifdef __MSDOS__
    if ( rawc == 0 )
    {
      if ( getch() == CURDN )           /* Cursor abwaerts? */
      {
#else
    if (rawc == PGDN)
    {
#endif
        sprintf( minibuffer, "%c", ESC ); /* ESC-Taste simulieren */
        if ( dirstate == 0 )            /* Dir neu scannen */
        {

#ifdef __MSDOS__
          findfirst("*.*", &fileblock, 0 );
          strcat( minibuffer, fileblock.ff_name );
#else
#ifdef _I386
          directory=opendir(".");
          entry=readdir(directory);     /* . weglassen */
          entry=readdir(directory);     /* .. weglassen */
          entry=readdir(directory);
          strcat( minibuffer, entry->d_name);
#else
          dirdesc=open(".",0);
          
                                        /* . und .. weglesen */
          read(dirdesc,&entry,sizeof(struct dirent));
          read(dirdesc,&entry,sizeof(struct dirent));
          read(dirdesc,&entry,sizeof(struct dirent));
          strcat( minibuffer, entry.d_name );
#endif
#endif

          dirstate = 1;
        }
        else
        {
#ifdef __MSDOS__
          if ( findnext( &fileblock ) == 0 )
            strcat( minibuffer, fileblock.ff_name );
#else           
#ifdef _I386
          if ( (entry=readdir(directory)) != NULL)
            strcat( minibuffer, entry->d_name );
#else
          /* alte Eintraege (inode 0) ueberlesen */
          while((valid=read(dirdesc,&entry,sizeof(struct dirent))) > 0
            && entry.d_ino == 0);
          if ( valid > 0 )
            strcat( minibuffer, entry.d_name );
#endif
#endif
          else
          {
            dirstate = 0;
#ifndef __MSDOS__
#ifdef _I386
            closedir(directory);
#else
            close(dirdesc);
#endif
#endif
          }
        }
#ifdef __MSDOS__
/* hier wird die 2. MSDOS-Klammerebene geschlossen */
      }
      else continue;     /* nix ins Puffer, also nix zum Auslesen */
      /* else putch(7);  bewirkt Piepen bei falscher Mausbewegung */
#endif
    }
    else sprintf(minibuffer,"%c",rawc); /* mit \0 dran ins Puffer */
    i=0;
    while ( ( c = minibuffer[i++]) != '\0' )
    {
      if(isalnum(c) || c=='.' || c=='_')
      {
			  		/* Pruefe, ob
				  	   - Punkt zu weit hinten
					     - zweiter Punkt
  					*/
        if (c=='.' && (len>8 || punktset))
        {
        	putchar(7); /* nicht putch, sonst Curses-Chaos */
        	continue;
        }
        putch(c);
        buffer[len]=c;
        buffer[len+1]='\0';
        len++;
        if (c=='.') punktset=len;         /* String enthaelt nun 1 Punkt */
        if((len>8 && !punktset) || (punktset && (len-punktset>3)))
       	ungetch(DEL);                   /* automatisches DELETE */
        continue;
      }
      switch(c)
      {
        case ESC:
      	  len=0;
      	  punktset=0;
      	  buffer[0]='\0';
      	  clrscr();
      	  break;
        case DEL:
      	  if(len>0)
      	  {
            len--;
      	    if(buffer[len]=='.') punktset=0;
  	        buffer[len]='\0';
      	    clrscr();
  	        cputs(buffer);
      	  }
        	break;
        default:putchar(7); /* nicht putch, sonst Curses-Chaos */
      }
    }
  }
#ifdef __MSDOS__
  window(1,1,80,25);
#else
  delwin(stdscr);
  stdscr=stdschirm;
  touchwin(stdscr);
#endif
  return 0;
}

#ifdef __MSDOS__
int geraetefehler()                     /* Hardware-Error-Handler */
{
  int eingabe;
  if(device==DRUCKER)
  {
    d_errno=-1;                         /* globale Druckerfehlervariable */
    liesbs(fetitle,drkfetbl,taspalte,enterzeile);
    hardresume(0);                      /* Druckerfehler behandelt */
  }
  else                                  /* Floppy-Fehler */
  {
    eingabe=liesbs(fetitle,flpfetbl,taspalte,enterzeile);
    if(eingabe=='n')                    /* ESC in der Praxis */
    {
      gotoxy(1,24);
      hardresume(2);                    /* Programm abbrechen */
    }
    else
      hardresume(1);                    /* nochmal wiederholen */
  }
  return 0;                             /* nur pro forma */
}
#endif

void copytofont()
{
  int i;
  for (i=1;i<12;i++)
   zeichen[znr].dat[i-1]=col[i];
  zeichen[znr].att=attribut;
  zeichen[znr].used=1;
}

void copyfromfont()
{
  int i;
  if (zeichen[znr].used)
  {
    for(i=1;i<12;i++)
      col[i]=zeichen[znr].dat[i-1];
    attribut=zeichen[znr].att;
  }
  else                                  /* ungenutzt: piepen */
  {
    putchar(7);
    for(i=1;i<12;i++)
      col[i]=0;
    attribut=0;
  }
}

void load()
{
  int desc;
  char oldnofontname,oldfontname[15];

  device=FLOPPY;
  oldnofontname=nofontname;             /* Namensflag sichern */
  strcpy(oldfontname,fontname);         /* Namen sichern */
  if(fontunsaved)
    if(liesbs(latitle,fwarntbl,taspalte,enterzeile)=='n') return;
  fontunsaved=0;
  liesnamen(latitle,strintbl,tab,statuszeile,fontname);
  nofontname=0;
  desc=open(fontname,O_BINARY|O_RDONLY);
  if(desc==-1)
  {
    liesbs(fetitle,nopentbl,taspalte,enterzeile);
    nofontname=oldnofontname;
    strcpy(fontname,oldfontname);
    printstat();
    return;
  }
  if(filelength(desc)!=sizeof(zeichen)) /* 3328 Bytes */
  {
    liesbs(fetitle,nofnttbl,taspalte,enterzeile);
    close(desc);
    nofontname=oldnofontname;
    strcpy(fontname,oldfontname);
    printstat();
    return;
  }
  title(latitle);
  table(momentbl);
  read(desc,zeichen,sizeof(zeichen));
  close(desc);
  printstat();       /* sonst Aerger mit Curses ... */
}

void invert()
{
  char inv,maske=1;
  maske <<= jko;
  inv=col[iko]^maske;
					/* Beispiel       jko=3:
					   col[iko+1]     00001001
					   col[iko]       01010101
					   col[iko-1]     00110000
					   (nach links umgekippt)

					   maske          00001000
					   col[iko]^maske 01011101
					*/
  /* Regel: keine nebeneinanderliegenden Pixel erlaubt! */
  if ((col[iko-1]&maske | col[iko+1]&maske)&inv)
    liesbs(fetitle,verbttbl,taspalte,enterzeile);
  else col[iko]=inv;
  if (col[iko] & maske) putch(PIXEL);
  else putch(' ');
}

void edit()
{
  int funktion,i;
  do
  {
    funktion=liescode(edtitle,editrtbl,24+2*iko,20-2*jko);
    switch(funktion)
    {
      /* ENTER (Pixel setzen/loeschen) */
      case ' ':
      case 0x0d:invert();charunsaved=1;
            		printstat();break;
      /* Cursor links */
      case CURL: if (iko>1) iko--;
            		break;
      /* Cursor rechts */
      case CURR: if (iko<11) iko++;
            		break;
      /* Cursor aufwaerts */
      case CURUP: if (jko<7) jko++;
            		break;
      /* Cursor abwaerts */
      case CURDN: if (jko>0) jko--;
              	break;
      /* Pins oben/unten */
      case 'p': attribut=128-attribut;
		charunsaved=1;fontunsaved=1;printstat();break;
      /* Bild auf: zurueckblaettern */
      case PGUP: if (charunsaved)
		{
		  if(liesbs(bltitle,zwarntbl,taspalte,enterzeile)=='n')
		    break;
		}
		charunsaved=0;
		if (nocharname)
		{
		  znr=255;
		  nocharname=0;
		}
		else
		{
                  znr=(znr+255)%256;
/*		  if (znr>1) znr--; */
		}
		copyfromfont();
		iko=1;jko=0;
		paint();
		printstat();
		break;
      /* Bild ab: vorblaettern */
      case PGDN: if (charunsaved)
		{
		  if(liesbs(bltitle,zwarntbl,taspalte,enterzeile)=='n')
		    break;
		}
		charunsaved=0;
		if (nocharname)
		{
		  znr=0;
		  nocharname=0;
		}
		else
		{
                  znr= (znr+1)%256;
/*		  if (znr<255) znr++; */
		}
		copyfromfont();
		iko=1;jko=0;
		paint();
		printstat();
		break;
      /* Bearbeiten eines existierenden Zeichens */
      case 'b': if (charunsaved)
		{
		  if(liesbs(betitle,zwarntbl,taspalte,enterzeile)=='n')break;
		}
		charunsaved=0;
		znr=liesnummer(betitle,zhlintbl,tab,statuszeile+1);
		nocharname=0;
		copyfromfont();
		iko=1;jko=0;
		paint();
		printstat();
		break;
#ifdef __MSDOS__
      case 'l':
#else
      case 'z':
#endif
                if (charunsaved)
		{
		  if (liesbs(letitle,zwarntbl,taspalte,enterzeile)=='n')break;
		}
		charunsaved=0;
		for (i=1;i<12;i++)
		  col[i]=0;
		iko=1;jko=0;
		nocharname=1;
		paint();
		printstat();
		break;
      /* uebernehmen */
      case 'u': if (nocharname)
		{
		  liesbs(fetitle,kenumtbl,taspalte,enterzeile);
		  break;
		}
		copytofont();
		charunsaved=0; /* Zeichen in den Editorfont gesichert */
		fontunsaved=1; /* Font muss noch gesichert werden */
		printstat();
		break;
      case 'a': znr=liesnummer(uatitle,zhlintbl,tab,statuszeile+1);
		nocharname=0;  /* Zeichen hat eine Nummer */
		copytofont();
		charunsaved=0; /* Zeichen in den Editorfont gesichert */
		fontunsaved=1; /* Font muss noch gesichert werden */
		printstat();
		break;
      case 'r': paint();printstat();  /* nicht fuer den Benutzer gedacht */
      case ESC: if(charunsaved)
		{
		  if(liesbs(estitle,zwarntbl,taspalte,enterzeile)=='n')
		  {
		    funktion=KEINE;
		    break;
		  }
		}
		charunsaved=0;
		for (i=1;i<12;i++)
		  col[i]=0;
		iko=1;jko=0;
		nocharname=1;
		paint();
		printstat();
    }
  }
  while(funktion!=ESC);
}

void zremove()
{
  int i,zch1,zch2;
  gotoxy(1,statuszeile-2); cprintf("von:");
  printstat();
  zch1=liesnummer(entitle,zhlintbl,tab,statuszeile-2);
  gotoxy(1,statuszeile-2); cprintf("von:");
  gotoxy(tab,statuszeile-2); cprintf("%-3d",zch1);
  gotoxy(1,statuszeile-1); cprintf("bis:");
  printstat();
  zch2=liesnummer(entitle,zhlintbl2,tab,statuszeile-1);
  for(i=zch1;i<=zch2;i++)
    zeichen[i].used=0;
  gotoxy(1,statuszeile-2); cprintf("               ");
  gotoxy(1,statuszeile-1); cprintf("               ");
  fontunsaved=1;
  printstat();
}

void save()
{
  int desc;
  device=FLOPPY;
  if(nofontname)
  {
    liesbs(sititle,kenamtbl,taspalte,enterzeile);
    return;
  }
#ifdef __MSDOS__
  desc=open(fontname,O_BINARY|O_WRONLY|O_CREAT|O_TRUNC,
		     S_IFREG|S_IREAD|S_IWRITE);
#else
  desc=creat(fontname,S_IFREG|S_IREAD|S_IWRITE);
#endif
  if(desc==-1)
  {
    liesbs(fetitle,nopentbl,taspalte,enterzeile);
    printstat();
    return;
  }
  title(sititle);
  table(momentbl);
  write(desc,zeichen,sizeof(zeichen));
  close(desc);
  fontunsaved=0;
  printstat();
}

void saveas()
{
  int desc;
  char oldnofontname,oldfontname[15];

  device=FLOPPY;
  oldnofontname=nofontname;             /* Namensflag sichern */
  strcpy(oldfontname,fontname);         /* Namen sichern */
  liesnamen(satitle,strintbl,tab,statuszeile,fontname);
  nofontname=0;
#ifdef __MSDOS__
  desc=open(fontname,O_BINARY|O_WRONLY|O_CREAT|O_TRUNC,
		     S_IFREG|S_IREAD|S_IWRITE);
#else
  desc=creat(fontname,S_IFREG|S_IREAD|S_IWRITE);
#endif
  if(desc==-1)
  {
    liesbs(fetitle,nopentbl,taspalte,enterzeile);
    nofontname=oldnofontname;
    strcpy(fontname,oldfontname);
    printstat();
    return;
  }
  title(satitle);
  table(momentbl);
  write(desc,zeichen,sizeof(zeichen));
  close(desc);
  fontunsaved=0;
  printstat();
}


void install()
{
  int i,j;
  char sendch;
  device=DRUCKER;
  d_errno=0;
  if(fputc(ESC,stdprn)==-1) putchar(7);
  if(d_errno==-1) return;
  title(intitle);
  table(momentbl);
  fprintf(stdprn,"%c%c%c%c",':',0,0,0);  /* Kopiere ROM->RAM */
  for(i=0;i<256;i++)
  {
    if(i==0x1a) i++;                    /* Computer sendet kein Ctrl-z */
    if(zeichen[i].used)
    {                                   /* Kopieren Zeichen->RAM */
      fprintf(stdprn,"%c%c%c%c%c%c",ESC,'&',0,i,i,zeichen[i].att);
      for(j=0;j<11;j++)
      {
      	sendch=zeichen[i].dat[j];
      	if(sendch==0x1a) sendch=0x3a;   /* Computer sendet kein Ctrl-z */
        fprintf(stdprn,"%c",sendch);
      }
    }
  }
  fprintf(stdprn,"%c%c%c%c",ESC,'%',1,0); /* RAM-Zeichen verwenden */
}

void deinstall()
{
  device=DRUCKER;
  d_errno=0;
  if(fputc(ESC,stdprn)==-1) putchar(7);
  if(d_errno==-1) return;
  title(detitle);
  table(momentbl);
  fprintf(stdprn,"%c%c%c",'%',0,0); /* ROM-Zeichen verwenden */
}

void test()
{
  int i;
  device=DRUCKER;
  d_errno=0;
  if(fputc('Z',stdprn)==-1) putchar(7);
  if(d_errno==-1) return;
  title(tetitle);
  table(momentbl);
  fprintf(stdprn,"eichensatz-Test:\n");
  for (i=32;i<128;i++)
  {
    fprintf(stdprn,"%d: %c  ",i,i);
  }
  fprintf(stdprn,"     \n");
}

void convert()
{
  struct
  {
    unsigned char line[16];
  } herczeichen[256],
    herctest;                           /* Veroderung aller Zeichen:
					   Daraus laesst sich die Hoehe des
					   Zeichensatzes ermitteln
					*/
					/* Waehrend Hercules-Fonts
					   zeilenweise in Bytes gepackt
					   werden (16 Zeilen), sind
					   MSP-Druckerfonts spaltenweise
					   in Bytes (11 Spalten). Daher
					   werden die Indices umgerechnet
					   werden muessen. Zur Vereinfachung
					   wird ein 2-d-Feld angelegt,
					   dessen Elemente nur Nullen und
					   Einsen sein koennen */
  unsigned char puffer[11][8];

  int desc;
  int i,j,k,start,end,hoehe,index,puffindex,hercindex;
  float soll;
  char oldnofontname,oldfontname[15];

  device=FLOPPY;
  oldnofontname=nofontname;             /* Namensflag sichern */
  strcpy(oldfontname,fontname);         /* Namen sichern */
  if(fontunsaved)
    if(liesbs(kotitle,fwarntbl,taspalte,enterzeile)=='n') return;
  liesnamen(kotitle,hrcintbl,tab,statuszeile,fontname);
  nofontname=0;
  desc=open(fontname,O_BINARY|O_RDONLY);
  if(desc==-1)
  {
    liesbs(fetitle,nopentbl,taspalte,enterzeile);
    nofontname=oldnofontname;
    strcpy(fontname,oldfontname);
    printstat();
    return;
  }
  if(filelength(desc)!=sizeof(herczeichen))
  {
    liesbs(fetitle,nherctbl,taspalte,enterzeile);
    close(desc);
    nofontname=oldnofontname;
    strcpy(fontname,oldfontname);
    printstat();
    return;
  }
  title(kotitle);
  table(momentbl);
  read(desc,herczeichen,sizeof(herczeichen));  /* 4096 Bytes */
  fontunsaved=1;                        /* im Unterschied z. Laden! */

  for(j=0;j<16;j++) herctest.line[j]=0; /* initialisieren Test-Zeichen */

					/* alle wichtigen Zeichen in
					   herctest verodern
					*/
  for(i=0;i<256;i++)
  {
    if(isalpha(i))
    {
      for(j=0;j<16;j++)
      {
	herctest.line[j]|=herczeichen[i].line[j];
      }
    }
  }

  start=0;
  while (herctest.line[start] == 0 && start<16) start++;

  end=15;
  while (herctest.line[end] == 0 && end>-1) end--;

  hoehe=end-start+1;

#ifdef _DCDEBUG_
  gotoxy(2,30);
  cprintf("Start: %d Ende: %d Hoehe: %d\n",start,end,hoehe);
  getchar();
#endif

  for(i=0;i<256;i++)
  {
    zeichen[i].used=1;                  /* benutzt */
    zeichen[i].att=128;                 /* obere Pins */
    for(j=0;j<11;j++)                   /* zunaechst leer */
      zeichen[i].dat[j]=0;

    for(j=0;j<11;j++)                   /* Puffer initialisieren */
      for(k=0;k<8;k++)
	puffer[j][k]=0;
					/* Die Zeilen zwischen start und
					   end im Herculeszeichen werden
					   durchlaufen. ->hercindex
					   Dabei kann - wenn das Herczch.
					   groesser als das Puffer ist -
					   auch mal eine Zeile uebersprungen
					   werden.
					   Ein weiterer Index durchlaeuft
					   lueckenlos das Pufferzeichen.
					   ->puffindex
					*/

    puffindex=hercindex=0;
    soll=0.0;

    while(puffindex<8)
    {
      for(k=0;k<8;k++)
      {
	if(ZEILE & (1<<k))
	{
	  puffer[10-k][7-puffindex]=1;
	}
      }


      puffindex++;
      hercindex++;
      soll+=(float)hoehe/8.0;             /* ideale Erhoehung des Indexes */

      /* Wenn die ideale Erhoehung des Indexes einen zu grossen Vor-
	 sprung vor der realen (hercindex) hat, wird durch weitere
	 Erhoehung ausgeglichen. Bei einer Hoehe von 11 z.B. wird
	 insgesamt 3x erhoeht werden, da insgesamt 11 um 3 hoeher ist
	 als die Puffergroesse 8. Justieren kann man an der Be-
	 dingung, wann erhoeht werden muss. Bei allen Werten zwischen
	 0 und 1 sollte auf jeden Fall relativ gleichmaessig kopiert
	 werden.
	 Enthaelt die zu ueberspringende Zeile einen Querstrich,
	 (beide Bits links und rechts von der Mitte gesetzt),
	 die naechste aber nicht, dann wird ausnahmsweise nicht
	 uebersprungen. Dasselbe gilt, wenn die Zeile den unteren
	 Abschluss bildet.
      */
					  /* Bei 0.55 kommen nach meiner
					     Erfahrung die mittl. Quer-
					     striche immer mit rueber,
					     und die Kleinbuchst. sind
					     i. a. noch leserlich.
					  */
      if(soll>=hercindex-0)
      {
	if(
	   !(((ZEILE & 0x18)==0x18)
	     &&
	     ((NZEILE & 0x18)!=0x18))
	   &&
	   !((ZEILE !=0) && (NZEILE==0))
	  )
	  /* akt. Zeile ist weder Querstreifen noch unterer Rand */
	{
	  hercindex++;
	}
      }
    }
					/* Figur ein wenig verbreitern */
    index=3;                            /* wird fuer Verschieb. gebr. */
    for(j=3;j<11;j++)
    {
      if ((j==5)||(j==7)||(j==10))
       index--;
      for(k=0;k<8;k++)
      {
	puffer[j-index][k]=puffer[j][k];
	if((j==5)||(j==7)||(j==10))
	  puffer[j-index-1][k]=puffer[j][k];
      }
    }

					/* Designrules anwenden */
    for (j=1;j<11;j++)
    {
      for(k=0;k<8;k++)
      {
	if(puffer[j-1][k]==1 && puffer[j][k]==1)
	  puffer[j][k]=0;
      }
    }

					/* Sammeln f. interne Darstellg. */
					/* Jede Spalte ist mit 0 initial. */
    for(j=0;j<11;j++)
    {
      for(k=0;k<8;k++)
      {
	zeichen[i].dat[j]|=puffer[j][k]<<k;
      }
    }
  }

  close(desc);
  printstat();
}

void newfont()
{
  int i;
  if(fontunsaved)
  {
    if(liesbs(netitle,fwarntbl,taspalte,enterzeile)=='n')
    return;
  }
  nofontname=1;
  fontunsaved=0;
  for(i=0;i<256;i++)
    zeichen[i].used=0;
  printstat();
}

main(argc,argv)
int argc;
char *argv[];
{
  int funktion;
  char prtdev[80];

#ifdef __MSDOS__
  directvideo=1;
  harderr(geraetefehler);
#else
  if (argc>1)
    strcpy(prtdev,argv[1]);
  else
    strcpy(prtdev,STDPRN);
  stdprn=fopen(prtdev,"w");
  if (stdprn==NULL)
  {
    fprintf(stderr,
      "%s nicht bereit. Einschalten oder mit \"font4 <file>\" aufrufen.\n",
      prtdev);
    exit(1);
  }
  stdschirm = initscr();
  taschirm = newwin(11,21,tazeile,taspalte);
  tischirm = newwin( 1,21,tizeile,tispalte);
  raw();     /* bewirkt u.a. getch statt getchar beim curses-getch */
  noecho();  /* bewirkt u.a. kein implizites putch beim curses-getch */
#endif
  menu();
  highvideo();
  paint();
  printstat();
  liesbs(hatitle,starttbl,taspalte,enterzeile);
  do
  {
    funktion=liescode(hatitle,haupttbl,taspalte,enterzeile);
    switch (funktion)
    {
      case 'l': load();break;
      case 'e': edit();break;
      case 'z': zremove();break;
      case 's': save();break;
      case 'a': saveas();break;
      case 'i': install();break;
      case 'd': deinstall();break;
      case 't': test();break;
      case 'k': convert();break;
      case 'n': newfont();break;
      case ESC: if(fontunsaved)
		{
		  if(liesbs(estitle,fwarntbl,taspalte,enterzeile)=='n')
		  {
		    funktion=KEINE;
		    break;
		  }
		}
		fontunsaved=0;
		printstat();
    }
  } while(funktion!=ESC);
  gotoxy(1,24);
#ifndef __MSDOS__
  endwin();
#endif
}
