
static char rcsid[] = "@(#)$Id: listalias.c,v 5.8 1993/01/27 20:34:55 syd Exp $";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 5.8 $   $State: Exp $
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Syd Weinstein, Elm Coordinator
 *	elm@DSI.COM			dsinc!elm
 *
 *******************************************************************************
 * $Log: listalias.c,v $
 * Revision 5.8  1993/01/27  20:34:55  syd
 * Add return statement to new print_alias routine
 * From: Syd via prompt from Denis Lambot
 *
 * Revision 5.7  1993/01/19  03:51:14  syd
 * Do not assume that "char c" can represent EOF.
 * From: chip@tct.com (Chip Salzenberg)
 *
 * Revision 5.6  1992/12/20  05:15:58  syd
 * Add a c)hange alias, -u and -t options to listalias to list only user
 * and only system aliases respectively.
 * From: "Robert L. Howard" <robert.howard@matd.gatech.edu>
 *
 * Revision 5.5  1992/11/15  01:24:34  syd
 * The situation is that the .elm/aliases file is missing, but
 * .elm/aliases.dir and .elm/aliases.pag exist (isn't serendipity
 * wonderful?).  The ndbz functions tolerate this and just put a NULL
 * pointer in the db structure for the data file FILE pointer.  However,
 * get_one_alias() in listalias and elm doesn't account for the db_open()
 * succeeding but the dbz_basef field being NULL, so it passes the NULL
 * pointer to fread().  Detect null and return 0
 * From: dwolfe@pffft.sps.mot.com (Dave Wolfe)
 *
 * Revision 5.4  1992/11/02  20:49:19  syd
 * Resolve a linking error in listalias when DEBUG is enabled.
 * From cs.utexas.edu!chinacat!chip Sun Nov  1 22:04:02 1992
 *
 * Revision 5.3  1992/10/30  22:13:43  syd
 * Apply same mapin/mapout changes to listalias as were used by
 * alias in elm
 * From: Syd
 *
 * Revision 5.2  1992/10/11  01:10:31  syd
 * Add missing setlocale and catopen (just forgotten)
 * From: Syd
 *
 * Revision 5.1  1992/10/04  00:46:45  syd
 * Initial checkin as of 2.4 Release at PL0
 *
 *
 ******************************************************************************/

/** Program that lists all the available aliases.  This one uses the pipe 
    command, feeding the stuff to egrep then sort, or just sort.

**/

#include "elmutil.h"
#include "s_newalias.h"
#include "sysdefs.h"
#include "ndbz.h"

#ifdef BSD
  FILE *popen();
#endif

/*
 * These are used by the "dbz" routines.
 */
#ifdef DEBUG
int debug = 0;
FILE *debugfile = stderr;
#endif

static void usage();

main(argc, argv)
int argc;
char *argv[];
{
	extern int optind;

	FILE *fd_pipe;

	int system = TRUE, user = TRUE;
	int err_flag = 0;

	char buffer[SLEN], fd_data[SLEN], *home;
	int c;

#ifdef I_LOCALE
	setlocale(LC_ALL, "");
#endif

	elm_msg_cat = catopen("elm2.4", 0);

	while ((c = getopt(argc, argv, "su")) != EOF) {
	    switch (c) {
	        case 's' :
	            user = FALSE;
	            if (system == FALSE)
	                err_flag++;
	            break;
	        case 'u' :
	            system = FALSE;
	            if (user == FALSE)
	                err_flag++;
	            break;
	        case '?' :
	            err_flag++;
 	    }
	}	
	if (err_flag) {
	    usage();
	}

	if (optind < argc)
	    sprintf(buffer, "egrep \"%s\" | sort", argv[optind++]);
	else
	    sprintf(buffer, "sort");

	if (optind < argc)
	    usage();

	if ((fd_pipe = popen(buffer, "w")) == NULL) {
	  if (argc > 1) 
	    fprintf(stderr, catgets(elm_msg_cat, NewaliasSet, NewaliasNoPipe,
		"cannot open pipe to egrep program for expressions!\n"));
	  fd_pipe = stdout;
	}

	if (user) {
	    home = getenv("HOME");
	    sprintf(fd_data, "%s/%s", home, ALIAS_DATA);
	    if (print_aliases(fd_data, fd_pipe) == -1) {
	        fprintf(stderr, catgets(elm_msg_cat, NewaliasSet,
		  NewaliasNoOpenData, "Could not open %s data file!\n"),
	          catgets(elm_msg_cat, NewaliasSet, NewaliasUser, "user"));
	    }
	}

	if (system) {
	    strcpy(fd_data, system_data_file);
	    if (print_aliases(fd_data, fd_pipe) == -1) {
	        fprintf(stderr, catgets(elm_msg_cat, NewaliasSet,
		  NewaliasNoOpenData, "Could not open %s data file!\n"),
	          catgets(elm_msg_cat, NewaliasSet, NewaliasSystem, "system"));
	    }
	}

	pclose(fd_pipe);

	exit(0);
}

int
print_aliases(fd_data, fd_pipe)
char *fd_data;
FILE *fd_pipe;
{

	FILE *datafile;
	DBZ *db;
	struct alias_rec alias_entry;
	int len;

	char buffer[VERY_LONG_STRING];

	if ((db = dbz_open(fd_data, O_RDONLY, 0)) == NULL) {
	    return(-1);
	}
	
	/** Otherwise let us continue... **/

	datafile = db->dbz_basef;
	while (read_one_alias(db, &alias_entry)) {
	    len = alias_entry.length;
	    fread(buffer,
		len > sizeof(buffer) ? sizeof(buffer) : len, 1, datafile);
	    alias_entry.alias	= (int) alias_entry.alias	+ (int) buffer;
	    alias_entry.name 	= (int) alias_entry.name	+ (int) buffer;
	    alias_entry.address = (int) alias_entry.address	+ (int) buffer;
	    fprintf(fd_pipe, "%-20.20s %s (%s)\n",
		alias_entry.alias, alias_entry.address, alias_entry.name);
	    for (len -= sizeof(buffer); len > 0; len -= sizeof(buffer))
	        fread(buffer,
		    len > sizeof(buffer) ? sizeof(buffer) : len, 1, datafile);
	}

	return(0);
}

static void usage()
{
	fprintf(stderr, catgets(elm_msg_cat, NewaliasSet, NewaliasListUsage,
	    "Usage: listalias [ -s | -u ] <optional-regular-expression>\n"));
	exit(1);
}
