.TH DTE 1L "dte Version 5.1"
.ad b
.SH NAME
dte - full screen text editor
.SH SYNOPSIS
.B dte
[ filename ]
.SH DESCRIPTION
.B dte
.PD 0
is a simple full-screen text editor suitable for editing program source
code. It was designed with goals including:
.PP
.TP 7
\    1.\^
To perform well over slow serial communication lines;
.PP
.TP 7
\    2.\^
To imitate the command keys used in WordStar / Turbo Pascal.
.PD
.PP
It is therefore expected that this editor will be particularly suitable for
distance education students, who normally use Turbo Pascal (and hence are
already familiar with the keystrokes required), and who also normally have
to log in via 300/1200/2400 baud modems.
.PP
.PD 0
To edit a file called "test.p", use the command:
.PP
    \fBdte test.p\fR
.PP
.PD
If "test.p" already exists, it will be loaded ready to edit.
If it does not yet exist,
.B dte
will create a new empty file.
.PP
If no file is specified, then
.B dte
will automatically display its on-line help (which contains most of the
information included in this manual entry).
.PP
In the following commands,
.B ^x
is used to represent \fBcontrol-x\fR (this means
holding down the control key, and then typing \fBx\fR).
.PP
.ne 4
.I Cursor Movement Commands:
.PD 0
.PP
.PD
 ^X  - line down
 ^E  - line up
 ^D  - character right
 ^S  - character left
 ^F  - word right
 ^A  - word left
 ^C  - screen down
 ^R  - screen up
 ^QC - end of file
 ^QR - beginning of file
 ^QX - bottom of screen
 ^QE - top of screen
 ^QD - end of current line
 ^QS - beginning of current line
.PD 0
.TP 7
\ ^QI -\^
start of particular line in file (\fBdte\fR will prompt for line
number)
.PP
.PD
 ^QB - beginning of marked block
 ^QK - end of marked block
 ^Q0 ... ^Q9 - move to marker 0 ... 9
.PD 0
.PP
.TP 7
\ ^Q[ -\^
match forwards  - works with () {} [] '' "" /* */ begin end [if the
cursor is on one of these characters, then it will be moved to the
matched pair]
.PP
.TP 7
\ ^Q] -\^
match backwards - works with () {} [] '' "" /* */ begin end
.PP
.TP 7
\ ^QF -\^
find text in file [\fBdte\fR will prompt for text to find and
for options - see below]
.PP
.PD
 ^QP - move to previous position
.PP
.ne 4
.I Screen Scrolling Commands:
.PD 0
.PP
.PD
 ^Z  - scroll down one line
 ^W  - scroll up one line
 ^C  - scroll down one page
 ^R  - scroll up one page
.PP
.ne 4
.I Search and Replace Commands:
.PD 0
.PP
.PD
 ^QF - find
 ^QA - replace
 ^L  - repeat last find/replace
.PP
.ne 4
.I Find/Replace Options:
.PD 0
.PP
.PD
 U   - ignore case
 B   - search backwards
 G   - scan entire file (global)
 L   - scan marked block (local)
 N   - replace without asking
 M   - match original case when replacing
 W   - match entire words only
 <n> - perform find/replace <n> times
.PP
.ne 4
.I Editing Search Strings (and file names):
.PD 0
.PP
.PD
 ^S  - move cursor left
 ^D  - move cursor right
 ^E  - move to start of string
 ^X  - move to end of string
 ^Y  - delete all of string
 ^R  - restore original string
 ^G  - delete character under cursor
 <BackSpace> - delete character to left of cursor
 printable characters are inserted at the cursor
.PP
.ne 4
.I Block Commands:
.PD 0
.PP
.PD
 ^KB - mark start of block
 ^KK - mark end of block
 ^KH - hide/unhide block
 ^KC - copy marked block to cursor
 ^KV - move marked block to cursor
 ^KY - delete marked block
 ^KW - write block to file
 ^KR - read in file at cursor
 ^K@ - read in file at cursor, expanding tabs etc
 ^KP - print block or entire file
 ^KI - indent block by current tab size
 ^KU - unindent block by current tab size
.PP
.ne 4
.I File Commands:
.PD 0
.PP
.PD
 ^KD - save file, then exit editor
 ^KX - save file only if modified, then exit
 ^KS - save file, continue editing
 ^KT - save file under new name, continue editing
 ^KQ - exit editor without saving
.PP
.ne 4
.I Text Insertion:
.PD 0
.PP
.TP 7
\ ^N  -\^
insert new line at cursor, leave cursor on current line
.PP
.TP 11
\ <Enter> -\^
insert new line at cursor, cursor moves to start of new line
.PP
.TP 1
\&\^
printable characters are (in insert mode) inserted in front of the cursor
.PD
.PP
.ne 4
.I Text Deletion Commands:
.PD 0
.PP
.TP 15
\ <BackSpace> -\^
delete character to left of cursor, move cursor left
.PP
.TP 7
\ ^G  -\^
delete character under cursor, do not move cursor
.PP
.TP 7
\ ^Y  -\^
delete current line
.PP
.TP 7
\ ^QY -\^
delete from cursor to end of line
.PP
 ^T  - delete from cursor to end of word
.PP
 ^KY - delete marked block
.PD
.PP
.ne 4
.I Change Editing Modes:
.PD 0
.PP
.TP 7
\ ^V  -\^
insert character in front of cursor / overwrite character at cursor
.PP
.TP 7
\ ^OI -\^
indent new line to match previous / start new line at column 0
.PP
.TP 7
\ ^OU -\^
<BackSpace> matches earlier indentation / deletes just one character
.PD
.PP
.ne 4
.I Window Commands:
.PD 0
.PP
.TP 7
\ ^OK -\^
change to another window, or create a new window below cursor [the new
window will start on the line immediately below the cursor, and continue
down to the bottom line in the current window.]
.PP
.TP 7
\ ^OM -\^
change the size of the current window [the cursor line will become the
new boundary between the current window and the one below (or above if
the current window is the bottom window)]
.PD
.PP
.ne 4
.I Miscellaneous Commands:
.PD 0
.PP
.PD
 ^U or <ESC> - abort current command
 ^J  - obtain on-screen help
 ^QL - restore current line
 ^K0 ... ^K9 - set position marker 0 ... 9
 ^\\  - redraw entire display (useful if screen gets garbled)
 ^OT - set tab stop interval
 ^KF - shell out to operating system
.SH AUTHOR
Douglas Thomson, Monash University College Gippsland.
.SH "BUG REPORTS TO"
Douglas Thomson    doug@giaea.oz
