#define DINKUM.C
#include "dink_sym.h"
#include "dink_glb.h"
#include <stdlib.h>
#define Failed		0
#define Request		1

/* ---------------- Version Date --------------- */
char *lb_date = "24 August 1992" ;
/* --------------------------------------------- */

/*  ---- Version Number  ---- */
char *lb_version = "1.27" ;
/*  ------------------------- */

/* ---------------- Version Type --------------- */
char *lb_share = "[Shareware Version]" ;
/* --------------------------------------------- */

/*  ---- Serial Number  ---- */
#define S_number 	1
int serial = S_number ;
/*  ------------------------ */
 
/* Global variables local to this file only */
int sw_help = FALSE, sw_null = FALSE, sw_number = FALSE, sw_standard = FALSE ;

/* MAIN PROGRAM --- MAIN PROGRAM --- MAIN PROGRAM --- MAIN PROGRAM */
void main(argc,argv)
/********************************************************************/
/*                                                                  */
/*                  --- The Dinkum Program ---                      */
/*                                                                  */
/* Software by Gary A. Allen, Jr.  24 August 1992  Version: Mk 1.27 */
/*           (c) Copyright 1990 by Gary A. Allen, Jr.               */
/*                                                                  */
/********************************************************************/

int argc ;
char *argv[] ;
{
register int i, j ;

int dig_1, dig_2 ;
int pnt, n, i_rand1, i_rand2, i_rand3, old_n = 0, n_back ;
long l_pass, l_time, l_base, start_time, *time_arg = 0 ;
char chr, cmd[8] ;

#ifdef __TURBOC__
/* Function prototypes */
void switch_list(void) ; 
void cmd_switch(char[8], int, int, char *[]) ;
void bugs(int), help(void) ;
void kelly(int), long_descp(int), objlooker(int), killer(int) ;
void gleeper(int), actor(int), ender(int), closer(int), opener(int) ;
void dialer(int), taker(int), dropper(int), describe(int), rdtxt(int) ;
void igniter(int), switcher(int), unlocker(int), sounder(int) ;
void loader(void), eater(void), filler(void), looker(int), exit(int) ;
void monster(int*,int*), new_score(void), boom(void), parse(void) ;
void inventer(void), drinker(void), reader(void), pusher(int*);
void pass(void), unloader(int) ;
long time(long*) ;
char getch(void), getche(void) ;
#endif

/* Software security */
if (serial != S_number) exit(0) ;  /* abort if serial number changed */

/* Scan the after the DOS/Unix command for switches or file name */
if (argc > 1) {
for (i = 1; i <= argc-1; i++) {
	/* Flush command vector */
	for (j = 0; j <= 7; j++) cmd[j] = '\0' ;
	/* Get command vector */
	sscanf(argv[i],"%c%c%c%c%c%c%c%c%c", &chr, &cmd[0], &cmd[1],
		&cmd[2], &cmd[3], &cmd[4], &cmd[5], &cmd[6], &cmd[7]) ;
	sw_null = FALSE ;
	if (chr == '?') help() ;
	if (chr == '-') {
		for (j = 0; j <= 7; j++) {
			cmd_switch(cmd, j, i, argv) ;
			if (sw_number) {
				i++ ;
				sw_number = FALSE ;
				break ;
			}
			if (sw_null) break ;
		} /* end of command "for" loop */

		if (j >= 7) {
printf("\n!!!! Too many commands on one \"-\" switch group.\n") ;
printf("!!!! Break up the commands into several \"-\" switch groups.\n") ;
			bugs(Failed) ;
		}
	} /* end of the "-" marker block */

	/* Deal with garbage on the command line */
	else {
printf ("\n!!!! The following on the command line was not understood:  %s \n",
	argv[i]);
		bugs(Failed) ;
	} /* Nondefault scratch file opening block */

} /* end of argument token "for" loop */

if (sw_help) help() ;
} /* end of the command switch block */

/* Deal with someone cheating with switch "-s" */
if (sw_standard && (!sw_wizard)) {
	printf("!!!! Command line switch -s is unknown.\n") ;
	bugs(Failed) ;
}
 
/* Software security */
if (serial != S_number) exit(0) ;  /* abort if serial number changed */

/* Initialize the program */
sw_warned = FALSE ;
l_time = time(time_arg) ;
l_base = l_time/10 ;
l_base *= 10 ;
l_pass = l_time - l_base ;
dig_1 = (int)l_pass ;

printf("                    ") ;
printf("                   --- Dinkum --- \n");
printf("                    ") ;
printf("     (c) Copyright 1990 by Gary A. Allen, Jr.\n") ;
printf("                    ") ;
printf("  All Rights Reserved. Version %s, %s\n\n",
	lb_version, lb_date);

printf("Would like some initial help with Dinkum?\n") ;

for (;;) {

#ifndef __TURBOC__
	do {
		printf("(Answer:  Yes or No) ") ; 
	} while ('\n' == (chr = getchar())) ;

	while ('\n' != getchar()) ;
#endif

#ifdef __TURBOC__
	printf("\n") ;
	do {
		printf("(Answer:  Yes or No) ") ; 
	} while ('\n' == (chr = getch())) ;
	printf("\n") ;
#endif

	if (('n' == chr)||('N' == chr)||('y' == chr)||('Y' == chr)) {
		if (('y' == chr)||('Y' == chr)) {
printf("\nG'day Mate!  Welcome to \"Dinkum\" the Australian adventure");
printf("\ngame.  In Dinkum you'll search for treasure in the\n") ;
printf("Australian Outback.  You give the commands and I'll do the\n");
printf("dangerous work. I understand most plain English sentences.\n");
printf("If you want me to go east then type \"Will you please go\n");
printf("east?\" and press the RETURN or ENTER key.  If you don't\n") ;
printf("enjoy typing then just type \"e\" and press RETURN.  I'll\n");
printf("still go east.  After you have gathered up some things\n") ;
printf("you can see what you have by typing \"inventory\".\n") ;
printf("Sometimes you can learn more about an object by typing\n");
printf("\"examine NAME-OF-OBJECT\".  I understand many other\n") ;
printf("commands and words.  However I'll let you have the fun of\n") ;
printf("finding out what I can and can not understand. Good luck!\n\n");
		}
		break ;
	}
}

/* produce two random numbers ranging from 0-9 based on system clock*/
l_time = time(time_arg) ;
start_time = l_time ;
l_base = l_time/10 ;
l_base *= 10 ;
l_pass = l_time - l_base ;
dig_2 = (int)l_pass ;

/* generate the actual random array pointers */
if (sw_standard) {
	i_rand1 = 1 ; 
	i_rand2 = 0 ;
	i_rand3 = 7 ;
}
else {
	i_rand3 = (dig_1 + dig_2)/2 ;
	i_rand2 = dig_2/3 ;
	i_rand1 = (dig_1/3) + 1 ;
}

printf("\nIt's a hot summer day (in January) in ") ;
printf("Queensland, Australia.\n") ;
n_back = R_meadow ;
n = R_meadow ;

/* Software security */
if (serial != S_number) exit(0) ;  /* abort if serial number changed */

/* load objects into the rooms */
for (i = 0; i <= obj_init_max; i++) 
	object[obj_init[i][0]][J_loc] = obj_init[i][i_rand1] ;

carry_count = 0 ;
carry_weight = 0 ;

for (i = 0; i <= objcnt; i++) {
	j = object[i][J_loc] ;
	if ((j >= 0) && (object[i][J_type] != Z_unmovable))
		 ++room[j][M_obj_cnt] ;
}

/* load monsters into the rooms */
for (i = 0; i <= mon_init_max; i++) 
	enemy[i+1][E_location] = mon_init[i][i_rand2] ;

for (i = 0; i <= enemy_max; i++) { 
	j = enemy[i][E_location] ;
	if (j != B_unmade) ++room[j][M_monster] ;
}
 
/* load the gleep reproductive locations and seed gleep */
for (i = 0; i <= 9; i++)  
	gleep_spot[i] = gleep_init[i][i_rand2] ;
room[gleep_spot[0]-1][M_gleep] = 1 ; /* seed a nonreproductive spot */ 

/* load safe passage for end-game killing passages  */
room[218 + i_rand3][M_rm_type] = T_short_descp ;

/* Beginning of main loop */
loop:
/* special action routine */
new_score() ;  /* update the score */

/* See if the game has timed out */
l_time = time(time_arg) ;
if ((!sw_warned) && (l_time > start_time + 3300)) {
	sw_warned = TRUE ;
	start_time = l_time ;
printf("There's suddenly a puff of blue smoke which fills the room\n") ;
printf("with a hazy cloud.  Slowly this cloud coalesces into a\n") ;
printf("ghostly human form.  This ethereal being is wearing a grey\n") ;
printf("flannel suit, a bowler hat, and glancing at a gold pocket\n") ;
printf("watch which is attached to a long golden chain.  You can\n");
printf("hear \"Waltzing Matilda\" being played softly in the\n") ;
printf("background.  You know what?  I think this ethereal being\n") ;
printf("is none other than the ghost of Banjo Patterson!  With\n") ;
printf("this realization Banjo looks up in your direction and\n") ;
printf("begins to speak:\n\n") ;
printf("\"Sorry mate, you've been at this for too long!  You've\n") ;
printf("got five more minutes to go and then you're history!\"\n\n") ;
printf("Then just as suddenly Banjo Patterson dissolves back into\n") ;
printf("smoke and disappears from view.\n\n") ;
}
if (sw_warned && (l_time > start_time + 300)) {
printf("You hear someone clearing his throat behind you.  You turn\n") ;
printf("around and see Banjo Patterson has appeared once again.  An\n");
printf("old brass chain is hanging from mid air next to Banjo.  On\n") ;
printf("the end of the chain is a white porcelain tear drop shaped\n");
printf("nob with the word \"PULL\" written on it in black letters.\n") ;
printf("Banjo reaches for the nob and says the following:\n\n\"Sorry") ;
printf(" mate, your time has come!  Better luck next time!\"\n\n");
printf("He gives the chain a quick jerk and everything around you\n") ;
printf("slowly fades from view.\n\n") ;
	ender(F_quit) ;
}

kelly(n) ; /* check if Ned Kelly can do something */
 
/* Check if there is a long description */
if ((room[R_hideout][M_monster] > 0)&&(n == R_hideout)) goto command ;
if ((monster_flag == F_monster_active)&&(old_n == n)) goto command ;
	else old_n = 0 ;
if (room[n][M_rm_type] == T_long_descp) {
	long_descp(n) ; /* do the long description of the room */
	goto objlook ;  
}
else describe(n) ;  /* short description */

/* describe unmovable action objects and status */
if (room[n][M_rm_type] == T_action_obj) actor(n) ;

objlook:
objlooker(n) ; /* Check if there are objects in the room */
gleeper(n) ;   /* check for gleeps and update the gleep count */

/* see if the spaceship's transporter is active */
if (sw_transport) {
	if (n == R_ship_passage) sw_transport = FALSE ;
	else if (n == R_transport) {
		n = R_closet ;
		sw_transport = FALSE ;
printf("\nSuddenly radiant energy seems to surge from the hexagons\n");
printf("around you.  Then there is a bright flash and you find\n");
printf("yourself in.....\n\n") ;
printf("A closet stinking of moth balls full of nondescript junk.\n") ;
printf("The only exit is to the north through a curtain hanging\n");
printf("over the entrance.\n\n") ; 
	}
}

/* monster check */
command:
if ((room[n][M_monster] > 0)||(monster_flag != F_no_monster)) {
	if (monster_flag == F_wounded) {
		monster_flag = F_monster_active ;
	}
	else monster(&n,&old_n) ;
}

/* parse in the command */
parse();

/* poison check */
/* remove atropine drug with each game cycle */
if (i_poison > 0) {
	--i_poison ;
}
else {
	/* accumulate poison if holding the orange clip */
	if (object[O_org_clip][J_loc] == B_have) {
		--i_poison ;
		switch (i_poison) {
		case -20:
	printf("You've developed a nervous tick near your eye.\n") ;
			break ;
		case -30:
	printf("You're hands are starting to shake ") ;
	printf("and you're sweating like a pig.\n") ;	
			break ;
		case -35:
	printf("You're shaking so bad you can barely stand and you ");
	printf("could lose your lunch\nat any moment.\n") ;
			break ;
		case -40:
printf("The toxic fumes coming off of the orange ammo clip you were ") ;
printf("carrying finally\ncaught up with you.  You fall over DEAD!\n") ;
			ender(F_died) ;
		}
	}
	/* remove poison after release of orange clip */
	else if (i_poison < 0) ++i_poison ;
}

/* clock check */
if (sw_clock) {
	switch (flag_clock) {
	/* see if the blasting cap is to explode */
	case V_cap:
		if (time(time_arg) > clock_explode) {
			if (object[O_cap][J_loc] == B_have) {
printf("                           POP!!\n") ;
printf("The blasting cap which you were stupidly holding in your\n") ;
printf("hand just blew up and took two of your fingers with it!\n") ;
printf("Good thing you've got another eight fingers to spare!\n\n") ;
				carry_count-- ;
				carry_weight -= object[O_cap][J_weight];
			}
			else {
printf("Far down the tunnel you hear a POP!\n") ;
printf("The blasting cap has finally exploded, not that it\n");
printf("achieved much except make a loud noise.\n\n") ;
			}
			object[O_cap][J_loc] = B_destroyed ;
			sw_clock = FALSE ;
		}
		break ;
	
	/* see if the dynamite is to explode */
	case V_dynamite:
		if (time(time_arg) > clock_explode) {
			/* player dies if he is holding the dynamite */
			if (object[O_dynamite][J_loc] == B_have) {
			boom () ;

printf("The dynamite which you were holding and had earlier ignited\n");
printf("the fuse has finally exploded.  That was a rather noisy\n");
printf("and messy way to commit suicide!  Needless to say there is\n");
printf("nothing left of you but a greasy spot.\n") ;
			ender(F_died) ;
			}
			/* player dies if too close during explosion */
			else {
	if (((n <= 185)&&(n >= 178))||((n <= 170)&&(n >= 166))) {
			boom () ;

printf("You weren't far enough away from the dynamite when it\n");
printf("exploded!  The shock wave was still strong enough to blow\n");
printf("your brains out your ears.  Good try anyway!\n");
			ender(F_died) ;
				}
			/* dynamite explodes and player survives */
				else {
printf("Far down the tunnel you hear a low BOOM!\n") ;
printf("That dynamite you set burning has finally exploded.\n\n");

/* open up the passage to the UFO */
if (object[O_dynamite][J_loc] == R_blast_point) {
	room[R_blast_point][1] = 186 ;
	room[R_blast_point][M_descp] = 55 ;
					}
				}
			}
			object[O_dynamite][J_loc] = B_destroyed ;
			sw_clock = FALSE ;
		}
		break ;
	}
}

/* the command is a simple move command */
if (tag[V_MOVE]) {
	pnt = verb ;
move:
	/* see if this movement prohibits blasting caps */
	if (((pnt == V_u)||(pnt == V_up))&&
		((n == R_manhole_1)||(n == R_manhole_2))) {
		if (object[O_cap][J_loc] == B_have) {
printf("As you were climbing up through the hole in the ceiling,\n");
printf("the blasting cap slipped from your grasp and fell to the\n") ;
printf("floor below where it detonated on impact.  The explosion\n") ;
printf("was deafening, but caused no damage.\n") ;
			carry_count-- ;
			carry_weight -= object[O_cap][J_weight] ;
			object[O_cap][J_loc] = B_destroyed; 
		}
		else if ((object[O_dynamite][J_loc] == B_have)&&
			(object[O_dynamite][J_type] == Z_alias)) {
			boom () ;

printf("As you were climbing up through the hole in the ceiling,\n");
printf("the dynamite with the blasting cap inside slipped from\n") ;
printf("your grasp and fell to the floor below where it detonated\n") ;
printf("on impact.  At that point you literally became a human\n");
printf("cannon ball as the shock wave carried you up the vertical\n");
printf("passage and splattered you into protoplasmic jelly on the\n");
printf("ceiling above.\n") ; 
			ender(F_died) ;
		}
	}

	pnt-- ;
	if (room[n][pnt] == -1) {
		printf ("You can't go that way. \n");
		goto command ; 
	}

	n_back = n ;		/* save previous "n" for "back" */
	n = room[n][pnt] ;
	if (room[n][M_rm_type] != T_lethal) goto loop ;

/* player walked into a lethal room */
	long_descp(n) ;
	ender(F_died) ;
}

/* complicated command decoder */
switch (verb) {
 
/* "help" command */
case V_help:
case V_info:
printf("There is no help available.  You're on your own!\n") ;
	break ;
 
/* "quit" command */
case V_quit:
	ender(F_quit) ;

/* "question" command */
case V_QUESTION:
	if (tag[V_VERB_ONLY]) {
		if (tag[V_how]) {
printf("That's for you to figure out.\n") ;
			break ;
		}
printf("I don't have a clue!\n") ;
		break ;
	}

	/* Question "Where am I?" */
	if (tag[V_where] && tag[V_am]) {
		tag[V_VERB_ONLY] = TRUE ; /* This is for "looker" */
		looker(n) ;
		break ;
	}

	/* Question "What have I got?" */
	if (tag[V_what] && tag[V_have]) {
		inventer() ;
		break ;
	}

	/* Question which can't be processed */
printf("You asked a question.  Unfortunately I have no answers.\n") ;
	break ;

/* "inventory" command */
case V_inventory: 
case V_invent:
	inventer() ;
	break;

/* "close" command  */
case V_close:
case V_shut:
	closer(n) ;
	break;

/* "open" command  */
case V_open:
case V_swing:
	opener(n) ;
	break;

/* "dial" command  */
case V_dial:
case V_combination:
	dialer(n) ;
	break ;
 
/* "drink" command */
case V_drink: 
	drinker() ;
	break ;

/* "ignite" command */
case V_ignite: 
case V_light: 
	igniter(n) ;
	break ;

/* "read" command  */
case V_read:
	reader() ;
	break;
 
/* "push" command  */
case V_push:
case V_press:
	pusher(&n) ;
	break ;
 
/* "turn", "switch" command */
case V_switch:
case V_turn:
case V_select:
case V_set:
	switcher(n) ;
	break ;
 
/* "shoot" command  */
case V_shoot:
case V_fire:
case V_kill:
	killer(n) ;
	break;
 
/* "unlock" command  */
case V_unlock:
	unlocker(n) ;
	break;
 
/* "eat" command  */
case V_eat:
case V_swallow:
	eater() ;
	break;
 
/* "fill" command  */
case V_fill:
	filler() ;
	break;
 
/* "sound" command  */
case V_sound:
case V_bang:
case V_hit:
case V_strike:
	sounder(n) ;
	break;

/* "SVC" wizard move command */
case V_svc:
	if (sw_wizard) {
		printf ("Enter room coordinate number:  ");
		scanf ("%d",&n);
		goto loop ;
	}
	else {
cheater:
printf("Rather than cheat at this game by using a disassembler, you\n");
printf("should send the author $150 and he'll gladly send you\n") ;
printf("the source code.  If you just want a clue, then send $20\n") ;
printf("registration fee with your question and he'll provide\n") ;
printf("the answer.  You can find the author's address by\n") ;
printf("typing:  dinkum -h\n") ;
		exit(0) ;
	} 

/* "STATS" game statistics */
case V_stats :
		printf("      --- Dinkum --- \n");
		printf("Version: %s, %s\n\n", lb_version, lb_date);
		printf("i_rand1 = %d, i_rand2 = %d, i_rand3 = %d\n",
			i_rand1, i_rand2, i_rand3) ;
		printf("Room Number = %d\n", n) ;
		printf("Room object count = %d \n",
			room[n][M_obj_cnt]) ;
		printf("Room monster count = %d\n",
			room[n][M_monster]) ; 
		printf("Gleeps on room's floor count = %d\n",
			room[n][M_gleep]) ;
		printf("Poison level = %d\n",i_poison) ;
		printf("Gleep count = %d\n", gleep_count) ;
		printf("carry_count = %d, carry_weight = %d\n",
			carry_count, carry_weight) ;
		break ;

/* "SU" wizard initiation command */
case V_su:
	pass() ;
	break ;

/* "JSYS" wizard command which deactivates a monster */
case V_jsys:
	if (sw_wizard) monster_flag = F_no_monster ;
	else goto cheater ;
	break ;

/* "score" command */
case V_score: 
	new_score () ;
	if ((gleep_score == 0)&&(score == 0)) {
printf("You haven't scored anything at all, Bozo! Try putting\n");
printf("a valuable into the safe or find some gleeps.\n") ;
		break ;
	}
	if (score == 0) { 
		if (gleep_score > 1) {
printf("You haven't scored any points but you splashed ") ;
printf ("%d gleeps into the gleep tank.\n",gleep_score) ;
		}
		else {
printf("You haven't scored any points at all but you did put a\n");
printf ("gleep in the gleep tank (big deal!).\n") ;
		}
	}
	else {
printf ("You scored %d points ",score) ;
		if (gleep_score == 0) 
printf ("but have yet to put any gleeps in the gleep tank.\n") ;
		else {
			if (gleep_score > 1) 
printf ("and put %d gleeps into the gleep tank.\n",gleep_score) ;
	
			else 
printf ("and put a gleep in the gleep tank.\n") ;
		}
	}
	break ;
 
/* "enter" command  */
case V_enter:
switch (n) {
 
	/* Lift entrance at the ground level */
	case R_lift_entr:
		if (room[R_lift_entr][2] == -1) goto door_shut ;
		pnt = 3 ;
		break ;
	/* office door */
	case R_office_entr:
		if (room[R_office_entr][2] == -1) goto door_shut ;
		pnt = 3 ;
		break ;
	/* Lift entrance at level #49 */
	case R_L49_entr:
		pnt = 3 ;
		break ;
	/* Entrance to Ned Kelly's hideout */
	case R_hideout_entr:
		pnt = 3 ;
		break ;
	default:
	printf("I don't understand exactly how to enter. \n");
		goto command ;
}
goto move ;
door_shut:
printf("I can't do it!  The door needs to be opened.\n") ;
goto command ;

/* "exit" command  */
case V_exit:
case V_leave:
case V_depart:
switch (n) {
 
	/* Lift entrance at the ground level */
	case R_lift_inside:
		pnt = 4 ;
		break ;
	/* office door */
	case R_office_hall:
		pnt = 4 ;
		break ;
	/* Ned Kelly's hideout */
	case R_hideout :
		pnt = 4 ;
		break ;
	default:
printf("I don't understand exactly how you want to exit.\n");
		goto command ;
}
goto move ;

/* "dig" command */
case V_dig:
printf("You get on your knees and scrape away at the ground for\n") ;
printf("awhile. Except for getting your hands dirty you didn't\n") ;
printf("achieve much.\n") ;
	break ;

/* "stand" command */
case V_stand:
printf("You're standing there very nicely.  However you're not\n");
printf("achieving much by doing so.\n") ;
	break ;

/* "load" rifle command */
case V_load:
	loader() ;
	break ;

/* "unload" rifle command */
case V_unload:
	unloader(n) ;
	break ;

/* "pull" command */
case V_pull:
	if (tag[V_trigger]) {
		/* alias in the "shoot" command */
		verb = V_shoot ;
		tag[V_VERB_ONLY] = TRUE ;
		killer(n) ;   /* "pull trigger" */
	}
	else  printf("I don't see how I could pull that.\n") ;
	break ;

/* "climb" command */
case V_climb:
printf("I'm not climbing anything!  (I'm afraid of heights.)\n") ;
	break ;

/* "swim" command */
case V_swim:
printf("I'm not going for a swim!  (I'm afraid of the water.)\n") ;
	break ;

/* Go backwards to previous location */
case V_back:
	n = n_back ;
	goto loop ;
 
/* "take", "get", "lift" command */
case V_take:
case V_get:
case V_lift:
case V_pick:
case V_grab:
case V_remove:
case V_attach:
case V_hold:
	taker(n) ;
	break ;
 
/* "drop", "throw", "put" command */
case V_drop:
case V_throw:
case V_put:
case V_fling:
case V_insert:
case V_give:
case V_eject:
case V_slow_drop:
	dropper(n) ;
	break ;

/* "look" command */
case V_look:
case V_l:
case V_examine:
case V_describe:
	looker(n) ;
	break;

/* gibberish command */
default:
printf("Huh?  You will have to make yourself clearer! \n");

} /* end of "decoder" switch */
goto command;

} /* --- end of Main routine --- */

void cmd_switch(cmd, cmd_arg, i_point, argv)
/*****************************************************/
/*                                                   */
/*         --- Command line Switch Parser ---        */
/*                                                   */
/*  (c) Copyright 1992,   University of Queensland   */
/*        Program written by Gary A. Allen, Jr.      */
/*           Version:  Mk 1.1   24 February 1992     */
/*                                                   */
/*****************************************************/

char cmd[8], *argv[] ;
int cmd_arg, i_point ;
{
void switch_list(), description() ; 

switch (cmd[cmd_arg]) {
case '\0':
case -1:
	sw_null = TRUE ;
	return ;

/* Version verification command switch */
case 'v':
	if ((cmd[cmd_arg+1] == 'e')&&(cmd[cmd_arg+2] == 'r')) {
		printf("Version: %s, Serial Number: %06d %s \n", 
			lb_version, serial, lb_share) ;
		bugs(Request) ;
	}
	else {
		printf("!!!! Command line switch -v is unknown.\n") ;
		bugs(Failed) ;
	}

/* Wizard mode command switch */
case 'w':
case 'W':
	pass() ;
	break ;

/* Standard matrix load command switch */
case 's':
case 'S':
	sw_standard = TRUE ;
	break ;


/* Rubbish option to supress a warning */
case 'y':
case 'Y':
	sw_number = TRUE ;
	printf("y = %d\n", atoi(argv[i_point+1])) ;
	return ;

/* Help option */
case '?':
case 'h':
case 'H':
	sw_help = TRUE ;
	return ;

case ' ':
case '-':
case '1':
case '2':
case '3':
case '4':
case '5':
case '6':
case '7':
case '8':
case '9':
	return ;

default:
printf("!!!! Command line switch -%c is unknown.\n", cmd[cmd_arg]) ;
	bugs(Failed) ;
}
} /* --- end of the cmd_switch subroutine --- */

void bugs(i_type)
/***************************************************************/
/*                                                             */
/*       (c) Copyright 1992,   University of Queensland        */
/*            Program written by Gary A. Allen, Jr.            */
/*             Version:  Mk 1.0        24 April 1992           */
/*                                                             */
/***************************************************************/
int i_type ;
{
switch(i_type) {
case Failed:
	printf("!!!! If confused, type:  dinkum -h \n");
	printf("!!!! --- Program ABORTED --- \n");
	break ;

case Request:
	printf("Program terminated by user request.\n") ;
	break ;
}
exit (0) ; 
} /* --- end of the "bugs" subroutine --- */

void help() 
/*****************************************************/
/*                                                   */
/*                    Help Routine                   */
/*                                                   */
/*  (c) Copyright 1992,   University of Queensland   */
/*        Program written by Gary A. Allen, Jr.      */
/*           Version:  Mk 1.0    24 April 1992       */
/*                                                   */
/*****************************************************/
{
char chr ;

printf("                    --- Dinkum --- \n");
printf("       (c) Copyright 1990 by Gary A. Allen, Jr.\n") ;
printf("   All Rights Reserved. Version: %s, %s\n\n", 
		lb_version, lb_date);

printf("      Dinkum is a text style \"adventure\" game.\n\n") ;

printf("You are free to use, copy and distribute Dinkum provided:\n") ;
printf("       NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.\n") ;
printf("       THIS PROGRAM IS FOR PRIVATE, NONCOMMERICAL USE ONLY.\n");
printf("       THE PROGRAM MAY NOT BE MODIFIED IN ANY WAY.\n\n") ;

printf("This program is provided AS IS without any warranty,\n") ;
printf("expressed or implied, including but not limited to fitness\n") ;
printf("for any particular purpose.\n\n") ;

/* keep the screen from scrolling */
#ifndef __TURBOC__
printf("         [Press RETURN or ENTER to continue]") ;
chr = getchar() ;
#endif

#ifdef __TURBOC__
printf("  [Press \"q\" to quit or any other key to continue]") ;
chr = getche() ;
printf("\r                                                        \r") ;
#endif

if ((chr == 'q')||(chr == 'Q')) exit (0) ;

printf("When corresponding please state the current version of\n") ;
printf("Dinkum which you are using.  Contributions and questions\n") ;
printf("about this program should be sent to the following address:\n\n") ;
printf("          E-mail address:     gary@sun.mech.uq.oz.au\n\n") ;
printf("          Postal address:     Gary A. Allen, Jr. \n");
printf("                              P.O. Box 13\n") ;       
printf("                              St. Lucia, Queensland  4067\n");
printf("		 	 	            Australia\n") ;

exit(0);
} /* ---- end of the "help" subroutine ---- */

