/**********************************************************************/
/*   Added  value  functions for the splay tree library to make life  */
/*   easier.  These  may  not  be  efficient,  but  they make coding  */
/*   easier.							      */
/**********************************************************************/
# include	"sptree.h"
# include	"../foxlib/chkalloc.h"

static int splay_tree_size;
static int splay_index;
static void	sp_size_cb();
static void	sp_flatten_cb();

/**********************************************************************/
/*   This function returns the number of SPBLKs in a splay tree.      */
/**********************************************************************/
int
sp_size(tree)
SPTREE	*tree;
{	

	splay_tree_size = 0;
	spwalk(tree->root, sp_size_cb, 0);
	return splay_tree_size;
}
/**********************************************************************/
/*   Call back for above function.				      */
/**********************************************************************/
static void
sp_size_cb(node, arg)
SPBLK	*node;
int	arg;
{
	splay_tree_size++;
}

/**********************************************************************/
/*   The  following  function takes a splay tree and builds an array  */
/*   of  pointers  to  the SPBLKs, i.e. it flattens the tree so that  */
/*   the  calling  function  can perform a simple iterative function  */
/*   over  each  node  in  the tree rather than using the convoluted  */
/*   callback  mechanism  of  spwalk()  and  spapply().  The user is  */
/*   returned   a   chk_alloc()'ed  array  pointer,  with  the  last  */
/*   element being NULL. The user must free this array.		      */
/**********************************************************************/
SPBLK **
sp_flatten(tree)
SPTREE	*tree;
{	int	size;
	SPBLK	**array;
	
	size = sp_size(tree);
	array = (SPBLK **) chk_alloc((size + 1) * sizeof(SPBLK *));
	if (array == NULL)
		return NULL;
	splay_index = 0;
	spwalk(tree->root, sp_flatten_cb, array);
	array[splay_index] = NULL;
	return array;
}

/**********************************************************************/
/*   Call back function for above.				      */
/**********************************************************************/
static void
sp_flatten_cb(node, arg)
SPBLK	*node;
SPBLK	**arg;
{
	arg[splay_index++] = node;
}
