/**************************************************************
 *
 *	CRISP - Custom Reduced Instruction Set Programmers Editor
 *
 *	(C) Paul Fox, 1989
 *
 *    Please See COPYRIGHT notice.
 *
 **************************************************************/
# include	"list.h"

# define	K_START BUFFER *saved_bp = curbp; \
				curbp = scrbp; \
				set_hooked()
# define	K_END	curbp = saved_bp; \
			set_hooked()

int	scrap_type;
extern	BUFFER	*scrap_bp;
BUFFER	*scrbp;
static	LINE	*klp;
static	int	kline;

/**********************************************************************/
/*   Prototypes.						      */
/**********************************************************************/
void	k_init();
void	k_delete();
int	k_type PROTO((void));
void	k_newline PROTO((void));
void	k_seek PROTO((void));
int	k_read PROTO((char **));
void	k_end PROTO((void));

void
inq_scrap()
{
	if (argv[2].l_flags == F_INT)
		argv[2].l_sym->s_int = scrap_type;
	acc_assign_int((long) scrap_bp->b_bufnum);
}
void
k_init()
{
	scrbp = scrap_bp;
}
void	
k_delete(n) 
int	n;
{	
	register LINE *lp;
	int	line = 1;
	RSIZE	nbytes = 0;
	K_START;
	
	scrap_type = n;
	for (lp = linep(1); line < scrbp->b_numlines; line++) {
		nbytes += llength(lp) + 1;
		lp = lforw(lp);
		}
	*cur_line = 1;
	*cur_col = 1;
	if (nbytes > 0)
		nbytes--;
	if (nbytes)
		u_insert(nbytes, 0);
	bclear(scrbp);
	K_END;
}
void
k_write(buf, cnt)
u_char	*buf;
int	cnt;
{	K_START;

	llinsert((char *) buf, (u_int32) cnt, FALSE);
	K_END;
}
int
k_type()
{
	return scrap_type;
}
void
k_newline() 
{	K_START;
	lnewline();
	K_END;
}
void
k_seek()
{
	klp = lforw(scrbp->b_linep);
	kline = 1;
}
int
k_read(cpp)
char	**cpp;
{	int	used = klp->l_used;
	if (klp == scrbp->b_linep)
		return -1;
	*cpp = (char *) klp->l_text;
	klp = lforw(klp);
	return used;
}
/**********************************************************************/
/*   Return how many lines are in the scrap buffer.		      */
/**********************************************************************/
int
k_numlines()
{
	return scrbp->b_numlines;
}
void
k_undo()
{
	K_START;
	undo(0);
	K_END;
}
void
k_end()
{
	K_START;
	u_chain();
	K_END;
}
void
set_scrap_info()
{
	if (argv[2].l_flags == F_INT)
		scrap_type = argv[2].l_int;
}
