/**********************************************************************/
/*   Header file for self-organising integer library.		      */
/**********************************************************************/

# define	SINT_INCR	32 /* Size to increase size of array by */

typedef struct sentry_t {
	unsigned long se_key;	/* Key value.				*/
	char	*se_ptr;	/* Pointer to value.			*/
	} sentry_t;

typedef struct stype_t {
	short	st_need_sort;	/* TRUE when we insert into the object. */
	int	st_size;	/* Number of entries available.		*/
	int	st_used;	/* Number entries used so far.		*/
	sentry_t *st_block;	/* Array allocated to entry.		*/
	} stype_t;
	
stype_t		*st_alloc PROTO((void));
void		st_free PROTO((stype_t *));
void		st_insert PROTO((stype_t *, unsigned long, char *));
void		st_sort PROTO((stype_t *));
sentry_t	*st_lookup PROTO((stype_t *, unsigned long));
void		st_replace PROTO((stype_t *, sentry_t *, char *));
