#include	<sys/types.h>
#include	<sys/stat.h>
#include	<stdio.h>
#include	<curses.h>
#include	<errno.h>
#include	<time.h>
#include	"comb.h"

/*	this will have the routine to save a message to a file		*/
/*	and also the routine to update the mailbox at close of		*/
/*	the program.							*/

extern  HEADER	*current_top;
extern	HEADER	*current_msg;

static	FILE	*mailpipe;
static	FILE	*mailfile;

extern	char	dest[];
extern	char	printer[];
extern	char	command[];
extern	char	mailpath[];
extern	char	quotechar[];
extern	char	homedir[];
extern	char	shell[];
extern	char	organization[];
extern	char	editor[];
extern	char	pager[];
extern  char    sitename[];
extern	char	signature[];

extern	char	*uname(); /* just in case it's not in stdio.h */
extern	char	*getlogin();

extern  int	line;

static	char	ch;

extern	int	bell_pref;
extern	int	sort_pref;
extern	int	disp_pref;

int	indy_del;

char	month[12][4] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug",
			"Sep","Oct","Nov","Dec"};

/*	check for those silly ctrl-a ctrl-a end-of-message chars so	*/
/*	so we can promptly ignore them.					*/
#define ISCEOM(p)	((p)[0] == '\001' && (p)[1] == '\001' && (p)[2] == '\n')

int	dotcnt;

writemsg(msg)
HEADER	*msg;
{
	char	bufr[MAXBUF];


	if (msg != NULL)
	{
	    if (msg->status > 1)
		    if (indy_del == YES)
			{
			current_top = msg;
			current_msg = msg;
			redrawmenu();
			if (yesno("Delete this message (y/n)? ") == NO)
				msg->status = 0;
			}
	    if (msg->status < 2)
		{
		if (fseek(mailfile,msg->position,0) != 0)
			fail("Writemsg/Update: fseek on mailbox failed.");
		while((fgets(bufr,MAXBUF,mailfile)) != NULL)
		{
     		   if ((msg->next != NULL) &&
		       (ftell(mailfile) >= msg->next->position))
		   {
			fputs(bufr,mailpipe);
			if (fflush(mailpipe) == EOF)
				fail("Writemsg/Update: failed write.");
			break;
		   } /* position > msg->next->position */
		   else {
			fputs(bufr,mailpipe);
			if (fflush(mailpipe) == EOF)
				fail("Writemsg/Update: failed write.");
			dots(++dotcnt);
		   }
		} /* while fgets... != NULL */
		} /* msg->status <= 2 */
		writemsg(msg->next);
	}
}

int updatemailbox(first)
HEADER *first;
{
	char	*tmpbox;

	tmpbox = mktemp("/tmp/mailboxXXXXXX");

	if (yesno("Delete all messages marked for deletion (y/n)?  ") == NO)
	{
	    if(yesno("Individually confirm and delete marked messages (y/n)?  ")
							== NO) return FAIL;
	    else indy_del = YES;	/* confirm and delete each message */
	}
	/* rewrite mailbox, removing all messages marked for deletion */

	if ((mailfile = fopen(mailpath,"r")) == NULL)
		fail("Updatemailbox: Could not open mail box");
	if ((mailpipe = fopen(tmpbox,"w")) == NULL)
		fail("Updatemailbox: Could not open temp file");

	dotcnt = 0;
	writemsg(first);

	fclose(mailpipe);
	fclose(mailfile);

	sprintf(command, "cp %s .mailbox.old", mailpath);
	if (system(command) != 0)
		fail("Updatemailbox: cannot save old mailbox");

	sprintf(command, "cp %s %s", tmpbox, mailpath);
	if (system(command) != 0) {
		sprintf(command, "cp .mailbox.old %s", mailpath);
		system(command);	/* Restore old mailbox */
		fail("Updatemailbox: Couldn't update mailbox, restoring old mailbox");
	}

	unlink(tmpbox);
	unlink(".mailbox.old");	/* remove this if you want added safety */
	return 0;
}

/* this is to avoid duplication of effor in forwardmsg	*/
/* write a particular message to a file.		*/
filemsg(filethis,where,quoteit)
HEADER *filethis;
char *where;
int quoteit;	/* quote message?	 */
{

	char	bufr[MAXBUF];

	dotcnt = 0;

	if ((mailfile = fopen(mailpath,"r")) == NULL)
		fail ("filemsg:  Could not open mailbox.");
	if ((mailpipe = fopen(where,"w")) == NULL)
		fail ("filemsg:  Could not open savefile.");
	if (fseek(mailfile,filethis->position,0) != 0)
		fail ("filemsg:  fseek on mailbox failed.");

	while((fgets(bufr,MAXBUF,mailfile)) != NULL) {

		if((filethis->next != NULL) &&
		(ftell(mailfile) >= filethis->next->position))
		{
			if ((quoteit == YES) && (!ISCEOM(bufr)))
				fprintf(mailpipe,"%s%s",quotechar,bufr);
			else if (!ISCEOM(bufr)) fputs(bufr,mailpipe);
			break;
		}
		if ((quoteit == YES) && !(ISCEOM(bufr)))
			fprintf(mailpipe,"%s%s",quotechar,bufr);
		else	if (!ISCEOM(bufr)) fputs(bufr,mailpipe);
		dots(++dotcnt);
	}
	fclose(mailfile);
	fclose(mailpipe);
}

savemsg(savethis)
HEADER *savethis;
{
	/* write message to file specified by user.		      */
	/* here again, we could use an option to strip header.	      */
	struct	stat	mailstat;
	char	smsg[MAXLINE];
	int	result;

	clearworkarea();
	dest[0] = '\0';
	result = 0;
	while (strlen(dest) == 0)
	{
		mvaddstr(18,1,"Filename to save to: ");
		refresh();
		getpath(dest);	/* might as well. */
		if (dest[0] == '\033') return;	
		if (dest[0] == '\0') return;
		addch(" ");
		if(stat(dest,&mailstat) == 0)
			{
			sprintf(smsg,"File %s exists, overwrite (y/n)? ",dest);
			result = yesno(smsg);
			if (result == ESCAPE) return;
			if (result == NO) dest[0] = '\0';
			}
	}
	filemsg(savethis,dest,DONTQUOTE);
}

ninelines(fname)
char *fname;
{
	int	nine = 9;
	int	v = 6;
	char	bufr[MAXBUF];
	char	buf2[MAXBUF];

	if ((mailpipe = fopen(fname,"r")) == NULL)
		fail("Ninelines: Could not open file");
	while ((--nine != 0) && (fgets(bufr,MAXBUF,mailpipe)) != NULL)
	{
		if ((bufr[0] != '\001') && (bufr[1] != '\001'))
		{
		move(v++,0);
		stripnl(bufr,buf2);
		printw("%-79s",buf2);
		}
	}
	fclose(mailpipe);
}

beep()
{ /* no support for visual-bell yet */
	if (bell_pref == BELLRINGIT)
		printf("\007\b");
}

clearworkarea()
{
	/* clear area of screen where user inputs information		*/
	/* no refresh, because it's usually followed by a prompt	*/
	MVCEOL(17,0);
	MVCEOL(18,0);
	MVCEOL(19,0);
}

clearmenu()
{
	move(17,0); clrtobot();
}

int yesno(mssg)
char *mssg;
/* specific to this program:  clear "work area", ask question 'mssg' 	*/
/* then return value of answer.						*/
{
	MVADDCEOL(18,1,mssg);
	refresh();
	while (ch = getch())
		switch (ch)
		{
		case 'Y'	:
		case 'y'	:	return (YES);
		case 'n'	:
		case 'N'	:	return (NO);
		case '\033'	:	return (ESCAPE);
		default		:	beep();
		}
}


/* use environment variables to override compiled defaults */
environment()
{
	char	pathjunk[MAXLINE];
	char	*junk;
	int	ind;

	/*	default the following	*/
	sort_pref	= SORTCHRONO;
	disp_pref	= 0; /* don't display anything */
	bell_pref	= BELLRINGIT;

	if((junk = getenv("PRINTDEV")) != NULL)
		strcpy(printer,junk);
	else strcpy(printer,DEF_PRINTER);
	if((junk = getenv("HOME")) != NULL)
		strcpy(homedir,junk);
	if((junk = getenv("SHELL")) != NULL)
		strcpy(shell,junk);
	if((junk = getenv("ORGANIZATION")) != NULL)
		strcpy(organization,junk);
	else strcpy(organization,DEF_ORGANIZATION);
	if((junk = getenv("EDITOR")) != NULL)
		strcpy(editor,junk);
	else strcpy(editor,DEF_EDITOR);
	if((junk = getenv("PAGER")) != NULL)
		strcpy(pager,junk);
	else strcpy(pager,DEF_PAGER);
	if((junk = getenv("QUOTE")) != NULL)
		strcpy(quotechar,junk);
	else strcpy(quotechar,DEF_QUOTE);
	if((junk = getenv("SIGNATURE")) != NULL)
		strcpy(signature,junk);
	else signature[0] = '\0';
	
	strcpy(sitename,uname());

	if (strlen(mailpath) == 0) {
		if((junk=getenv("MAILPATH")) != NULL)
		{
		if (strlen(junk) == 0)
			fail("MAILPATH is exported but contains no path");
		strcpy(mailpath,junk);
		}
		else strcpy(mailpath,DEF_MAILPATH);
	}
	/* open-ended directory at end of mailpath? */
	strcpy(pathjunk,mailpath);
	while(pathjunk[ind++] != '\0');
	ind -= 2;
	if (pathjunk[ind] == '/') { /* append login-name */
		if ((junk = getlogin()) == NULL)
			fail("Could not identify you.");
		strcat(mailpath,junk);
	}
}

/* check if there has been mail since the last call	*/
int ismail()
{
	static	time_t	then;
	struct	stat	mailstat;

	if(stat(mailpath,&mailstat) != 0)
		{
			fail("ismail(): could not open mailbox");
		}
	if(mailstat.st_size == 0) return NO;
	if(mailstat.st_mtime < then)
	{
		time(&then);
		return NO;
	}
	if(mailstat.st_mtime > then)
	{
		time(&then);
		return YES;
	}
}

/*	stupid function that indicates program is working	*/
/*	and not frozen.						*/
dots(d)
int	d;
{
	if ((d > 99) && (d % 100 == 0))
	{
		printf(" \b\b\b\b\bo\b");
	}
	else
	{
		if ((d > 19) && (d % 20 == 0)) printf(".o\b");
	}
	fflush(stdout);
}


 
