#include	<stdio.h>
#include	<curses.h>
#include	"comb.h"

static FILE	*mailpipe;
static FILE	*mailfile;

extern char	editor[];
extern char	dest[];
extern char	subject[];
extern char	organization[];
extern char	command[];
extern char	mailpath[];
extern char	signature[];

static char	ch;

char	destinfo[MAXLINE];	/* value returned by route() */
char	tmp[MAXLINE];		/* tmp storage area */

sendmsg()
{
	char	tmpsnd[MAXLINE];

	char	*junk;
	int	tempfile;

	clearworkarea();
	

	dest[0] = '\0';
	while (strlen(dest) == 0) {
		MVADDCEOL(17,1,"Send Message To: ");
		refresh();
		getpath(dest);
		if (dest[0] == '\033') return;
		destinfo[0] = '\0';
		strcpy(tmp,route(dest,destinfo));
		stripnl(tmp,dest);
		mvaddstr(17,18,dest);
		if (strlen(destinfo) != 0) printw(" (%s)",destinfo);
		clrtoeol();
		if (strlen(dest)==0)
			{ beep();
			  mvaddstr(18,1,"Could not interpret address."); }
	}
	MVADDCEOL(18,1,"Subject: ");
	refresh();
	getpath(subject);
	if (subject[0] == '\033') return;
	junk = mktemp("/tmp/mailXXXXXX");
	strcpy(tmpsnd,junk);
	if ((tempfile = creat(tmpsnd,0600)) < 0)
		fail("Sendmsg:  Could not creat() tmpfile");
	close(tempfile);
	sendthis(tmpsnd);	

}

confirm(confirmthis)
char	*confirmthis;
{
	int result;
	char	bufr[MAXBUF];

	clear();
	while (YES)
	{
		mvaddstr(01,1,"To       : ");
		mvaddstr(03,1,"Subject  : ");
		standout();
		MVCEOL(01,12);
		MVADDCEOL(01,12,dest);
		mvaddstr(03,12,subject);
		mvaddstr(17,1,"M"); mvaddstr(18,1,"C");
		mvaddstr(19,1,"E"); mvaddstr(20,1,"D");
		mvaddstr(21,1,"S");
		standend();
		MVCEOL(02,12);
		if (strlen(destinfo) != 0) printw("(%s)",destinfo);
		ninelines(confirmthis);	/* print first 9 lines of msg */
		if (strlen(dest) == 0)
			mvaddstr(15,1,"You forgot to include a destination.");
		mvaddstr(17,3,"Mail this message");
		mvaddstr(18,3,"Cancel sending of this message.");
		mvaddstr(19,3,"Edit this message again.");
		mvaddstr(20,3,"change Destination of this message.");
		mvaddstr(21,3,"change Subject of this message.");
		mvaddstr(05,0,"[first nine lines of message]");
		MVADDCEOL(23,1,"Please select M, C, E, D or S: ");
		refresh();
		ch = getch();
		switch (ch)
		{
		case 'M' :
		case 'm' : if (strlen(dest) > 0) {
			addstr("Mailing..."); refresh();
		    /* okay, mail it.  need error-check here */
		    sprintf(command,"mail %s",dest);

		    /* put message onto pipe to mail, insert SUBJECT: */
		    /* and XMAILER: lines (prepend)			  */
		    if ((mailfile = fopen(confirmthis,"r")) == NULL)
			fail("Sendmsg: Could not re-open tmp mail file");

		    if ((mailpipe = popen(command,"w")) == NULL)
			fail("Sendmsg: Could not open pipe to mailer.");

		    fprintf(mailpipe,"Organization: %s\n",organization);
		    fprintf(mailpipe,"X-Mailer: %s CoMB %s\n",XMAILER, VERSION);
		    fprintf(mailpipe,"Subject: %s\n",subject);
		    while ((ch = fgetc(mailfile)) != EOF)
			fputc(ch,mailpipe);

		    if (fclose(mailfile) == EOF)
			fail("Sendmsg: Could not close tmp mail file.");
		    /* pclose rtrns same status as wait, add error-checking. */

		    /* SIGNIT? */
		    if(signature[0] != '\0')
		    {
			if ((mailfile = fopen(signature,"r")) == NULL)
			{
				fail("sendmsg: could not open signature file");
			}
			while(fgets(bufr,MAXBUF,mailfile) != NULL)
			{
				fputs(bufr,mailpipe);
			}
		    }

		    pclose(mailpipe);
		    
		    move(15,1); clrtobot();
	    	    result = yesno("Message Sent.  Send copy to another address (y/n)? ");
		    if (result == YES)
			{
			   move(15,1); clrtobot();refresh();
			   dest[0] = '\0';
			   while (strlen(dest) == 0) {
				   MVCEOL(1,12);
				   refresh();
				   getpath(dest); 
				   if (dest[0] == '\033')
					{ dest[0] = '\0'; break; }
				   destinfo[0] = '\0';
				   strcpy(tmp,route(dest,destinfo));
				   stripnl(tmp,dest);
				   if (strlen(dest) == 0)
					{
				MVADDCEOL(15,1,"Cannot interpret address. ");
				beep();
					}
				}
			   MVCEOL(15,1);
			}
			else /* send another copy? */
			{ unlink(confirmthis); return; }
		    refresh();
		    break;
		} else { /* destination is blank */
			beep();
			break;
		}
		case '\033' : case 'q' : case 'Q' : case 'c' :
		case 'C' : { unlink(confirmthis); return; break; }
		case 'e' : 
		case 'E' : {	addstr("Editing...");
				
				sprintf(command,"%s %s",editor,confirmthis);
				echo(); noraw();
				system(command);
				raw(); noecho();
				clear(); break; }
		case 'd' :
		case 'D' : {

			   dest[0] = '\0';
			   while (strlen(dest) == 0) {
				   MVCEOL(1,12);
				   refresh();
				   getpath(dest); 
				   if (dest[0] == '\033')
					{ dest[0] = '\0'; break; }
				   destinfo[0] = '\0';
				   strcpy(tmp,route(dest,destinfo));
				   stripnl(tmp,dest);
				   if (strlen(dest) == 0)
					{
				MVADDCEOL(15,1,"Cannot interpret address. ");
				beep();
					}
				}
			   MVCEOL(15,1);
			   break;
			   }
		case 's' : 
		case 'S' : {
			   MVCEOL(3,12);
			   refresh();
			   getpath(subject);
			   if (subject[0] == '\033')
				subject[0] = '\0';
			   break;
			   }
		default  : beep();
		}
	} /* while (YES) */
} /* confirm() */

sendthis(tosend)
char *tosend;
{
	/* invoke editor */
	echo(); noraw();
	sprintf(command,"%s %s",editor,tosend);
	system(command);
	noecho(); raw();
	/* confirm */
	confirm(tosend);
}

getpath(towho)
char towho[];
{
	getst(towho);
}

forwardmsg(forwardto)
HEADER *forwardto;
{
	char	tmpsnd[MAXLINE];
	char	*junk;

	clearworkarea();

	dest[0] = '\0';

	while (strlen(dest) == 0)
	{
		MVADDCEOL(17,1,"Forward message to: ");
		refresh();
		getpath(dest);
		if (dest[0] == '\033') return;
		destinfo[0] = '\0';
		strcpy(tmp,route(dest,destinfo));
		stripnl(tmp,dest);
		if (strlen(dest)==0)
			{ beep();
			  mvaddstr(18,1,"Could not interpret address."); }
	}
	strcpy(subject,forwardto->subject);
	strcat(subject," (forwarded)");
	junk = mktemp("/tmp/forwardXXXXXX");
	strcpy(tmpsnd,junk);
	filemsg(forwardto,tmpsnd,QUOTEIT);
	confirm(tmpsnd);
}

replymsg(replyto)
HEADER *replyto;
{
	char	tmpsnd[MAXLINE];
	char	*junk;
	int	tempfile;
	int	result;

	strcpy(destinfo,"Check address, reply-path parser is not THAT smart.");
	strcpy(dest,replyto->from_path);
	strcpy(subject,"Re: ");
	strcat(subject,replyto->subject);
	junk = mktemp("/tmp/replyXXXXXX");
	strcpy(tmpsnd,junk);
	result = yesno("Quote Message (y/n)? ");
	if (result == ESCAPE) return;
	if (result == YES)
		filemsg(replyto,tmpsnd,QUOTEIT);
	else {	/* don't quote it!, create a blank file instead. */
		if ((tempfile = creat(tmpsnd,0600)) < 0)
			fail("Replymsg: Could not creat() tempfile");
		close(tempfile);
	}
	sendthis(tmpsnd);
}

