#include	<sys/types.h>
#include	<time.h>
#include	<curses.h>
#include	<string.h>

#include	"comb.h"

WINDOW	*glass;

extern	HEADER	*root;
extern	HEADER	*current_msg;
extern	HEADER	*current_top;
extern	HEADER	*current_bot;

extern	int	ismail();

extern	int	num_msgs;
extern	int	deleted_msgs;

extern	int	sort_pref;
extern	int	disp_pref;

extern	char	month[12][4];
extern  char	mailpath[];

int	line;

show_headers()
{
	line = 3;


	if(ismail() == YES)
		{	/* add new mail to linked-list */
		mvaddstr(1,27,"You have received new mail.");
		rescan();
		/* maybe we're starting with an empty-mail box	*/
		/* fix pointers if that's true.			*/
		if (current_msg == NULL)
			{
			current_msg = root;
			current_top = root;
			}
		}

	move(0,27);	/* stats */
	printw("%2d Messages (%2d Deleted)",num_msgs,deleted_msgs);

	if(current_msg != NULL) display_headers(current_top);
	else mvaddstr(5,4,"You have no mail.");
	if (sort_pref == SORTRECEIVED) {
		if(current_top->prev != NULL)
			mvaddstr(3,73,"-more-");
		else mvaddstr(3,73,"-top- ");
		if(current_bot->next != NULL)
			mvaddstr(16,73,"-more-");
		else mvaddstr(16,73,"-end- ");
	}
	else { /* sort_pref == SORTCHRONO */
		if(current_top->next != NULL)
			mvaddstr(3,73,"-more-");
		else mvaddstr(3,73,"-top- ");
		if(current_bot->prev != NULL)
			mvaddstr(16,73,"-more-");
		else mvaddstr(16,73,"-end- ");
	}

}

titlepage()
{





	mvaddstr(05,19," ________             ____ ____   _______");
	mvaddstr(06,19,"|          ________  |    |    | |       |");
	mvaddstr(07,19,"|         |        | |    |    | |_______|");
	mvaddstr(08,19,"|         |        | |    |    | |        |");
	mvaddstr(09,19,"|________ |________| |    |    | |________|");

	move(12,19); printw("Coherent Mail Box, v%s",VERSION);
	mvaddstr(14,19,"(C)1991 Richard Nickle");
	mvaddstr(15,19,"   All Rights Reserved. This Is Free Software");
	mvaddstr(17,19,"Comments/Suggestions: fcsys!trystro!rick@think.com");
	mvaddstr(19,19,"Mailbox           : "); printw("%s",mailpath);
	mvaddstr(21,19,"Processing Message: ");
}

display_headers(message)
HEADER *message;
{
	char	junk[LSUBJ];

	if ((message != NULL) && (line < 15))
	{
		line++;
		standend(); 

		switch (message->status)
		{
			case 1 : {mvaddstr(line,0,"R ");break;}
			case 2 : {mvaddstr(line,0," D");break;}
			case 3 : {mvaddstr(line,0,"RD");break;}
			default: {mvaddstr(line,0,"  ");break;}
		}
		if (message->position == current_msg->position) 
		{	
			standout();
			move(line, 3); printw(">");
			if (disp_pref == SHOWBYTE) {
				move(line,71); printw("  %6D",message->size);
			}
			if (disp_pref == SHOWLINE) {
				move(line,71); printw("  %6d",message->lines);
			}
		}
		else { move(line,3); printw(" ");
		       move(line,71); clrtoeol();
		}
		move(line, 4); printw(" %-20.20s",message->from_who);
		move(line,24); printw("  %-6s  ",message->when_sent);
		if (disp_pref == 0)
		  {
			move(line,34);
			printw("%-*s ",LSUBJ-1,message->subject);
		  }
		else {
			move(line,34);
			strncpy(junk,message->subject,LSUBJ-8);
			if (strlen(message->subject) > LSUBJ-8)
			{
				junk[LSUBJ-8] = '\0';
				junk[LSUBJ-9] = '$';
			}
			printw("%-*s ",LSUBJ-8,junk);
		}
		standend();
/*		if (line == 15) 
*/			current_bot = message;
		if (sort_pref == SORTCHRONO)
			display_headers(message->prev);
		if (sort_pref == SORTRECEIVED)
			display_headers(message->next);
	}
	else move(18,10);
}

showtime()
{
	time_t	timenumber;

	struct tm *current;

	int	hour;

	standout();
	time(&timenumber);
	current = localtime(&timenumber);
	hour = current->tm_hour;
	if (hour == 0) hour = 12;
	if (hour > 12) hour = hour - 12;
	move(0,65);
	printw("%3s %2d ",month[current->tm_mon],current->tm_mday);
	printw("%02d:%02d ",hour,current->tm_min);
	if ((current->tm_hour > 0) && (current->tm_hour < 12))
			printw("am");
		else printw("pm");
	standend();
}

drawmenu()
{

	standout();

	mvaddstr(0,1,"Mail Box:");
	mvaddstr(2,0,"__");
	mvaddstr(2,4,"From");
	mvaddstr(2,26,"Date");
	mvaddstr(2,34,"Subject");
	standend();

	if (disp_pref == SHOWBYTE)
		mvaddstr(2,72,"(bytes)");
	if (disp_pref == SHOWLINE)
		mvaddstr(2,72,"(lines)");


	showtime();

	mvaddstr(21,55,"(c)1991 Rick Nickle");
	mvaddstr(22,55,"CoMB: Coherent Mailbox");
	mvaddstr(23,55,"Version: ");
	printw("%s",VERSION);

	mvaddstr(20,1,"J Down    K Up               Read      P Print");
	mvaddstr(21,1,"M Mail    R Reply    F       Forward   # Sub-shell");
	mvaddstr(22,1,"D Delete  U Undelete S       Save      C Configure");
	mvaddstr(23,1,"? Help   ^L Redraw   Q       Quit");
	standout();
	mvaddstr(20,1,"J"); mvaddstr(20,11,"K"); mvaddstr(20,22,"<ENTER>");
	mvaddstr(20,40,"P");
	mvaddstr(21,1,"M");	mvaddstr(21,11,"R");	mvaddstr(21,22,"F");
	mvaddstr(21,40,"#");

	mvaddstr(22,1,"D");	mvaddstr(22,11,"U");	mvaddstr(22,22,"S");
	mvaddstr(22,40,"C");
	mvaddstr(23,1,"?");	mvaddstr(23,10,"^L");	mvaddstr(23,22,"Q");
	standend();

	mvaddstr(18,1,"Command: "); refresh();
}

redrawmenu()
{
	clear();
	clearmenu();
	show_headers();
	drawmenu();
	refresh();
}
