/*   This file contains all routines concerning monsters   */

# include <curses.h>

# include "INCLUDE/windows.h"
# include "INCLUDE/monst.h"
# include "INCLUDE/items.h"
# include "INCLUDE/castle.h"
/*
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+   Routines in this Module:                                                +
+                                                                           +
+       combat()        - All combat operations run from here.              +
+       show_monst(mon) - Show the appropriate picture for mon.             +
+       monst()         - Set up monster configurations.                    +
+       make_dam(R,M)   - Calculate damages R = rand_max, M = Multplier     +
+       get_monst()     - Choose an appropriate monster for this level.     +
+       monst_att(mon)  - Run monster attack routine.                       +
+       abil_one(mon)   - Have monster hit you for damage.                  +
+       abil_two(mon)   - Monster drains your strength.                     +
+       abil_three(mon) - Monster fries you.                                +
+       abil_four(mon)  - The monster blasts you with an electric sphere.   +
+       abil_five(mon)  - The Creature drains your hitpoints.               +
+       abil_six(mon)   - The Creature chokes you for damage.               +
+       abil_seven(mon) - The Creature burns you for damage.                +
+       abil_eight(mon) - The Creature Breaths fire breath at you.          +
+       abil_nine(mon)  - The Creature Causes you to gasp for air.          +
+       abil_ten(mon)   - The Creature is capable of many of the above.     +
+       abil_twelve(mon)- Does a big hit, not like abil_one which depends   +
+                         on monster level.                                 +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	This is a public domain program, I have no objection to modifications
made on it or use for some other reason so long as this notice remains intact.

	
		Part of:  castle 	Ted Wisniewski
		Author:			Plymouth State College
					Plymouth NH,
						    03264
		Copyright() PSC

		Ported to Coherent by Udo Munk		Oberstr. 21
							4040 Neuss 1
							Germany
		mwcbbs!umunk!udo
*/
combat()
{
	int mon,hit,Au,test;
	int run_att = FALSE;
	char get;

	run_away = FALSE;
	mon = get_monst();	/*  Make more monsters so get_monst   	*/
	m_killed = FALSE;	/*  can be used.			*/
	mon_faced = TRUE;
	if(mon == WIN_CRE)
	  run_att = TRUE;
	m_temp.m_hp = m[mon].m_hp;
	show_monst(mon);
	clr_mess_win();
	sprintf(wrk_buf,"You face a %s.",m[mon].monster);
	print_mess(wrk_buf,0,0);
	wrefresh(message_win);
	while(!m_killed && !run_away){
	  print_mess("F)ight R)un D)efend C)ast U)se L)ookup ",1,0);
	  wrefresh(message_win);
	  get = wgetch(message_win);
	  wmove(message_win,2,0);
	  switch (get){
	     case 'f' :
	     case 'F' : test = (35 + char_stats.dexterity);
			wclear(message_win);
			if(rand()%50 < test){
			  m_temp.m_hp -= hit = make_dam(d_val,d_mod);
			  wclear(message_win);	
			  sprintf(wrk_buf,"You did %d points of damage.",hit);
			  print_mess(wrk_buf,2,0);
			}else
			  print_mess("You Missed Him.",2,0);
			wrefresh(message_win);
			sleep(1);
			if(m_temp.m_hp > DEAD)
			  monst_att(mon);
	     break;
	     case 'c' :
	     case 'C' : spells();
			if(!run_away)
			if(m_temp.m_hp > DEAD)
			  monst_att(mon);
	     break;
	     case 'r' :
	     case 'R' : if(!run_att) {
			  if(rand()%18 + 3 < char_stats.dexterity)
			   run_away = TRUE;
			  else{
			   run_att = TRUE;
			   print_mess("You can\'t get away!",2,0);
			   wrefresh(message_win);
			  }
			}else{
			  print_mess("You can\'t get away!",2,0);
			  wrefresh(message_win);
			}
	     break;
	     case 'l' :
	     case 'L' :
		      exp_spell();
		      break;
	     case 'u' :
	     case 'U' :
		      use_it();
		      break;
	     case 'd' :
	     case 'D' : if(m_temp.m_hp > DEAD){
			  char_stats.ac += 4;
			  monst_att(mon);
			  char_stats.ac -= 4;
			}
	     break;
	     case RE_DRAW:
		redraw();
		show_monst(mon);
	     break;
	     default :
	     break;
      	  }
	  if(m_temp.m_hp < 0)
	    m_killed = TRUE;  
	  if(char_stats.hitpoints < 0){
	    strcpy(tmp.death_by,m[mon].monster);
	    death();
	  }
	}
	mon_faced = FALSE;
	if(m_killed){
	   wclear(message_win);
	   sprintf(wrk_buf,"You killed a %s. ",m[mon].monster);
	   print_mess(wrk_buf,1,0);
	   if(mon == WIN_CRE){
		char_stats.experience += 50000L;
		strcpy(tmp.death_by,"Old Age");
		death();
	   }
	   if(mon == 0)
	     mon = 1;
	   char_stats.gold += Au = 10 * (rand()%mon + 1);
	   sprintf(wrk_buf,"You find %d in Gold. ",Au);
	   print_mess(wrk_buf,2,0);
	   char_stats.experience += m[mon].m_hp;
	   gain_lvl();
	   print_stats();
	   wrefresh(message_win);
	   sleep(1);
	}
	wrefresh(message_win);
	clr_mess_win();
	show_scr();
}

show_monst(m_num)	
int m_num;
{
	int row,col;
	
	wmove(view_win,0,0);
	for(row=0;row<=11;row++)
	   for(col=0;col<=26;col++)
	       wprintw(view_win,"%c",mon_scr[m[m_num].m_scr][row][col]);
	wrefresh(view_win);
	wmove(command_win,0,0);
	wrefresh(command_win);
}

monst()
{
		      /*   First Level Monsters   */

	strcpy(m[0].monster,"Horde");      
	m[0].m_lvl = 1; m[0].ability = 1; m[0].m_hp = 2;  m[0].m_scr  = 3;
	
	strcpy(m[1].monster,"Conjurer 1st");
	m[1].m_lvl = 1; m[1].ability = 1; m[1].m_hp = 4;  m[1].m_scr  = 0;

	strcpy(m[2].monster,"Spider");		
	m[2].m_lvl = 1; m[2].ability = 2; m[2].m_hp = 3;  m[2].m_scr  = 1;

	strcpy(m[3].monster,"Magician 1st");
	m[3].m_lvl = 1; m[3].ability = 3; m[3].m_hp = 6;  m[3].m_scr  = 0;

	strcpy(m[4].monster,"Warrior 1st");		
	m[4].m_lvl = 1; m[4].ability = 1; m[4].m_hp = 8; m[4].m_scr = 4;

	strcpy(m[5].monster,"Priest 1st");		
	m[5].m_lvl = 1; m[5].ability = 5; m[5].m_hp = 5; m[5].m_scr = 5;

	strcpy(m[6].monster,"Flying Serpent");		
	m[6].m_lvl = 1; m[6].ability = 6; m[6].m_hp = 7; m[6].m_scr = 2;

		/*  Second Level Monsters    */
	
	strcpy(m[7].monster,"Cannibal");		
	m[7].m_lvl = 2; m[7].ability = 1; m[7].m_hp = 7; m[7].m_scr = 6;

	strcpy(m[8].monster,"Illusionist");		
	m[8].m_lvl = 2; m[8].ability = 3; m[8].m_hp = 11; m[8].m_scr = 0;

	strcpy(m[9].monster,"Priest 2nd");		
	m[9].m_lvl = 2; m[9].ability = 5; m[9].m_hp = 12; m[9].m_scr = 5;

	strcpy(m[10].monster,"Warrior 2nd");		
	m[10].m_lvl = 2; m[10].ability = 1; m[10].m_hp = 13; m[10].m_scr = 4;

	strcpy(m[11].monster,"Stinger");		
	m[11].m_lvl = 2; m[11].ability = 2; m[11].m_hp = 6;  m[11].m_scr  = 1;
	
	/*          Level 3 monsters  		*/

	strcpy(m[12].monster,"Mage 1st");		
	m[12].m_lvl = 3; m[12].ability = 3; m[12].m_hp = 17; m[12].m_scr = 0;

	strcpy(m[13].monster,"Fire Lion");		
	m[13].m_lvl = 3; m[13].ability = 7; m[13].m_hp = 21; m[13].m_scr = 7;

	strcpy(m[14].monster,"Swordsman");		
	m[14].m_lvl = 3; m[14].ability = 1; m[14].m_hp = 19; m[14].m_scr = 14;

	strcpy(m[15].monster,"Brother 1st");		
	m[15].m_lvl = 3; m[15].ability = 5; m[15].m_hp = 18; m[15].m_scr = 5;

	strcpy(m[16].monster,"Head Banger");		
	m[16].m_lvl = 3; m[16].ability = 1; m[16].m_hp = 15; m[16].m_scr = 6;

	/*      Level 4  monsters		*/

	strcpy(m[17].monster,"Vapor Cloud");		
	m[17].m_lvl = 4; m[17].ability = 9; m[17].m_hp = 18; m[17].m_scr = 8;

	strcpy(m[18].monster,"Minor Demon");		
	m[18].m_lvl = 4; m[18].ability = 8; m[18].m_hp = 22; m[18].m_scr = 9;

	strcpy(m[19].monster,"Killer Robot");		
	m[19].m_lvl = 4; m[19].ability = 1; m[19].m_hp = 18; m[19].m_scr = 10;

	strcpy(m[20].monster,"Griffon");		
	m[20].m_lvl = 4; m[20].ability = 1; m[20].m_hp = 20; m[20].m_scr = 11;
	
	/*   	Level 5 monsters		*/

	strcpy(m[21].monster,"Electric Knight");
	m[21].m_lvl = 5; m[21].ability = 4; m[21].m_hp = 21;  m[21].m_scr  = 14;

	strcpy(m[22].monster,"Red Dragon Fly");
	m[22].m_lvl = 5; m[22].ability = 7; m[22].m_hp = 16; m[22].m_scr  = 2;

	strcpy(m[23].monster,"Druid ");
	m[23].m_lvl = 5; m[23].ability = 4; m[23].m_hp = 19; m[23].m_scr  = 12;

	strcpy(m[24].monster,"Master Mage");
	m[24].m_lvl = 5; m[24].ability = 3; m[24].m_hp = 26; m[24].m_scr  = 13;

	strcpy(m[25].monster,"Wizard");
	m[25].m_lvl = 5; m[25].ability = 10; m[25].m_hp = 34; m[25].m_scr  = 13;

	strcpy(m[26].monster,"Phantom");		
	m[26].m_lvl = 5; m[26].ability = 11; m[26].m_hp = 23; m[26].m_scr = 9;

		/* level 6 monsters */

	strcpy(m[27].monster,"Ninja");
	m[27].m_lvl = 6; m[27].ability = 13;m[27].m_hp = 25;  m[27].m_scr  = 14;

	strcpy(m[28].monster,"Head Master");		
	m[28].m_lvl = 6; m[28].ability = 1; m[28].m_hp = 25; m[28].m_scr = 6;

	strcpy(m[29].monster,"High Priest");		
	m[29].m_lvl = 6; m[29].ability = 5; m[29].m_hp = 27; m[29].m_scr = 5;

		/* level 7 monsters    */

	strcpy(m[30].monster,"Thunder Cloud");		
	m[30].m_lvl = 7; m[30].ability = 4; m[30].m_hp = 27; m[30].m_scr = 8;

	strcpy(m[31].monster,"Flame Lion");		
	m[31].m_lvl = 7; m[31].ability = 8; m[31].m_hp = 33; m[31].m_scr = 7;

	strcpy(m[32].monster,"Smoky Dragon");		
	m[32].m_lvl = 7; m[32].ability = 8; m[32].m_hp = 42; m[32].m_scr = 15;

		/* level 8 monsters    */

	strcpy(m[33].monster,"Sleepy Dragon");		
	m[33].m_lvl = 8; m[33].ability = 9; m[33].m_hp = 53; m[33].m_scr = 15;

	strcpy(m[34].monster,"Wraith");		
	m[34].m_lvl = 8; m[34].ability = 11; m[34].m_hp = 39; m[34].m_scr = 9;

		/* level 9 monsters */
	
	strcpy(m[35].monster,"Hungry Dragon");		
	m[35].m_lvl = 8; m[35].ability = 9; m[35].m_hp = 64; m[35].m_scr = 15;

		/* level 10 monster  (win creature)  */

	strcpy(m[36].monster,"The Wiz");		
	m[36].m_lvl = 10;m[36].ability = 12;m[36].m_hp = 260;m[36].m_scr = 13;

/*	Ideas:   Phantasmist, Holy Warder
*/
}

make_dam(rnd,mult)
int rnd,mult;
{
	int total = 0,x;

	for(x=1;x<=mult;x++)
		total += ((rand()%rnd)+1);
	return(total);
}

int get_monst()
{
	int min,max;
			/* min = First monster in level group */
			/* max = Last monster in level group  */
			/* returns choice from monsters of the*/
			/* 	   level group.		      */

	switch (p->level){
	case 1: min = 0; 	/* Relatively Easy     */
		max = 7;
	break;					
	case 2: min = 6;	/* A little Tougher    */
		max = 13;
	break;
	case 3: min = 10;	/* Moderately Tough    */
		max = 20;
	break;
	case 4: min = 16;	/* Difficult	       */
		max = 27;
	break;
	case 5: min = 22;	/* Very Difficult      */
		max = 32;
	break;
	case 6: min = 29;
	        max = 36;
	break;
	}
    return(rand()%((max + 1) - min) + min);
}

lose_lvl()
{
	int hitpt, sppt;

	if(char_stats.level < 35)
	if(exp[char_stats.level] > char_stats.experience)
	  if(lvl_att[char_stats.level] == TRUE){
	     hitpt = rand()%6 + 4;
	     sppt  = rand()%2 + 1;
	     char_stats.hitpoints  -= hitpt;
	     char_stats.max_hp -= hitpt;
	     char_stats.spellpoints -= sppt;
	     char_stats.max_spt -= sppt;
	     char_stats.level--;
	     known[char_stats.level+1] = FALSE;
	     lvl_att[char_stats.level+1] = FALSE;
	     lvl_att[char_stats.level] = TRUE;
	     print_stats();
	  }
}

use_it()
{
	char choice;

	start = firstnode;
	do
          {
	    wclear(inv_win);
	    wmove(inv_win,0,0);
	    wprintw(inv_win,"Use which Item?");
	    wmove(inv_win,1,0);	
	    wprintw(inv_win,"N)ext P)rev S)elect esc) to exit");
	    wmove(inv_win,3,0);
	    wprintw(inv_win,"%s",start->item);
	    wmove(inv_win,1,21);
	    wrefresh(inv_win);
	    switch(choice = getch()){
		case 'n':
		case 'N': 
			if(start->next != NULL)
			   start = start->next;
			break;
		case 'p':
		case 'P':
			if(start->prev != NULL)
			   start = start->prev;
			break;
		case 's':
		case 'S':
			 switch (start->item_type){
			   case 9: 
				 if(start->special > 0){
				   p->compass_on = TRUE;
				   ct_compass = 100;
				   compass();
				   start->special--;
				   choice = ESC;
				 }else{
				   print_mess("Item Has no more charges.",0,0);
				   wrefresh(message_win);
				   sleep(1);
				 }
			         break;
		   	   case 10:
				 if(start->special > 0){
				   detect_trap();
				   ct_dtrap = 100;
				   detect = ON;
				   start->special--;
				   choice = ESC;
				 }else{
				   print_mess("Item Has no more charges.",0,0);
				   wrefresh(message_win);
				   sleep(1);
				 }
			         break;
			   case 11:
				 if(start->special > 0){
				   med_heal();
				   start->special--;
				   choice = ESC;
				 }else{
				   print_mess("Item Has no more charges.",0,0);
				   wrefresh(message_win);
				   sleep(1);
				 }
			         break;
			   case 12:
				 if(start->special > 0){
				   flame();
				   start->special--;
				   choice = ESC;
				 }else{
				   print_mess("Item Has no more charges.",0,0);
				   wrefresh(message_win);
				   sleep(1);
				 }
			         break;
			   case 13:
				 if(start->special > 0){
				   teleport();
				   start->special--;
				   choice = ESC;
				 }else{
				   print_mess("Item Has no more charges.",0,0);
				   wrefresh(message_win);
				   sleep(1);
				 }
				 break;
			   default:
				 print_mess("You cannot Use that!",0,0);
				 wrefresh(message_win);
				 break;
			 }
			  
	       }
	}while(choice != ESC);
	wclear(inv_win);
	wrefresh(inv_win);
}

monst_att(mon)
int mon;
{ 
	wclear(message_win);	
        wmove(message_win,0,0);
	switch (m[mon].ability){
	    case 0:
	    case 1: abil_one(mon);
	            break;
	    case 2: abil_two();
	            break;
	    case 3: abil_three(mon);
	    	    break;
	    case 4: abil_four(mon); 
	    	    break;
	    case 5: abil_five(mon);
	    break;
	    case 6: abil_six(mon);
	    	    break;
	    case 7: abil_seven(mon);
	    break;
	    case 8: abil_eight(mon);
	    break;
	    case 9: abil_nine(mon); 
	    break;
	    case 10: abil_ten(mon); 
	    break;
	    case 11: abil_eleven(mon); 
	    break;
	    case 12: abil_twelve(mon);
	    break;
	    case 13: abil_thirteen(mon);
            break;
	}
	wrefresh(message_win);
	sleep(1);
}

abil_one(monst)
int monst;
{
   if(rand()%16 > char_stats.ac){
      char_stats.hitpoints -= damag = make_dam(5,m[monst].m_lvl); 
      sprintf(wrk_buf,"He hit you for %d points damage.",damag);
      print_mess(wrk_buf,2,0);
      print_stats();
    }else
      print_mess("He Misses you!",2,0);
}

abil_two()
{
   if(rand()%6 > char_stats.ac){
      if(char_stats.strength > MIN_STAT)
        char_stats.strength--;
        print_mess("Your Strength is drained.",2,0);
        print_stats();
      }else
        print_mess("He misses you.",2,0);
}

abil_three(monst)
int monst;
{
    switch (rand()%2 ? 1 : 2){
      case 1: if((rand()%18) + 3  > char_stats.constitution){
		char_stats.hitpoints -= damag = make_dam(5,m[monst].m_lvl);
		sprintf(wrk_buf,"You got fried for %d points damage.",damag);
		print_mess(wrk_buf,2,0);
		print_stats();
	      }else
		print_mess("You resist the Spell.",2,0);
      break;
      case 2: abil_one(monst);
      break;
   }
}

abil_four(mon)
int mon;
{
	switch(rand()%2 ? 1 : 2){
	  case 1: if((rand()%18)+6 > char_stats.constitution){
		    char_stats.hitpoints -= damag = make_dam(5,4);
		    print_mess("You are blasted by an electric",2,0);
		    sprintf(wrk_buf,"sphere for %d points damage.",damag);
		    print_mess(wrk_buf,3,0);
		    print_stats();
		  }else{
		     print_mess("You resist the spell.",2,0);
		     sleep(1);
		  }
	  break;
	  case 2: abil_three(mon);
	  break;
	}
}

abil_five(mon)
int mon;
{
	switch(rand()%2 ? 1 : 2){
	  case 1: if((rand()%18) + 5 > char_stats.constitution){
		    damag = make_dam(m[mon].m_lvl,3);
		    char_stats.hitpoints -= damag;
		    sprintf(wrk_buf,"You are drained for %d ",damag);
		    print_mess(wrk_buf,2,0);
		    print_mess("points of damage.",3,0);
		    m_temp.m_hp += (damag>>1);
		    print_stats();
		  }else
		    print_mess("You resist the affects.",2,0);
	          break;
	  case 2: abil_one(mon);
	          break;
	}
}

abil_six(mon)
int mon;
{
	switch (rand()%2 ? 1 : 2){
	   case 1: if((rand()%18) + 3 > char_stats.constitution){
		     char_stats.hitpoints -= damag = make_dam(5,m[mon].m_lvl);
	             print_mess("You are choked for ",2,0);
		     sprintf(wrk_buf,"%d points damage.",damag);
		     print_mess(wrk_buf,3,0);
		     print_stats();
	      	   }else
		     print_mess("You resist the spell.",2,0);
	   break;
	   case 2: abil_one(mon);
	   break;
   }
}

abil_seven(mon)
int mon;
{
	switch(rand()%2 ? 1 : 2){
	  case 1: if((rand()%18) + 3 > char_stats.intelligence){
		    char_stats.hitpoints -= damag = make_dam(5,m[mon].m_lvl);
		    sprintf(wrk_buf,"You are burnt for %d ",damag);
		    print_mess(wrk_buf,2,0);
		    print_mess("points damage.",3,0);
		    print_stats();
		  }else
		    print_mess("The spell does not affect you.",2,0);
		  break;
	  case 2: abil_one(mon);
	  break;
	}
}

abil_eight(monst)
int monst;
{
	switch(rand()%2 ? 1 : 2){
	  case 1: if((rand()%18)+3 > char_stats.constitution){
		    char_stats.hitpoints -= damag = make_dam(8,3);
		    print_mess("He Breathes and burns you ",2,0);
	   	    sprintf(wrk_buf,"for %d points damage.",damag);
		    print_mess(wrk_buf,3,0);
		    print_stats();
		  }else
		    print_mess("The Spell does not Affect you.",2,0);
	  break;
	  case 2: abil_one(monst);
	  break;
	}
}

abil_nine(monst)
int monst;
{
	int tmp;

	switch(rand()%2 ? 1 : 2){
	  case 1: abil_six(monst);
	  break;
	  case 2: if((rand()%18)+3 > char_stats.strength){
		    tmp = (m[monst].m_lvl + 2);
		    char_stats.hitpoints -= damag = (10 + make_dam(5,tmp));
		    sprintf(wrk_buf,"You gasp, and take %d points ",damag);
		    print_mess(wrk_buf,2,0);
		    print_mess("damage due to lack of air.",3,0);
		    print_stats();
		  }else
		    print_mess("You resist the affects.");
	  break;
	}
}

abil_ten(monst)
int monst;
{
	switch(rand()%3){
	  case 0: abil_three(monst);
	  break;
	  case 1: abil_four(monst);
	  break;
	  case 2: abil_seven(monst);
	  break;
	}
}
	
abil_eleven(monst)
int monst;
{
	switch(rand()%3){
	case 0:
	  if(char_stats.ac + 75 < rand()%100){
	    char_stats.experience -= (m[monst].m_lvl * 10);
	    print_mess("He touches you and drains experience.",2,0);
	    lose_lvl();
	    print_stats();
	  }else
	    print_mess("He reaches toward you but misses.",2,0);
	break;
	case 1: abil_five(monst);
		break;
	case 2: abil_one(monst);
		break;
      	}
}
	
abil_twelve(monst)
int monst;
{
	switch(rand()%3){
	  case 0: abil_thirteen(monst);
	  break;
	  case 1: char_stats.hitpoints -= damag = make_dam(5,8);
		  sprintf(wrk_buf,"He did %d points damage.",damag);
		  print_mess(wrk_buf,2,0);
		  wrefresh(message_win);
		  print_stats();
	  break;
	  case 2: abil_nine(monst);
	  break;
	}
}

abil_thirteen(monst)
int monst;
{
   if(rand()%100 > 85){
     char_stats.hitpoints -= damag = (rand()%10) + 10;
     char_stats.dexterity -= 3;
     char_stats.m_dex  -= 1;
     sprintf(wrk_buf,"He hit for %d points of damage",damag);
     print_mess(wrk_buf,2,0);
     print_mess("and he also damaged your dexterity.",3,0);
   }else{
     char_stats.hitpoints -= damag = (rand()%10) + 15;
     sprintf(wrk_buf,"You are hit for %d points damage.",damag);
     print_mess(wrk_buf,2,0);
   }
   print_stats();
   wrefresh(message_win);
}
