# include <curses.h>			/* include screen routines          */
# include <sys/types.h>
# include <sys/stat.h>
#ifndef COHERENT
# include <fcntl.h>
# include <sys/time.h> 		        /* include for the time routines    */
#else
# ifndef _I386
#   include <sys/fcntl.h>
# else
#   include <fcntl.h>
# endif
# include <time.h>
#endif

# include "INCLUDE/items.h"
# include "INCLUDE/castle.h"

# define  LF    '\012'
/*
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                         +
+ Included are The file routines:                                         +
+                                                                         +
+ get_levels()    Coordinates read of the dungeon levels.                 +
+ read_level()    Reads the individual levels.                            +
+ help_me()       Reads the help file and displays it on the screen.      +
+ game_stat()     Reads the hours file and determines if the game         +
+                 is open depending on the time.                          +
+ dis_open_scr()  Displays the opening credits screen.                    +
+ score_list()    Coordinates the score file routines.                    +
+ write_it()      Writes updated information to the score file.           +
+ read_it()       Reads the old information from the score file.          +
+ configure()     Configures the information that is to be written        +
+                 to the score file, (Puts your name in the proper        +
+                 place in the score list).                               +
+ print_scores()  Prints the scores if you just died or quit, after       +
+                 a game run.                                             +
+ prn_scores()    Prints score list if -s option is given at command line.+
+                                                                         +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

/*

	This is a public domain program, I have no objection to modifications
made on it or use for some other reason so long as this notice remains intact.

	
		Part of:  castle 	Ted Wisniewski
		Author:			Plymouth State College
					Plymouth NH,
						    03264
		Copyright() PSC

		Ported to Coherent by Udo Munk		Oberstr. 21
							4040 Neuss 1
							Germany
		mwcbbs!umunk!udo
*/

char files[128];
char f_nam[128];
static char savfil[50];
static int inv_rec[16];

get_levels()
{
	strcpy(files,D_LVL_1);
	read_level(0);
	strcpy(files,D_LVL_2);
	read_level(1);
	strcpy(files,D_LVL_3);
	read_level(2);	
	strcpy(files,D_LVL_4);
	read_level(3);
	strcpy(files,D_LVL_5);
	read_level(4);
	strcpy(files,D_LVL_6);
	read_level(5);
}

read_level(lvl)
int lvl;
{
	int filedes,row,col,count;

	filedes = open(files,O_RDONLY);
	read(filedes,wrk_buf,1750);
	close(filedes);

	count = 0;
	for(row=0;row<=23;row++){
		for(col=0;col<=75;col++){
			levels[lvl][row][col] = wrk_buf[count];
			count++;
		}
	}
}


help_me()
{
	FILE *fp;
	int lines = 0;

	sprintf(f_nam,"%s",HELP);
	fp = fopen(f_nam, "r");
#ifdef COHERENT
	setbuf(fp, NULL);
#endif
	savetty();
	initscr();
	crmode();
	noecho();
	clear();
	while (fgets(wrk_buf, 81, fp)) {
		printw("%s", wrk_buf);
		lines++;
		if((lines % 21) == 0){
			printw("\n\nPress a key to continue.");
			refresh();
			getch();
			clear();
			move(0,0);
		}
	}
	refresh();
	fclose(fp);
	resetty();
	exit(0);
}



game_stat()
{
#ifndef COHERENT
	int row = 1;
	int col = 1;
	int hour,day,i;
	int filedes,numread;
	long t_ptr;			/* Make time pointer a long int  */
	struct tm *local, *localtime(); /* Give variables tm structure   */
	static char matrix[24][80];

	time(&t_ptr);	 	        /* Get the time from the system  */

	local = localtime(&t_ptr);  	/* Get tm struct for the time    */

	hour = local->tm_hour;		/* set variable to local->tm_hour*/
	day  = local->tm_wday;          /* set variable to local->tm_wday*/

	(void) strcpy(f_nam,HOURS);
	if((filedes = open(f_nam,O_RDONLY)) < 0){
		printf("Aborted Due to No Hours File <%s>.\n", f_nam);
		exit(1);
	}

	numread = read(filedes,wrk_buf,1000);
	close(filedes);


	for(i=0;i<=numread;i++){
		if(wrk_buf[i] == 10 || wrk_buf[i] == 13){
			matrix[row][col] = wrk_buf[i];
			row++;
			col = 1;
		}
		else{
			matrix[row][col] = wrk_buf[i];
			col++;
		}
	}

	if(matrix[day + 4][hour + 6] == 'X')
		;
	else{
	   	savetty();
		initscr();		/* initialize screen                */
		refresh();
		clear();		/* Clear the screen                 */
		for(i=0;i<=numread;i++)
			printf("%c",wrk_buf[i]);
		endwin();
		resetty();
		exit(0);
	}
#endif
}

dis_open_scr()
{
	int fd,nr,ind;

	(void) strcpy(f_nam,OPEN_SCR);
	if((fd = open(f_nam,O_RDONLY)) < 0){
		printf("No Opening screen file, Aborting.");
		end_game();
	}
	else
		if((nr =  read(fd,wrk_buf,1500)) < 1){
			printf("Nothing in Opening credit file.");
			end_game();
		}
	else{
		move(0,0);
		for(ind=0;ind<nr;ind++)
			printw("%c",wrk_buf[ind]);
		move(23,0);
		printw("Press any key to Continue. ");
		refresh();
		crmode();
		noecho();
		getch();
		nocrmode();
		echo();
		clear();
		refresh();
	}
	close(fd);
}

score_list()
{
	tmp.score = char_stats.experience;
	tmp.level = char_stats.level;
	strcpy(tmp.name, char_stats.Name);

	if(read_it() == -1){
		out[0].score = tmp.score;
		out[0].level = tmp.level;
		strcpy(out[0].name, tmp.name);
		strcpy(out[0].death_by,tmp.death_by);
	}
	else
		configure();
	write_it();
	print_scores();
}

write_it()
{
	FILE *fp;

	(void) strcpy(f_nam,SCORES);
	if((fp = fopen(f_nam,"w")) == (FILE *)NULL){
		fprintf(stderr,"Cannot open file.\n");
		if(creat(f_nam,PERMS) < 0)
			fprintf("Error in making score File.");
		exit(1);
	}
#ifdef COHERENT
	setbuf(fp, NULL);
#endif
	if(fwrite((char *)out, sizeof(out),1,fp) != 1){
		fprintf(stderr,"Cannot open file.\n");
		exit(1);
	}
	fclose(fp);
}

read_it()
{
	FILE *fp;

	(void) strcpy(f_nam,SCORES);
	if((fp = fopen(f_nam,"r")) == (FILE *)NULL){
		if(creat(SCORES,PERMS) < 0)
			exit(1);
	} else {
#ifdef COHERENT
		setbuf(fp, NULL);
#endif
		if(fread((char *)in, sizeof(in),1,fp) != 1){
			fprintf(stderr,"Cannot open file.\n");
			return(-1);
		}
	}
	fclose(fp);
	return(1);
}


configure()
{
	int inloc = 0;
	int outloc = 0;

	do
	    {
		if(tmp.score >= in[inloc].score){
			out[outloc].score = tmp.score;
			out[outloc].level = tmp.level;
			strcpy(out[outloc].name, tmp.name);
			strcpy(out[outloc].death_by,tmp.death_by);
			outloc++;
			out[outloc].score = in[inloc].score;
			out[outloc].level = in[inloc].level;
			strcpy(out[outloc].name,in[inloc].name);
			strcpy(out[outloc].death_by,in[inloc].death_by);
			outloc++;
			inloc++;
			tmp.score = -1;
		}
		else
			if(tmp.score < in[inloc].score){
				out[outloc].score = in[inloc].score;
				out[outloc].level = in[inloc].level;
				strcpy(out[outloc].name,in[inloc].name);
				strcpy(out[outloc].death_by,in[inloc].death_by);
				outloc++;
				inloc++;
			}
		else{
			out[outloc].score = tmp.score;
			out[outloc].level = tmp.level;
			strcpy(out[outloc].name, tmp.name);
			strcpy(out[outloc].death_by,tmp.death_by);
			outloc++;
		}
	}
	while(outloc <= 19);
}

print_scores()
{
	int ind = 0,finished = FALSE;
	int start = 2;

	clear();
	move(0,0);
	printw("Rank");
	move(0,5);
	printw("Name");
	move(0,20);
	printw("Score");
	move(0,30);
	printw("Level");
	move(0,40);
	printw("Killed by");
	move(1,0);
	printw("-------------------------------------------------");
	do
	    {
		if(out[ind].level == 0)
			finished = TRUE;
		else{
			move(start + ind,0);
			printw("%d)",ind + 1);
			move(start + ind,5);
			printw("%s",out[ind].name);
			move(start + ind,20);
			printw("%d",out[ind].score);
			move(start + ind,30);
			printw("%d",out[ind].level);
			move(start + ind,40);
			printw("%s",out[ind].death_by);
			ind++;
		}
	}
	while(ind <= 19 && !finished);
	move(23,0);
	printw("Press any key to Continue.");
	refresh();
	getch();
	move(23,0);
	clrtoeol();
}

prn_scores()
{
	int ind = 0,finished = FALSE;
	int start = 2;

	initscr();
	crmode();
	noecho();
	clear();
	if(read_it() > 0){
		move(0,0);
		printw("Rank");
		move(0,5);
		printw("Name");
		move(0,20);
		printw("Score");
		move(0,30);
		printw("Level");
		move(0,40);
		printw("Killed by");
		move(1,0);
		printw("-------------------------------------------------");
		do
		    {
			if(in[ind].level == 0)
				finished = TRUE;
			else{
				move(start + ind,0);
				printw("%d)",ind + 1);
				move(start + ind,5);
				printw("%s",in[ind].name);
				move(start + ind,20);
				printw("%d",in[ind].score);
				move(start + ind,30);
				printw("%d",in[ind].level);
				move(start + ind,40);
				printw("%s",in[ind].death_by);
				ind++;
			}
		}
		while(ind <= 19 && !finished);
		move(23,0);
		printw("Press any key to Continue.");
		refresh();
		getch();
		clear();
	}
	end_game();
}


save()
{
	FILE *fp;
	int fd,i;

	for(i=0;i<=15;i++)
		inv_rec[i] = -1;
	posi.row = p->row;
	posi.col = p->col;
	posi.level = p->level;
	posi.face = p->face;
	posi.screen = p->screen;
	posi.compass_on = p->compass_on;
	posi.move_count = p->move_count;
	temp = firstnode;
	i = 1;
	do
	    {
		inv_rec[i] = temp->item_no;
		i++;
		temp = temp->next;
	}
	while(temp->next != NULL);
	inv_rec[0] = i;
	if(temp->next == NULL)
		inv_rec[i] = temp->item_no;
	save_inven();

	sprintf(savfil,"%s%s",SAVE_DIR,user.acct);
	if((fp = fopen(savfil,"w")) == (FILE *)NULL){
		fprintf(stderr,"Cannot open a savefile for you.\n");
		if((fd = creat(savfil,0777)) < 0){
			printw("Cannot create the Save file.");
			refresh();
		}  			
	}
#ifdef COHERENT
	setbuf(fp, NULL);
#endif
	clear();
	refresh();
	if(fwrite((char *)&char_stats, sizeof(char_stats),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&posi, sizeof(posi),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)levels, sizeof(levels),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&ct_compass, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&ct_dtrap, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&showit, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&detect, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&d_val, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&d_mod, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&which_one, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)&mon_faced, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)known, sizeof(known),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)lvl_att, sizeof(lvl_att),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)inv_rec, sizeof(inv_rec),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fwrite((char *)s_inven, sizeof(s_inven),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}

	fclose(fp);
	printw("Saving!");
	refresh();
	sleep(2);
	end_game();
}

recover()
{
	FILE *fp;
	int i;
	struct stat st_buff;

	sprintf(savfil,"%s%s",SAVE_DIR,user.acct);
	if((fp = fopen(savfil,"r")) == (FILE *)NULL){
		fprintf(stderr,"Sorry you don\'t have a saved game.\n");
		end_game();
	}
#ifdef COHERENT
	setbuf(fp, NULL);
#endif
	if(fread((char *)&char_stats, sizeof(char_stats),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&posi, sizeof(posi),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)levels, sizeof(levels),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&ct_compass, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&ct_dtrap, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&showit, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&detect, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&d_val, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&d_mod, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&which_one, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)&mon_faced, sizeof(int),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)known, sizeof(known),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)lvl_att, sizeof(lvl_att),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)inv_rec, sizeof(inv_rec),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}
	if(fread((char *)s_inven, sizeof(s_inven),1,fp) != 1){
		fprintf(stderr,"Cannot write to file.");
	}

	fclose(fp);
	if(stat(savfil,&st_buff) < 0)
	   fprintf(stderr,"ERROR: Could not stat file.\n");
	else
	   if(unlink(savfil) < 0)
	     fprintf(stderr,"ERROR: %s Not Removed.\n",savfil);

	p->row = posi.row;
	p->col = posi.col;
	p->level = posi.level;
	p->face = posi.face;
	p->screen = posi.screen;
	p->compass_on = posi.compass_on;
	p->move_count = posi.move_count;
	char_stats.ac = 0;
	d_val = 3;
	d_mod = 1;

/*	oldnode = (list *) malloc(sizeof(list));
	firstnode = oldnode;  */
	init_list();

	for(i=1;i<=inv_rec[0];i++)
		add_item(inv_rec[i]);
	oldnode = firstnode; 
	firstnode = oldnode->next;
	oldnode->next->prev = NULL;
	oldnode->next = NULL;
	temp = firstnode;

	i = 0;
	do{
	  temp->item_type = s_inven[i].item_type;
	  temp->armor_val = s_inven[i].armor_val;
	  temp->dam_val = s_inven[i].dam_val;
	  temp->dam_mod = s_inven[i].dam_mod;
	  temp->item_no = s_inven[i].item_no;
	  temp->special = s_inven[i].special;
	  temp->used = s_inven[i].used;
	  if(temp->used == TRUE)
	  switch (temp->item_type){
	     case 1: char_stats.ac += temp->armor_val;
		     break;
	     case 2: char_stats.ac += temp->armor_val;
		     break;
	     case 3: char_stats.ac += temp->armor_val;
		     break;
	     case 4: char_stats.ac += temp->armor_val;
		     break;
	     case 5: char_stats.ac += temp->armor_val;
		     break;
	     case 6: d_val = temp->dam_val;
	 	     d_mod = temp->dam_mod;
		     break;
	     default : break;
	  }
	  i++;
	  temp = temp->next;
	if(temp->next == NULL){
	  temp->item_type = s_inven[i].item_type;
	  temp->armor_val = s_inven[i].armor_val;
	  temp->dam_val = s_inven[i].dam_val;
	  temp->dam_mod = s_inven[i].dam_mod;
	  temp->item_no = s_inven[i].item_no;
	  temp->special = s_inven[i].special;
	  temp->used = s_inven[i].used;
	  if(temp->used == TRUE)
	  switch (temp->item_type){
	     case 1: char_stats.ac += temp->armor_val;
		     break;
	     case 2: char_stats.ac += temp->armor_val;
		     break;
	     case 3: char_stats.ac += temp->armor_val;
		     break;
	     case 4: char_stats.ac += temp->armor_val;
		     break;
	     case 5: char_stats.ac += temp->armor_val;
		     break;
	     case 6: d_val = temp->dam_val;
	 	     d_mod = temp->dam_mod;
		     break;
	     default : break;
	  }
	 }
	}while(temp->next != NULL);
}

save_inven()
{
	int i = 0;
	temp = firstnode;

	do{
	   (void) strcpy(s_inven[i].item,temp->item);
	   s_inven[i].item_type = temp->item_type;
	   s_inven[i].armor_val = temp->armor_val;
	   s_inven[i].dam_val = temp->dam_val;
	   s_inven[i].dam_mod = temp->dam_mod;
	   s_inven[i].item_no = temp->item_no;
	   s_inven[i].special = temp->special;
	   s_inven[i].used = temp->used;
	   i++;
	   temp = temp->next;
	   if(temp->next == NULL){
	     (void) strcpy(s_inven[i].item,temp->item);
	     s_inven[i].item_type = temp->item_type;
	     s_inven[i].armor_val = temp->armor_val;
	     s_inven[i].dam_val = temp->dam_val;
	     s_inven[i].dam_mod = temp->dam_mod;
	     s_inven[i].item_no = temp->item_no;
	     s_inven[i].special = temp->special;
	     s_inven[i].used = temp->used;
	   }
	}while(temp->next != NULL && i != 15);
}


mail_help()
{
}
