# include <curses.h>
# include <ctype.h>
# include <signal.h>
#ifndef COHERENT
# include <fcntl.h>
# include <sys/time.h> 	
#else
# ifndef _I386
#   include <sys/fcntl.h>
# else
#   include <fcntl.h>
# endif
# include <time.h>
#endif

# include "INCLUDE/windows.h"
# include "INCLUDE/castle.h"
# include "INCLUDE/items.h"

/*
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+   Routines in this module:                                                +
+                                                                           +
+     main()          - Runs the whole program.                             +
+     set_windows()   - Sets up the windows for the screen.                 +
+     show_scr()      - Show the current view screen.                       +
+     print_stats()   - Update the character stats in the stat window.      +
+     init()          - initialize the start configurations for the game.   +
+     which_scr(r,c,l)- Determine which view screen to show.                +
+     getint()        - Get an integer in from the message window.          +
+     look_inv()      - Look at the character's inventory list.             +
+     init_list()     - Initialize the inventory list as a double linked    +
+                       List.                                               +
+     find_item()     - Determine if an item is found, then tell which one  +
+                       to add to the list.                                 +
+     add_item()      - Add an Item to the list.                            +
+     check_it()      - See if item to be worn has an item of same type     +
+                       already worn.                                       +
+     
+                       exit from the game.                                 +
+     disarm()        - Attempt to disarm a trap.                           +
+     regen()         - Keep track of a characters status hp, spt and       +
+                       and Regenerate them at the appropriate rate.        +
+     gain_lvl()      - Determines when a player should gain an experience  +
+                       level.                                              +
+     clr_mess_win()  - An extra routine to clear the message window.       +
+     rest()          - Allow player to rest, (regenerate with a lesser     +
+                       chance of being attacked.                           +
+     place_at()      - For use in some teleporters to a specific location. +
+     create_wall()   - Create a wall in the player's location (Trap).      +
+     god_mode()      - Primative checking to see if player has "god status"+
+     death()         - Tells player what killed him.                       +
+     end_game()      - Sets terminal back to non game state.               +
+                                                                           +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	This is a public domain program, I have no objection to modifications
made on it or use for some other reason so long as this notice remains intact.

	
		Part of:  castle 	Ted Wisniewski
		Author:			Plymouth State College
					Plymouth NH,
						    03264
		Copyright() PSC

		Ported to Coherent by Udo Munk		Oberstr. 21
							4040 Neuss 1
							Germany
		mwcbbs!umunk!udo
*/

main(argc,argv)
int argc;
char *argv[];
{
	int row,col,level;
	unsigned char dir;
	int recov;
	int catch();

	if((p = (pos_stats *) malloc(sizeof(pos_stats))) == NULL) {
	  fprintf(stderr,"can't malloc memory for pos_stats\n");
	  exit(1);
	}
	strcpy(user.acct,getenv("USER"));       /* Find who the player is.   */
  	strcpy(user.home,getenv("HOME"));	/* Find his Home Directory.  */
	strcpy(char_stats.Name,user.acct);
	if((strcmp(getenv("TERM"),"dumb")) == 0){
	   fprintf(stderr,"dumb terminal: cannot run!\n");
	   exit(1);
	}

	recov = FALSE;
	if(argc > 2){
	  fprintf(stderr,"Too many Arguments\n");
	  fprintf(stderr,"Aborting program.\n");
	  exit(1);
	}else
	  if(argc == 1)
	    game_stat();			/* Find out if the game      */
						/* operating hours are open. */
	  else
	    if(strcmp(argv[1],"-h") == 0)  /* If the option is "h"   */
	      help_me();			          /* display the help file.   */
	    else
	      if(strcmp(argv[1],"-s") == 0) 	  /*  If the option is "s"    */
		prn_scores();		     	  /*  display the score file. */
	      else
		if(strcmp(argv[1],"-r") == 0){
		  game_stat();	
		  recov = TRUE;
		}

	savetty();		/* Save The current status of the terminal.  */
	srand(getpid());	/* Seed the random number generator.         */

	monst();	 	/* Initialize monsters.			  */

	initscr();              /* Set-up the screen for the game.        */
	clear();
	refresh();
	dis_open_scr();		/* Display the opening screen.		  */
	crmode(); noecho();

	signal(SIGINT,catch);	/* Signals to catch.      		  */
	signal(SIGHUP,catch);
	signal(SIGSEGV,catch);
	signal(SIGTERM,catch);
#ifndef COHERENT
	signal(SIGILL,catch);
	signal(SIGFPE,catch);
	signal(SIGBUS,catch);
#endif

	set_windows();		/* Set-up the windows.			*/
	if(!recov){
	  get_levels();   	/* Read the levels in from their files.   */
	  init_list();		/* initialize the inventory list.       */
	  init();
	}else{
	    recover();
	    show_scr();
	}
	print_stats();
	for(;;){		/* begin the main loop.			*/
		row = p->row;
		col = p->col;
		level = p->level;
		if(which_one == ON)
			which_one = OFF;
		else
			which_one = ON;

		which_scr(row,col,level);
		if(showit){		/* if the screen needs to be */
			show_scr();	/* displayed, do so.         */
			showit = FALSE;
		}
		if(p->compass_on)	/* if the compass is on display it.  */
			compass();
		if(detect == ON){	/* if trap detect is on warn player  */
		  clr_mess_win();	/* if there is a trap ahead.         */
		  detect_trap();
	 	}
		if(rand()%100 > 85){    /* Find out if the player encounters */
		   combat();		/* a monster.			     */
		}

		find_item();
		spell_counts();
		wmove(command_win,0,0);
		wrefresh(command_win);
		dir = getch();
		switch (dir){

		case 'h':
		case 52 :               	 /* Turn Left */
		case 180: 
			showit = TRUE;
			if(p->face == NORTH)
				p->face = WEST;
			else
				p->face--;
			break;

		case 'k':
		case 56 :			/* Move forward              */
		case 184: 			
						/* make sure player does not 
					  	   go through a wall.        */
			switch (p->face){       
			case NORTH: 
			       if(levels[level-1][row-1][col]!=WALL && row != 1){
					p->row--;
					showit = TRUE;
				}else
				  	beep();
				break;
			case EAST: 
			       if(levels[level-1][row][col+1]!=WALL && col != 73){
					p->col++;
					showit = TRUE;
				}else
					beep();
				break;
			case SOUTH: 
			       if(levels[level-1][row+1][col]!=WALL && row !=22){
					p->row++;
					showit = TRUE;
				}else
					beep();
				break;
			case WEST: 
			       if(levels[level-1][row][col-1]!=WALL && col != 1){
					p->col--;
					showit = TRUE;
				}else
					beep();
				break;
			}
			break;

		case 'j':
		case 50 :			
		case 178: 
						/* Back up a space and also
						   make sure he does not go
						   through a wall.           */
			switch (p->face){
			case NORTH: 
			       if(levels[level-1][row+1][col]!=WALL && row != 22){
					p->row++;
					showit = TRUE;
				}else
					beep();
				break;
			case EAST: 
			       if(levels[level-1][row][col-1]!=WALL && col != 1){
					p->col--;
					showit = TRUE;
				}else
					beep();
				break;
			case SOUTH: 
			      if(levels[level-1][row-1][col]!=WALL && row != 1){
					p->row--;
					showit = TRUE;
				}else
					beep();
				break;
			case WEST: 
			      if(levels[level-1][row][col+1]!=WALL && col != 73){
					p->col++;
					showit = TRUE;
				}else
					beep();
				break;
			}
			break;

		case 'l':		/* Turn Right */
		case 54 : 
		case 182:
			showit = TRUE;
			if(p->face == WEST)
				p->face = NORTH;
			else
			        p->face++;
			break;
		case '.': 		/* Turn Around. */
			switch (p->face){
			case NORTH: 
				p->face = SOUTH;
				break;
			case WEST: 
				p->face = EAST;
				break;
			case SOUTH: 
				p->face = NORTH;
				break;
			case EAST: 
				p->face = WEST;
				break;
			}
			showit = TRUE;
			break;

		case UP: 		/* Go up a staircase   */
			if(levels[level-1][row][col] == UP && p->level != 1){
				p->level--;
				showit = TRUE;
			}
			else{
				print_mess("Can't Go up here!",0,0);
				wrefresh(message_win);
				sleep(1);
				clr_mess_win();
				wmove(message_win,0,0);
				wrefresh(message_win);
			}
			break;
		case DOWN: 		/* Go down a staircase. */
			if(levels[level-1][row][col] == DOWN && p->level != 6){
				p->level++;
				level++;
				showit = TRUE;
			}
			else{
				print_mess("Can't Go down here!",0,0);
				wrefresh(message_win);
				sleep(1);
				clr_mess_win();
				wmove(message_win,0,0);
				wrefresh(message_win);
			}
			break;
		case 'c':		/* Cast Spells */
		case 'C': 
			clr_mess_win();
			spells();
			break;
		case 'd':		/* Disarm a trap. */
		case 'D':
			clr_mess_win();
		   	disarm();
			break;
		case 'i':		/* Look into your inventory.  */
		case 'I': 
			wclear(message_win);
			wrefresh(message_win);
			look_inv();
			break;
		case 'N':
			wclear(message_win);
			print_mess("Name -> ",0,0);
			wrefresh(message_win);
			get_str(0,9);
			strcpy(char_stats.Name,string);
			print_stats();
			break;
		case 'r':		/* Rest for some period.      */
		case 'R':
			wclear(message_win);
			wrefresh(message_win);
			rest();
			break;
		case 'S':
			which_known();
			break;
		case 'q':		/* Quit the game.            */
		case 'Q': 
			wmove(message_win,0,0);
			wclrtoeol(message_win);
			print_mess("Quit (y/n)? ",0,0);
			wrefresh(message_win);
			if(wgetch(message_win) == 'y'){
			  strcpy(tmp.death_by,"Cowardice");
			  score_list();
			  end_game();
			}
			break;
		case 'u' :
		case 'U' : 
			use_it();
			break;
		case 'L':		/* Explain A spell	    */
			wclear(message_win);
			wrefresh(message_win);
			exp_spell();
		        break;
		case RE_DRAW:		/* Redraw the screen (?)    */
			redraw();
		break;
		case G_MODE:
			god_mode();
		break;
		case SAVE:
			save();
		break;
		case '?':
			help_list();
			break;
		case '~': mail_help();
			  break;
		case 'v':		/* Print version and credits */
			wclear(message_win);
			wrefresh(message_win);
			print_mess("Version 1.1",0,0);
			print_mess("Screens:",1,0);
			print_mess("Lauriannne Olcott &",2,5);
			print_mess("Ted Wisniewski",3,10);
			print_mess("Game by: Ted Wisniewski",4,0);
			print_mess("Ported to Coherent by: Udo Munk",5,0);
			print_mess("Press a key.",6,0);
			wrefresh(message_win);
			wgetch(message_win);
		break;
			
		}
		location();
		regen();
		if(char_stats.hitpoints < 0)
		  death();
	}
}

location()
{
	char spot;
	int gold;

	spot = levels[p->level-1][p->row][p->col];

	wclear(message_win); 
	wrefresh(message_win);

	switch (spot){
	case DOWN: 		/* Is the spot a down staircase?   */
		print_mess("This is a down staircase.",0,0);
		break;
	case UP: 		/* Is the spot an up staircase?    */
		print_mess("This is an up Staircase.",0,0);
		break;
	case TELE: 		/* Teleport the Player? 	   */
		print_mess("You are Teleported.",0,0);
		p->row = rand()%22 + 1;
		p->col = rand()%72 + 1;
		break;
	case TRAP: 		/* Ouch you are on a trap!         */
		print_mess("You Hit A Trap!",0,0);
		char_stats.hitpoints -= rand() % 10 + 1;
		levels[p->level-1][p->row][p->col] = BLANK;
		if(char_stats.hitpoints < 0)
		  strcpy(tmp.death_by,"A Trap");
		print_stats();
		break;
	case T_DOOR:		/* A trap door to the next level.  */
		print_mess("You fall through a trap door.",0,0);
		p->level++;
		showit = TRUE;
		char_stats.hitpoints -= rand() % 5;
		if(char_stats.hitpoints < 0)
		  strcpy(tmp.death_by,"Falling");
		print_stats();
		break;
	case GOLD: 		/* Find some extra Cash!!	   */
		char_stats.gold += gold = rand() % (p->level * 50) + 25;
		sprintf(wrk_buf,"You Find %d gold!!",gold);
		print_mess(wrk_buf,0,0);
		levels[p->level-1][p->row][p->col] = BLANK;
		print_stats();
		break;
	case SPIN:		/* Spin to a random direction	  */
		p->face = rand()%4;
		print_mess("You feel Dizzy.",0,0);
		showit = TRUE;
	 	break;
	case H_DRAIN:		/* Hurt em' a little.             */
		print_mess("Ouch!!",0,0);
		char_stats.hitpoints -= (3 * p->level);
		if(char_stats.hitpoints < 0)
		  strcpy(tmp.death_by,"Unknown force");
		print_stats();
		break;
	case S_DRAIN:		/* Take some ability to cast spells */
		print_mess("You Feel Uneasy.",0,0);
		char_stats.spellpoints -= (2 * p->level);
		if(char_stats.spellpoints < 0)
		  char_stats.spellpoints = 0;
		print_stats();
		break;
	case T_LOC:		/* Take them some place specific.  */
		place_at();
		break;
	case C_WALL:		/* Create a wall here.		   */
		create_wall();
		break;
	case STORE:		/* Enter the Store. 		   */
	        the_store();
		break;
	case FOUNTAIN:
		fountain();
		break;
	case SP_ITEM:
		add_item(13);
		levels[p->level-1][p->row][p->col] = BLANK;
		print_mess("You Have found The Death Lance.",1,0);
		beep();
		wrefresh(message_win);
		break;
	case CLUE:
		print_mess(clues[rand()%16],0,0);
		wrefresh(message_win);
		levels[p->level-1][p->row][p->col] = BLANK;
		break;
	case '1':
		ask_ques(1);
		break;
	case '2':
		ask_ques(2);
		break;
	case '3':
		ask_ques(3);
		break;
	default: 		/* clean up.			      */
		wclear(message_win);
		wrefresh(message_win);
	 	break;
	}
	wrefresh(message_win);
}

set_windows() 
{
	stat_win = subwin(stdscr,19,15,1,0);
	view_win = subwin(stdscr,12,27,0,20);
	message_win = subwin(stdscr,7,40,16,20);
	compass_win = subwin(stdscr,9,9,14,70);
	inv_win = subwin(stdscr,8,26,4,54);
	command_win = subwin(stdscr,1,1,21,0);
#ifdef DEBUG
	debug_win   = newwin(3,15,10,60);
#endif
}


show_scr()			/* Display the screen pointed to. */
{
	int row,col;

	wmove(view_win,0,0);
	for(row=0;row<=11;row++){
		for(col=0;col<=26;col++){
			wprintw(view_win,"%c",screens[p->screen][row][col]);
		}
	}
	wrefresh(view_win);
}

print_stats()		/* Print the players Stats to the stat  */
				/* Window. 				*/
{
	wclear(stat_win);
	wmove(stat_win,0,0);
	wprintw(stat_win,"Name: %s",char_stats.Name);
	wmove(stat_win,2,0);
	wprintw(stat_win,"Str: %d",char_stats.strength);
	wmove(stat_win,3,0);
	wprintw(stat_win,"Con: %d",char_stats.constitution);
	wmove(stat_win,4,0);
	wprintw(stat_win,"Dex: %d",char_stats.dexterity);
	wmove(stat_win,5,0);
	wprintw(stat_win,"Int: %d",char_stats.intelligence);
	wmove(stat_win,6,0);
	wprintw(stat_win,"Wis: %d",char_stats.wisdom);
	wmove(stat_win,8,0);
	wprintw(stat_win,"Lvl: %d",char_stats.level);
	wmove(stat_win,9,0);
	wprintw(stat_win,"Exp: %d",char_stats.experience);
	wmove(stat_win,10,0);
	wprintw(stat_win,"CSp: %d",char_stats.spellpoints);
	wmove(stat_win,11,0);
	wprintw(stat_win,"MSp: %d",char_stats.max_spt);
	wmove(stat_win,12,0);
	wprintw(stat_win,"CHP: %d",char_stats.hitpoints);
	wmove(stat_win,13,0);
	wprintw(stat_win,"MHP: %d",char_stats.max_hp);
	wmove(stat_win,15,0);
	wprintw(stat_win,"Gold : %d",char_stats.gold);
	wmove(stat_win,16,0);
	wprintw(stat_win,"AC : %d",char_stats.ac);
	wrefresh(stat_win);
}

init()		/* Set the players stats and some other info.   */
{
	int x;

	char_stats.m_str = char_stats.strength    = (rand()%16)+MIN_STAT;
	char_stats.m_con = char_stats.constitution= (rand()%16)+MIN_STAT;
	char_stats.m_dex = char_stats.dexterity   = (rand()%16)+MIN_STAT;
	char_stats.m_int = char_stats.intelligence= (rand()%16)+MIN_STAT;
	char_stats.m_wis = char_stats.wisdom      = (rand()%16)+MIN_STAT;
	char_stats.max_spt = char_stats.spellpoints = 3;
	char_stats.max_hp =  char_stats.hitpoints   = 12;
	char_stats.gold        = 100;
	char_stats.level       = 1;
	char_stats.experience  = 0;
	char_stats.ac = 0;
	char_stats.num_items   = 0;
	p->move_count = 0;
	p->face = EAST;
	p->compass_on = FALSE;
	p->row = 9;
	p->col = 1;
	p->level = 1;
	which_one = TRUE;
	showit = TRUE;
	detect = OFF;
	d_val = HAND_DAM;
	d_mod = HAND_MUL;
	add_item(3);
	for(x=0;x<=20;x++)
	  known[x] = FALSE;
	known[0] = known[1] = TRUE;
}

which_scr(row,col,level)
int row,col,level;
{
	extern long atol();
	int wall;
	long number;
	char walls[7];
/*
	How wall configurations are determined:

	                _____________     The 'X' is you.
                        | 2 | 5 | 3 |     Spot 0 is to your left.
		        -------------     Spot 1 is to your Right.
                        | 4 |   | 6 |     Spot 2 is two spaces out front
		        -------------            and to your left.
                        | 0 | X | 1 |     Spot 3 is two spaces out front
		        -------------            and to your right.
                                          Spot 4 is one space out front
                                                 and to your left.
                                          Spot 5 is two spaces out front.
                                          Spot 6 is one space out front
                                                 and to your right.


			 # #
			##n##
			 w e       You are at the 's' or south of viewing area.
			##s##      As pointed to.
		  	 #^#
*/
	for(wall=0;wall<=6;wall++)
		walls[wall] = '0';

	switch (p->face){
	case NORTH:  
		if(levels[level-1][row-1][col]!= WALL){
			if(levels[level-1][row-2][col]   == WALL) 
				walls[5] = '1';                
			if(levels[level-1][row-1][col-1] == WALL)
				walls[4] = '1';                
			if(levels[level-1][row-1][col+1] == WALL)
				walls[6] = '1';               
			if(levels[level-1][row-2][col-1] == WALL) 
				walls[3] = '1';                 
			if(levels[level-1][row-2][col+1] == WALL) 
				walls[2] = '1';                
			if(levels[level-1][row][col-1]   == WALL) 
				walls[0] = '1';  	       
			if(levels[level-1][row][col+1]   == WALL) 
				walls[1] = '1';                 
			number = atol(walls);
		}
		else{
			number = -1L;
		}
		break;
		/*
				 # #
				##n##
		                >w e    
				##s## 
				 # #
		*/
	case EAST:  
		if(levels[level-1][row][col+1]!= WALL){
			if(levels[level-1][row][col+2]   == WALL) 
				walls[5] = '1';                
			if(levels[level-1][row-1][col+1] == WALL)
				walls[4] = '1';                
			if(levels[level-1][row+1][col+1] == WALL)
				walls[6] = '1';                
			if(levels[level-1][row-1][col]   == WALL) 
				walls[0] = '1';                 
			if(levels[level-1][row-1][col+2] == WALL) 
				walls[3] = '1';                 
			if(levels[level-1][row+1][col]   == WALL) 
				walls[1] = '1';                 
			if(levels[level-1][row+1][col+2] == WALL) 
				walls[2] = '1';                 
			number = atol(walls);
		}
		else{
			number = -1L;
		}
		break;
		/*
				#v#
			       ##n## 
		                w e  
			       ##s##
				# #
		*/
	case SOUTH: 
		if(levels[level-1][row+1][col]!= WALL){
			if(levels[level-1][row+2][col]   == WALL)	
				walls[5] = '1';		       	
			if(levels[level-1][row+1][col-1] == WALL)	
				walls[6] = '1';		       	
			if(levels[level-1][row+1][col+1] == WALL)	
				walls[4] = '1';		       	
			if(levels[level-1][row][col+1]   == WALL)	
				walls[0] = '1';		       	
			if(levels[level-1][row][col-1]   == WALL) 
				walls[1] = '1';		       	
			if(levels[level-1][row+2][col-1] == WALL)	
				walls[2] = '1';		       	
			if(levels[level-1][row+2][col+1] == WALL)	
				walls[3] = '1';		       	
			number = atol(walls);
		}
		else{
			number = -1L;
		}
		break;
		/*
			 	 # #
				##n##
			         w e<  	
				##s##
				 # #
		*/
	case WEST: 
		if(levels[level-1][row][col-1]!= WALL){
			if(levels[level-1][row][col-2] == WALL)  
				walls[5] = '1';		       
			if(levels[level-1][row+1][col-1] == WALL)
				walls[4] = '1';		        
			if(levels[level-1][row-1][col-1] == WALL) 
				walls[6] = '1';		        
			if(levels[level-1][row+1][col]   == WALL) 
				walls[0] = '1';		        
			if(levels[level-1][row-1][col]   == WALL) 
				walls[1] = '1';		        
			if(levels[level-1][row-1][col-2] == WALL) 
				walls[2] = '1';		        
			if(levels[level-1][row+1][col-2] == WALL) 
				walls[3] = '1';		        
			number = atol(walls);
		}
		else{
			number = -1L;
		}
		break;
	}
	if (number == -1L) {
		p->screen = 0;
	} else if (number == 101L ||	/* Basic hallway */
		   number == 1101L ||
		   number == 10101L ||
		   number == 11101L ||
		   number == 100101L ||
		   number == 110101L ||
		   number == 101101L ||
		   number == 111101L ||
		   number == 1000101L ||
		   number == 1001101L ||
		   number == 1010101L ||
		   number == 1100101L ||
		   number == 1110101L ||
		   number == 1101101L ||
		   number == 1111101L ||
		   number == 1011101L) {
		if(which_one)
			p->screen = 1;
		else
			p->screen = 2;
	} else if (number == 11L || 
		   number == 11011L ||
		   number == 110011L ||
		   number == 111011L ||
		   number == 100011L ||
		   number == 1010011L) {
		p->screen = 3;
	} else if (number == 1110L ||	/* Left Wall & Wall Ahead */
		   number == 11110L ||
		   number == 101110L ||
		   number == 1011110L ||
		   number == 1001110L) {
		p->screen = 4;
	} else if (number == 1111010L) {/* wall out front alone from passage */
		p->screen = 5;
	} else if (number == 111L ||
		   number == 1111L ||
		   number == 11111L ||
		   number == 111111L ||
		   number == 100111L ||
		   number == 101111L ||
		   number == 110111L ||
		   number == 1011111L ||
		   number == 1111111L) {
		p->screen = 6;
	} else if (number == 0L) {
		p->screen = 7;
	} else if (number == 1100L ||/*	Screen Full left, none on Right */
		   number == 1000100L ||
		   number == 11100L ||
		   number == 1011100L ||
		   number == 101100L ||
		   number == 1001100L ||
		   number == 111100L ||
		   number == 1110100L ||
		   number == 100100L || 
		   number == 1100100L) {
		p->screen = 8;
	} else if (number == 10001L ||
		   number == 11001L ||
		   number == 110001L ||
		   number == 111001L ||	
		   number == 100001L ||
		   number == 101001L ||
		   number == 1010001L ||
		   number == 1000001L ||
		   number == 1L) { 
		p->screen = 9;
	} else if (number == 10L) {
		p->screen = 10;
	} else if (number == 1111000L) {
		p->screen = 11;
	} else if (number == 1100000L) {
		p->screen = 12;
	} else if (number == 1101000L) {
		p->screen = 13;
	} else if (number == 111000L) {
		p->screen = 14;
	} else if (number == 11010L) {
		p->screen = 15;
	} else if (number == 1111100L ||/* Wall is partial on left */
		   number == 1101100L) {/* Full on Right. */
		p->screen = 16;
	} else if (number == 1011001L ||/* Full right wall partial on left */
		   number == 1111001L || 
		   number == 1110001L ||
		   number == 1101001L ||
		   number == 1100001L) {
		p->screen = 17;
	} else if (number == 1111011L ||/* Left corner with partial on left Side. */
		   number == 1110011L ||
		   number == 1011011L) {
		p->screen = 18;
	} else if (number == 1111110L ||/* Right corner with partial on Right Side. */
		   number == 1101110L ||
		   number == 111110L) { 
		p->screen = 19;
	} else if (number == 110000L) {
		p->screen = 20;
	} else if (number == 1001000L) {
		p->screen = 21;
	} else if (number == 11000L) {
		p->screen = 22;
	} else if (number == 1000000L) {
		p->screen = 23;
	} else if (number == 111010L) {
		p->screen = 24;
	} else if (number == 1011010L) {
		p->screen = 25;
	} else if (number == 10010L) {
		p->screen = 26;
	} else if (number == 10011L) {
		p->screen = 27;
	} else if (number == 1101010L) {
		p->screen = 28;
	} else if (number == 1110010L) {
		p->screen = 29;
	} else if (number == 1001010L) {
		p->screen = 30;
	} else if (number == 110010L) {
	 	p->screen = 31;
	} else if (number == 101010L) {
		p->screen = 32;
	} else if (number == 1011000L) {
		p->screen = 33;
	} else {
		p->screen = 7;
	}
# ifdef DEBUG
	wmove(debug_win,0,0);
	wclrtoeol(debug_win);
	wrefresh(debug_win);
	wprintw(debug_win,"num=%d",number);
	wmove(debug_win,1,0);
	wclrtoeol(debug_win);
	wprintw(debug_win,"scr=%d",p->screen);
	wrefresh(debug_win);
# endif
}


int getint(row,col)			/* routine to read an integer from */
int row,col;	 			/* the message window.		   */
{
	get_str(row,col);
	return(atoi(string));
}

look_inv()		/* look at your inventory.   */
{
	unsigned char choice;

	start = firstnode;
	wclear(inv_win);
	do
	    {
		wmove(inv_win,0,0);
		wprintw(inv_win,"Inventory :");
		wmove(inv_win,1,0);
		wprintw(inv_win,"N)ext P)rev W)ield R)emove");
		wmove(inv_win,2,0);
		wprintw(inv_win,"U)se D)rop esc) to exit ");
		wmove(inv_win,4,0);
		wclrtoeol(inv_win);
		wprintw(inv_win,"%s ",start->item);
		wprintw(inv_win,"%d ",start->armor_val);
		if(start->used == TRUE)
			wprintw(inv_win,"*");
		wmove(inv_win,2,24);
		wrefresh(inv_win);
		choice = getch();
		switch (choice){
	        case 'N':		/* Go to the next item.    */
		case 'n': 
			if(start->next != NULL)
			   start = start->next;
			break;
		case 'P':		/* Go to the previous item. */
		case 'p': 
			if(start->prev != NULL)
	  		  start = start->prev;
			break;
		case 'W':		/* Put on the item.	    */
		case 'w': 
			if(check_it(start->item_type) == FALSE){
			  if(start->used == FALSE)
			    char_stats.ac += start->armor_val;
			  else{
			    wclear(message_win);
			    print_mess("You already are wearing this.",0,0);
			    wrefresh(message_win);
			  }
			  start->used = TRUE;
			  print_stats();
			  if(start->item_type == 6){
			     d_val = start->dam_val;
			     d_mod = start->dam_mod;
			  }
			}
			break;
	     	case 'R':		/* Take off an item.       */
		case 'r': 
			if(start->used == TRUE){
			      if(start->item_type == 6){
			         d_val = HAND_DAM;
			         d_mod = HAND_MUL;
			      }
				char_stats.ac -= start->armor_val;
				start->used = FALSE;
				print_stats();
			}
			break;
		case 'D':		/* Drop an item.          */
		case 'd': 
			 if(start->used == TRUE){
			   print_mess("Must take off item first.",0,0);
			   wrefresh(message_win);
			 }
			 else
			 if(start->next == NULL && start->prev == NULL){
			   print_mess("Can't Drop Everything!!",0,0);
			   wrefresh(message_win);
			 }
			 else				/* reset pointers. */
			   if(start->next == NULL){
			      start->prev->next = NULL;
			      start = start->prev;
			      char_stats.num_items--;
		  	  }
			    else
			       if(start->prev == NULL){
			         start->next->prev = NULL;
			         start = start->next;
				 firstnode = start;
			         char_stats.num_items--;
			       }
			       else{
				   start->next->prev = start->prev;
				   start->prev->next = start->next;
				   start = start->next;
			           char_stats.num_items--;
			       }   
			break;
		default: 
			break;
		}
	}
	while(choice != ESC);
	wclear(inv_win);
	wrefresh(inv_win);
}

init_list()
{

	oldnode = (list *) malloc(sizeof(list));
	firstnode = oldnode;

	oldnode->prev = NULL;
	strcpy(oldnode->item,"Leather");
	oldnode->armor_val = 3;
	oldnode->item_type = 1;
	oldnode->dam_val  = 0;
	oldnode->dam_mod  = 0;
	oldnode->item_no = 0;
	oldnode->used  = FALSE;
	oldnode->next = NULL;
}

find_item()
{
	if(rand()%100 > 97){
	     if(char_stats.num_items < MAX_INV){
		if(rand()%100 > 99)
		  add_item(12);  /* Special Weapon  */
		else{
		    if(rand()%9 < 2)
			add_item(15);
		    else
	                add_item(((rand()%3)+1) * p->level);
		}
	        char_stats.num_items++;
	  	clr_mess_win();
		sprintf(wrk_buf,"You found something.");
		print_mess(wrk_buf,0,0);
		wrefresh(message_win);
	      }
	}
}



add_item(item_no)
int item_no;
{
	   oldnode = firstnode;
	   newnode = (list *) malloc(sizeof(list));
	   if(item_no == 15){
	     item_no = (14 + rand()%5);
	     strcpy(newnode->item,armor[item_no].item);
	     newnode->armor_val = 0;
	     newnode->item_type = armor[item_no].item_type;
	     newnode->dam_val = 0;
	     newnode->dam_mod = 0;
	     newnode->item_no = item_no;
	     newnode->special = 1;
	     newnode->used = FALSE;
	     newnode->next = NULL;
	   }else{
	     strcpy(newnode->item,armor[item_no].item);
	     newnode->armor_val = armor[item_no].armor_val;
	     newnode->item_type = armor[item_no].item_type;
	     newnode->dam_val = armor[item_no].dam_val;
	     newnode->dam_mod = armor[item_no].dam_mod;
	     newnode->item_no = item_no;
	     newnode->special = 0;
	     newnode->used = FALSE;
	     newnode->next = NULL;
	   }
	   while(oldnode->next != NULL)
	      oldnode = oldnode->next;
	   newnode->prev = oldnode;
	   oldnode->next = newnode;
}

int check_it(type)
int type;
{
	int found;
	int ct = 0;

	temp = firstnode;
	found = FALSE;
	if(temp->next != NULL)
	do
	  {
	    if((temp->item_type == type) && (temp->used == TRUE)){
	      ct = 15;
	      sprintf(wrk_buf,"You must take off your %s ",temp->item);
	      print_mess(wrk_buf,0,0);
	      print_mess("before you can wear this.",1,0);
	      wrefresh(message_win);
	      found = TRUE;
	    }else{
    	      temp = temp->next;
	      ct++;
	      found = FALSE;
	    }
	  }
	while(temp->next != NULL && ct != 15 && !found);
return(found);
}
		

catch(signo)		/* Catch a signal and handle it.  */
int signo;
{
	switch (signo){

	case SIGINT : 
		clr_mess_win();
		print_mess("Really Quit?",0,0);
		wrefresh(message_win);
		if(wgetch(message_win) == 'y'){
			strcpy(tmp.death_by,"quitting");
			death();
		}else
		   	wclear(message_win);
		break;

	case SIGTERM:
	case SIGHUP :
	case SIGSEGV:
#ifndef COHERENT
	case SIGILL :
	case SIGFPE :
	case SIGBUS :
#endif
		clr_mess_win();
		print_mess("PANIC QUIT - SIGNAL ",0,0);
		wmove(message_win,1,0);
		wprintw("%d",signo);
		wrefresh(message_win);
		save();
		sleep(1);
		end_game();
	break;
	}
	wrefresh(message_win);
}

	

disarm()		/* disarm a trap.  */
{
	int rows,cols;
	
	rows = p->row;
	cols = p->col;
	switch (p->face){

 	   case NORTH:
 		     rows--;
  	   break;
	   case EAST :
		     cols++;
	   break;
	   case SOUTH:
		     rows++;
	   break;
	   case WEST :
		     cols--;
	   break;
	}

	if(levels[p->level-1][rows][cols] == TRAP)  /* Were you successful? */
	  if((char_stats.level + 50) > rand()%99){
	    print_mess("You disarmed the Trap!",0,0);
	    char_stats.experience += 2;
	    gain_lvl();
	    levels[p->level-1][rows][cols] = BLANK; /* if so remove trap.   */
	    p->row = rows;
	    p->col = cols;
	    showit = TRUE;
	    print_stats();
	  }else{
	    wmove(message_win,0,0);
	    wclrtoeol(message_win);
						  /* else hurt you.       */
	    print_mess("OUCH, you failed to disarm.",0,0);
	    if(char_stats.dexterity > 16)	
	      char_stats.hitpoints -= rand()%4 + 1;
	    else
	      char_stats.hitpoints -= rand()%10 + 1;
	    print_stats();
	  }
	  else
	     print_mess("No trap Here!",0,0);
 	wrefresh(message_win);
sleep(1);
}

regen()		/* regenerate character, rate depends on level */
{
	int hp_factor;
	int sp_factor;

	switch(char_stats.level){
	   case 1:
		   hp_factor = 10;
		   sp_factor = 15;
	   break;
	   case 2:
		   hp_factor = 20;
		   sp_factor = 20;
	   break;
	   case 3:
		   hp_factor = 25;
		   sp_factor = 30;
	   break;
	   case 4:
		   hp_factor = 35;
		   sp_factor = 40;
	   break;
	   case 5:
		   hp_factor = 45;
		   sp_factor = 50;
	   break;
	   case 6:
		   hp_factor = 55;
		   sp_factor = 65;
	   break;
	   case 7:
		   hp_factor = 65;
		   sp_factor = 75;
	   break;
	   case 8:
		   hp_factor = 75;
		   sp_factor = 90;
	   break;
	   case 9:
		   hp_factor = 95;
		   sp_factor = 110;
	   break;
	   case 10:
		   hp_factor = 110;
		   sp_factor = 125;
	   break;
	   default: hp_factor = 150;
		    sp_factor = 170;
	}
	p->move_count++;
	if(p->move_count % (hp_factor / char_stats.level) == 0){
		if(char_stats.hitpoints != char_stats.max_hp){
			char_stats.hitpoints++;
			print_stats();
		}
	}
	if(p->move_count % (sp_factor / char_stats.level) == 0){
		if(char_stats.spellpoints != char_stats.max_spt){
			char_stats.spellpoints++;
			print_stats();
		}
	}
}

	
gain_lvl()			/* gain an experience level */
{
	int hitpt, sppt;

	if(char_stats.level < 35)
	if(exp[char_stats.level + 1] <= char_stats.experience)
	  if(lvl_att[char_stats.level + 1] != TRUE){
	     hitpt = rand()%6 + 4;
	     sppt  = rand()%2 + 1;
	     char_stats.hitpoints  += hitpt;
	     char_stats.max_hp += hitpt;
	     char_stats.spellpoints += sppt;
	     char_stats.max_spt += sppt;
	     char_stats.level++;
	     known[char_stats.level] = TRUE;
	     lvl_att[char_stats.level] = TRUE;
	     lvl_att[char_stats.level + 1] = FALSE;
	     print_stats();
	     beep();
	     wrefresh(message_win);
	  }
}

clr_mess_win()
{
	int index;

	wmove(message_win,0,0);
	for(index=0;index<240;index++)
	   wprintw(message_win,"%c",BLANK);
	wmove(message_win,0,0);
	wrefresh(message_win);
}

rest()		/* Rest for a period */
{
	int turns,chance,x;

	print_mess("Rest How long? ",0,0);
	wrefresh(message_win);
	turns = getint(0,16);
	wclear(message_win);
	wrefresh(message_win);
	if(turns > 100)
	  chance = 90;
	else
	  chance = 95;
	for(x=0;x<=turns;x++){
	  if(rand()%100 > chance){
	    print_mess("Woke up.",0,0);
	    wrefresh(message_win);
	    combat();
	    turns = 0;
	  }
	  if(turns%2 == 0)
	    regen();
	}
	print_mess("Done Resting.",0,0);
}

place_at()			/* Teleport player to some exact location */
{
	switch(p->level){
	  case 1: if(p->row == 4 && p->col == 61){
		     p->row = 4;
		     p->col = 55;
		   }else{
		     p->row = 1;
		     p->col = 30;
		   }
	  break;
	  case 2: if(p->row == 0 && p->col == 0){
		     p->row = 0;
		     p->col = 0;
		   }else{
		     p->row = 0;
		     p->col = 0;
		   }
	  break;
	  case 3: if(p->row == 6 && p->col == 10){
		     p->row = 13;
		     p->col = 63;
		   }else{
		     p->row = 7;
		     p->col = 12;
		   }
	  break;
	  case 4: if(p->row == 0 && p->col == 0){
		     p->row = 0;
		     p->col = 0;
		   }else{
		     p->row = 0;
		     p->col = 0;
		   }
	  break;
	  case 5: if(p->row == 0 && p->col == 0){
		     p->row = 0;
		     p->col = 0;
		   }else{
		     p->row = 0;
		     p->col = 0;
		   }
	  break;
	}
showit = TRUE;
}

create_wall()
{
	levels[p->level-1][p->row][p->col] = WALL;
}

redraw()
{
	move(0,0);
	clear();
	refresh();
	wclear(view_win);
	wclear(message_win);
	wclear(stat_win);
	wclear(compass_win);
	wclear(inv_win);
	wrefresh(inv_win);
	show_scr();
	print_stats();
        if(p->compass_on)
          compass();
}

fountain()
{
	print_mess("You see a Fountain.",0,0);
	print_mess("Drink from the fountain? (y/n) ",1,0);
	wrefresh(message_win);
	if(wgetch(message_win) == 'y'){	
	  levels[p->level-1][p->row][p->col] = BLANK;
	switch(rand()%6){
	  case 0:
		  if(char_stats.dexterity < 18){
		    char_stats.m_dex++;
		    char_stats.dexterity++;
		    print_mess("You feel more dexterous.",2,0);
                    print_stats();
		  }
		  else
		    print_mess("You feel more dexterous.",2,0);
	          wrefresh(message_win);
	  break;
	  case 1:
		  if(char_stats.constitution < 18){
		    char_stats.m_con++;
		    char_stats.constitution++;
		    print_mess("You feel more healthy.",2,0);
                    print_stats();
		  }
		  else
		    print_mess("You feel more healthy.",2,0);
	          wrefresh(message_win);
	  break;
	  case 2:
		  if(char_stats.intelligence < 18){
		    char_stats.m_int++;
		    char_stats.intelligence++;
		    print_mess("You feel more intelligent.",2,0);
                    print_stats();
		   }
		   else
		     print_mess("You feel more intelligent.",2,0);
	          wrefresh(message_win);
	  break;
	  case 3:
		  if(char_stats.wisdom < 18){
		    char_stats.m_wis++;
		    char_stats.wisdom++;
		    print_mess("You feel more wise.",2,0);
                    print_stats();
		  }
		  else
		    print_mess("You feel more wise.",2,0);
	          wrefresh(message_win);
	  break;
	  case 4:
		  if(char_stats.strength < 18){
		    char_stats.m_str++;
		    char_stats.strength++;
		    print_mess("You feel stronger.",2,0);
                    print_stats();
		  }
		  else
		    print_mess("You feel stronger.",2,0);
	          wrefresh(message_win);
	  break;
	  case 5:
		 if(char_stats.level < 33){
		   char_stats.experience = exp[char_stats.level+1];
		   gain_lvl();
	           print_stats();
		 }
	         print_mess("You Feel More Skillful.",2,0);
		 wrefresh(message_win);
	  break;
	}
	}else
	  print_mess("Left the Fountain alone.",2,0);
}

god_mode()
{
	char strin[20];
	int test;
	char ans;

	print_mess("Password: ",0,0);
	wmove(message_win,0,11);
	wrefresh(message_win);
	scanw("%s",strin);
	if((test = strcmp(strin,"THE_WIZ")) != 0){
	   print_mess("Sorry, You cannot enter 'god mode.'",1,0);
	   wrefresh(message_win);
	   sleep(1);
	 }else{
	   wclear(message_win);
	   print_mess("Name: ",0,0);
	   wmove(message_win,0,7);
	   wrefresh(message_win);
	   get_str(0,7);
	   strcpy(char_stats.Name,string);
	   print_stats();
	   wclear(message_win);
	   print_mess("Set Str to 18 (y/n)? ",0,0);
	   wrefresh(message_win);
	   ans = getch();
	   if(ans == 'y'){
	     char_stats.strength = 18;
	     char_stats.m_str = 18;
	     print_stats();
	   }
	   wclear(message_win);
	   print_mess("Set Con to 18 (y/n)? ",0,0);
	   wrefresh(message_win);
	   ans = getch();
	   if(ans == 'y'){
	     char_stats.constitution = 18;
	     char_stats.m_con = 18;
	     print_stats();
	   }
	   wclear(message_win);
	   print_mess("Set Dex to 18 (y/n)? ",0,0);
	   wrefresh(message_win);
	   ans = getch();
	   if(ans == 'y'){
	     char_stats.dexterity = 18;
	     char_stats.m_dex = 18;
	     print_stats();
	   }
	   wclear(message_win);
	   print_mess("Set Int to 18 (y/n)? ",0,0);
	   wrefresh(message_win);
	   ans = getch();
	   if(ans == 'y'){
	     char_stats.intelligence = 18;
	      char_stats.m_int = 18;
	     print_stats();
	   }
	   wclear(message_win);
	   print_mess("Set Wis to 18 (y/n)? ",0,0);
	   wrefresh(message_win);
	   ans = getch();
	   if(ans == 'y'){
	     char_stats.wisdom = 18;
	     char_stats.m_wis = 18;
	     print_stats();
	   }
	   do{
	     wclear(message_win);
	     print_mess("Raise level (y/n)? ",0,0);
	     wrefresh(message_win);
	     ans = getch();
	     if(ans == 'y' && char_stats.level < 34){
	       char_stats.experience = exp[char_stats.level+1];
	       gain_lvl();
	       print_mess("Welcome to the next level.",2,0);
	       wrefresh(message_win);
	       sleep(1);
	     }
	   }
	   while(ans == 'y');
	     
	   wclear(message_win);
	   print_mess("Add 3000 Gold (y/n)? ",0,0);
	   wrefresh(message_win);
	   ans = getch();
	   if(ans == 'y'){
             char_stats.gold += 3000;
	     print_stats();
	   }
	   wclear(message_win);
	   print_mess("Add item to inventory (y/n)? ",0,0);
	   wrefresh(message_win);
	   ans = getch();
	   if(ans == 'y'){
	     print_mess("What item number? ",2,0);
	     wrefresh(message_win);
	     test = getint(2,19);
	     if(test < 15 && test >= 0)
               add_item(test);
	     else{
	       beep();
	       print_mess("No such Item.",3,0);
	       wrefresh(message_win);
	       sleep(1);
	     }
	}
      }
}


which_known()
{
	print_mess("+----------------+",0,0);
	sprintf(wrk_buf,"| a) [%d]  b) [%d] |",known[0],known[1]);
	print_mess(wrk_buf,1,0);
	sprintf(wrk_buf,"| c) [%d]  d) [%d] |",known[2],known[3]);
	print_mess(wrk_buf,2,0);
	sprintf(wrk_buf,"| e) [%d]  f) [%d] |",known[4],known[5]);
	print_mess(wrk_buf,3,0);
	sprintf(wrk_buf,"| g) [%d]  h) [%d] |",known[6],known[7]);
	print_mess(wrk_buf,4,0);
	print_mess("+----------------+",5,0);
	print_mess("Hit a key to Continue.",6,0);
	wrefresh(message_win);
	wgetch(message_win);
}

death()
{
	score_list();
	clear();
	move(11,20);
	printw("You were killed by %s.",tmp.death_by);
	move(12,20);
	printw("Better Luck Next Time!");
	end_game();
}

end_game()
{
	nl();
	echo();
	move(23,0);
	refresh();
	resetty();
	exit(0);
}

