#ifndef _MEMDBG
#define _MEMDBG
#ifdef __LINE__
#define malloc(x) vmalloc((x), __FILE__, __LINE__)
#define free(x) vfree((x), __FILE__, __LINE__)
#define realloc(x,y) vrealloc((x), (y), __FILE__, __LINE__)
#define calloc(x,y) vcalloc((x), (y), __FILE__, __LINE__)
#define MEMDMP() vdump(__FILE__,__LINE__)
void *vmalloc(unsigned int, char *, int);
void vfree(void *, char *, int);
void vverify(char *, int);
void *vrealloc(void *, unsigned int, char *, int);
void *vcalloc(unsigned int, unsigned int, char *, int);
void vdump(char *, int);
#else
#define malloc vmalloc
#define free vfree
#define realloc vrealloc
#define calloc vcalloc
#define MEMDMP() vdump()
void *vmalloc();
void vfree();
void vverify();
void *vrealloc();
void *vcalloc();
void vdump();
#endif
#endif
