/*
 * Driver for bit-mapped devices implementing a partial iBCS console ioctl() 
 * code compliant interface.  For Coherent 4.0.
 * By Harry C. Pulley, IV.  Started 23NOV92
 */

	/*
	**	Vance W. Petree - 12/10/92
	**	Added global flag to disable screen saver when in graphics
	**	mode (see mmas.s.diff).
	*/

#include <sys/coherent.h>
#include <sys/reg.h>
#include <sys/con.h>
#include <sys/devices.h>
#include <errno.h>
/* #include <sys/proc.h> not needed */
#include <sys/stat.h>

#include "bm.h"

/*
 * Driver configuration.
 */
int	bmload();
int	bmunload();
int	bmopen();
int	bmclose();
int	bmioctl();
int	nulldev();
int	nonedev();
	  
/* ----------------------------------------------------------------- */

int	graphics_mode ;	/* set true (1) or false (0)	*/

/* ----------------------------------------------------------------- */

CON	bmcon =	{
	DFCHR,				/* Flags - character device*/
	BM_MAJOR,			/* Major index - in sys/devices.h */
	bmopen,				/* Open */
	bmclose,			/* Close */
	nulldev,			/* Block */
	nonedev,			/* Read */
	nonedev,			/* Write */
	bmioctl,			/* Ioctl */
	nulldev,			/* Powerfail */
	nulldev,			/* Timeout */
	bmload,				/* Load */
	bmunload			/* Unload */
};

static display_mapped=0;
static display_open=0;

static
bmload()
{
	/* we should probably check for the existance of a graphics card here
	   for now, we will assume one exits - caveat utilitor... */

	printf("Generic Bit-Mapped Graphics driver loaded.\n");
}

static 
bmunload()
{
	if (display_mapped)
	{
		/* we should unmap the display here, but the system call is not
		   available to do this */
		display_mapped=0;
	}

	if (display_open)
	{
		/* we should do things to 'close' the display here */
		display_open=0;
	}
}

static
bmopen(dev,mode)
dev_t dev;
unsigned int mode;
{
	/* for now, only have a minor device 0 which is the iBCS interface.
	   later, maybe minor device 1 which has some sort of graphics support
	   built in (the iBCS interface relies entirely on the application 
	   program to control the bit-mapped device) */

	graphics_mode = 1 ;		/* disable screen saver */
	if (minor(dev) != 0)
	{
		u.u_error = ENXIO;

		return;
	}

	/* only one process may have the bitmap device at one time */

	if (display_open)
	{
		u.u_error = EBUSY;

		return;
	}

#ifdef CHECKMODE
	/* display must be opened for write at least */

	if (!(mode&IPW))
	{
		u.u_error = ENODEV;

		return;
	}
#endif

	display_open = 1;

	/* should we save the i/o permission map here and restore on close()? */
}

static
bmclose(dev)
dev_t dev;
{
	display_open = 0;
	graphics_mode = 0 ;	/* enable screen saver */
	display_mapped = 0;

	/* if we saved the i/o permission map before, we should restore it here */
}

static
bmioctl(dev,com,vec)
dev_t dev;
int com;
struct bmform *vec;
{
	struct bmform bmstruc;

	ukcopy(vec,&bmstruc,sizeof(struct bmform));

	switch (com)
	{
	case KDMAPDISP:
		/* we should do some error checking here */

		if (bmstruc.arg.map.userAddr%4096)
		{
			u.u_error = EINVAL;
			printf("userAddr is not on a page boundary - display not mapped.\n");
			return;
		}

		if (bmstruc.arg.map.videoAddr%4096)
		{
			u.u_error = EINVAL;
			printf("videoAddr is not on a page boundary - display not mapped.\n");
			return;
		}

		if (bmstruc.arg.map.videoAddr<0x000A0000)
		{
			u.u_error = EINVAL;
			printf("videoAddr is below A0000 - display not mapped.\n");
			return;
		}
	
		if ((bmstruc.arg.map.videoAddr+bmstruc.arg.map.videoLen)>0x000C0000)
		{
			u.u_error = EINVAL;
			printf("videoAddr + videoLen goes above C0000 - display not mapped.\n");
			return;
		}

		if (mapPhysUser(bmstruc.arg.map.userAddr,bmstruc.arg.map.videoAddr,
			bmstruc.arg.map.videoLen))
		{
			display_mapped++;
		}
		else
		{
			u.u_error = ENXIO;
			printf("Unable to map bit-mapped device.\n");
		}
		break;

	case KDUNMAPDISP: /* not yet implemented - system call not available */
		/* u.u_error = EINVAL; we'll not make it an error for now */
		display_mapped--;
		break;

	case KDADDIO:
		/* we should do some error checking here */
		if (bmstruc.arg.io.offset>0x7ff)
		{
			u.u_error = EINVAL;
			return;
		}

		bmstruc.arg.io.val=kiopriv(bmstruc.arg.io.offset,0);

		kucopy(&bmstruc,vec,sizeof(struct bmform));
		break;

	case KDDELIO:
		/* we should do some error checking here */
		if (bmstruc.arg.io.offset>0x7ff)
		{
			u.u_error = EINVAL;
			return;
		}

		bmstruc.arg.io.val=kiopriv(bmstruc.arg.io.offset,1);

		kucopy(&bmstruc,vec,sizeof(struct bmform));
		break;

	case KDENABIO: /* not yet implemented */
	case KDDISABIO: /* not yet implemented */
	default:
		u.u_error = EINVAL;
		return;
	}
}
