/*

NAME
     banr - print strings in large letters

SYNOPSIS
     banr [-n]

DESCRIPTION
     banr prints its standard input in large letters (but smaller than
     banner(1)) on the standard output.

OPTIONS
     -n  Forces no underlining to be used even if the capability exists.

SEE ALSO
     banner(1)

AUTHOR
     Art Messenger 10/22/87
     art@wilbur.coyote.trw.com

*/

/* compile with -ltermcap */

#include <stdio.h>

#define	TRUE	1
#define	FALSE	0
#define when	break;case
#define wlse	break;default

char usagem[] = "Usage: %s [-n]\n";

struct font {
    struct {
	char *line,*ulmask;
    } c[4];
} character[128] = {	/* the font file: variable width */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x00 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x01 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x02 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x03 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x04 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x05 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x06 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x07 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x08 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x09 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x0a */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x0b */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x0c */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x0d */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x0e */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x0f */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x10 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x11 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x12 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x13 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x14 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x15 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x16 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x17 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x18 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x19 */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x1a */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x1b */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x1c */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x1d */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x1e */
	{ {"",""},{"",""},{"",""},{"",""} },	/* 0x1f */
	{ {"  ","  "},
	  {"  ","  "},
	  {"  ","  "},
	  {"  ","  "} },		/* 0x20: ' ' */
	{ {" "," "},
	  {"|"," "},
	  {"."," "},
	  {" "," "} },			/* 0x21: ! */
	{ {"  ","  "},
	  {"//","  "},
	  {"  ","  "},
	  {"  ","  "} },		/* 0x22: " */
	{ {"   ","   "},
	  {"|_|","_ _"},
	  {"|_|","_ _"},
	  {"| |","   "} },		/* 0x23: # */
	{ {" __", "   "},
	  {"(| ", " _ "},
	  {"_|)", " _ "},
	  {"   ", "   "} },		/* 0x24: $ */
	{ {"  ","  "},
	  {"o/","  "},
	  {"/o","  "},
	  {"  ","  "} },		/* 0x25: % */
	{ {"  ","  "},
	  {"o ","  "},
	  {"(X","  "},
	  {"  ","  "} },		/* 0x26: & */
	{ {" "," "},
	  {"/"," "},
	  {" "," "},
	  {" "," "} },			/* 0x27: ' */
	{ {" "," "},
	  {"/"," "},
	  {"\\"," "},
	  {" "," "} },			/* 0x28: ( */
	{ {" "," "},
	  {"\\"," "},
	  {"/"," "},
	  {" "," "} },			/* 0x29: ) */
	{ {"  ","  "},
	  {"\\/","__"},
	  {"/\\","  "},
	  {"  ","  "} },		/* 0x2a: * */
	{ {"   ","   "},
	  {"_|_"," _ "},
	  {" | ","   "},
	  {"   ","   "} },		/* 0x2b: + */
	{ {" "," "},
	  {" "," "},
	  {"o"," "},
	  {"/"," "} },			/* 0x2c: , */
	{ {"  ","  "},
	  {"__","  "},
	  {"  ","  "},
	  {"  ","  "} },		/* 0x2d: - */
	{ {" "," "},
	  {" "," "},
	  {"o"," "},
	  {" "," "} },			/* 0x2e: . */
	{ {"  ","  "},
	  {" /","  "},
	  {"/ ","  "},
	  {"  ","  "} },		/* 0x2f: / */
	{ {" _ ", "   "},
	  {"/.\\", "   "},
	  {"\\_/", "   "},
	  {"   ", "   "} },		/* 0x30: 0 */
	{ {" ", " "},
	  {"|", " "},
	  {"|", " "},
	  {" ", " "} },			/* 0x31: 1 */
	{ {"_ ", "  "},
	  {" )", "  "},
	  {"/_", "_ "},
	  {"  ", "  "} },		/* 0x32: 2 */
	{ {"_ ", "  "},
	  {"_)", "  "},
	  {"_)", "  "},
	  {"  ", "  "} },		/* 0x33: 3 */
	{ {"   ", "   "},
	  {"/_|", "_  "},
	  {"  |", "   "},
	  {"   ", "   "} },		/* 0x34: 4 */
	{ {" __", "   "},
	  {"|_ ", "   "},
	  {"._)", "   "},
	  {"   ", "   "} },		/* 0x35: 5 */
	{ {"   ", "   "},
	  {" / ", " _ "},
	  {"(_)", "   "},
	  {"   ", "   "} },		/* 0x36: 6 */
	{ {"__", "  "},
	  {" /", "  "},
	  {"/ ", "  "},
	  {"  ", "  "} },		/* 0x37: 7 */
	{ {" _ ", "   "},
	  {"(_)", "   "},
	  {"(_)", "   "},
	  {"   ", "   "} },		/* 0x38: 8 */
	{ {" _ ", "   "},
	  {"(_)", "   "},
	  {" / ", "   "},
	  {"   ", "   "} },		/* 0x39: 9 */
	{ {" ", " "},
	  {"o", " "},
	  {"o", " "},
	  {" ", " "} },			/* 0x3a: : */
	{ {" ", " "},
	  {"o", " "},
	  {"o", " "},
	  {"/", " "} },			/* 0x3b: ; */
	{ {" ", " "},
	  {"/", " "},
	  {"\\", " "},
	  {" ", " "} },			/* 0x3c: < */
	{ {"  ", "  "},
	  {"__", "  "},
	  {"__", "  "},
	  {"  ", "  "} },		/* 0x3d: = */
	{ {" ", " "},
	  {"\\", " "},
	  {"/", " "},
	  {" ", " "} },			/* 0x3e: > */
	{ {" _ ", "   "},
	  {"' )", "   "},
	  {" ! ", "   "},
	  {"   ", "   "} },		/* 0x3f: ? */
	{ {"   ", "   "},
	  {" _ ", "   "},
	  {"(Q)", " __"},
	  {"   ", "   "} },		/* 0x40: @ */
	{ {" _ ", "    "},
	  {"/_\\", "   "},
	  {"| |", "_ _"},
	  {"   ", "   "} },		/* 0x41: A */
	{ {"__ ", "   "},
	  {"|_)", "   "},
	  {"|_)", "_  "},
	  {"   ", "   "} },		/* 0x42: B */
	{ {" _ ", "   "},
	  {"/ '", "   "},
	  {"\\_,", "   "},
	  {"   ", "   "} },		/* 0x43: C */
	{ {"__ ", "   "},
	  {"| \\", "   "},
	  {"|_/", "_  "},
	  {"   ", "   "} },		/* 0x44: D */
	{ {"___", "   "},
	  {"|_ ", "   "},
	  {"|__", "_  "},
	  {"   ", "   "} },		/* 0x45: E */
	{ {"___", "   "},
	  {"|_ ", "   "},
	  {"|  ", "_  "},
	  {"   ", "   "} },		/* 0x46: F */
	{ {" _ ", "   "},
	  {"/ _", "   "},
	  {"\\_|", "   "},
	  {"   ", "   "} },		/* 0x47: G */
	{ {"_ _", "   "},
	  {"|_|", "   "},
	  {"| |", "_ _"},
	  {"   ", "   "} },		/* 0x48: H */
	{ {"_", " "},
	  {"|", " "},
	  {"|", "_"},
	  {" ", " "} },			/* 0x49: I */
	{ {" _", "  "},
	  {" |", "  "},
	  {"\\/", "  "},
	  {"  ", "  "} },		/* 0x4a: J */
	{ {"_ _", "   "},
	  {"|_/", "   "},
	  {"| \\", "_ _"},
	  {"   ", "   "} },		/* 0x4b: K */
	{ {"_  ", "   "},
	  {"|  ", "   "},
	  {"|__", "_  "},
	  {"   ", "   "} },		/* 0x4c: L */
	{ {"_  _", "    "},
	  {"|\\/|", "    "},
	  {"|  |", "_  _"},
	  {"    ", "    "} },		/* 0x4d: M */
	{ {"_  _", "    "},
	  {"|\\ |", "    "},
	  {"| \\|", "_  _"},
	  {"    ", "    "} },		/* 0x4e: N */
	{ {" _ ", "   "},
	  {"/ \\", "   "},
	  {"\\_/", "   "},
	  {"   ", "   "} },		/* 0x4f: O */
	{ {"__ ", "   "},
	  {"|_)", "   "},
	  {"|  ", "_  "},
	  {"   ", "   "} },		/* 0x50: P */
	{ {" _ ", "   "},
	  {"/ \\", "   "},
	  {"\\_X", "   "},
	  {"   ", "   "} },		/* 0x51: Q */
	{ {"__ ", "   "},
	  {"|_)", "   "},
	  {"| \\", "_ _"},
	  {"   ", "   "} },		/* 0x52: R */
	{ {" _ ", "   "},
	  {"(_'", "   "},
	  {",_)", "   "},
	  {"   ", "   "} },		/* 0x53: S */
	{ {"___", "   "},
	  {" | ", "   "},
	  {" | ", " _ "},
	  {"   ", "   "} },		/* 0x54: T */
	{ {"_ _", "   "},
	  {"| |", "   "},
	  {"\\_/", "   "},
	  {"   ", "   "} },		/* 0x55: U */
	{ {"_  _", "    "},
	  {"\\  /", "    "},
	  {" \\/ ", "    "},
	  {"    ", "    "} },		/* 0x56: V */
	{ {"_  _", "    "},
	  {"|  |", "    "},
	  {"\\/\\/", "    "},
	  {"    ", "    "} },		/* 0x57: W */
	{ {"_ _", "   "},
	  {"\\_/", "   "},
	  {"/ \\", "_ _"},
	  {"   ", "   "} },		/* 0x58: X */
	{ {"_ _", "   "},
	  {"\\_/", "   "},
	  {" | ", " _ "},
	  {"   ", "   "} },		/* 0x59: Y */
	{ {"__", "  "},
	  {" /", "  "},
	  {"/_", "_ "},
	  {"  ", "  "} },		/* 0x5a: Z */
	{ {"__","  "},
	  {"| ","  "},
	  {"|_","_ "},
	  {"  ","  "} },		/* 0x5b: [ */
	{ {"  ","  "},
	  {"\\ ","  "},
	  {" \\","  "},
	  {"  ","  "} },		/* 0x5c: \ */
	{ {"__","  "},
	  {" |","  "},
	  {"_|"," _"},
	  {"  ","  "} },		/* 0x5d: ] */
	{ {"  ","  "},
	  {"/\\","  "},
	  {"  ","  "},
	  {"  ","  "} },		/* 0x5e: ^ */
	{ {"  ","  "},
	  {"  ","  "},
	  {"__","  "},
	  {"  ","  "} },		/* 0x5f: _ */
	{ {" "," "},
	  {"\\"," "},
	  {" "," "},
	  {" "," "} },			/* 0x60: ` */
	{ {"   ", "   "},
	  {" _.", "   "},
	  {"(_|", "   "},
	  {"   ", "   "} },		/* 0x61: a */
	{ {"   ", "   "},
	  {"|_ ", "   "},
	  {"|_)", "   "},
	  {"   ", "   "} },		/* 0x62: b */
	{ {"  ", "  "},
	  {" _", "  "},
	  {"|_", "  "},
	  {"  ", "  "} },		/* 0x63: c */
	{ {"   ", "   "},
	  {" _|", "   "},
	  {"(_|", "   "},
	  {"   ", "   "} },		/* 0x64: d */
	{ {"   ", "   "},
	  {" _ ", "   "},
	  {"(-'", " _ "},
	  {"   ", "   "} },		/* 0x65: e */
	{ {" _", "  "},
	  {"|_", "_ "},
	  {"| ", "  "},
	  {"  ", "  "} },		/* 0x66: f */
	{ {"   ", "   "},
	  {" _ ", "   "},
	  {"(_|", "   "},
	  {"._)", "   "} },		/* 0x67: g */
	{ {"   ", "   "},
	  {"|_ ", "   "},
	  {"| |", "   "},
	  {"   ", "   "} },		/* 0x68: h */
	{ {" ", " "},
	  {".", " "},
	  {"|", " "},
	  {" ", " "} },			/* 0x69: i */
	{ {"  ", "  "},
	  {" .", "  "},
	  {" |", "  "},
	  {"./", "  "} },		/* 0x6a: j */
	{ {"  ", "  "},
	  {"| ", "  "},
	  {"|<", "  "},
	  {"  ", "  "} },		/* 0x6b: k */
	{ {" ", " "},
	  {"|", " "},
	  {"|", "_"},
	  {" ", " "} },			/* 0x6c: l */
	{ {"     ", "     "},
	  {"._ _ ", "     "},
	  {"| | |", "     "},
	  {"     ", "     "} },		/* 0x6d: m */
	{ {"   ", "   "},
	  {"._ ", "   "},
	  {"| |", "   "},
	  {"   ", "   "} },		/* 0x6e: n */
	{ {"   ", "   "},
	  {" _ ", "   "},
	  {"(_)", "   "},
	  {"   ", "   "} },		/* 0x6f: o */
	{ {"   ", "   "},
	  {"._ ", "   "},
	  {"|_)", "   "},
	  {"|  ", "   "} },		/* 0x70: p */
	{ {"   ", "   "},
	  {" _.", "   "},
	  {"(_|", "   "},
	  {"  |", "   "} },		/* 0x71: q */
	{ {"  ", "  "},
	  {"._", "  "},
	  {"| ", "  "},
	  {"  ", "  "} },		/* 0x72: r */
	{ {" ", " "},
	  {"_", " "},
	  {"\\", "_"},
	  {" ", " "} },			/* 0x73: s */
	{ {" ", " "},
	  {"|", "_"},
	  {"|", " "},
	  {" ", " "} },			/* 0x74: t */
	{ {"   ", "   "},
	  {"   ", "   "},
	  {"|_|", "   "},
	  {"   ", "   "} },		/* 0x75: u */
	{ {"  ", "  "},
	  {"  ", "  "},
	  {"\\/", "  "},
	  {"  ", "  "} },		/* 0x76: v */
	{ {"    ", "    "},
	  {"    ", "    "},
	  {"\\/\\/", "    "},
	  {"    ", "    "} },		/* 0x77: w */
	{ {"  ", "  "},
	  {"  ", "  "},
	  {"><", "  "},
	  {"  ", "  "} },		/* 0x78: x */
	{ {"   ", "   "},
	  {"   ", "   "},
	  {"\\_/", "   "},
	  {"_/ ", "   "} },		/* 0x79: y */
	{ {" ", " "},
	  {"_", " "},
	  {"/", "_"},
	  {" ", " "} },			/* 0x7a: z */
	{ {" "," "},
	  {"("," "},
	  {"("," "},
	  {" "," "} },			/* 0x7b: { */
	{ {" "," "},
	  {"|"," "},
	  {"|"," "},
	  {" "," "} },			/* 0x7c: | */
	{ {" "," "},
	  {")"," "},
	  {")"," "},
	  {" "," "} },			/* 0x7d: } */
	{ {"  ","  "},
	  {"^v","  "},
	  {"  ","  "},
	  {"  ","  "} },		/* 0x7e: ~ */
	{ {"",""},{"",""},{"",""},{"",""} }	/* 0x7f */
};

char *rindex();

main(argc,argv)
    int argc;
    char *argv[];
{
    int
	nflag=FALSE,		/* -n: don't underline */
	uflag=FALSE,		/* do underlining */
	i;
    char
	*arg0,			/* the name of this program */
	line[BUFSIZ],		/* input line */
	*tname,			/* name of TERM variable */
	bp[BUFSIZ],		/* buffer used by termcap stuff */
	buf[BUFSIZ],		/* buffer to place us and ue strings */
	*area=buf,		/* pointer into buf */
	*us,*ue,		/* underline start and end strings */
	*s,
	*tgetstr(),*getenv();

    /* parse arguments */
    arg0 = rindex(*argv,'/') ? rindex(*argv,'/')+1 : *argv;
    while (*++argv)
	if (**argv == '-')
	    switch (*++*argv) {
		when 'n':
		    nflag=TRUE;
		wlse:
		    usage(arg0);
	    }
	else usage(arg0);

    /* check for underline ability */
    if (!nflag && (tname=getenv("TERM")) && tgetent(bp,tname)==1) {
	/* only do if changing to underlining takes no space (I'm lazy) */
	uflag= tgetnum("ug") <= 0
		&& (us=tgetstr("us",&area))
		&& (ue=tgetstr("ue",&area));
    }

    /* now portray the strings */
    while (fgets(line,BUFSIZ,stdin))
	for (i=0;i<4;i++)
	    for (s= line; *s; s++) {
		putouts(*s & 0177,i,uflag,us,ue);
		if (s[1])
		    putchar(' ');
	    }
    exit(0);
}

putouts(ch,i,uflag,us,ue)
    int ch,i,uflag;
    char *us,*ue;
{
    int ul,putch();
    char *l,*u;

    if (ch == '\n')
	putchar(ch);
    else {
	l = character[ch].c[i].line;
	u = character[ch].c[i].ulmask;
	while (*l) {
	    if (ul = (uflag && (*l=='_' || *u=='_')))
		tputs(us,1,putch);
	    if (uflag && *l=='_')
		putchar(' ');
	    else
		putchar(*l);
	    if (ul)
		tputs(ue,1,putch);
	    
	    ++l; ++u;
	}
    }
}

putch(ch) { putchar(ch); }

/* usage -- print usage message and exit */
usage(arg0)
    char *arg0;
{
    fprintf(stderr,usagem,arg0);
    exit(1);
}
