/******************************
 *   Banner.C, (c)1990 by     *
 *     Michael Baudisch       *
 ******************************/

/*************************************************************************/
/*   Achtung!! Hier bitte fuer den jeweiligen Computer-typ einstellen!!  */
/*************************************************************************/
/* #define MS_DOS  */       /* Nur fuer MS-DOS-computer + kompatible */
/* #define AMIGA   */       /* Fuer die Amiganer */
#   define UNIX             /* Fuer Unix-ler */
#   define INTERN_DATA      /* Nur das eingebaute Data-file zaehlt */

#ifndef MS_DOS
# ifndef INTERN_DATA
#  define STD_DATA_FILE ""  /* Fuer Nicht-MsDos'ler: Path+name vom StdData */
# endif
#endif                          
/*************************************************************************/

#ifdef MS_DOS
#   include <process.h>
#endif

#ifndef AMIGA
#ifdef COHERENT
#include <sys/malloc.h>
#else
#   include <malloc.h>
#endif
#   include <string.h>
#endif

#include <stdio.h>
#include <ctype.h>

#ifdef INTERN_DATA
unsigned char intern_data[] = {
0x012,0x055,0x020,0x000,0x0ff,0x041,0x001,0x007,0x042,0x001,0x00f,0x043,0x001,0x017,0x044,0x001,
0x01f,0x045,0x001,0x027,0x046,0x001,0x02f,0x047,0x001,0x037,0x048,0x001,0x03f,0x049,0x001,0x047,
0x04a,0x001,0x04f,0x04b,0x001,0x057,0x04c,0x001,0x05f,0x04d,0x001,0x067,0x04e,0x001,0x06f,0x04f,
0x001,0x077,0x050,0x001,0x07f,0x051,0x001,0x087,0x052,0x001,0x08f,0x053,0x001,0x097,0x054,0x001,
0x09f,0x055,0x001,0x0a7,0x056,0x001,0x0af,0x057,0x001,0x0b7,0x058,0x001,0x0bf,0x059,0x001,0x0c7,
0x05a,0x001,0x0cf,0x03a,0x001,0x0d7,0x03b,0x001,0x0df,0x03d,0x001,0x0e7,0x03f,0x001,0x0ef,0x028,
0x001,0x0f7,0x029,0x001,0x0ff,0x02d,0x002,0x007,0x02f,0x002,0x00f,0x021,0x002,0x017,0x02e,0x002,
0x01f,0x02c,0x002,0x027,0x02b,0x002,0x02f,0x02a,0x002,0x037,0x022,0x002,0x03f,0x023,0x002,0x047,
0x030,0x002,0x04f,0x031,0x002,0x057,0x032,0x002,0x05f,0x033,0x002,0x067,0x034,0x002,0x06f,0x035,
0x002,0x077,0x036,0x002,0x07f,0x037,0x002,0x087,0x038,0x002,0x08f,0x039,0x002,0x097,0x027,0x002,
0x09f,0x05c,0x002,0x0a7,0x061,0x002,0x0af,0x062,0x002,0x0b7,0x063,0x002,0x0bf,0x064,0x002,0x0c7,
0x065,0x002,0x0cf,0x066,0x002,0x0d7,0x067,0x002,0x0df,0x068,0x002,0x0e7,0x069,0x002,0x0ef,0x06a,
0x002,0x0f7,0x06b,0x002,0x0ff,0x06c,0x003,0x007,0x06d,0x003,0x00f,0x06e,0x003,0x017,0x06f,0x003,
0x01f,0x070,0x003,0x027,0x071,0x003,0x02f,0x072,0x003,0x037,0x073,0x003,0x03f,0x074,0x003,0x047,
0x075,0x003,0x04f,0x076,0x003,0x057,0x077,0x003,0x05f,0x078,0x003,0x067,0x079,0x003,0x06f,0x07a,
0x003,0x077,0x03c,0x003,0x07f,0x03e,0x003,0x087,0x07c,0x003,0x08f,0x05f,0x003,0x097,0x020,0x003,
0x09f,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x018,0x03c,0x066,0x066,0x07e,0x066,0x066,
0x000,0x0fc,0x066,0x066,0x07c,0x066,0x066,0x0fc,0x000,0x03c,0x066,0x0c0,0x0c0,0x0c0,0x066,0x03c,
0x000,0x0f8,0x06c,0x066,0x066,0x066,0x06c,0x0f8,0x000,0x0fe,0x062,0x068,0x078,0x068,0x062,0x0fe,
0x000,0x0fe,0x062,0x068,0x078,0x068,0x060,0x0f0,0x000,0x03c,0x066,0x0c0,0x0c0,0x0ce,0x066,0x03e,
0x000,0x066,0x066,0x066,0x07e,0x066,0x066,0x066,0x000,0x07e,0x018,0x018,0x018,0x018,0x018,0x07e,
0x000,0x01e,0x00c,0x00c,0x00c,0x0cc,0x0cc,0x078,0x000,0x0e6,0x066,0x06c,0x078,0x06c,0x066,0x0e6,
0x000,0x0f0,0x060,0x060,0x060,0x062,0x066,0x0fe,0x000,0x0c6,0x0ee,0x0fe,0x0fe,0x0d6,0x0c6,0x0c6,
0x000,0x0c6,0x0e6,0x0f6,0x0de,0x0ce,0x0c6,0x0c6,0x000,0x038,0x06c,0x0c6,0x0c6,0x0c6,0x06c,0x038,
0x000,0x0fc,0x066,0x066,0x07c,0x060,0x060,0x0f0,0x000,0x038,0x06c,0x0c6,0x0c6,0x0da,0x0cc,0x076,
0x000,0x0fc,0x066,0x066,0x07c,0x06c,0x066,0x0e6,0x000,0x03c,0x066,0x060,0x03c,0x006,0x066,0x03c,
0x000,0x07e,0x05a,0x018,0x018,0x018,0x018,0x03c,0x000,0x066,0x066,0x066,0x066,0x066,0x066,0x03c,
0x000,0x066,0x066,0x066,0x066,0x066,0x03c,0x018,0x000,0x0c6,0x0c6,0x0c6,0x0d6,0x0fe,0x0ee,0x0c6,
0x000,0x0c6,0x06c,0x038,0x038,0x06c,0x0c6,0x0c6,0x000,0x066,0x066,0x066,0x03c,0x018,0x018,0x03c,
0x000,0x0fe,0x0c6,0x08c,0x018,0x032,0x066,0x0fe,0x000,0x000,0x000,0x018,0x018,0x000,0x018,0x018,
0x000,0x000,0x000,0x018,0x018,0x000,0x018,0x018,0x030,0x000,0x000,0x07e,0x000,0x000,0x07e,0x000,
0x000,0x03c,0x066,0x066,0x00c,0x018,0x000,0x018,0x000,0x00c,0x018,0x030,0x030,0x030,0x018,0x00c,
0x000,0x030,0x018,0x00c,0x00c,0x00c,0x018,0x030,0x000,0x000,0x000,0x000,0x07e,0x000,0x000,0x000,
0x000,0x006,0x00c,0x018,0x030,0x060,0x0c0,0x080,0x000,0x018,0x018,0x018,0x018,0x018,0x000,0x018,
0x000,0x000,0x000,0x000,0x000,0x000,0x018,0x018,0x000,0x000,0x000,0x000,0x000,0x000,0x018,0x018,
0x030,0x000,0x018,0x018,0x07e,0x018,0x018,0x000,0x000,0x000,0x066,0x03c,0x0ff,0x03c,0x066,0x000,
0x000,0x066,0x066,0x066,0x000,0x000,0x000,0x000,0x000,0x06c,0x06c,0x0fe,0x06c,0x0fe,0x06c,0x06c,
0x000,0x07c,0x0c6,0x0ce,0x0d6,0x0e6,0x0c6,0x07c,0x000,0x018,0x038,0x018,0x018,0x018,0x018,0x07e,
0x000,0x03c,0x066,0x006,0x03c,0x060,0x066,0x07e,0x000,0x03c,0x066,0x006,0x01c,0x006,0x066,0x03c,
0x000,0x01c,0x03c,0x06c,0x0cc,0x0fe,0x00c,0x01e,0x000,0x07e,0x062,0x060,0x07c,0x006,0x066,0x03c,
0x000,0x03c,0x066,0x060,0x07c,0x066,0x066,0x03c,0x000,0x07e,0x046,0x006,0x00c,0x018,0x018,0x018,
0x000,0x03c,0x066,0x066,0x03c,0x066,0x066,0x03c,0x000,0x03c,0x066,0x066,0x03e,0x006,0x066,0x03c,
0x000,0x00c,0x018,0x030,0x000,0x000,0x000,0x000,0x000,0x0c0,0x060,0x030,0x018,0x00c,0x006,0x002,
0x000,0x000,0x000,0x078,0x00c,0x07c,0x0cc,0x076,0x000,0x0e0,0x060,0x07c,0x066,0x066,0x066,0x0dc,
0x000,0x000,0x000,0x03c,0x066,0x060,0x066,0x03c,0x000,0x01c,0x00c,0x07c,0x0cc,0x0cc,0x0cc,0x076,
0x000,0x000,0x000,0x03c,0x066,0x07e,0x060,0x03c,0x000,0x01c,0x036,0x030,0x078,0x030,0x030,0x078,
0x000,0x000,0x000,0x03e,0x066,0x066,0x03e,0x006,0x07c,0x0e0,0x060,0x06c,0x076,0x066,0x066,0x0e6,
0x000,0x018,0x000,0x038,0x018,0x018,0x018,0x03c,0x000,0x006,0x000,0x00e,0x006,0x006,0x066,0x066,
0x03c,0x0e0,0x060,0x066,0x06c,0x078,0x06c,0x0e6,0x000,0x038,0x018,0x018,0x018,0x018,0x018,0x03c,
0x000,0x000,0x000,0x06c,0x0fe,0x0d6,0x0d6,0x0c6,0x000,0x000,0x000,0x0dc,0x066,0x066,0x066,0x066,
0x000,0x000,0x000,0x03c,0x066,0x066,0x066,0x03c,0x000,0x000,0x000,0x0dc,0x066,0x066,0x07c,0x060,
0x0f0,0x000,0x000,0x076,0x0cc,0x0cc,0x07c,0x00c,0x01e,0x000,0x000,0x0dc,0x076,0x060,0x060,0x0f0,
0x000,0x000,0x000,0x03c,0x060,0x03c,0x006,0x07c,0x000,0x030,0x030,0x07c,0x030,0x030,0x036,0x01c,
0x000,0x000,0x000,0x066,0x066,0x066,0x066,0x03e,0x000,0x000,0x000,0x066,0x066,0x066,0x03c,0x018,
0x000,0x000,0x000,0x0c6,0x0d6,0x0d6,0x0fe,0x06c,0x000,0x000,0x000,0x0c6,0x06c,0x038,0x06c,0x0c6,
0x000,0x000,0x000,0x066,0x066,0x066,0x03e,0x006,0x07c,0x000,0x000,0x07e,0x04c,0x018,0x032,0x07e,
0x000,0x00c,0x018,0x030,0x060,0x030,0x018,0x00c,0x000,0x060,0x030,0x018,0x00c,0x018,0x030,0x060,
0x000,0x018,0x018,0x018,0x018,0x018,0x018,0x018,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,
0x0ff,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000 };
#endif

typedef unsigned int UINT;
typedef unsigned char UCHAR;
typedef UCHAR * DATA;

/*******************/
#define VERSION 1.3
/*******************/

#ifndef SEEK_END
#define SEEK_END 2
#endif

#define TRUE    1
#define FALSE   0
#define SIZE_LINE ((size_h+1)*size_y)
#define SIZE_LINE_Y (size_y)
#define SIZE_CHAR (size_x*size_y)
#define CLEAR_LINE 1
#define CLEAR_CHAR 2
#define CLEAR_ALL (CLEAR_LINE|CLEAR_CHAR)
#define XMAX (size_h)

void main        (/*int argc, char *argv[]*/);
void help        (/*void*/);
void shutdown    (/*char *txt*/);
void clearmem    (/*int was*/);
void newline     (/*void*/);
void writeword   (/*char *txt*/);
void putword     (/*char *txt*/);
void calc_char   (/*char x*/);
void insert_char (/*char chrx*/);
void writechar   (/*char x*/);
int  read_word   (/*FILE *fh, char *txt*/);
void banner_file (/*FILE *fh*/);

DATA zs = 0, chr = 0, line = 0;
FILE *fh = 0;
UCHAR str[256], b_file[80], fchar = ' ', fchar2 = ' ';
int size_h = 80, size_x = 8, size_y = 8;
int xpos, empty = TRUE, chars=FALSE, pipe=FALSE, upper=FALSE;
int italics = FALSE, inverse = FALSE, fcharf = FALSE, ultraflag = FALSE;

void main(argc,argv)
int argc;
char *argv[];
{
long n,m;
#ifdef COHERENT
char *puffer;
#else
void *puffer;
#endif
	*str=*b_file='\0';
	if(argc==1||(argc==2&&!(strcmp(argv[1],"?")*strcmp(argv[1],"/?")*strcmp
													(argv[1],"/h"))))
	{
		help();
		shutdown("");
	}
	for(n=1;n<argc;n++)
	{
		if(*argv[n]=='/')
		{
			switch(tolower(argv[n][1]))
			{
				case 's':
					sscanf(&argv[n][3],"%4u",&size_h);
					break;
				case 'd':
					strcpy(str,&argv[n][3]);
					break;
				case 'f':
					strcpy(b_file,&argv[n][3]);
					break;
				case '?':
				case 'h':
					help();
					break;
				case '#':
					chars=TRUE;
					break;
				case 'p':
					pipe=TRUE;
					break;
				case 'u':
					upper=TRUE;
					break;
				case 'r':
					inverse=TRUE;
					break;
				case 'i':
					italics=TRUE;
					size_h-=size_y;
					break;
				case 'c':
					fcharf=TRUE;
					fchar=argv[n][2];
					if(strlen(argv[n])>3)
						fchar2=argv[n][3];
					if(argv[n][4]=='!')
						ultraflag=TRUE;
					break;
				default:
					shutdown("Falsche Option! Aufruf mit /h oder /? listet alle Optionen.");
					break;
			}
		}
	}
	if(!*str)
	{
#ifdef MS_DOS
		strcpy(str,argv[0]);
		strcpy(str+strlen(str)-3,"DAT");
#else
# ifdef STD_DATA_FILE
		strcpy(str,STD_DATA_FILE);
# endif
#endif
	}
#ifdef INTERN_DATA
        zs=(DATA)intern_data;
#else
        if(!(fh=fopen(str,"rb")))
		shutdown("Datenfile nicht gefunden!!");
	if(fseek(fh,0L,SEEK_END))
		shutdown("Interner Fehler.");
	if((n=ftell(fh))==-1)
		shutdown("Interner Fehler.");
        rewind(fh);          
#  ifdef MS_DOS
	if(!(zs=(DATA)malloc((size_t)n)))
		shutdown("Zu wenig Speicher!!");
        fread((void *)zs, (size_t)1, (size_t)n, (FILE *)fh);
#  else
        if(!(zs=(DATA)malloc((int)n)))
                shutdown("Zu wenig Speicher!!");
        fread((void *)zs, (int)1, (int)n, (FILE *)fh);
#  endif       
        fclose(fh);
#endif
	if(!(chr=(DATA)malloc(size_x*size_y)))
		shutdown("Zu wenig Speicher!!");
	if(!(line=(DATA)malloc(SIZE_LINE)))
		shutdown("Zu wenig Speicher!!");
	if( (float)( (int)VERSION*16)+(VERSION-1.0)*10.0<(float)zs[0])
		shutdown("Datenfile nicht fuer diese Version von Banner.C geeignet.");
	if(zs[0]<(UCHAR)0x12)
		upper=TRUE; /* 1.0 und 1.1 unterstuetzen NUR Grossbuchstaben! */
	clearmem(CLEAR_ALL);
	xpos=0;
	for(n=1;n<argc;n++)
	{
		if(argv[n][0]!='/')
		{
			writeword(argv[n]);
			if((xpos+=size_x)>XMAX-1)
				newline();
		}
	}
	if(xpos) newline();
#ifndef AMIGA
	if(*b_file)
	{
		if(!(fh=fopen(b_file,"rb")))
			shutdown("Kann zu bannerndes Datenfile nicht finden.");
		banner_file(fh);
		fclose(fh);
		newline();
	}
#endif
	if(pipe)
		banner_file(stdin);
	shutdown("");
}

void banner_file(fh)
FILE *fh;
{
long m;
	while(!feof(fh))
	{
		m=(long)read_word(fh,str);
		if(strlen(str))
		{
			writeword(str);
			if((xpos+=size_x)>XMAX-1 || m)
			{
				newline();
				m=0L;
			}
		}
		if(m) newline();
	}
}

int read_word(fh,txt)
FILE *fh;
char *txt;
{
int flag = TRUE, n = 0, ret=0;
char x;
	while(flag && n<250)
	{
		x=(char)fgetc(fh);
		if(x==' ' || !isprint(x))
			flag=FALSE;
		else
			str[n++]=x;
		ret=(x=='\n'||x=='\r'||x==(char)0x0a||x==(char)0x0d)?1:0;
	}
	str[n]='\0';
	return(ret);
}

void writeword(txt)
char *txt;
{
	if(xpos+size_x*strlen(txt)>XMAX)
	{
		if(!xpos)
			putword(txt);
		else
		{
			newline();
			writeword(txt);
			return;
		}
	}
	else
		putword(txt);
}

void putword(txt)
char *txt;
{
int n;
	for(n=0;n<strlen(txt);n++)
		writechar(txt[n]);
}

void writechar(x)
char x;
{
char chr = upper?toupper(x):x;
	calc_char(chr);
	insert_char(chr);
	if((xpos+=size_x)>XMAX-1) newline();
}

void calc_char(x)
char x;
{
int n,m,a,b;
UINT b2;
	fchar2|=(UCHAR)0x80;
	clearmem(CLEAR_CHAR);
	for(n=0,m=-1;n<zs[1] && m<0;n++)
	{
		if(zs[2+n*3]==x)
			m=n;
	}
	if(m<0) return;
	for(n=0;n<8;n++)
	{
		b=(int)zs[2+256*zs[m*3+3]+zs[m*3+4]+n];
		b2=(UINT)(b<0?256+b:b);
		for(a=0;a<8;a++)
		{
			if(b&1)
				chr[n*8+7-a]=inverse?(UCHAR)fchar2:(chars?x:(fcharf?fchar:'#'));
			else
				chr[n*8+7-a]=inverse?(chars?x:(fcharf?fchar:'#')):(UCHAR)fchar2;
			b>>=1;
		}
	}
}

void insert_char(chrx)
char chrx;
{
int n,m,a;
UCHAR x = fchar2, xold;
	empty=FALSE;
	for(n=0;n<8;n++)
	{
		for(m=0;m<8;m++)
		{
			xold=x;
			x=chr[8*n+m];
			if(!ultraflag)
				line[size_h*n+xpos+m]=(UCHAR)x&0x7f;
			else
			{
				if(x==fchar2 && xold==(chars?chrx:fchar))
					x=(UCHAR)' ';
				line[size_h*n+xpos+m]=(UCHAR)x&0x7f;
			}
		}
	}
}

void newline(/*void*/)
{
int a,b,c,x, wrote, flag;
	if(empty)
	{
		xpos=0;
		return;
	}
	empty=TRUE;
	xpos=0;
	for(a=0;a<SIZE_LINE_Y;a++)
	{
		wrote=0;
		if(italics)
		{
			for(b=0;b<(SIZE_LINE_Y-a);b++, wrote++)
				putchar(' ');
		}
		for(b=size_h-1,c=0;b>1 && !c;b--)
		{
			if(line[size_h*a+b]!=' ' && line[size_h*a+b]!='\0')
				c=++b;
		}
		for(b=0;b<c && b<size_h;b++)
		{
			x=(int)line[size_h*a+b];
			if(!x) x=32;
			putchar(x);
			wrote++;
		}
		if(wrote<(size_h+(italics?SIZE_LINE_Y:0)))
			putchar('\n');
	}
	clearmem(CLEAR_LINE);
}

void clearmem(was)
int was;
{
register UINT n;
	if(was&CLEAR_CHAR)
	{
		for(n=0;n<SIZE_CHAR;n++)
			chr[n]=(char)32;
	}
	if(was&CLEAR_LINE)
	{
		for(n=0;n<SIZE_LINE;n++)
			line[n]=(char)0;
	}
}

void help(/*void*/)
{
	printf("\nBanner.c, V%1.1f, (c)1990 by Lizard\n=================================\n",VERSION);
#ifdef AMIGA
	puts("( Geschrieben fuer FALCON :-)");
#endif /* ;-) */
	puts("Aufruf:   Banner /<option1> /<opt2> /<opt3> [etc... :-)] <text>\n");
	puts("Moegliche Optionen:\n");
	puts(" /?          : Dieser Text hier. Auch: /h oder kein Parameter.");
	puts(" /S:<breite> : Breite des geBANNERten Textes (Horizontal/Gesamt), Default: 80");
	puts(" /D:<path>   : Anderes Zeichensatz-Datenfile hernehmen.");
#ifndef AMIGA
	puts(" /F:<path>   : File <path> bannern.");
#endif /* Tja, amiga hat nicht fopen("..","rb") !! */
	puts(" /#          : Die Buchstaben werden anstatt mit #'s mit den jeweiligen Chars");
	puts("               gebildet.");
	puts(" /P          : Pipe-option: Von stdin wird der zu bannernde Text gelesen.");
	puts(" /U          : Alles in Grossbuchstaben umwandeln.");
	puts(" /R          : Invertierte Darstellung.");
	puts(" /I          : Italics (schraege Buchstaben)");
	puts(" /Cxy!       : 'Vordergrundfarbe'=x, 'Hintergrundfarbe'=y. y ist optional.");
	puts("             : Bei angegebenem '!' wird die Shadow-funktion aktiviert.");
	puts("-------------------------------------------------------------------");
}

void shutdown(txt)
char *txt;
{
#ifdef MS_DOS
        fcloseall();
#endif
#ifndef INTERN_DATA
        if(zs) free((void *)zs);
#endif
#ifndef COHERENT
	if(chr) free((void *)chr);
	if(line) free((void *)line);
#else
	if (chr) free(chr);
	if (line) free(line);
#endif
	if(*txt) printf("\n%s\n",txt);
	exit(0);
}
