0.  NAME

	ae	Anthony's Editor January 93


1.  SYNOPSIS

	ae [-f config_file]  [filename]


2.  OPERANDS

config_file     The pathname of an AE configuration file.  The
		pathname may be absolute, relative the current
		directory, or relative the user's home directory.

filename	The name of a existing or new file to edit.


3.  DESCRIPTION

AE is a simple full screen text editor that can be configured for
either a modual (VI-style interface) or a modeless (EMACS-style
interface).

Text files consist of lines of printable text or tab characters.  
A line can be of arbitary length and is delimited by either a 
newline or the end of file.  Carriage return is mapped to newline 
on input and ignored on output.  Carriage returns already in the file
are preserved.  Tab stops are every eight columns.


4.  COMMANDS

Two default configuration files are supplied.  One of them should be
renamed to "ae.rc" and placed in the user's home directory.  The two
supplied files are "mode.rc" and "modeless.rc" which configure the
editor for either modual (VI-style) or modeless (EMACS-style)
operation.


4.1.  MODUAL CONFIGURATION 

4.1.1.  SUPPORT

?		Toggle help on/off.
M		Macro add, change, delete, or view.
r		Refresh the screen.
R W		Read and write file to and from the buffer.
q Q		Quit with and without query.
V		Display version.

4.1.2.  MOVEMENT

h j k l		Left, down, up, right cursor movement.
H J K L		Word left, page down, page up, word right.
[ ]		Beginning and end of line.
T B		Top and bottom of file.

4.1.3.  EDIT

i ESC ERASE	Enter insert mode, escape to leave, backspace.
^V		Next character typed will be treated as a literal.
X x		Delete character left or under the cursor.
SPACE		Toggle block on/off.
C		Cut block to scrap.
P		Paste scrap into buffer.
u		Undo last cut, delete, paste, read, insert, or undo.


4.1.4.  MACROS

a		Append after cursor.
A		Append at teh end of a line.
cw		Change word.
D		Delete from cursor to end of line.
dd		Delete line.
dw		Delete word.
o O		Open line below or above.
y		Yank current block.


4.2.  MODELESS CONFIGURATION

4.2.1.  SUPPORT

F1		Toggle help on/off.
^K^M		Macro add, change, delete, or view.
^L		Refresh the screen.
^R ^W		Read and write file to and from the buffer.
^C ^K^C		Quit with and without query.  
^K^V		Display version.


4.2.2.  MOVEMENT

cursor keys	Left, down, up, right cursor movement (ansi defined).
^A ^D		Word left,  word right.
^F ^E		Front and end of line.
^N ^P		Next and previous page.
^T ^B		Top and bottom of file.


4.2.3.  EDIT

unbound keys	Insert.
BACKSPACE ^X	Delete character left or under the cursor.
^V		Next character typed will be treated as a literal.
F2		Toggle block on/off.
F3		Cut block to scrap.
F4		Paste scrap into buffer.
^U		Undo last cut, paste, read, or undo.


4.2.4.  MACROS

No pre-defined macros.


5.  CONFIGURATION

The user is able to configure the editor with the help text and keys
that the user likes.  It is possible to define a modual or modeless
key interface and support multi-character key sequences.

The configuration file layout is fairly simple.  All keywords begin 
on a line starting with a period (.).  Invalid keywords and lines 
without a leading period are ignored.  

The parameters <string> and <character> can be any text other than
whitspace (blank, tab, carriage-return, and newline).  It is possible
to specify control keys by prefixing the following characters with a
caret (^):

	@ a b c d e f g h i j k l m n o 
	p q r s t u v w x y z [ \ ] ^ _

The sequence ^? represents ASCII DEL (0x7f).  The following escape 
constants are recognised:

	backspace	\b
	formfeed	\f
	newline		\n
	return		\r
	space		\s
	tab		\t
	
Also numeric escapes are possible.  The value represented must be 
between 0 and 255 inclusive.

	decimal		\ddd
	octal		\0ooo
	hex		\0xhh

A literal escape begins with a backslash and is followed by any
character that does not specify an escape constant or start a 
number, and will represent the character itself.

eg.
	.insert_enter	i		<-- single character string
	.insert_exit	^[		<-- defines ASCII ESC
	.delete_right	\0x7f		<-- defines ASCII DEL
	.cursor_up	^[[A		<-- defines sequence ESC [ A


5.1.  KEYWORDS

5.1.1.  SUPPORT

.file_read <string>
.file_write <string>
	Read or write a file to or from a buffer.

.help <string>
	Toggle the help text and ruler line on and off.

.help_off
	Disable initial help message at startup.  

.help_text
  <text lines>
.end
	All the subsequent lines upto the .end keyword are considered
	help text.  The terminating keyword is discarded.  There may
	be more than one .help_text given.

.itself <character>
	The following character represents itself.  This is really a
	redundant keyword since any key not defined by a keyword,
	automatically represents itself.

.macro <string>
	Define a macro during an edit session.  The user will be
	prompted for an input line consisting of zero, one, or two 
	<strings> separated by whitespace.  

	Pressing <return> at the prompt, with no input strings, will
	display the current set of macros definitions and how many
	slots have been used versus the total number of slots available.

	One string entered will remove the macro defined to have 
	that string as the left-hand-side.  

	Two input strings defines a macro, where the first string, 
	when typed, pushes the second string onto an input stack.

	Macros may be nested.  It is only possible to delete or change 
	macros that appear in the listing of currently defined macros.
	All other key-bindings cannot be redefined during an edit
	session.

.macro_define
.macro_define <lhs string> <rhs string>
	The first case reserves space for one macro definition that 
	may be defined during the edit session.  The other case will 
	actually define a macro, where the left-hand-side, when typed
	will push onto an input stack the right-hand-side.  Either
	case may be used as many times as desired (memory permiting).
	Macros may be nested.

.quit <string>
.quit_ask <string>
	Exit the editor.

.redraw <string>
	Force a screen redraw.

.show_version <string>
	Display the release information.


5.1.2.  CURSOR MOTION

.cursor_up <string>
.cursor_down <string>
.cursor_left <string>
.cursor_right <string>
	Cursor motion in four directions.  Typically the arrow keys.

.file_top <string>
.file_bottom <string>
	Move to the top and bottom of the file buffer.

.line_left <string>
.line_right <string>
	Move to the beginning or end of the line.

.page_up <string>
.page_down <string>
        Previous or next screen full of text.

.word_left <string>
.word_right <string>
        Move to word left or right of the current cursor.


5.1.3.  EDIT

.block <string>
.cut <string>
.paste <string>
	Block on/off toggle, cut block, and paste before.

.delete_left <string>
.delete_right <string>
	Delete character to the left or right of the cursor.

.insert_enter <string>
.insert_exit <string>
	Enter and exit insert mode.  The use of .insert_enter denotes
	a modual user interface.  Insert mode does not perform macro
	expansion.

.literal <string>
	Next character entered is treated as a literal.

.stty_erase
.stty_kill
	Declare that the terminal's values for the erase and kill
	characters should be used in insert mode to backspace-erase,
	or discard and restart input.

.undo <string>
	Undo last cut, delete, insert, paste, read, or undo.


6.  EXIT STATUS

0	Success.
1	Unknown error.
2	Usage error.
3	Understood failure.


7.  INSTALLATION 

The source has been know to compile on a wide variety of machines and 
compilers like BSD and System V Unix with GNU C, PC mahcines with 
WatCom C or Turbo C, and ATARI ST machines with Sozobon C.  Any machine 
that provides at least K&R C and a BSD CURSES library (as described by 
Ken Arnolds's paper) should have no trouble getting AE to compile.

To build AE on most unix-like systems, type

	make

The supplied makefile is configured for a BSD environment.  Some
systems may require that the macros CC, CFLAGS, LD, LDFLAGS, and LIBS
be configured.

For a System V environment alter the following macros to:

	CFLAGS = -O
	LIBS = -lcurses

To build AE on systems that have POSIX.1 or System V termios library,
modify the CFLAGS macro to

	CFLAGS = -O -DTERMIOS=1

If the constants CHUNK or CONFIG are not defined by CFLAGS then
the defaults used are

	CHUNK	= 8096L
	CONFIG	= "ae.rc"

CHUNK is the size by which the buffer is expanded when the buffer
becomes full while inserting text.  CONFIG is the name of the default 
configuration file.  The name chosen aims to satisfy both unix and 
personal systems.  Unix affectionados may want to reconfigure this 
to ".aerc".

TERMIOS should be defined for systems that have POSIX.1 termios
support (which is based on System V termios).  This has the affect of
disabling the INTR, QUIT, and SUSP signals.  XON/XOFF is left
unchanged.  If TERMIOS is not defined, then cbreak() and nocbreak()
are used which do not disable the above mentioned signals.

Most EBCDIC machines use block mode terminals.  This is a problem
that has not been addressed and/or tested for.


8.  BUGS

No known bugs.


9.  REFERENCES

[Fin80]	Craig A. Finseth, "Theory and Practice of Text Editors or 
	A Cookbook For An EMACS", TM-165, MIT Lab. for Computer 
	Science

[KeP81]	Kernighan & Plauger, "Software Tools in Pascal", 
	Addison-Wesley, 81, chapter 6

[Mil86]	Eugene W. Myers & Webb Miller, "Row-replacement Algorithums
	for Screen Editors", TR 86-19, Dept. of Compter Science, 
	U. of Arizona

[MyM86]	Eugene W. Myers & Webb Miller, "A simple row-replacement 
	method", TR 86-28, Dept. of Compter Science, U. of Arizona

[Mil87]	Webb Miller, "A Software Tools Sampler", Prentice Hall, 87
	ISBN 0-13-822305-X, chapter 5

[net90]	"Editor 101/102" articles from comp.editors


10.  FILES

ae.man		Manual.
ae.rc		Default configuration file used by AE.
mode.rc		Sample configuration for modual style.
modeless.rc	Sample configuration for modeless style (ansi cursor keys).


11.  NOTICES

Public Domain 1991, 1993 by Anthony Howe.  No warranty.

