
/*	program ADVENT0.C					*\
\*	execution will read the four adventure text files	*\
\*	files; "advent1.txt", "advent2.txt", "advent3.txt" &	*\
\*	"advent4.txt".  it will create the file "advtext.h"	*\
\*	which is an Index Sequential Access Method (ISAM)	*\
\*	header to be #included into "advent.c" before the	*\
\*	header "advdef.h" is #included.				*/


#include	<stdio.h>	/* drv = 1.1st file 2.def 3.A	*/
#include 	<string.h>
#include	"advent.h"


#ifndef MS_DOS /* ltoa converts val to *str (ingoring radix specification),
			and returns ptr to string) */
#define ltoa(val,str,rad) (sprintf (str, "%ld", val), str)
#endif /* not MS_DOS */

#ifndef ADV_TXTFILE
# ifdef UNIX
#  define ADV_TXTFILE "/usr/games/lib/adventure.txt"
# else
#  define ADV_TXTFILE "advent.txt"
# endif /* UNIX */
#endif /* ADV_TXTFILE defined */

main(argc, argv)
int	argc;
char	**argv;
{
	FILE	*isam, *fd1, *fd2, *fd3, *fd4, *fdout;
	char	itxt[255], otxt[255], lstr[12];
	char *out_fname = ADV_TXTFILE;
	int	cnt;

	/* first, check to see if an output file name was
	given.  Don't bother to make this idiot-proof,
	since only the porter will use this (by changing the Makefile) */

	if (argc > 1)
		out_fname = argv[1];
		
	isam = fopen("advtext.h", "w");
	if (!isam) {
		printf("Sorry, I can't open advtext.h. . .\n");
		exit();
	}
	fd1 = fopen("advent1.txt", "r");
	if (!fd1) {
		printf("Sorry, I can't open advent1.txt...\n");
		exit();
	}
	fd2 = fopen("advent2.txt", "r");
	if (!fd2) {
		printf("Sorry, I can't open advent2.txt...\n");
		exit();
	}
	fd3 = fopen("advent3.txt", "r");
	if (!fd3) {
		printf("Sorry, I can't open advent3.txt...\n");
		exit();
	}
	fd4 = fopen("advent4.txt", "r");
	if (!fd4) {
		printf("Sorry, I can't open advent4.txt...\n");
		exit();
	}

   fdout = fopen(out_fname,"w");
   if (!fdout) {
      printf("Sorry, I can't open %s for output...\n",out_fname);
      exit();
   }

   printf("Dumping output on %s. . . \n",out_fname);

   fprintf(isam, "\n/");
	fprintf(isam, "*\theader: ADVTEXT.H\t\t\t\t\t*/\n\n\n");


   printf("advent1.txt: long descriptions.\n");
   cnt = -1;
	lstr[0] = '\0';
	fprintf(isam, "long\tidx1[MAXLOC] = {\n\t");
	while (fgets(itxt, 255, fd1)) {
		strxor (otxt, itxt, 0xff);
      fprintf(fdout,"%s", otxt);
		if (itxt[0] == '#') {
			if (lstr[0])
				fprintf(isam, "%s,", lstr);
			if (!ltoa(ftell(fdout), lstr, 10)) {
				printf("ltoa err in advent1.txt\n");
				exit();
			}
			if (++cnt == 5) {
				fprintf(isam, "\n\t");
				cnt = 0;
			}			/* if (cnt)	*/
		}				/* if (itxt[0])	*/
	}					/* while fgets	*/
	fprintf(isam, "%s\n\t};\n\n", lstr);

   printf("advent2.txt: short descriptions.\n");
	cnt = -1;
	lstr[0] = '\0';
	fprintf(isam, "long\tidx2[MAXLOC] = {\n\t");
	while (fgets(itxt, 255, fd2)) {
      strxor (otxt, itxt, 0xff);
      fprintf(fdout,"%s", otxt);
		if (itxt[0] == '#') {
			if (lstr[0])
				fprintf(isam, "%s,", lstr);
			if (!ltoa(ftell(fdout), lstr, 10)) {
				printf("ltoa err in advent2.txt\n");
				exit();
			}
			if (++cnt == 5) {
				fprintf(isam, "\n\t");
				cnt = 0;
			}			/* if (cnt)	*/
		}				/* if (itxt[0])	*/
	}					/* while fgets	*/
	fprintf(isam, "%s\n\t};\n\n", lstr);

   printf("advent3.txt: item descriptions.\n");
	cnt = -1;
	lstr[0] = '\0';
	fprintf(isam, "long\tidx3[MAXOBJ] = {\n\t");
	while (fgets(itxt, 255, fd3)) {
      strxor (otxt, itxt, 0xff);
		fprintf(fdout,"%s", otxt);
		if (itxt[0] == '#') {
			if (lstr[0])
				fprintf(isam, "%s,", lstr);
			if (!ltoa(ftell(fdout), lstr, 10)) {
				printf("ltoa err in advent3.txt\n");
				exit();
			}
			if (++cnt == 5) {
				fprintf(isam, "\n\t");
				cnt = 0;
			}			/* if (cnt)	*/
		}				/* if (itxt[0])	*/
	}					/* while fgets	*/
	fprintf(isam, "%s\n\t};\n\n", lstr);
   
   printf("advent4.txt: messages.\n");
	cnt = -1;
	lstr[0] = '\0';
	fprintf(isam, "long\tidx4[MAXMSG] = {\n\t");
	while (fgets(itxt, 255, fd4)) {
      strxor (otxt, itxt, 0xff);
		fprintf(fdout,"%s", otxt);
		if (itxt[0] == '#') {
			if (lstr[0])
				fprintf(isam, "%s,", lstr);
			if (!ltoa(ftell(fdout), lstr, 10)) {
				printf("ltoa err in advent4.txt\n");
				exit();
			}
			if (++cnt == 5) {
				fprintf(isam, "\n\t");
				cnt = 0;
			}			/* if (cnt)	*/
		}				/* if (itxt[0])	*/
	}					/* while fgets	*/
	fprintf(isam, "%s\n\t};\n\n", lstr);
   fclose(fdout);
   fclose(isam);
   fclose(fd1);
   fclose(fd2);
   fclose(fd3);
   fclose(fd4);

}						/* main		*/

/* routine to xor a string with a specified value: */

strxor (outstring, instring, xorval)
char outstring[], instring[];
int xorval;
{
   while (*instring)
      *outstring++ = *instring++  ^ xorval;
   *outstring = 0;
}
