/*	program ADVENT.C					

	WARNING: "advent.c" allocates GLOBAL storage space by	
		including "advdef.h".				
  		All other modules use "advdec.h".		*/

#include	<stdio.h>	/* drv = 1.1st file 2.def 3.A	*/
#include   <string.h>
#ifdef MS_DOS
#include   <memory.h>
#endif

#include	"advent.h"	/* #define preprocessor equates	*/
#include	"advword.h"	/* definition of "word" array	*/
#include	"advcave.h"	/* definition of "cave" array	*/
#include	"advtext.h"	/* definition of "text" arrays	*/
#include	"advdef.h"

char username [20]; /* holds save/restore file name */


/* following defines default dir for advent.txt */

#ifndef ADV_TXTFILE
#  ifdef UNIX
#    define ADV_TXTFILE "/usr/games/lib/adventure.txt"

#  else /*probably MS_DOS*/
#    define ADV_TXTFILE "advent.txt"
#  endif UNIX
#endif /* ADV_TXTFILE */

#ifndef MAGIC_WORD
#  define MAGIC_WORD "hyeryeon"
#endif /* MAGIC_WORD */

main(argc, argv)
int	argc;
char	**argv;
{
	int	rflag;		/* user restore request option	*/

	rflag = 0;
	dbugflg = 0;
	while (--argc > 0) {
		++argv;
		if (**argv !=  '-')
			break;
		switch(tolower(argv[0][1])) {
		   case 'd':
			   ++dbugflg;
			   continue;
		   default:
			   printf("unknown flag: %c\n", argv[0][1]);
			   continue;
		}				/* switch	*/
	}					/* while	*/
	if (dbugflg < 2)
		dbugflg = 0;	/* must request three times	*/
	opentxt();
	initplay();
   rspeak (65);
   yes(202, 1, 0);

	srand(511);				/* seed random	*/
	describe();

   while(1) {
		turn(TRUE); /* ask for english input */
	   if (saveflg)
		   saveadv();
      if (restflg)
         restore();
   }
	fclose(fd1);
	exit(0);				/* exit = ok	*/
}						/* main		*/

/* ************************************************************	*/

/*
	Initialize integer arrays with sscanf
*/
scanint(pi, str)
int	*pi;
char	*str;
{

	while (*str) {
		if  ((sscanf(str, "%d,", pi++)) < 1)
			bug(41);	/* failed before EOS	*/
		while (*str++ != ',')	/* advance str pointer	*/
			;
	}
	return;
}

/*
	Initialization of adventure play variables
*/
initplay()
{
	turns = 0;

	/* initialize location status array */
	memset (cond, 0, (sizeof(int))*MAXLOC);
	scanint(&cond[1], "5,1,5,5,1,1,5,17,1,1,");
	scanint(&cond[13], "32,0,0,2,0,0,64,2,");
	scanint(&cond[21], "2,2,0,6,0,2,");
	scanint(&cond[31], "2,2,0,0,0,0,0,4,0,2,");
	scanint(&cond[42], "128,128,128,128,136,136,136,128,128,");
	scanint(&cond[51], "128,128,136,128,136,0,8,0,2,");
	scanint(&cond[79], "2,128,128,136,0,0,8,136,128,0,2,2,");
	scanint(&cond[95], "4,0,0,0,0,1,");
	scanint(&cond[113], "4,0,1,1,");
	scanint(&cond[122], "8,8,8,8,8,8,8,8,8,");

	/* initialize object locations */
	memset(place, 0, (sizeof(int))*MAXOBJ);
	scanint(&place[1], "3,3,8,10,11,0,14,13,94,96,");
	scanint(&place[11], "19,17,101,103,0,106,0,0,3,3,");
	scanint(&place[23], "109,25,23,111,35,0,97,");
	scanint(&place[31], "119,117,117,0,130,0,126,140,0,96,");
	scanint(&place[50], "18,27,28,29,30,");
	scanint(&place[56], "92,95,97,100,101,0,119,127,130,");

   /* initialize second (fixed) locations */
	memset (fixed, 0, (sizeof(int))*MAXOBJ);
	scanint(&fixed[3], "9,0,0,0,15,0,-1,");
	scanint(&fixed[11], "-1,27,-1,0,0,0,-1,");
	scanint(&fixed[23], "-1,-1,67,-1,110,0,-1,-1,");
	scanint(&fixed[31], "121,122,122,0,-1,-1,-1,-1,0,-1,");
	scanint(&fixed[62], "121,");

	/* initialize default verb messages */
	scanint(actmsg, "0,24,29,0,33,0,33,38,38,42,14,");
	scanint(&actmsg[11], "43,110,29,110,73,75,29,13,59,59,");
	scanint(&actmsg[21], "174,109,67,13,147,155,195,146,110,13,13,");

	/* initialize various flags and other variables */
	memset (visited, 0, (sizeof(int))*MAXLOC);
	memset (prop, 0, (sizeof(int))*MAXOBJ);
	memset (&prop[50], 0xff, (sizeof(int))*(MAXOBJ-50));
   strcpy (magicwd, MAGIC_WORD);
   wzdark = closed = closing = holding = detail = 0;
	limit = 350;
	tally = 15;
	tally2 = 0;
	newloc = loc = oldloc = oldloc2 = 1;
	knfloc = 0;
	chloc = 114;
	chloc2 = 140;
/*	dloc[DWARFMAX-1] = chloc				*/
	scanint(dloc, "0,19,27,33,44,64,114,");
	scanint(odloc, "0,0,0,0,0,0,0,");
	dkill = 0;
	scanint(dseen, "0,0,0,0,0,0,0,");
	clock_ = 30;
	clock2 = 50;
	panic = 0;
	bonus = 0;
	numdie = 0;
	daltloc = 18;
	lmwarn = 0;
	foobar = 0;
	dflag = 0;
	gaveup = 0;
   wizard = FALSE;
   descmode = BRIEF;
	saveflg = 0;
   oldmotion = 57;
   restflg = 0;
   username [0] = 0;
   return;
}

/*
	Open advent.txt file.
	First, check ENVIRONMENT for name (so porter can overide
	default to current directory), if null, then substitute
	default name & dir.
*/
opentxt()
{
	char adv_file[80];
	strncpy(adv_file,getenv("ADV_LIB"),79);

	if (!*adv_file) /*not in environment*/
		strcpy(adv_file,ADV_TXTFILE);

	fd1 = fopen(adv_file, "r");
	if (!fd1) {
		printf("Sorry, I can't open %s.\n",adv_file);
		exit();
	}
}

/**************************************************************************
* Save Game-- This routine was modified to save play variables one by     *
*    one, this is because not all linkers allocate play variables         *
*    sequentially.                                                        *
*    --------------------------------------------------------------       */

saveadv()
{
	FILE	*savefd;
   int i;

  /* first reset save mode */
  saveflg = 0;

  get_username("What do you want to name the saved game? ");
  savefd = fopen(username, "w");
	if (savefd == NULL) {
		printf("Sorry, I can't save this adventure as `%s.'\n", \
		       username);
		return;
/*		exit(1); */
	}

  /* save play variables */
   for (i=0; i< MAXLOC; i++)
     put_wchk (savefd, cond[i], username);
   for (i=0; i< MAXOBJ; i++)
      put_wchk (savefd, place[i], username);
   for (i=0; i< MAXOBJ; i++)
      put_wchk (savefd, fixed[i], username);
   for (i=0; i< MAXLOC; i++)
      put_wchk (savefd, visited[i], username);
   for (i=0; i< MAXOBJ; i++)
      put_wchk (savefd, prop[i], username);
   for (i=0; i< DWARFMAX; i++)
      put_wchk (savefd, dloc[i], username);
   for (i=0; i< DWARFMAX; i++)
      put_wchk (savefd, dseen[i], username);
   for (i=0; i< DWARFMAX; i++)
      put_wchk (savefd, odloc[i], username);
   put_wchk (savefd, turns, username);
   put_wchk (savefd, loc, username);
   put_wchk (savefd, oldloc, username);
   put_wchk (savefd, oldloc2, username);
   put_wchk (savefd, newloc, username);
   put_wchk (savefd, tally, username);
   put_wchk (savefd, tally2, username);
   put_wchk (savefd, limit, username);
   put_wchk (savefd, lmwarn, username);
   put_wchk (savefd, wzdark, username);
   put_wchk (savefd, closing, username);
   put_wchk (savefd, closed, username);
   put_wchk (savefd, holding, username);
   put_wchk (savefd, detail, username);
   put_wchk (savefd, knfloc, username);
   put_wchk (savefd, clock_, username);
   put_wchk (savefd, clock2, username);
   put_wchk (savefd, panic, username);
   put_wchk (savefd, dflag, username);
   put_wchk (savefd, daltloc, username);
   put_wchk (savefd, dkill, username);
   put_wchk (savefd, chloc, username);
   put_wchk (savefd, chloc2, username);
   put_wchk (savefd, bonus, username);
   put_wchk (savefd, numdie, username);
   put_wchk (savefd, object1, username);
   put_wchk (savefd, gaveup, username);
   put_wchk (savefd, foobar, username);
   put_wchk (savefd, dbugflg, username);
   put_wchk (savefd, descmode, username);
   put_wchk (savefd, lastglob, username);

	if (fclose(savefd)  ==  -1) {
		printf("Sorry, I can't close the file...%s\n", \
		       username);
		exit();
	}
	printf("Ok.  I saved your game...\n");

}

put_wchk (savefd,play_var,username)
FILE *savefd;
int play_var;
char *username;
{
#ifdef MS_DOS
   play_var += ((play_var < EOFCHR) ? 0 : 1); /* Don't write EOF */
#endif /* MS_DOS */
   if ( (fwrite (&play_var, sizeof(int), 1, savefd)) != 1) {
      printf("Write error on save file `%s.'\n", \
             username);
      exit();
   }
}
/**************************************************************************
* Restore Saved Game -- since variables may not be allocated sequentially,*
*    we force proper restoration by reading in variables one by one.      *
*   -------------------------------------------------------------------   */

restore()
{
	int   i;
   FILE  *restfd;

   /* first reset the restore flag */
   restflg = 0;

   get_username("What game do you want to restore? ");
	restfd = fopen(username, "r");
	if (restfd == NULL) {
		printf("Sorry, I can't find that adventure (%s.)\n", \
		       username);
		return;
/*		exit(1); */ /* whether or not to bomb is a matter of taste */
	}

   /* restore play variables */

   for (i=0; i< MAXLOC; i++)
     cond[i] = get_wchk (restfd, username);
   for (i=0; i< MAXOBJ; i++)
      place[i] = get_wchk (restfd, username);
   for (i=0; i< MAXOBJ; i++)
      fixed[i] = get_wchk (restfd, username);
   for (i=0; i< MAXLOC; i++)
      visited[i] = get_wchk (restfd, username);
   for (i=0; i< MAXOBJ; i++)
      prop[i] = get_wchk (restfd, username);
   for (i=0; i< DWARFMAX; i++)
      dloc[i] = get_wchk (restfd, username);
   for (i=0; i< DWARFMAX; i++)
      dseen[i] = get_wchk (restfd, username);
   for (i=0; i< DWARFMAX; i++)
      odloc[i] = get_wchk (restfd, username);
   turns = get_wchk (restfd, username);
   loc = get_wchk (restfd, username);
   oldloc = get_wchk (restfd, username);
   oldloc2 = get_wchk (restfd, username);
   newloc = get_wchk (restfd, username);
   tally = get_wchk (restfd, username);
   tally2 = get_wchk (restfd, username);
   limit = get_wchk (restfd, username);
   lmwarn = get_wchk (restfd, username);
   wzdark = get_wchk (restfd, username);
   closing = get_wchk (restfd, username);
   closed = get_wchk (restfd, username);
   holding = get_wchk (restfd, username);
   detail = get_wchk (restfd, username);
   knfloc = get_wchk (restfd, username);
   clock_ = get_wchk (restfd, username);
   clock2 = get_wchk (restfd, username);
   panic = get_wchk (restfd, username);
   dflag = get_wchk (restfd, username);
   daltloc = get_wchk (restfd, username);
   dkill = get_wchk (restfd, username);
   chloc = get_wchk (restfd, username);
   chloc2 = get_wchk (restfd, username);
   bonus = get_wchk (restfd, username);
   numdie = get_wchk (restfd, username);
   object1 = get_wchk (restfd, username);
   gaveup = get_wchk (restfd, username);
   foobar = get_wchk (restfd, username);
   dbugflg = get_wchk (restfd, username);
   descmode = get_wchk (restfd, username);
   lastglob = get_wchk (restfd, username);

   if (fclose(restfd)  ==  -1) {
		printf("Warning -- can't close restore file...%s\n", \
		       username);
	}
   }

/*******************************************************
* get int from a binary format file, checking for errors
*------------------------------------------------------*/
get_wchk (restfd, username)
FILE *restfd;
char *username;
{
  int c;
  if (fread (&c, sizeof(int), 1, restfd) != 1) {
     printf("Read error on save file `%s.'\n", username);
     exit();
  }
#ifdef MS_DOS
  return (c < EOFCHR) ? c : c - 1;
#else /* not MS_DOS, so no stupid ^Z EOF mark */
  return c;
#endif /* MS_DOS */
}

get_username (message)
char message[];
{
  char *sptr;

  if (word2[0])
     strcpy (username, word2);
  if (!username[0]) {
     printf(message);
	   scanf("%s", username);
  }
  if (sptr = strchr(username, '.'))
     *sptr = '\0';		/* kill extension	*/
  strcat(username, ".adv");

}
