vvsshh -- Command

Interactive graphical shell
vvsshh [-dd_d_i_r_e_c_t_o_r_y] [-eeiirrtt]

vvsshh  is  a  visual shell.   With  it,  you can  use  arrow  keys or  simple
keystrokes  to  perform  common  operating-system  tasks,  such  as  change
directories, edit  files, and  execute programs.   Each user can  program a
bank of  up to nine  function keys to  perform complex tasks  with a single
keystroke.  With  vvsshh, a  naive user  can access much  of the power  of his
operating system  without having  to learn  the details of  a line-oriented
shell.

Unlike  X  or  other windowing  systems,  vvsshh  works  on a  character-based
terminal and requires only a modest  amount of memory.  It does not require
a mouse.

_G_r_a_p_h_i_c_s _I_n_t_e_r_f_a_c_e
vvsshh uses  the ccuurrsseess  library and tteerrmmiinnffoo  descriptions.  To use  vvsshh, you
must have  a tteerrmmiinnffoo description  installed for the device  upon which you
wish to  run it.  Under  UUCP or COHERENT,  you must set  the environmental
variable TTEERRMM  to point correctly  to that description.   See your system's
documentation for details on how you should set up the terminal description
and environment.

If you  have a  non-standard terminal or  have trouble displaying  vvsshh, try
invoking it with  the options -ee or -tt.  All  of vvsshh's command-line options
are described below.

_M_a_i_n _S_c_r_e_e_n
When you invoke vvsshh, you see a screen that appears as follows:

-------------------------------------------------------------------------------|
| File     Dir      Options  Install  Command  Refresh  Exit     Help          |
-------------------------------------------------------------------------------|
|/v                                   |>|                                      |
|------------------------------------------------------------------------------|
| [..]                     12:49  2-04-94 rwxr-xr-x ^ System:  lepanto         |
| [PostScript]             12:15 12-02-93 rwxrwxrwx # Line:    ttyp1           |
| [backup]                  9:39 10-05-93 rwxr-xr-x + Login:   fred            |
| [font]                   12:41 10-19-93 rwxr-xr-x + UID:     fred (10)       |
| [fwb]                    13:51  2-09-94 rwxr-xr-x + GID:     user (5)        |
| [gif]                     9:23  2-05-94 rwxrwxrwx + Date:    2-9-94          |
| [lost+found]             15:00 11-15-93 rwxrwxrwx + Time:    22:08           |
| [sounds]                 16:04  1-05-94 rwxr-xr-x + -------------------------|
| OLD.gtz            95868  9:30  1-29-94 rw-r--r-- + Files:               10  |
| mount.all            372 10:02  1-29-94 rwxr-xr-x + File size:        96240  |
|                                                   + Files tagged:         0  |
|                                                   + File size ta.:        0  |
|                                                   + File size ta.:        0  |
|                                                   + Dir. Stack:           0  |
|                                                   + Mail:              None  |
|                                                   + /usr/spool/mail/fred     |
|                                                   + you can get messages     |
|                                                   +                          |
|                                                   v                          |
|------------------------------------------------------------------------------|
1______  2______  3______  4______  5______  6______  7______  8______  9______

As  you can  see, the  screen  is divided  the following  six sections,  or
_w_i_n_d_o_w_s:

-> The first  window, the  _C_o_m_m_a_n_d Window, is  the narrow window  that runs
   across the top  of the screen.  This window lists  the commands that vvsshh
   can perform.   You will  enter this window  frequently as you  work with
   vvsshh.

-> The  second window,  the _C_u_r_r_e_n_t _D_i_r_e_c_t_o_r_y  window, names  the directory
   that you are currently in.

-> The third  window, the _D_e_s_t_i_n_a_t_i_o_n  _D_i_r_e_c_t_o_r_y window, names  the default
   destination directory.

-> The fourth  window, the _F_i_l_e Window,  extends down the left  side of the
   screen.  It lists the contents  of the current directory.  You will also
   work frequently in this window.

-> The fifth  window, the _S_y_s_t_e_m Window,  is the upper window  on the right
   side of the screen.  It gives information about the system, that is, who
   is running  vvsshh, the device she  is running it on,  and the current date
   and time.  Your cursor never enters this window.

-> The last window, the _S_t_a_t_u_s Window, gives information about the work you
   have  performed under  vvsshh.  Again, your  cursor will  never enter  this
   window.

Across the bottom  of the screen are nine ``stubs,''  one each for function
keys  one through  nine.  The  stub's text indicates  the command  that vvsshh
executes when you press that key.

The following sections discuss each window in detail.

_F_i_l_e _W_i_n_d_o_w
The file window  lists all of the files and  directories within the current
directory.  This is the default window for vvsshh; the cursor ordinarily rests
in this window, and you will do most of your work in it.

The leftmost  column in  the File  Window gives the  name of each  file and
directory.  Directories are given at the top of the list; they are enclosed
within brackets  `[ ]'.  The other columns give,  respectively the time the
file or directory  was last updated; the date it  was last updated; and its
permissions.  For  information on how to  interpret the permissions string,
see the documentation that came with your operating system.

The top  listing in the  File Window is  always [..], which  represents the
current directory's parent directory.

The  top listing  in this  list is  highlighted by  being shown  in reverse
video.  To  move the highlighting bar  up and down the  list, use the arrow
keys.  If you  press the arrow keys on your  keyboard's number pad, be sure
to turn the <NNuummLLoocckk> key _o_f_f, or the keys will not work as you expect.  If
you press the v key, the bar shifts down one row on the list.  Pressing the
^ key moves the bar up one row.

You can page up or page down by pressing, respectively, the keys <PPggUUpp> and
<PPggDDnn>. The key  <HHoommee> moves the cursor to the  top of the list, and <EEnndd>
moves it  to the bottom.  If  your terminal does not  implement these keys,
you can use the following control characters:

    <ccttrrll-NN>    Next page (like <PPggDDnn>)
    <ccttrrll-PP>    Previous page (like <PPggUUpp>)
    <ccttrrll-AA>    Beginning (top) of list (like <HHoommee>)
    <ccttrrll-EE>    End (bottom) of list (like <EEnndd>)

Note that if the list of files and directories is too large to fit into the
window, moving  the bar  to the  bottom of the  window and pressing  v will
scroll the list.  If you press the <EEnndd> key, the row moves to the last row
in the list; and if you press <HHoommee>, it moves to the top of the list.

A scroll bar runs down the right side of the File Window.  As you scroll up
and down this window, the scroll  bar moves.  Note that the position of the
scroll bar  is proportional to the highlighting  bar's position in relation
to the  entire list of files,  not just to its  current position within the
File Window.  This  gives you an easy way to  see just where you are in the
entire file list.

If you position the highlighting bar over the name of a directory and press
<rreettuurrnn>,  vvsshh names  that directory  in the  Current Directory  Window and
displays its contents in the File Window.  For example, if you position the
highlighting bar over the entry for directory [lleetttteerrss] and press <rreettuurrnn>,
vvsshh displays the contents of directory lleetttteerrss in the File Window.  (If you
are familiar  with the Bourne or  Korn shells, this has  the same effect as
typing the  command ccdd lleetttteerrss.)  To return to  the directory you  had just
been displaying  (that is, the parent directory of  lleetttteerrss), use the arrow
keys to move  the highlighting bar to the entry  [..]; then press <rreettuurrnn>.
vvsshh changes the  contents of the Current Directory Window,  and in the File
Window  erases the  contents of  lleetttteerrss and displays  the contents  of its
parent directory.

If you press  <rreettuurrnn> while a file is highlighted  instead of a directory,
vvsshh does the following:

11. If the file is executable, vvsshh executes it.

22. If the  file matches a  pattern from the file-action  list, vvsshh executes
   the action from  the list with the file as  input.  The file-action list
   is in file .vvsshh in your  home directory; and it looks something like the
   following:

       [Mm]akefile:make
       *.mk:make -f %F
       *.sh:sh %F
       *.c:cc -c -O %F
       *.sc:sc %F
       *.a:ar tv %F | more
       *.[1-9]:nroff -man %F | more
       *.tar.F:fcat %F | tar xvf -
       *.F:fcat %F | more
       *.tar.Z:zcat %F | tar xvf -
       *.Z:zcat %F | more

   vvsshh recognizes  most common wildcard characters:  that is, it interprets
   an `*'  as any  string of  characters, and it  interprets an `?'  as any
   single character.   The token %FF  stands for the file  that is currently
   highlighted.  For  example, in the  above example the  entry *.ZZ:zzccaatt %FF
   means that if you select a  file with the suffix .ZZ (which usually means
   that  a file  has been  compressed), vvsshh  should pass  that file  to the
   command zzccaatt  to uncompress and  display it.  vvsshh  defines many defaults
   for you  when it creates  this file, which  you can use as  a model.  To
   change the  file-action list,  use the  FFiillee aaccttiioonnss sub-command  of the
   IInnssttaallll command, which is described below.

33. If the file appears to be ASCII vvsshh displays it with the default viewer.

While vvsshh  is working, it displays  a large letter `X'  in reverse video in
the lower  right corner of the  screen.  This shows that  vvsshh is doing some
internal task.  vvsshh cannot accept  any commands while the `X' is displayed,
so please be patient.

Also,  note that  vvsshh cannot  handle  more than  1,000 files  in any  given
directory.  If  a directory contains more than 1,000  files, only the first
thousand will be available for use.

_S_y_s_t_e_m _W_i_n_d_o_w
The system window is the upper  of the two windows on the right side of the
screen.  The  cursor never enters  this window; rather,  this window simply
displays information about your system, and how you are currently using it.
It contains the following entries:

SSyysstteemm:
     This  gives  the  name  of   your  system,  as  you  (or  your  system
     administrator) has set it.

LLiinnee:
     This gives the device by which  you are accessing your system.  If you
     are working  on your system's console, then you  should see ccoonnssoollee on
     this line; whereas  if you are accessing your system  via a PC plugged
     into a  serial port, then you  should see here the  name of that port.
     If you are  using virtual consoles, the line is  shown as mmoonnoo[00-88] or
     ccoolloorr[00-88].

LLooggiinn:
     This  gives the  name under  which you logged  into your  system.  For
     example, if your login identifier is ffrreedd, then you should see ffrreedd on
     this line.

UUIIDD: This  shows your  user-identification number  (or  UID).  This  is the
     unique  number  by  which  your  system  knows you,  as  set  in  file
     /eettcc/ppaasssswwdd.

GGIIDD: This gives the number and name  of the user group to which you belong.
     Users  on a  UNIX or  COHERENT  system can  be organized  into groups;
     permissions on files can be set  to include the members of your group,
     but exclude all others.

DDaattee:
     This gives  today's date (or  rather, what your  system thinks today's
     date is).

TTiimmee:
     This  gives what  your system  thinks  the current  time is.   If your
     system's time is not set correctly,  then the time shown here will not
     be correct.

_C_o_m_m_a_n_d _W_i_n_d_o_w
The Command Window is the top window, and stretches across the width of the
screen.  This window gives you  access to vvsshh's commands.  Some commands in
the command window actually open an entire menu of commands, with which you
can perform all manner of work.

The command  window contains the  following entries.  For  convenience, the
following displays the  entries vertically; the actual window displays them
horizontally:

    FFile
    DDirectory
    OOptions
    IInstall
    CCommand
    RRefresh
    EExit
    HHelp

When the cursor  is in the File Window (which  is the default) and you wish
to execute  one of the  commands in the  Command Window, press  its initial
letter.  For example, to execute the RReeffrreesshh command, press RR.

Note  that the  commands on  this window  are in  two groups.   A command's
behavior differs, depending upon which group it belongs to.

The commands FFiillee, DDiirreeccttoorryy, OOppttiioonnss, and IInnssttaallll display a drop-down menu
when  you invoke  it.   That is  because  they have  more  than one  option
available under it.   If you do not wish to  invoke any of the sub-commands
on that menu,  you can do either of the  following: You can press the <EEsscc>
key, which erases the drop down-menu and returns you to the File Window; or
you can  press the <-  or -> keys,  which move you  to the command  in this
group that lies,  respectively, to the left or to  the right of the current
command.  For  example, suppose that you  were in the File  Window, and you
pressed FF to  invoke the FFiillee command.  vvsshh would  move the cursor into the
Command  Window, and  display the  File  Command's drop-down  window, which
displays its  sub-commands.  If you  then pressed the <EEsscc>  key, vvsshh would
return you to the File Window.   If you pressed the -> key, vvsshh would erase
the  FFiillee command's  drop-down window and  display, instead,  the drop-down
window for the DDiirreeccttoorryy command.  If, however, you pressed the <- key, vvsshh
would erase  the FFiillee command's drop-down window  and display, instead, the
drop-down  window for  the  HHeellpp command.   As  you can  see, vvsshh  ``wraps-
around'' the cursor  -- it considers the command at  the far right to be to
the left of the command to the far left, and vice versa.  This concept is a
little difficult to  grasp when you read about it,  but once you try it, it
will quickly become clear.

The other  group of commands  are the commands CCoommmmaanndd,  RReeffrreesshh, EExxiitt, and
HHeellpp. Each has only option, so  when you invoke one of them, it immediately
begins  to execute  that option.   When  you access  one of  these commands
through the ->  and <- keys, each displays a  drop-down menu that shows its
one option.

The following describes each command in detail.

FFiillee Pressing FF  invokes the FFiillee command.  This  displays a drop-down menu
     that  lists  a  set  of  sub-commands.   These  sub-commands  let  you
     manipulate  files; with  them, you  can  edit a  file, create  a file,
     change its  permissions, rename  it, erase it,  print it, or  do other
     common tasks.

     To invoke a sub-command, you can do either of the following: Press the
     letter in the sub-command that is underlined (each sub-command has its
     own unique  letter with which you  can invoke it); or use  the ^ and v
     keys  to move  the highlighting  bar to that  command, and  then press
     <rreettuurrnn>.

     The following discusses each sub-command in detail:

     CCooppyy This sub-command copies a file.  Please note that the behavior of
          this subcommand depend upon whether you have tagged files.

          If you have  tagged one or more files, vvsshh  opens a pop-up window
          that  requests the  path name  of a  directory.  By  default, vvsshh
          displays the  destination directory, if  you have set  one.  When
          you enter  the path name, vvsshh copies every  tagged file into that
          directory.

          If you have not tagged any  files, vvsshh opens a pop-up window that
          requests that  you enter a file  name or a path  name.  Again, if
          you have  set a destination directory, the  window displays it by
          default.  If  you enter  only a file  name into this  window, vvsshh
          copies  the highlighted  file into  the newly  named file  in the
          current  directory;  if  you have  named  an  existing file,  vvsshh
          prompts you before it overwrites  that file.  If you enter a path
          name, vvsshh copies the highlighted file into the directory you have
          named; the  copied file retains  its current name.   If, however,
          you enter both  a file name and a path  name, then vvsshh copies the
          highlighted file  into the directory you named,  and gives it the
          file name that you entered.

          Note that this command will not  overwrite a file that you do not
          own; nor will it create a new file in a directory in which you do
          not have  write permission, or  copy a file  on which you  do not
          have read permission.

     MMoovvee This sub-command prompts you for  the name of a directory; if you
          have  set a  destination directory, vvsshh  displays it  by default.
          When you confirm the destination, vvsshh then moves all tagged files
          into it.  (If no files are tagged, vvsshh moves only the highlighted
          file.  For  more information  on tagging,  see the entry  for the
          sub-command TTaagg, below.) The  files retain their names in the new
          directory.

          This command does not move a  file for which you do not have read
          permission, or move a file into a directory into which you do not
          have  write permission;  nor  will it  move  a file  into a  non-
          existent directory (of course).

     DDeelleettee
          This  sub-command deletes  the tagged  files.   (If no  files are
          tagged,  then it  deletes only  the  highlighted file.   For more
          information on  tagging, see the  entry for the  sub-command TTaagg,
          below.) It will prompt you to  confirm that you really do want to
          delete the  file or files  in question.  With regard  to the mass
          deletion  of  tagged  files,  this  sub-command lets  you  choose
          whether to do a mass deletion or delete files one at a time.

          Note that this sub-command will not delete a file that you do not
          own.

     RReennaammee
          This sub-command lets  you rename the highlighted file.  It opens
          a  pop-up window  that shows  the current name  of the  file, and
          prompts you to type the new name.  Press <EEsscc> to abort this sub-
          command, or type the new name and press <rreettuurrnn>.

          It does not work with directories.   It will not let you rename a
          file that you do not own.

     EExxeeccuuttee
          This sub-command executes  the highlighted file.  vvsshh prompts you
          to type  the arguments you  wish to pass this  file, then invokes
          the file with those arguments.

          Note that vvsshh  will not execute a file for  which you do not have
          execute permission.

     AAcccceessss
          This sub-command lets you change the manner in which every tagged
          file can  be accessed.  (If  no files are tagged,  the default is
          the  highlighted file.)  When  you invoke  it,  vvsshh displays  the
          following pop-up window for each tagged file:

              Change access f file _f_i_l_e_n_a_m_e

              Owner
              Read [x]       Write[x]        Execute[ ]

              Group
              Read [x]       Write[ ]        Execute[ ]

              World
              Read [x]       Write[ ]        Execute[ ]

              Special
              Set UID [ ]    Set GID [ ]     Set sticky[ ]


          An `x'  in a  field means  that that permission  is turned  on; a
          blank means that it is turned off.  Use the arrow keys to move to
          the cursor the field whose  status you wish to change, then enter
          a space or  `x' to, respectively, turn off or  turn on that given
          permission.  To  abort this command,  press <EEsscc>. Note  that you
          can reset permissions only on the files you own.

     OOwwnneerr
          This lets  you change the  owner and group that  owns each tagged
          file.   If no  files are  tagged, then this  applies only  to the
          highlighted file.  When  you invoke this sub-command, vvsshh opens a
          pop-up window that shows the user and group that own a file: type
          the name  of the  user or  group you want  to own the  file.  vvsshh
          repeats this  step for each tagged file.   To abort this command,
          press <EEsscc>.

     PPrriinntt
          This passes every tagged  file to the print spooler for printing.
          To change  the default print  spooler, use the  IInnssttaallll command's
          PPrriinntt ssppoooolleerr sub-command.

          Note that vvsshh simply passes the file to the spooler for printing;
          you cannot use this to  process a file before printing it.  Under
          some operating systems, if you try  to use this feature of vvsshh to
          print a file on a  PostScript printer, the printer will hang.  We
          suggest that  you use the  CCoommmmaanndd feature to  print a file  on a
          specialized printer; it's  a little more difficult, but it works.
          Another approach under UNIX or  COHERENT is to use the spooler llpp
          and  prepare  a  special  backend  script  to do  the  processing
          automatically.

     VViieeww This  sub-command  invokes  the  default  viewer to  display  the
          contents of  every tagged file.  If you try  to view the contents
          of a binary file, the results may not be what you expect.

          Note that vvsshh  will not display a file for  which you do not have
          read permission.   To change the default  viewer, use the IInnssttaallll
          command's FFiillee vviieewweerr sub-command.

     EEddiitt This  sub-command invokes  the text editor  to edit  every tagged
          file.  If  no files  are tagged,  then edit only  the highlighted
          file.

          The  default text  editor is  vvii, which  can create  problems for
          persons who do not know how  to exit from that editor.  To change
          the default  text editor, use  the IInnssttaallll command's  EEddiittoorr sub-
          command.  Note  that vvsshh will not  let you edit a  file for which
          you do not have read permission.

     EEddiitt nneeww
          This sub-command  prompts you  to type the  name of a  file, then
          invokes the editor  for that file.  This can be  a new file (that
          is, one that  does not yet exist in the  current directory), or a
          file that already exists.

          Note  that if  you do  try to  edit a binary  file, you  may find
          yourself running into difficulties.

     TToouucchh
          This ``touches''  every tagged  file --  that is, it  changes the
          date and time  that the file was last modified,  just the same as
          if you had just edited it.

          Note that you cannot touch a file for which you do not have write
          permission.

     TTaagg aallll
          This sub-command  ``tags'' every  file in the  current directory.
          This lets you do mass moves  or deletions of files.  When you tag
          a file, vvsshh updates the entries FFiilleess ttaaggggeedd and FFiillee ssiizzee ttaa. in
          the Status  Window, to reflect  the number and total  size of the
          files you  have just tagged.  It also prints  an asterisk next to
          the tagged file.

          When the cursor is in the  File Window, you can toggle tagging on
          the highlighted  file by pressing  the space bar.   Note that the
          highlighted  file is  implicitly tagged,  whether an  as asterisk
          appears next to  it or not.  For details, see  the section on the
          Status Window, below.

     UUnnttaagg aallll
          This sub-command untags all  files that are tagged in the current
          directory.  As  noted above,  you can  toggle the tagging  of the
          highlighted file by pressing the space bar.  This command updates
          the Status Window to reflect your changes.

     SSeelleecctt
          This  sub-command opens  a  pop-up window  and lets  you enter  a
          regular  expression;  it  then  tags  all  files that  match  the
          expression.  For example, if you enter *.cc, then this sub-command
          tags all files that end in the string .cc.

     FFiillee ttyyppee
          This sub-command  prints a summary of  information about the type
          of the highlighted file.

     FFiillee iinnffoo
          This  sub-command  opens   a  pop-up  window  that  displays  the
          following information about the highlighted file or directory:

              Filename
              Filetype
              I-Node
              Links
              Owner UID
              Owner GID
              access
              modification
              status changed

          _F_i_l_e_n_a_m_e is  the name of  the file.  _F_i_l_e_t_y_p_e is  its type, e.g.,
          directory  or regular  file.   _I-_N_o_d_e gives  the  number of  this
          file's  i-node.  _L_i_n_k_s  gives the  number of  links to  the file.
          _O_w_n_e_r _U_I_D  and _O_w_n_e_r  _G_I_D identify the  owner and group  that own
          this  file.   _a_c_c_e_s_s,  _m_o_d_i_f_i_c_a_t_i_o_n,  and  _s_t_a_t_u_s  _c_h_a_n_g_e_d  give,
          respectively, the date and  time the file was last accessed, last
          modified, or last had its status changed.

DDiirreeccttoorryy
     Pressing DD  invokes the DDiirreeccttoorryy command.   This displays a drop-down
     menu that  lists a  set of  sub-commands.  These sub-commands  let you
     manipulate directories; with  them, you can create a directory, remove
     a directory, change permissions, and other common tasks.  You can also
     manipulate a ``directory stack,'' which lets you jump quickly from one
     directory to another without having to retype its name.

     The following discusses each sub-command in detail:

     CChhaannggee
          This lets you change the current directory.  When you invoke this
          subcommand, vvsshh displays the following pop-up window:


              Enter destination path


          Type the full  path name of the directory you  wish to enter.  If
          this directory  does not exist,  or if you cannot  access it, vvsshh
          leaves you  in the current directory; otherwise,  it moves you to
          the requested directory.

     HHoommee This moves you to your home directory.

     UUsseerr'ss HHoommee
          This moves  you to the home directory of  another user.  When you
          invoke this sub-command, vvsshh asks you to name the user whose home
          directory you wish to enter.   To abort, press <EEsscc>. If the user
          you enter does not exist or if you do not have permission to read
          her  home directory,  vvsshh leaves  you  in the  current directory;
          otherwise, vvsshh moves you into that user's home directory.

     SSeett ddeesstt
          Set the  destination directory.  This directory  is saved in your
          .vvsshh file, and is restored the next time you invoke vvsshh.

     PPuusshh The next  three sub-commands  makes it  easy for you  to maneuver
          your  way around  the your  machine's file  system.  The  work by
          using what  is called a ``directory stack''.   In effect, you can
          tell vvsshh  to remember  the directory you  are in (this  is termed
          ``pushing'' the  directory onto the  stack); then, when  you have
          switched to another directory, you can returned to this directory
          simply by  ``popping'' this  pushed directory from  the directory
          stack.   This  lets you  move  around  among directories  without
          having to retype them continually.

          The  PPuusshh  sub-command  pushes  the  current directory  onto  the
          directory stack.   When you push a  directory, vvsshh increments the
          number next  to the entry DDiirr. SSttaacckk in  the Status Window.  This
          tells you how many directories you have pushed onto the directory
          stack.

     PPoopp & ccdd
          This sub-command moves you  to the last directory you pushed onto
          the  directory  stack.   It  also  removes  that  directory  from
          directory  stack.  When  you pop a  directory from  the directory
          stack, vvsshh decrements the number  next to the entry DDiirr. SSttaacckk in
          the Status Window.  This tells you how many directories remain on
          the directory stack.

          Note that directories are  popped in the order opposite from that
          in which they were entered.  For example, if you pushed directory
          /uussrr/bbiinn/ssyyss   onto   the   directory   stack,   then   directory
          /uussrr/lliibb/mmaaiill,  then  /bbiinn,  invoking  the PPoopp  sub-command  will
          return you to  directory /bbiinn, then to /uussrr/lliibb/mmaaiill, and finally
          to directory /uussrr/iinncclluuddee/ssyyss.

     SSwwiittcchh
          This command switches the  current directory and the top entry in
          the directory stack.

     CCooppyy This copies  the highlighted directory  plus all of  its contents
          into another directory whose  name you type into a pop-up window.
          It behaves much like the command ccppddiirr.

     DDeelleettee
          This deletes  the highlighted directory.   It does not  work with
          files.  If the directory has files in it, vvsshh will prompt you and
          ask if you want the directory to vanish.  If you answer `Y', then
          vvsshh removes it, files and all  -- just as if you had executed the
          command rrmm -rrff.

          vvsshh will not delete a directory that you do not own.

     RReennaammee
          This sub-command renames  the highlighted directory.  vvsshh opens a
          pop-up  window  and prompts  you  to  type the  new  name of  the
          directory.  Press <EEsscc> to abort this sub-command.  Note that you
          can rename only  directories that you own.  This sub-command does
          not work with files.

     CCrreeaattee
          This  sub-command   creates  a  new  directory   in  the  current
          directory.  vvsshh  prompts you for  the name of  the new directory,
          and then  creates it.  Note that you can  create a directory only
          if you have write permission in the current directory.

     AAcccceessss
          This  lets you  reset the  access  permission on  the highlighted
          directory.   This  is   the  directory  equivalent  of  the  FFiillee
          command's  AAcccceessss sub-command.

     OOwwnneerr
          This  lets  you  reset  the  user  and group  that  own  a  given
          directory.   This  is   the  directory  equivalent  of  the  FFiillee
          command's OOwwnneerr  sub-command.  Note that only  the superuser rroooott
          can run this command.

     RReeaadd nneeww
          This tells vvsshh to  re-read the current directory.  vvsshh copies the
          contents of  the current directory  into memory for  its own use;
          thus, if other  people manipulated the directory and its contents
          after vvsshh read its contents, what you see in the File Window will
          not reflect the true state  of affairs in that directory.  If you
          are working with a directory  that is being manipulated by one or
          more other  people, you  should issue  this command from  time to
          time, to  ensure that you  are working with an  accurate image of
          the directory's contents.

     SSwwiittcchh CCWWDD
          This  command switches  the  current working  directory with  the
          destination directory.

     SSwwiittcchh TTOOSS
          This switches the destination directory with the directory on top
          of the stack.

     IInnffoo This  is the  same as  the FFiillee iinnffoo  sub-command under  the FFiillee
          command, described above.

OOppttiioonnss
     Pressing  OO invokes  the OOppttiioonnss  command.   Its sub-commands  let you
     perform common system tasks.  The following discusses each sub-command
     in detail:

     SShheellll
          This command  invokes an interactive  shell.  When you  exit from
          the  shell  (either by  typing  eexxiitt or  <ccttrrll-DD>),  you will  be
          returned to vvsshh.

          By  default,  vvsshh invokes  the  Bourne shell  sshh;  to change  the
          default  shell,  use  the  SShheellll  sub-command under  the  IInnssttaallll
          command, which is described below.

     LLoocckk tteerrmmiinnaall
          This command  locks your terminal.  When  the terminal is locked,
          no command can entered into it; this lets you walk away from your
          terminal briefly without worrying whether anyone (e.g., your cat)
          will do anything untoward under your login.  The terminal remains
          locked until you retype the secret password that you entered when
          you invoked this sub-command

          When you  invoke this sub-command,  a pop-up window  appears with
          the following:

              Lock Enter Password


          vvsshh prints  a `#' to echo  each character that you  type.  If you
          wish to  abort the LLoocckk  sub-command, press <EEsscc>.  When you have
          finished entering  your password, press <rreettuurrnn>.   When you have
          entered the password, the following window appears:

              This Terminal is locked!

              Enter Password to unlock
              or hit return to logoff


          Type  the password  to return  to vvsshh. If  you (or  someone else)
          presses <rreettuurrnn>, you will be logged out of your system.

     MMeessssaaggeess
          This sub-command lets  you receive or ignore messages.  A message
          can be sent to your  terminal by another user or another process;
          for example,  the mmaaiill command  may send a prompt  to your screen
          when new mail is received.

          When you invoke this sub-command, vvsshh displays the following pop-
          up window:


              Do you want to receive messages ?

                     Yes         No


          Use the -> and <- keys  to select the option you want, then press
          <rreettuurrnn>.  When  you change your message  status, the information
          in the  Status Window  changes.  For  example, when you  turn off
          messaging,  the following  appears at  the  bottom of  the Status
          Window:

              You can't get messages

          For more  information, see the description  of the Status Window,
          below.

     OOnnlliinnee mmaannuuaall
          This lets  you select an entry from  your system's on-line manual
          pages.   When  you  invoke  this  sub-command, vvsshh  displays  the
          following pop-up window:

              Enter topic, chapter is optional :

              Topic:

              Chapter:


          Type the  title and chapter of the entry  that interests you.  If
          you change your mind, press <EEsscc> to abort this command.

     SSyysstteemm nneewwss
          Display news about your current system.

     IInntteerrnneett nneewwss
          Invoke a reader for Internet news.

     EElleeccttrroonniicc mmaaiill
          Invoke your mail reader.

IInnssttaallll
     Pressing  II invokes  the IInnssttaallll  command.   Its sub-commands  let you
     modify some  of vvsshh's  default behaviors;  in particular, it  lets you
     program your  function keys to execute some tasks  you select with one
     keystroke.  The following discusses each sub-command in detail:

     DDiissppllaayy
          This  command lets  you  customize appearance  of  vvsshh. When  you
          invoke  this  sub-command,  vvsshh  displays  the  following  pop-up
          window:

              Display Attributes

              Menubar
              Menu color
              Menu attribute
              Dialog box


          The entry  MMeennuubbaarr lets you select the  display attribute for the
          menu bar, which can be one of bboolldd, uunnddeerrlliinnee, or rreevveerrssee.

          The entry  MMeennuu ccoolloorr lets you  set the menu color,  which can be
          either nnoorrmmaall  or rreevveerrssee. (This may vary,  depending on the type
          of terminal you are using.)

          The entry  MMeennuu aattttrriibbuuttee lets you set  the display attribute for
          pulldown menus,  which can  be one  of bboolldd, uunnddeerrlliinnee,  bboolldd, or
          nnoorrmmaall.

          Finally, the entry DDiiaalloogg  bbooxx lets you set the display attribute
          for dialogue boxes, which can be one of bboolldd, uunnddeerrlliinnee, or bbootthh.

          The best  way to see what  these commands do is  to try them out.
          As  mentioned  above,  the behavior  may  change  from device  to
          device, depending upon the type of terminal that you are using.

     FFuunnccttiioonn kkeeyyss
          This lets  you ``program'' up  to nine function keys,  so you can
          invoke selected commands easily.  Each user can have her own list
          of programmed function keys.

          When  you invoke  this  sub-command, vvsshh  displays the  following
          drop-down menu:

              Function keys

              Function key 1
              Function key 2
                 ...
              Function key 9


          Press 1  through 9 to program the  corresponding function key (or
          use the  ^ and v keys  to move then highlighting  bar, then press
          <rreettuurrnn>).  vvsshh asks you to  enter the label for the function key
          and the  command you want that function key  to invoke.  When you
          have  finished, the  new label will  appear in  the corresponding
          function-key tag at the bottom  of the screen; and when you press
          that function key, vvsshh executes the corresponding command.

          For example,  to make  the command ffoooo  one of your  function key
          entries, do  the following: First, press II  to invoke the IInnssttaallll
          command.  The  press kk to  invoke the FFuunnccttiioonn  kkeeyyss sub-command.
          When  the  function-keys drop-down  menu  appears,  press 22,  for
          function-key  FF22.  When  the label  pop-window appears,  type ffoooo
          into the first slot, which  holds the label.  Press <TTaabb> to jump
          to the second slot, which holds the command to execute, then type
          /uussrr/bbiinn/ffoooo. When you have done typing, press <rreettuurrnn>.

          As you  can see, the  FF22 stub at  the bottom of  the screen shows
          ffoooo; and  when you press FF22,  vvsshh launches you into  ffoooo. You can
          program the first nine function keys to work in the same way.

          You can embed the token %FF as a placeholder for the current file.
          For example,  to count the  number of lines in  the current file,
          put the following command into a function-key definition:

              wc -l %F

          Because some computers do  not have function keys (e.g., the NeXT
          machine), you  can also use  the number keys  to execute commands
          installed on the function keys.

     SShheellll
          This sub-command  lets you  set the  default shell that  vvsshh runs
          when you  invoke its  SShheellll command.   When you invoke  this sub-
          command, vvsshh displays the following pop-up menu:

              Enter command to run a shell

                  /bin/sh


          Type the  name of  the shell that  you want, and  press <rreettuurrnn>.
          (You can enter another program if  you like, but you may get some
          strange results if you do.)

     EEddiittoorr
          This lets you set the editor that vvsshh invokes when you select the
          EEddiitt  sub-command under  the FFiillee command.   When you  invoke the
          EEddiittoorr sub-command, vvsshh displays the following pop-up window:

              Enter command to run an editor

                  vi


          Type the editor that you want; then press <rreettuurrnn>.

     PPrriinntt ssppoooolleerr
          This lets  you set the  spooler that vvsshh invokes  when you select
          the PPrriinntt  sub-command under the  FFiillee command.  When  you invoke
          the PPrriinntt ssppoooolleerr  sub-command, vvsshh displays the following pop-up
          window:

              Enter command to run a print-spooler

                  lpr -B


          Enter the spooler that you want.

          Beginning with release 2.7 of vvsshh, this feature works with pipes.
          vvsshh understands  that the token  %FF represents the  current file.
          For  example, if  you have  a PostScript  printer, you  will want
          every file to be processed by the command ppssffiilltt before you print
          it.  Thus, enter the command:

              psfilt %F | lp

          This tells vvsshh to filter each file through ppssffiilltt to turn it into
          PostScript, then pipe the output to the spooler llpp.

     FFiillee vviieewweerr
          This lets you set the viewer that vvsshh invokes when you select the
          VViieeww  sub-command under  the FFiillee command.   When you  invoke the
          FFiillee  vviieewweerr  sub-command,  vvsshh  displays  the  following  pop-up
          window:

              Enter command to run a file view utility

                  more


          Enter the pager you want, such as mmoorree or lleessss.

     FFiillee aaccttiioonn
          As noted above,  vvsshh has a list of default  actions that it takes
          when you  select a  file of  a given type.   For example,  if you
          invoke the FFiillee command, move the highlighting bar to a file with
          the suffix  .cc and press  <rreettuurrnn>, vvsshh by default  invokes the C
          compiler cccc to compile that file.

          vvsshh stores the list of its  default actions.  in the file .vvsshh in
          your  home directory.   The  FFiillee aaccttiioonnss  sub-command invokes  a
          special editor with which you can edit this list.

          When you  invoke this option,  vvsshh displays the  following pop-up
          window:


              Edit actions list
              Configure action


          Use the ^ and v keys to move the highlighting bar to the item you
          want; then press <rreettuurrnn>.

          When you select  EEddiitt  aaccttiioonnss lliisstt, vvsshh displays a pop-up window
          that  contains all  of the  default actions.   The syntax  of the
          default actions is described above.  Use the ^ and v keys to move
          the highlighting  bar to the  action you wish to  edit.  To erase
          the  current line,  press  <ccttrrll-DD>; to  open a  new line,  press
          <ccttrrll-II>.

          To modify the line that is currently highlighted, press <rreettuurrnn>.
          When  you do  so, the  highlighting bar  disappears and  a cursor
          appears.  Use the <- and ->  keys to move the cursor to the point
          you wish  to change;  typing inserts  new text into  the command,
          whereas pressing <BBaacckkssppaaccee> erases text.  When you have finished
          modifying the  current line, press <rreettuurrnn>.   To abort modifying
          the current line, press <EEsscc>.

          When you  have finished modifying  the action list,  press <EEsscc>.
          vvsshh records  your changes into file .vvsshh, and  returns you to the
          File window.

          When  you select  the  option CCoonnffiigguurree  aaccttiioonn,  vvsshh displays  a
          window with the prompt

              Show file actions before execution ?

          The cursor is  under the response yy, for yyeess.  If you accept this
          option,  vvsshh will  prompt  you for  your  confirmation before  it
          performs a  default action.  If  you want vvsshh simply  to go ahead
          and perform  its default without asking  for your approval, press
          the -> key to move the  cursor to the option nn, for nnoo, and press
          <rreettuurrnn>.

     SSyyss. nneewwss rreeaaddeerr
          Tell  vvsshh what  system  news program  you  want it  to invoke  by
          default.

     IInntteerrnneett nneewwss
          Tell  vvsshh what  Internet news  reader  you want  it to  invoke by
          default.

     EElleeccttrroonniicc mmaaiill
          Tell vvsshh what mail reader you want it to invoke by default.

CCoommmmaanndd
     The command CCoommmmaanndd lets you send a command directly to a shell.  This
     lets  you invoke  commands that ordinarily  are not  available through
     vvsshh.

     Suppose, for example, that you decided you wanted to play a session of
     the game tteettrriiss, and that you have not yet programmed tteettrriiss as one of
     your function  keys.  Press CC to invoke CCoommmmaanndd.  vvsshh moves the cursor
     moves to  the bottom of the  screen, and erases the  row of boxes that
     describe the function keys.  You can now type the command you want, in
     this case  /uussrr/ggaammeess/tteettrriiss. To run  the command, press  <rreettuurrnn>; to
     abort entering a  command and return to vvsshh (such  as when you see the
     boss coming), type <EEsscc>.

     When you  press <rreettuurrnn>,  vvsshh runs the  command you typed.   When you
     have finished  playing tteettrriiss and have exited from  it, vvsshh clears the
     screen and displays the message:

         Hit any key to continue ...

     When you  press a key, vvsshh  redraws itself on your  screen and returns
     the cursor to the File Window.

     CCoommmmaanndd  remembers the  last  40 commands  that you  have issued.   To
     invoke a command that you previous issued through CCoommmmaanndd, press the ^
     key.  The last command you issued will appear in the command slot.  If
     you continue  to press the  ^ key, others commands  appear, in reverse
     order from  when you issued  them.  If you overshoot  the command that
     you want  to re-run,  press the v  key to walk  back down the  list of
     previously  issued  commands.  When  you  find  the previously  issued
     command that  you wish to rerun,  just press <rreettuurrnn> and  vvsshh runs it
     again.

     You can  also edit a  previously issued command.   The following gives
     lists the available editing commands:

          <-        Move the cursor one character to the left
          ->        Move the cursor one character to the right
          <ddeell>     Delete the character to the left
          <bbaacckkssppaaccee>Delete the character to the left
          <ccttrrll-DD>  Delete the character over the cursor
          <ccttrrll-PP>  Go to last character of the command
          <ccttrrll-NN>  Go to first character of the command

     A command  can use  environmental variables,  such as $HHOOMMEE.  vvsshh will
     expand  all  environmental  variables  correctly  before it  tries  to
     execute the command.

     You can also embed the following tokens in a command:

         %FF  Represent the currently highlighted file
         %TT  Represent all tagged files
         %DD  Represent the destination directory

     For example, the command

         cp %T %D

     copies all tagged files into the destination directory.

RReeffrreesshh
     The command RReeffrreesshh redraws the  screen.  It does no other work.  This
     is  helpful if  your screen  has become jumbled  or scrambled  for any
     reason -- such as a message  being written onto your screen by another
     user.

     To  invoke this  command, type  RR. vvsshh pauses  very briefly,  then the
     screen flickers  as vvsshh redraws.  If the screen  had been confused for
     any reason, invoking this  command should restore to its proper state.
     If you  need to  refresh the  screen while a  pop-up menu or  a pop-up
     window is active, press <ccnnttll-LL>.

EExxiitt The command  EExxiitt exits you  from vvsshh. To  exit from vvsshh,  press EE. In
     response, vvsshh pops the following window onto your screen:

         Do you really want to quit?

                Yes       No


     The  window is  in reverse  video,  for emphasis.   The option  YYeess is
     underlined, to show  that it is the default choice.   If you really do
     wish to exit, press <rreettuurrnn>; and vvsshh returns to the shell.

     If you changed your mind, however,  and do not wish to exit, press the
     ->  key to  change the  option; this will  shift the  underlining from
     option YYeess to  option NNoo. Pressing enter at this  point selects the NNoo
     option; vvsshh in response removes  the pop-up window from the screen and
     returns you to the File Window.

     If you  change your mind  again, though, and  really do wish  to exit,
     then press the <- key.  The underlining shifts back to the YYeess option;
     and when you press <rreettuurrnn> you exit from vvsshh and return to the shell.

_S_t_a_t_u_s _W_i_n_d_o_w
The Status Window is the lower window on the right side of the screen.  The
cursor  never enters  this window;  rather,  this window  gives information
about how  vvsshh is functioning, and  in particular about the  files that are
currently displayed in the File Window.

The Status Window contains the following entries:

FFiilleess
     This gives the number of files  being shown in File Window.  Note that
     this is  all files that can  be scrolled through that  window, _n_o_t the
     files that are shown in that window at this moment.

FFiillee ssiizzee
     This gives the total size, in bytes, of all files available through in
     the File Window.

FFiilleess ttaaggggeedd
     This  gives  the  number of  files  that  you  have  tagged.  See  the
     description of the FFiillee command, above, for details.

FFiillee ssiizzee ttaa.
     This gives the total size of all tagged files.  See the description of
     the FFiillee command, above, for details.

DDiirr. SSttaacckk
     This  gives the  number of  directories that  currently reside  on the
     directory stack.   As noted above,  you can ``push''  directories onto
     the directory stack or ``pop'' them from it.  By doing so, you have an
     easy way  to jump about from one directory  to another, without having
     to type directory names  repeatedly.  See the above description of the
     DDiirreeccttoorryy command  for details.  Note  that you can have  a maximum of
     ten directories on the stack.

MMaaiill This line indicates whether you have  mail waiting to be read.  If you
     don't, this line will say

         None

     whereas if you do, the line will say

         Avail

     and flash at you.  If new mail arrives, vvsshh flashes

         New

     in that slot.

_m_a_i_l_b_o_x
     This line  gives the name  of your mailbox  -- that is,  the file that
     mmaaiill reads.

_m_e_s_s_a_g_e_s
     This  indicates whether  your terminal can  receive messages  -- e.g.,
     whether a  message will  pop up  on your screen  if someone  wishes to
     communicate with you via the commands wwrriittee or ttaallkk.

_F_u_n_c_t_i_o_n _K_e_y_s
The bottom of the screen show nine small boxes in reverse video.  These are
labelled FF11 through FF99. If you  have defined the key using the FFuunnccttiioonn KKeeyy
command, vvsshh displays the box the tag that you gave that key.

For example, in  our above example we set key  FF11 to run the command ppss -aa,
and gave  it the tag ppss.  At the bottom of the screen,  the box labelled FF11
should show ppss.

For more details, see the description of the FFuunnccttiioonn KKeeyy command, above.

_C_o_n_f_i_g_u_r_a_t_i_o_n _F_i_l_e
vvsshh reads the file .vvsshh to configure itself.

A typical .vvsshh file reads as follows:

    cwd=/v/fwb
    shell=/bin/ksh
    editor=me
    print-spooler=hpr -B
    view=more
    make=make
    me-disp-attr=reverse
    pd-disp-color=normal
    pd-disp-attr=bold
    se-disp-attr=underline
    pfkey1=  mail mail
    pfkey9=tetris /usr/games/tetris
    cmd=
        tetris
        tetris
        echo foo

ccwwdd  points to  the current  working directory, that  is, the  directory in
which you have last worked with vvsshh. vvsshh returns you to that directory when
you next invoke the shell.

sshheellll, eeddiittoorr, pprriinntt-ssppoooolleerr, vviieeww, and mmaakkee give, respectively, the shell,
editor, print-spooler, viewer, and  make utility that you selected with the
IInnssttaallll command.   If you change one  of these values, the  behavior of vvsshh
changes to reflect the change.  For example, if you change the line

    editor=me

to

    editor=vi

then vvsshh will  invoke vvii the next time you  request the FFiillee command's EEddiitt
sub-command.

mmee-ddiisspp-aattttrr,  ppdd-ddiisspp-ccoolloorr,  ppdd-ddiisspp-aattttrr,   and  ssee-ddiisspp-aattttrr  give  the
display features for, respectively, the  menu bar, the menu color, the menu
attribute, and the dialogue box.

The lines ppffkkeeyy11 through ppffkkeeyy99 set the behavior of the function keys.  The
first seven characters after the equal  sign `=' give the text that appears
in stub  at the  bottom of  the screen.  Everything  after the  first seven
characters  describes  the  command to  be  executed  when  you press  that
function key.

The  text that  follows the  line  ccmmdd= lists  the commands  that you  have
executed with the command CCoommmmaanndd. You  can embed the following tokens in a
command:

    %FF  Represent the currently highlighted file
    %TT  Represent all tagged files
    %DD  Represent the destination directory

These are used just as they are with the CCoommmmaanndd command, described above.

_C_o_m_m_a_n_d-_l_i_n_e _O_p_t_i_o_n_s
vvsshh recognizes the following command-line options:

-dd_d_i_r_e_c_t_o_r_y
   Enter vvsshh and begin to work in _d_i_r_e_c_t_o_r_y. If no _d_i_r_e_c_t_o_r_y is named, then
   begin work  in the current  directory.  vvsshh normally begins  in the last
   directory used in your last vvsshh session.

-ee Do  not  use  the  graphic  character  set.  This  option  coarsens  the
   appearance  of vvsshh,  but gives  it  a fighting  chance to  run on  cheap
   terminals that do not implement  the full alternate character set of the
   DEC VT-100 terminal.

-ii Restrict the  user's ability to run the IInnssttaallll  command.  In this mode,
   vvsshh can be used only as  configured by someone else.  This is helpful if
   you are setting up vvsshh for a naive user whom you do not want to overstep
   her boundaries.

-rr Restrict the shell.  This option turns off the following:

       -> The command CCoommmmaanndd
       -> No interactive shell can be called from the OOppttiioonnss menu
       -> Most options from the DDiirreeccttoorryy menu
       -> Most options from the IInnssttaallll menu

   This lets the system administrator restrict the activity of users fairly
   strongly.

-tt This command-line option tells  vvsshh to assume the entire VT-100 mapping.
   This is  useful with terminals whose  system definitions are incomplete,
   or the alternate character set is ignored.

_F_i_l_e_s
$HHOOMMEE/.vvsshh -- Configuration file

_N_o_t_e_s
vvsshh was written by Udo Munk (udo@umunk.gun.de).

This  manual  page was  written  by  Fred Butzen  (fred@lepanto.chi.il.us),
adapted from  his manual  for the  COHERENT operating system.   This manual
page is copyright (c) 1994,  Mark Williams Company, and is distributed with
its permission.
