#ifndef LINT
static char COPYRIGHT[]="\
  COPYRIGHT --- COPYRIGHT --- COPYRIGHT --- COPYRIGHT \n\
  This program is copyright 1989 Nils McCarthy. This \
  program may be distributed if it is impossible for \
  the distributor to get a more up-to-date-version of \
  it. \n\
  COPYRIGHT --- COPYRIGHT --- COPYRIGHT --- COPYRIGHT \n\
  ";
static char AUTHOR[]="Copyright 1989 Nils McCarthy";
#endif /* LINT */

#include "unidraw.h"

char *WinGet(output,mlen,chrset) /* Get a string from a window */
 char *output;
 int mlen;
 char *chrset;
{
   char ch;
   output[0]=NULL;
   raw();
   
   while(strlen(output)<(mlen+1)) { /* so if there is too many chars, it
				       just dumps them out. */
      ch=getchar();
      if(ch==8) /* Backspace */
	 if(strlen(output)>0) {
	    output[strlen(output)-1]=NULL;
	    printw("\b \b");
	    refresh();
	 } else {} /* Needed so the following else will take the
		      right if */
      else
	 if(ch==13 || ch==10 || ch==KEY_ENTER) { /* enter key */
	    return(output);
	 } else
	    if(chrset==NULL || index(chrset,ch)!=NULL) {
	       int l; /* Add on a character */
	       l=strlen(output);
	       output[l]=ch;
	       output[l+1]=NULL;
	       addch(ch);
	       refresh();
	    }
   }
   return(output);
   printw("\n");
   resetty();
}

command(comm) /* execute a special command */
char *comm;
{
   if(!strncmp(comm,"write ",6)) { /* Write to a file */
      char **writebox;
      FILE *fptr;
      char *file;
      char *linespace;
      char *line;
      int i,j;

      writebox=(char **) malloc(PADLINES*sizeof(*writebox));
      for(i=0;i<PADCOLS;i++)
	 writebox[i]=malloc(PADCOLS*sizeof(**writebox));
      linespace=malloc(PADCOLS*sizeof(*linespace));
      line=linespace+1;
      linespace[0]=NULL;
      for(i=0;i<PADLINES;i++)
	 for(j=0;j<PADLINES;j++)
	    (writebox[i])[j]=pad(i,j);
      file=index(comm,' ');
      file+=1;
      if(*file==NULL) return;
      move(3,0);
      printw("Writing file... ");
      refresh();
      fptr=fopen(file,"w");
      if(fptr==NULL) {
	 move(3,0);
	 printw("ERROR: FILE NOT WRITABLE!!! ");
	 refresh();
	 return;
      }
      line[PADCOLS]=NULL;
      for(i=0;i<PADLINES;i++) {
	 for(j=0;j<PADCOLS;j++) /* Take of ending spaces*/
	    line[j]=pad(i,j);
	 while(line[strlen(line)-1]==' ' && strlen(line)>0)
	    line[strlen(line)-1]=NULL;
	 strcpy(writebox[i],line);
	 strcat(writebox[i],"\n");
      }
      for(i=PADLINES-1;(writebox[i])[0]=='\n' && i>=0;i--)
	 (writebox[i])[0]=NULL; /* take of ending blank lines */
      for(i=0;i<PADLINES;i++)
	 fprintf(fptr,writebox[i]);
      fclose(fptr);
   }
   if(!strncmp(comm,"read ",5)) { /* READ FILE */
      FILE *fptr;
      char *file;
      int i,j;
      char ch;
      
      move(3,0);
      file=index(comm,' ')+1;
      if(*file==NULL) return;
      move(3,0);
      if((fptr=fopen(file,"r"))==NULL) {
	 printw("CANNOT OPEN FILE");
	 refresh();
	 return;
      }
      printw("Reading...");
      refresh();
      for(i=0;i<PADLINES;i++)
	 for(j=0;j<PADCOLS;j++)
	    pad(i,j)=' ';
      i=0;j=0;
      while(j<PADLINES) {
	 if((ch=fgetc(fptr))==EOF)
	    return;
	 if(ch=='\n' || i>PADCOLS) { /* next line */
	    j++;
	    i=0;
	 } else {
	    pad(j,i)=ch;
	    i++;
	 }
      }
      redraw();
   }
   if(!strcmp(comm,"quit")) /* put the break key in the buffer */
      ungetc(brk,stdin);
   if(!strcmp(comm,"suspend")) /* put the suspend key in the buffer */
      ungetc(suspend,stdin);
   if(!strcmp(comm,"fill")) /* fill area */
      fill(padx,pady);
   if(!strcmp(comm,"clear")) { /* clear area */
      int i,j;
      for(i=0;i<PADCOLS;i++)
	 for(j=0;j<PADLINES;j++)
	    pad(j,i)=' ';
   }
   if(!strcmp(comm,"copy")) /* copyright notice */
      printw(COPYRIGHT);
}
